/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.JavaVersion;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.ffi.Buffer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.MetaUtil;
import com.oracle.truffle.espresso.nodes.EspressoInlineNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.InlineInBytecode;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNamesProvider;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.UnsafeSupport;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.Transition;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;

@EspressoSubstitutions(nameProvider=SharedUnsafe.class)
public final class Target_sun_misc_Unsafe {
    public static final int ADDRESS_SIZE;
    private static final int SAFETY_FIELD_OFFSET = 123456789;
    private static final int SAFETY_STATIC_FIELD_OFFSET = 3456789;
    private static final int ALLOWED_HIDDEN_FIELDS = 4096;
    private static final String TARGET_JDK_INTERNAL_MISC_UNSAFE = "Target_jdk_internal_misc_Unsafe";
    private static final String TARGET_SUN_MISC_UNSAFE = "Target_sun_misc_Unsafe";

    private Target_sun_misc_Unsafe() {
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static @JavaType(value=Class.class) StaticObject defineAnonymousClass(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject hostClass, @JavaType(value=byte[].class) StaticObject data, @JavaType(value=Object[].class) StaticObject constantPoolPatches, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (StaticObject.isNull(hostClass) || StaticObject.isNull(data)) {
            throw meta.throwNullPointerException();
        }
        if (hostClass.getMirrorKlass(meta).isArray() || hostClass.getMirrorKlass(meta).isPrimitive()) {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        byte[] bytes = (byte[])data.unwrap(language);
        ObjectKlass hostKlass = (ObjectKlass)hostClass.getMirrorKlass(meta);
        StaticObject pd = (StaticObject)meta.HIDDEN_PROTECTION_DOMAIN.getHiddenObject(hostClass);
        StaticObject[] patches = StaticObject.isNull(constantPoolPatches) ? null : (StaticObject[])constantPoolPatches.unwrap(language);
        ClassRegistry.ClassDefinitionInfo info = new ClassRegistry.ClassDefinitionInfo(pd, hostKlass, patches);
        EspressoContext context = meta.getContext();
        ObjectKlass k = null;
        try {
            k = context.getRegistries().defineKlass(null, bytes, hostKlass.getDefiningClassLoader(), info);
        }
        catch (EspressoClassLoadingException e) {
            throw e.asGuestException(meta);
        }
        k.safeInitialize();
        return k.mirror();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static int arrayBaseOffset(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        Unsafe unsafe = UnsafeAccess.getIfAllowed(meta);
        Klass klass = clazz.getMirrorKlass(meta);
        assert (klass.isArray());
        if (((ArrayKlass)klass).getComponentType().isPrimitive()) {
            Class<?> hostPrimitive = ((ArrayKlass)klass).getComponentType().getJavaKind().toJavaClass();
            return unsafe.arrayBaseOffset(Array.newInstance(hostPrimitive, 0).getClass());
        }
        return unsafe.arrayBaseOffset(Object[].class);
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static int arrayIndexScale(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        Unsafe unsafe = UnsafeAccess.getIfAllowed(meta);
        Klass klass = clazz.getMirrorKlass(meta);
        assert (klass.isArray());
        if (((ArrayKlass)klass).getComponentType().isPrimitive()) {
            Class<?> hostPrimitive = ((ArrayKlass)klass).getComponentType().getJavaKind().toJavaClass();
            return unsafe.arrayIndexScale(Array.newInstance(hostPrimitive, 0).getClass());
        }
        return unsafe.arrayIndexScale(Object[].class);
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class, isTrivial=true)
    public static int addressSize(@JavaType(value=Unsafe.class) StaticObject self) {
        return ADDRESS_SIZE;
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long objectFieldOffset(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Field.class) StaticObject field, @Inject Meta meta, @Inject EspressoLanguage language) {
        com.oracle.truffle.espresso.impl.Field target = com.oracle.truffle.espresso.impl.Field.getReflectiveFieldRoot(field, meta);
        if (target.isStatic()) {
            meta.throwIllegalArgumentExceptionBoundary();
        }
        return Target_sun_misc_Unsafe.getGuestFieldOffset(target, language);
    }

    public static int getGuestFieldOffset(com.oracle.truffle.espresso.impl.Field f, EspressoLanguage language) {
        return language.getGuestFieldOffsetStrategy().getGuestOffset(f);
    }

    static int guestOffsetToSlot(long guestOffset, EspressoLanguage language) {
        return language.getGuestFieldOffsetStrategy().guestOffsetToSlot(guestOffset);
    }

    static long slotToGuestOffset(int slot, boolean isStatic, EspressoLanguage language) {
        return language.getGuestFieldOffsetStrategy().slotToGuestOffset(slot, isStatic);
    }

    private static com.oracle.truffle.espresso.impl.Field resolveUnsafeAccessField(StaticObject holder, long offset, Meta meta, EspressoLanguage language) {
        com.oracle.truffle.espresso.impl.Field field;
        GuestFieldOffsetStrategy guestFieldOffsetStrategy = language.getGuestFieldOffsetStrategy();
        int slot = guestFieldOffsetStrategy.guestOffsetToSlot(offset);
        boolean forceStatic = guestFieldOffsetStrategy.forceStatic(offset);
        assert (!StaticObject.isNull(holder));
        if (slot >= 65536 || slot < -4096) {
            return null;
        }
        try {
            if (forceStatic) {
                if (holder.isMirrorKlass()) {
                    field = holder.getMirrorKlass(meta).lookupStaticFieldTable(slot);
                } else {
                    assert (holder.isStaticStorage());
                    field = holder.getKlass().lookupStaticFieldTable(slot);
                }
            } else {
                field = holder.isStaticStorage() ? holder.getKlass().lookupStaticFieldTable(slot) : holder.getKlass().lookupFieldTable(slot);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
        assert (field != null);
        return field;
    }

    private static StaticObject resolveUnsafeAccessHolder(com.oracle.truffle.espresso.impl.Field f, StaticObject advertisedHolder, Meta meta) {
        if (f.isStatic() && advertisedHolder.isMirrorKlass()) {
            return advertisedHolder.getMirrorKlass(meta).getStatics();
        }
        return advertisedHolder;
    }

    @CompilerDirectives.TruffleBoundary
    static EspressoException throwNoField(Meta meta, StaticObject holder, long offset) {
        if (StaticObject.isNull(holder)) {
            throw meta.throwExceptionWithMessage(meta.java_lang_UnsupportedOperationException, "No field at offset " + offset + " in null");
        }
        if (holder.isStaticStorage()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_UnsupportedOperationException, "No field at offset " + offset + " in static storage of " + holder.getKlass().getExternalName());
        }
        throw meta.throwExceptionWithMessage(meta.java_lang_UnsupportedOperationException, "No field at offset " + offset + " in instance of type " + holder.getKlass().getExternalName());
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static @JavaType(value=Class.class) StaticObject defineClass(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=String.class) StaticObject name, @JavaType(value=byte[].class) StaticObject guestBuf, int offset, int len, @JavaType(value=ClassLoader.class) StaticObject loader, @JavaType(value=ProtectionDomain.class) StaticObject pd, @Inject EspressoLanguage language, @Inject Meta meta) {
        ObjectKlass klass;
        byte[] buf = (byte[])guestBuf.unwrap(language);
        byte[] bytes = Arrays.copyOfRange(buf, offset, len);
        EspressoContext context = meta.getContext();
        try {
            klass = context.getRegistries().defineKlass(meta.getTypes().fromClassGetName(meta.toHostString(name)), bytes, loader, new ClassRegistry.ClassDefinitionInfo(pd));
        }
        catch (EspressoClassLoadingException e) {
            throw e.asGuestException(meta);
        }
        return klass.mirror();
    }

    @Substitution
    public static void registerNatives() {
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long allocateMemory(@JavaType(value=Unsafe.class) StaticObject self, long length, @Inject Meta meta) {
        long ptr;
        if (length < 0L) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "requested size is negative");
        }
        @Buffer TruffleObject buffer = meta.getNativeAccess().allocateMemory(length);
        if (buffer == null && length > 0L) {
            throw meta.throwExceptionWithMessage(meta.java_lang_OutOfMemoryError, "malloc returned NULL");
        }
        try {
            ptr = InteropLibrary.getUncached().asPointer((Object)buffer);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        return ptr;
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long reallocateMemory(@JavaType(value=Unsafe.class) StaticObject self, long address, long newSize, @Inject Meta meta) {
        long newAddress;
        if (newSize < 0L) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "requested size is negative");
        }
        @Buffer TruffleObject result = meta.getNativeAccess().reallocateMemory(RawPointer.create(address), newSize);
        if (result == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_OutOfMemoryError, "realloc couldn't reallocate " + newSize + " bytes");
        }
        try {
            newAddress = InteropLibrary.getUncached().asPointer((Object)result);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw EspressoError.shouldNotReachHere(e);
        }
        return newAddress;
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void freeMemory(@JavaType(value=Unsafe.class) StaticObject self, long address, @Inject Meta meta) {
        meta.getNativeAccess().freeMemory(RawPointer.create(address));
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static boolean shouldBeInitialized(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(clazz)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        Klass klass = clazz.getMirrorKlass(meta);
        return !klass.isInitialized();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void ensureClassInitialized(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        clazz.getMirrorKlass(meta).safeInitialize();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void copyMemory(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject srcBase, long srcOffset, @JavaType(value=Object.class) StaticObject destBase, long destOffset, long bytes, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (bytes == 0L) {
            return;
        }
        UnsafeAccess.getIfAllowed(meta).copyMemory(MetaUtil.unwrapArrayOrNull(language, srcBase), srcOffset, MetaUtil.unwrapArrayOrNull(language, destBase), destOffset, bytes);
    }

    @Substitution(hasReceiver=true)
    public static void copySwapMemory0(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject srcBase, long srcOffset, @JavaType(value=Object.class) StaticObject destBase, long destOffset, long bytes, long elemSize, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (bytes == 0L) {
            return;
        }
        UnsafeAccess.checkAllowed(meta);
        UnsafeSupport.copySwapMemory(MetaUtil.unwrapArrayOrNull(language, srcBase), srcOffset, MetaUtil.unwrapArrayOrNull(language, destBase), destOffset, bytes, elemSize);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static @JavaType(value=Object.class) StaticObject allocateInstance(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        Klass mirrorKlass = clazz.getMirrorKlass(meta);
        GuestAllocator.AllocationChecks.checkCanAllocateNewReference(meta, mirrorKlass, false);
        return meta.getAllocator().createNew((ObjectKlass)mirrorKlass);
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void setMemory(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject o, long offset, long bytes, byte value, @Inject Meta meta, @Inject EspressoLanguage language) {
        Object hostObject;
        if (StaticObject.isNull(o)) {
            hostObject = null;
        } else if (o.getKlass().isArray()) {
            hostObject = o.unwrap(language);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
        UnsafeAccess.getIfAllowed(meta).setMemory(hostObject, offset, bytes, value);
    }

    @Substitution(hasReceiver=true)
    public static int pageSize(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        return UnsafeAccess.getIfAllowed(meta).pageSize();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long staticFieldOffset(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Field.class) StaticObject fieldMirror, @Inject Meta meta, @Inject EspressoLanguage language) {
        com.oracle.truffle.espresso.impl.Field field = com.oracle.truffle.espresso.impl.Field.getReflectiveFieldRoot(fieldMirror, meta);
        if (!field.isStatic()) {
            meta.throwIllegalArgumentExceptionBoundary();
        }
        return Target_sun_misc_Unsafe.getGuestFieldOffset(field, language);
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static @JavaType(value=Object.class) StaticObject staticFieldBase(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Field.class) StaticObject field, @Inject Meta meta) {
        com.oracle.truffle.espresso.impl.Field target = com.oracle.truffle.espresso.impl.Field.getReflectiveFieldRoot(field, meta);
        if (!target.isStatic()) {
            meta.throwIllegalArgumentExceptionBoundary();
        }
        return target.getDeclaringKlass().getStatics();
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    public static void monitorEnter(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject object, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(object)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        InterpreterToVM.monitorUnsafeEnter(object.getLock(meta.getContext()));
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    public static void monitorExit(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject object, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(object)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        InterpreterToVM.monitorUnsafeExit(object.getLock(meta.getContext()));
    }

    @Substitution(hasReceiver=true, isTrivial=true)
    public static void throwException(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Throwable.class) StaticObject ee, @Inject Meta meta) {
        throw meta.throwException(ee);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void park(@JavaType(value=Unsafe.class) StaticObject self, boolean isAbsolute, long time, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (time < 0L || isAbsolute && time == 0L) {
            return;
        }
        EspressoContext context = meta.getContext();
        StaticObject thread = context.getCurrentPlatformThread();
        if (Target_sun_misc_Unsafe.parkReturnCondition(thread, meta)) {
            return;
        }
        State state = time > 0L ? State.TIMED_WAITING : State.WAITING;
        try (Transition transition = Transition.transition(context, state);){
            Target_sun_misc_Unsafe.parkImpl(isAbsolute, time, thread, meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parkImpl(boolean isAbsolute, long time, StaticObject thread, Meta meta) {
        EspressoLock parkLock = Target_sun_misc_Unsafe.getParkLock(thread, meta);
        parkLock.lock();
        try {
            while (true) {
                boolean elapsed;
                if (Target_sun_misc_Unsafe.parkReturnCondition(thread, meta)) {
                    return;
                }
                if (isAbsolute) {
                    elapsed = !parkLock.awaitUntil(new Date(time));
                } else {
                    boolean bl = elapsed = !parkLock.await(time, TimeUnit.NANOSECONDS);
                }
                if (elapsed) {
                    return;
                }
                continue;
                break;
            }
        }
        catch (GuestInterruptedException e) {
            return;
        }
        finally {
            parkLock.unlock();
        }
    }

    private static EspressoLock getParkLock(StaticObject thread, Meta meta) {
        return (EspressoLock)meta.HIDDEN_THREAD_PARK_LOCK.getHiddenObject(thread);
    }

    private static boolean parkReturnCondition(StaticObject thread, Meta meta) {
        return Target_sun_misc_Unsafe.consumeUnparkSignal(thread, meta) || meta.getThreadAccess().isInterrupted(thread, false);
    }

    private static boolean consumeUnparkSignal(StaticObject self, Meta meta) {
        com.oracle.truffle.espresso.impl.Field signals = meta.HIDDEN_THREAD_UNPARK_SIGNALS;
        return signals.getAndSetInt(self, 0) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @Substitution(hasReceiver=true)
    public static void unpark(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject thread, @Inject Meta meta) {
        EspressoLock parkLock = Target_sun_misc_Unsafe.getParkLock(thread, meta);
        parkLock.lock();
        try {
            meta.HIDDEN_THREAD_UNPARK_SIGNALS.setInt(thread, 1, true);
            parkLock.signal();
        }
        finally {
            parkLock.unlock();
        }
    }

    @Substitution(hasReceiver=true)
    public static long getAddress(@JavaType(value=Unsafe.class) StaticObject self, long address, @Inject Meta meta) {
        return UnsafeAccess.getIfAllowed(meta).getAddress(address);
    }

    @Substitution(hasReceiver=true)
    public static void putAddress(@JavaType(value=Unsafe.class) StaticObject self, long address, long x, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).putAddress(address, x);
    }

    @Substitution(hasReceiver=true)
    public static void loadFence(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).loadFence();
    }

    @Substitution(hasReceiver=true)
    public static void storeFence(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).storeFence();
    }

    @Substitution(hasReceiver=true)
    public static void fullFence(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).fullFence();
    }

    @Substitution(hasReceiver=true)
    public static boolean tryMonitorEnter(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject object, @Inject Meta meta) {
        if (StaticObject.isNull(object)) {
            throw meta.throwNullPointerException();
        }
        return InterpreterToVM.monitorTryLock(object.getLock(meta.getContext()));
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static int getLoadAverage(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=double[].class) StaticObject loadavg, int nelems) {
        return -1;
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static boolean isBigEndian0(@JavaType(value=Unsafe.class) StaticObject self) {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static boolean unalignedAccess0(@JavaType(value=Unsafe.class) StaticObject self) {
        return false;
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static long objectFieldOffset1(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject cl, @JavaType(value=String.class) StaticObject guestName, @Inject Meta meta, @Inject EspressoLanguage language) {
        Klass k = cl.getMirrorKlass(meta);
        if (k instanceof ObjectKlass) {
            ObjectKlass kl = (ObjectKlass)k;
            String hostName = meta.toHostString(guestName);
            Symbol<Symbol.Name> name = meta.getNames().lookup(hostName);
            if (name != null) {
                for (com.oracle.truffle.espresso.impl.Field f : kl.getFieldTable()) {
                    if (f.isRemoved() || f.getName() != name) continue;
                    return Target_sun_misc_Unsafe.getGuestFieldOffset(f, language);
                }
                for (com.oracle.truffle.espresso.impl.Field f : kl.getStaticFieldTable()) {
                    if (f.isRemoved() || f.getName() != name) continue;
                    return Target_sun_misc_Unsafe.getGuestFieldOffset(f, language);
                }
            }
        }
        throw meta.throwException(meta.java_lang_InternalError);
    }

    static {
        Unsafe unsafe = UnsafeAccess.get();
        ADDRESS_SIZE = unsafe.addressSize();
    }

    public static interface GuestFieldOffsetStrategy {
        default public int getGuestOffset(com.oracle.truffle.espresso.impl.Field f) {
            return Math.toIntExact(this.slotToGuestOffset(f.getSlot(), f.isStatic()));
        }

        public int guestOffsetToSlot(long var1);

        public boolean forceStatic(long var1);

        public long slotToGuestOffset(int var1, boolean var2);

        public boolean isAllowed(JavaVersion var1);

        public String name();
    }

    public static class Unsafe11
    extends SubstitutionNamesProvider {
        private static final String[] NAMES = new String[]{"Target_jdk_internal_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new Unsafe11();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }

    public static class Unsafe8
    extends SubstitutionNamesProvider {
        private static final String[] NAMES = new String[]{"Target_sun_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new Unsafe8();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }

    public static class SharedUnsafeObjectAccessToReference
    extends SubstitutionNamesProvider {
        private static final String[] NAMES = new String[]{"Target_sun_misc_Unsafe", "Target_jdk_internal_misc_Unsafe", "Target_jdk_internal_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new SharedUnsafeObjectAccessToReference();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }

        @Override
        public String[] getMethodNames(String name) {
            String[] names = new String[]{name, name, name.replace("Object", "Reference")};
            return names;
        }
    }

    public static class SharedUnsafeAppend0
    extends SharedUnsafe {
        public static SubstitutionNamesProvider INSTANCE = new SharedUnsafeAppend0();

        @Override
        public String[] getMethodNames(String name) {
            return SharedUnsafeAppend0.append0(this, name);
        }
    }

    public static class SharedUnsafe
    extends SubstitutionNamesProvider {
        private static final String[] NAMES = new String[]{"Target_sun_misc_Unsafe", "Target_jdk_internal_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new SharedUnsafe();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    @InlineInBytecode
    static abstract class CompareAndSetLong
    extends UnsafeAccessNode {
        CompareAndSetLong() {
        }

        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5, long var7);

        @Specialization
        static boolean doCached(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after, @Cached CompareAndSwapLong cas) {
            return cas.execute(self, holder, offset, before, after);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    @InlineInBytecode
    static abstract class CompareAndSetInt
    extends UnsafeAccessNode {
        CompareAndSetInt() {
        }

        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5, int var6);

        @Specialization
        static boolean doCached(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after, @Cached CompareAndSwapInt cas) {
            return cas.execute(self, holder, offset, before, after);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class)
    @InlineInBytecode
    static abstract class CompareAndSetObject
    extends UnsafeAccessNode {
        CompareAndSetObject() {
        }

        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5, @JavaType(value=Object.class) StaticObject var6);

        @Specialization
        static boolean doCached(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after, @Cached CompareAndSwapObject cas) {
            return cas.execute(self, holder, offset, before, after);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class GetAndSetObject
    extends UnsafeAccessNode {
        abstract @JavaType(value=Unsafe.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        @JavaType(value=Unsafe.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            return (StaticObject)UnsafeAccess.getIfAllowed(this.getMeta()).getAndSetObject(GetAndSetObject.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static @JavaType(value=Unsafe.class) StaticObject doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetAndSetObject.doGetAndSet(f, holder, value, meta);
            }
            return GetAndSetObject.doGetAndSetSlow(f, holder, value, meta);
        }

        private static StaticObject doGetAndSetSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            return GetAndSetObject.doGetAndSet(f, holder, value, meta);
        }

        private static StaticObject doGetAndSet(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            return f.getAndSetObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static abstract class CompareAndExchangeLong
    extends UnsafeAccessNode {
        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5, long var7);

        @Specialization(guards={"isNullOrArray(holder)"})
        long doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeLong(CompareAndExchangeLong.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static long doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndExchangeLong.doCAE(f, holder, before, after, meta);
            }
            return CompareAndExchangeLong.doCAESlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static long doCAESlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long before, long after, Meta meta) {
            return CompareAndExchangeLong.doCAE(f, holder, before, after, meta);
        }

        private static long doCAE(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long before, long after, Meta meta) {
            switch (f.getKind()) {
                case Long: {
                    return f.compareAndExchangeLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
                }
                case Double: {
                    return Double.doubleToRawLongBits(f.compareAndExchangeDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), Double.longBitsToDouble(before), Double.longBitsToDouble(after)));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    public static abstract class CompareAndExchangeShort
    extends UnsafeAccessNode {
        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, short var5, short var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        short doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short before, short after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeShort(CompareAndExchangeShort.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static short doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short before, short after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndExchangeShort.doCAE(f, holder, before, after, meta);
            }
            return CompareAndExchangeShort.doCAESlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static short doCAESlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, short before, short after, Meta meta) {
            return CompareAndExchangeShort.doCAE(f, holder, before, after, meta);
        }

        private static short doCAE(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, short before, short after, Meta meta) {
            switch (f.getKind()) {
                case Short: {
                    return f.compareAndExchangeShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
                }
                case Char: {
                    return (short)f.compareAndExchangeChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), (char)before, (char)after);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    public static abstract class CompareAndExchangeByte
    extends UnsafeAccessNode {
        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, byte var5, byte var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        byte doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte before, byte after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeByte(CompareAndExchangeByte.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static byte doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte before, byte after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndExchangeByte.doCAE(f, holder, before, after, meta);
            }
            return CompareAndExchangeByte.doCAESlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static byte doCAESlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, byte before, byte after, Meta meta) {
            return CompareAndExchangeByte.doCAE(f, holder, before, after, meta);
        }

        private static byte doCAE(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, byte before, byte after, Meta meta) {
            switch (f.getKind()) {
                case Boolean: {
                    return f.compareAndExchangeBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before != 0, after != 0) ? (byte)1 : 0;
                }
                case Byte: {
                    return f.compareAndExchangeByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    @InlineInBytecode
    public static abstract class CompareAndExchangeInt
    extends UnsafeAccessNode {
        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5, int var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        int doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeInt(CompareAndExchangeInt.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static int doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndExchangeInt.doCAE(f, holder, before, after, meta);
            }
            return CompareAndExchangeInt.doCAESlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static int doCAESlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int before, int after, Meta meta) {
            return CompareAndExchangeInt.doCAE(f, holder, before, after, meta);
        }

        private static int doCAE(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int before, int after, Meta meta) {
            switch (f.getKind()) {
                case Int: {
                    return f.compareAndExchangeInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
                }
                case Float: {
                    return Float.floatToRawIntBits(f.compareAndExchangeFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), Float.intBitsToFloat(before), Float.intBitsToFloat(after)));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class)
    @InlineInBytecode
    public static abstract class CompareAndExchangeObject
    extends UnsafeAccessNode {
        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5, @JavaType(value=Object.class) StaticObject var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        @JavaType(value=Object.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return (StaticObject)UnsafeSupport.compareAndExchangeObject(CompareAndExchangeObject.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndExchangeObject.doCAE(f, holder, before, after, meta);
            }
            return CompareAndExchangeObject.doCAESlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static StaticObject doCAESlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject before, StaticObject after, Meta meta) {
            return CompareAndExchangeObject.doCAE(f, holder, before, after, meta);
        }

        private static StaticObject doCAE(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject before, StaticObject after, Meta meta) {
            if (f.getKind() != JavaKind.Object) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
            return f.compareAndExchangeObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class CompareAndSwapLong
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5, long var7);

        @Specialization(guards={"isNullOrArray(holder)"})
        boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).compareAndSwapLong(CompareAndSwapLong.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndSwapLong.doCAS(f, holder, before, after, meta);
            }
            return CompareAndSwapLong.doCASSlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean doCASSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long before, long after, Meta meta) {
            return CompareAndSwapLong.doCAS(f, holder, before, after, meta);
        }

        private static boolean doCAS(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long before, long after, Meta meta) {
            switch (f.getKind()) {
                case Long: {
                    return f.compareAndSwapLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
                }
                case Double: {
                    return f.compareAndSwapDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), Double.longBitsToDouble(before), Double.longBitsToDouble(after));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class CompareAndSwapInt
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5, int var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).compareAndSwapInt(CompareAndSwapInt.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndSwapInt.doCAS(f, holder, before, after, meta);
            }
            return CompareAndSwapInt.doCASSlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean doCASSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int before, int after, Meta meta) {
            return CompareAndSwapInt.doCAS(f, holder, before, after, meta);
        }

        private static boolean doCAS(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int before, int after, Meta meta) {
            switch (f.getKind()) {
                case Int: {
                    return f.compareAndSwapInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
                }
                case Float: {
                    return f.compareAndSwapFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), Float.intBitsToFloat(before), Float.intBitsToFloat(after));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class CompareAndSwapObject
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5, @JavaType(value=Object.class) StaticObject var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).compareAndSwapObject(CompareAndSwapObject.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return CompareAndSwapObject.doCAS(f, holder, before, after, meta);
            }
            return CompareAndSwapObject.doCASSlow(f, holder, before, after, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean doCASSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject before, StaticObject after, Meta meta) {
            return CompareAndSwapObject.doCAS(f, holder, before, after, meta);
        }

        private static boolean doCAS(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject before, StaticObject after, Meta meta) {
            return f.compareAndSwapObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), before, after);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putLongVolatile")
    @InlineInBytecode
    public static abstract class PutLongVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putLongVolatile(PutLongVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutLongVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutLongVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long value, Meta meta) {
            PutLongVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long value, Meta meta) {
            f.setLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putDoubleVolatile")
    @InlineInBytecode
    public static abstract class PutDoubleVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, double var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putDoubleVolatile(PutDoubleVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutDoubleVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutDoubleVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, double value, Meta meta) {
            PutDoubleVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, double value, Meta meta) {
            f.setDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putFloatVolatile")
    @InlineInBytecode
    public static abstract class PutFloatVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, float var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putFloatVolatile(PutFloatVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutFloatVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutFloatVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, float value, Meta meta) {
            PutFloatVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, float value, Meta meta) {
            f.setFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putIntVolatile")
    @InlineInBytecode
    public static abstract class PutIntVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putIntVolatile(PutIntVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutIntVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutIntVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int value, Meta meta) {
            PutIntVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int value, Meta meta) {
            f.setInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putShortVolatile")
    @InlineInBytecode
    public static abstract class PutShortVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, short var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putShortVolatile(PutShortVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutShortVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutShortVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, short value, Meta meta) {
            PutShortVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, short value, Meta meta) {
            f.setShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putCharVolatile")
    @InlineInBytecode
    public static abstract class PutCharVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, char var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putCharVolatile(PutCharVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutCharVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutCharVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, char value, Meta meta) {
            PutCharVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, char value, Meta meta) {
            f.setChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putBooleanVolatile")
    @InlineInBytecode
    public static abstract class PutBooleanVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, boolean var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putBooleanVolatile(PutBooleanVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutBooleanVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutBooleanVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, boolean value, Meta meta) {
            PutBooleanVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, boolean value, Meta meta) {
            f.setBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="putObjectVolatile")
    @InlineInBytecode
    public static abstract class PutObjectVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putObjectVolatile(PutObjectVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutObjectVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutObjectVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            PutObjectVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            f.setObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putByteVolatile")
    @InlineInBytecode
    public static abstract class PutByteVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, byte var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putByteVolatile(PutByteVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutByteVolatileWithBase.doPut(f, holder, value, meta);
            } else {
                PutByteVolatileWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, byte value, Meta meta) {
            PutByteVolatileWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, byte value, Meta meta) {
            f.setByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class GetLong
    extends UnsafeAccessNode {
        GetLong() {
        }

        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        long doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getLong(address);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class GetDouble
    extends UnsafeAccessNode {
        GetDouble() {
        }

        abstract double execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        double doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getDouble(address);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class GetFloat
    extends UnsafeAccessNode {
        GetFloat() {
        }

        abstract float execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        float doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getFloat(address);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class GetInt
    extends UnsafeAccessNode {
        GetInt() {
        }

        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        int doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getInt(address);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class GetShort
    extends UnsafeAccessNode {
        GetShort() {
        }

        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        short doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getShort(address);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class GetChar
    extends UnsafeAccessNode {
        GetChar() {
        }

        abstract char execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        char doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getChar(address);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class GetByte
    extends UnsafeAccessNode {
        GetByte() {
        }

        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        byte doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getByte(address);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getLongVolatile")
    @InlineInBytecode
    public static abstract class GetLongVolatileWithBase
    extends UnsafeAccessNode {
        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        long doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getLongVolatile(GetLongVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static long doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetLongVolatileWithBase.doGet(holder, f, meta);
            }
            return GetLongVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static long doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetLongVolatileWithBase.doGet(holder, f, meta);
        }

        private static long doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Long) {
                return f.getLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsLong(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getDoubleVolatile")
    @InlineInBytecode
    public static abstract class GetDoubleVolatileWithBase
    extends UnsafeAccessNode {
        abstract double execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        double doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getDoubleVolatile(GetDoubleVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static double doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetDoubleVolatileWithBase.doGet(holder, f, meta);
            }
            return GetDoubleVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static double doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetDoubleVolatileWithBase.doGet(holder, f, meta);
        }

        private static double doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Double) {
                return f.getDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsDouble(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getFloatVolatile")
    @InlineInBytecode
    public static abstract class GetFloatVolatileWithBase
    extends UnsafeAccessNode {
        abstract float execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        float doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getFloatVolatile(GetFloatVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static float doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetFloatVolatileWithBase.doGet(holder, f, meta);
            }
            return GetFloatVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static float doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetFloatVolatileWithBase.doGet(holder, f, meta);
        }

        private static float doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Float) {
                return f.getFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsFloat(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getIntVolatile")
    @InlineInBytecode
    public static abstract class GetIntVolatileWithBase
    extends UnsafeAccessNode {
        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        int doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getIntVolatile(GetIntVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static int doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetIntVolatileWithBase.doGet(holder, f, meta);
            }
            return GetIntVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static int doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetIntVolatileWithBase.doGet(holder, f, meta);
        }

        private static int doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Int) {
                return f.getInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsInt(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getShortVolatile")
    @InlineInBytecode
    public static abstract class GetShortVolatileWithBase
    extends UnsafeAccessNode {
        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        short doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getShortVolatile(GetShortVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static short doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetShortVolatileWithBase.doGet(holder, f, meta);
            }
            return GetShortVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static short doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetShortVolatileWithBase.doGet(holder, f, meta);
        }

        private static short doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Short) {
                return f.getShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsShort(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getCharVolatile")
    @InlineInBytecode
    public static abstract class GetCharVolatileWithBase
    extends UnsafeAccessNode {
        abstract char execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        char doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getCharVolatile(GetCharVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static char doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetCharVolatileWithBase.doGet(holder, f, meta);
            }
            return GetCharVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static char doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetCharVolatileWithBase.doGet(holder, f, meta);
        }

        private static char doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Char) {
                return f.getChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsChar(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getBooleanVolatile")
    @InlineInBytecode
    public static abstract class GetBooleanVolatileWithBase
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getBooleanVolatile(GetBooleanVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetBooleanVolatileWithBase.doGet(holder, f, meta);
            }
            return GetBooleanVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetBooleanVolatileWithBase.doGet(holder, f, meta);
        }

        private static boolean doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Boolean) {
                return f.getBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsBoolean(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="getObjectVolatile")
    @InlineInBytecode
    public static abstract class GetObjectVolatileWithBase
    extends UnsafeAccessNode {
        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        @JavaType(value=Object.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return (StaticObject)UnsafeAccess.getIfAllowed(this.getMeta()).getObjectVolatile(GetObjectVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetObjectVolatileWithBase.doGet(holder, f, meta);
            }
            return GetObjectVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static StaticObject doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetObjectVolatileWithBase.doGet(holder, f, meta);
        }

        private static StaticObject doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Object) {
                return f.getObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsObject(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getByteVolatile")
    @InlineInBytecode
    public static abstract class GetByteVolatileWithBase
    extends UnsafeAccessNode {
        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        byte doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getByteVolatile(GetByteVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static byte doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetByteVolatileWithBase.doGet(holder, f, meta);
            }
            return GetByteVolatileWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static byte doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetByteVolatileWithBase.doGet(holder, f, meta);
        }

        private static byte doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Byte) {
                return f.getByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), true);
            }
            return f.getAsByte(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getLong")
    @InlineInBytecode
    public static abstract class GetLongWithBase
    extends UnsafeAccessNode {
        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        long doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getLong(GetLongWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static long doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetLongWithBase.doGet(holder, f, meta);
            }
            return GetLongWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static long doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetLongWithBase.doGet(holder, f, meta);
        }

        private static long doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Long) {
                return f.getLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsLong(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getDouble")
    @InlineInBytecode
    public static abstract class GetDoubleWithBase
    extends UnsafeAccessNode {
        abstract double execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        double doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getDouble(GetDoubleWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static double doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetDoubleWithBase.doGet(holder, f, meta);
            }
            return GetDoubleWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static double doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetDoubleWithBase.doGet(holder, f, meta);
        }

        private static double doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Double) {
                return f.getDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsDouble(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getFloat")
    @InlineInBytecode
    public static abstract class GetFloatWithBase
    extends UnsafeAccessNode {
        abstract float execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        float doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getFloat(GetFloatWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static float doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetFloatWithBase.doGet(holder, f, meta);
            }
            return GetFloatWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static float doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetFloatWithBase.doGet(holder, f, meta);
        }

        private static float doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Float) {
                return f.getFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsFloat(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getInt")
    @InlineInBytecode
    public static abstract class GetIntWithBase
    extends UnsafeAccessNode {
        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        int doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getInt(GetIntWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static int doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetIntWithBase.doGet(holder, f, meta);
            }
            return GetIntWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static int doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetIntWithBase.doGet(holder, f, meta);
        }

        private static int doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Int) {
                return f.getInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsInt(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getShort")
    @InlineInBytecode
    public static abstract class GetShortWithBase
    extends UnsafeAccessNode {
        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        short doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getShort(GetShortWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static short doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetShortWithBase.doGet(holder, f, meta);
            }
            return GetShortWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static short doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetShortWithBase.doGet(holder, f, meta);
        }

        private static short doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Short) {
                return f.getShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsShort(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getChar")
    @InlineInBytecode
    public static abstract class GetCharWithBase
    extends UnsafeAccessNode {
        abstract char execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        char doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getChar(GetCharWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static char doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetCharWithBase.doGet(holder, f, meta);
            }
            return GetCharWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static char doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetCharWithBase.doGet(holder, f, meta);
        }

        private static char doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Char) {
                return f.getChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsChar(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getBoolean")
    @InlineInBytecode
    public static abstract class GetBooleanWithBase
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getBoolean(GetBooleanWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetBooleanWithBase.doGet(holder, f, meta);
            }
            return GetBooleanWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetBooleanWithBase.doGet(holder, f, meta);
        }

        private static boolean doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Boolean) {
                return f.getBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsBoolean(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="getObject")
    @InlineInBytecode
    public static abstract class GetObjectWithBase
    extends UnsafeAccessNode {
        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        @JavaType(value=Object.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return (StaticObject)UnsafeAccess.getIfAllowed(this.getMeta()).getObject(GetObjectWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static @JavaType(value=Object.class) StaticObject doField(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetObjectWithBase.doGetField(holder, f, meta);
            }
            return GetObjectWithBase.doGetFieldSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static StaticObject doGetFieldSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetObjectWithBase.doGetField(holder, f, meta);
        }

        private static StaticObject doGetField(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Object) {
                return f.getObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsObject(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="getByte")
    @InlineInBytecode
    public static abstract class GetByteWithBase
    extends UnsafeAccessNode {
        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        byte doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getByte(GetByteWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static byte doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                return GetByteWithBase.doGet(holder, f, meta);
            }
            return GetByteWithBase.doGetSlow(holder, f, meta);
        }

        @CompilerDirectives.TruffleBoundary
        private static byte doGetSlow(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            return GetByteWithBase.doGet(holder, f, meta);
        }

        private static byte doGet(StaticObject holder, com.oracle.truffle.espresso.impl.Field f, Meta meta) {
            if (f.getKind() == JavaKind.Byte) {
                return f.getByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta));
            }
            return f.getAsByte(meta, Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), false);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    @InlineInBytecode
    public static abstract class PutOrderedObject
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putOrderedObject(PutOrderedObject.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutOrderedObject.doPut(f, holder, value, meta);
            } else {
                PutOrderedObject.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            PutOrderedObject.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            f.setObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    @InlineInBytecode
    public static abstract class PutOrderedLong
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putOrderedLong(PutOrderedLong.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutOrderedLong.doPut(f, holder, value, meta);
            } else {
                PutOrderedLong.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long value, Meta meta) {
            PutOrderedLong.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long value, Meta meta) {
            f.setLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    @InlineInBytecode
    public static abstract class PutOrderedInt
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putOrderedInt(PutOrderedInt.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutOrderedInt.doPut(f, holder, value, meta);
            } else {
                PutOrderedInt.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int value, Meta meta) {
            PutOrderedInt.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int value, Meta meta) {
            f.setInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value, true);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putLong")
    @InlineInBytecode
    public static abstract class PutLongWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putLong(PutLongWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutLongWithBase.doPut(f, holder, value, meta);
            } else {
                PutLongWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long value, Meta meta) {
            PutLongWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, long value, Meta meta) {
            f.setLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putDouble")
    @InlineInBytecode
    public static abstract class PutDoubleWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, double var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putDouble(PutDoubleWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutDoubleWithBase.doPut(f, holder, value, meta);
            } else {
                PutDoubleWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, double value, Meta meta) {
            PutDoubleWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, double value, Meta meta) {
            f.setDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putFloat")
    @InlineInBytecode
    public static abstract class PutFloatWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, float var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putFloat(PutFloatWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutFloatWithBase.doPut(f, holder, value, meta);
            } else {
                PutFloatWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, float value, Meta meta) {
            PutFloatWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, float value, Meta meta) {
            f.setFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putInt")
    @InlineInBytecode
    public static abstract class PutIntWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putInt(PutIntWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutIntWithBase.doPut(f, holder, value, meta);
            } else {
                PutIntWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int value, Meta meta) {
            PutIntWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, int value, Meta meta) {
            f.setInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putShort")
    @InlineInBytecode
    public static abstract class PutShortWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, short var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putShort(PutShortWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutShortWithBase.doPut(f, holder, value, meta);
            } else {
                PutShortWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, short value, Meta meta) {
            PutShortWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, short value, Meta meta) {
            f.setShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putChar")
    @InlineInBytecode
    public static abstract class PutCharWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, char var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putChar(PutCharWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutCharWithBase.doPut(f, holder, value, meta);
            } else {
                PutCharWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, char value, Meta meta) {
            PutCharWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, char value, Meta meta) {
            f.setChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putBoolean")
    @InlineInBytecode
    public static abstract class PutBooleanWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, boolean var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putBoolean(PutBooleanWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutBooleanWithBase.doPut(f, holder, value, meta);
            } else {
                PutBooleanWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, boolean value, Meta meta) {
            PutBooleanWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, boolean value, Meta meta) {
            f.setBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="putObject")
    @InlineInBytecode
    public static abstract class PutObjectWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putObject(PutObjectWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, StaticObject value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutObjectWithBase.doPut(f, holder, value, meta);
            } else {
                PutObjectWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            PutObjectWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, StaticObject value, Meta meta) {
            f.setObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true, methodName="putByte")
    @InlineInBytecode
    public static abstract class PutByteWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, byte var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putByte(PutByteWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        static void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value, @Bind Node node, @Cached GetFieldFromIndexNode getField, @Cached InlinedBranchProfile noField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(node, holder, offset);
            Meta meta = EspressoContext.get(node).getMeta();
            if (f == null) {
                noField.enter(node);
                throw Target_sun_misc_Unsafe.throwNoField(meta, holder, offset);
            }
            if (CompilerDirectives.isPartialEvaluationConstant((Object)f)) {
                PutByteWithBase.doPut(f, holder, value, meta);
            } else {
                PutByteWithBase.doPutSlow(f, holder, value, meta);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPutSlow(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, byte value, Meta meta) {
            PutByteWithBase.doPut(f, holder, value, meta);
        }

        private static void doPut(com.oracle.truffle.espresso.impl.Field f, StaticObject holder, byte value, Meta meta) {
            f.setByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, meta), value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class PutLong
    extends UnsafeAccessNode {
        PutLong() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, long var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putLong(address, value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class PutDouble
    extends UnsafeAccessNode {
        PutDouble() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, double var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, double value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putDouble(address, value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class PutFloat
    extends UnsafeAccessNode {
        PutFloat() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, float var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, float value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putFloat(address, value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class PutInt
    extends UnsafeAccessNode {
        PutInt() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, int var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putInt(address, value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class PutShort
    extends UnsafeAccessNode {
        PutShort() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, short var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, short value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putShort(address, value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class PutChar
    extends UnsafeAccessNode {
        PutChar() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, char var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, char value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putChar(address, value);
        }
    }

    @GenerateInline(value=false)
    @Substitution(hasReceiver=true)
    static abstract class PutByte
    extends UnsafeAccessNode {
        PutByte() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, byte var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, byte value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putByte(address, value);
        }
    }

    static abstract class UnsafeAccessNode
    extends SubstitutionNode {
        UnsafeAccessNode() {
        }

        protected static boolean isNullOrArray(StaticObject object) {
            return StaticObject.isNull(object) || object.isArray();
        }

        protected static Object unwrapNullOrArray(EspressoLanguage language, StaticObject object) {
            assert (UnsafeAccessNode.isNullOrArray(object));
            if (StaticObject.isNull(object)) {
                return null;
            }
            return object.unwrap(language);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetFieldFromIndexNode
    extends EspressoInlineNode {
        static final int LIMIT = 3;

        GetFieldFromIndexNode() {
        }

        abstract com.oracle.truffle.espresso.impl.Field execute(Node var1, StaticObject var2, long var3);

        @Specialization(guards={"slot == cachedSlot", "holder.isStaticStorage() == cachedIsStaticStorage", "holder.getKlass() == cachedKlass"}, limit="LIMIT")
        static com.oracle.truffle.espresso.impl.Field doCached(StaticObject holder, long slot, @Bind Node node, @Cached(value="slot") long cachedSlot, @Cached(value="holder.getKlass()") Klass cachedKlass, @Cached(value="holder.isStaticStorage()") boolean cachedIsStaticStorage, @Cached(value="doGeneric(holder, slot, node)") com.oracle.truffle.espresso.impl.Field cachedField) {
            return cachedField;
        }

        @Specialization(replaces={"doCached"})
        static com.oracle.truffle.espresso.impl.Field doGeneric(StaticObject holder, long slot, @Bind Node node) {
            Meta meta = EspressoContext.get(node).getMeta();
            return Target_sun_misc_Unsafe.resolveUnsafeAccessField(holder, slot, meta, EspressoLanguage.get(node));
        }
    }

    public static final class GraalGuestFieldOffsetStrategy
    implements GuestFieldOffsetStrategy {
        @Override
        public int guestOffsetToSlot(long guestOffset) {
            return Math.toIntExact(guestOffset) >> 2;
        }

        @Override
        public boolean forceStatic(long guestOffset) {
            return false;
        }

        @Override
        public long slotToGuestOffset(int slot, boolean isStatic) {
            return (long)slot << 2;
        }

        @Override
        public boolean isAllowed(JavaVersion v) {
            return v.java18OrEarlier() || v.java21OrLater();
        }

        @Override
        public String name() {
            return "graal";
        }
    }

    public static final class CompactGuestFieldOffsetStrategy
    implements GuestFieldOffsetStrategy {
        @Override
        public int guestOffsetToSlot(long guestOffset) {
            return Math.toIntExact(guestOffset);
        }

        @Override
        public boolean forceStatic(long guestOffset) {
            return false;
        }

        @Override
        public long slotToGuestOffset(int slot, boolean isStatic) {
            return slot;
        }

        @Override
        public boolean isAllowed(JavaVersion v) {
            return v.java18OrEarlier() || v.java21OrLater();
        }

        @Override
        public String name() {
            return "compact";
        }
    }

    public static final class SafetyGuestFieldOffsetStrategy
    implements GuestFieldOffsetStrategy {
        @Override
        public int guestOffsetToSlot(long guestOffset) {
            int offset = Math.toIntExact(guestOffset);
            if (SafetyGuestFieldOffsetStrategy.forceStatic(offset)) {
                return offset - 3456789;
            }
            return offset - 123456789;
        }

        @Override
        public boolean forceStatic(long guestOffset) {
            return SafetyGuestFieldOffsetStrategy.forceStatic(Math.toIntExact(guestOffset));
        }

        private static boolean forceStatic(int guestOffset) {
            return guestOffset < 123452693;
        }

        @Override
        public long slotToGuestOffset(int slot, boolean isStatic) {
            return (long)(isStatic ? 3456789 : 123456789) + (long)slot;
        }

        @Override
        public boolean isAllowed(JavaVersion v) {
            return true;
        }

        @Override
        public String name() {
            return "safety";
        }
    }
}

