/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.ffi.nfi.NFISulongNativeAccess;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.VersionFilter;

@EspressoSubstitutions
public final class Target_sun_nio_ch_NativeThread {

    @Substitution(versionFilter=VersionFilter.Java17OrEarlier.class)
    static abstract class Signal
    extends SubstitutionNode {
        Signal() {
        }

        abstract void execute(long var1);

        @Specialization
        static void doDefault(long nt, @Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().sun_nio_ch_NativeThread_signal.getCallTargetNoSubstitution())") DirectCallNode original) {
            if (!(context.getNativeAccess() instanceof NFISulongNativeAccess)) {
                original.call(new Object[]{nt});
            }
        }
    }

    @Substitution(versionFilter=VersionFilter.Java21OrLater.class)
    static abstract class Current0
    extends SubstitutionNode {
        Current0() {
        }

        abstract long execute();

        @Specialization
        static long doDefault(@Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().sun_nio_ch_NativeThread_current0.getCallTargetNoSubstitution())") DirectCallNode original) {
            if (context.getNativeAccess() instanceof NFISulongNativeAccess) {
                return 0L;
            }
            return (Long)original.call(new Object[0]);
        }
    }

    @Substitution(versionFilter=VersionFilter.Java21OrLater.class)
    static abstract class IsNativeThread
    extends SubstitutionNode {
        IsNativeThread() {
        }

        abstract boolean execute(long var1);

        @Specialization
        static boolean doDefault(long tid, @Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().sun_nio_ch_NativeThread_isNativeThread.getCallTargetNoSubstitution())") DirectCallNode original) {
            if (context.getNativeAccess() instanceof NFISulongNativeAccess) {
                return false;
            }
            return (Boolean)original.call(new Object[]{tid});
        }
    }

    @Substitution
    static abstract class Init
    extends SubstitutionNode {
        Init() {
        }

        abstract void execute();

        @Specialization
        static void doDefault(@Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().sun_nio_ch_NativeThread_init.getCallTargetNoSubstitution())") DirectCallNode original) {
            if (EspressoOptions.RUNNING_ON_SVM && !(context.getNativeAccess() instanceof NFISulongNativeAccess)) {
                original.call(new Object[0]);
            }
        }
    }
}

