/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.threads;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.ThreadsAccess;
import com.oracle.truffle.espresso.vm.VM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;

public final class EspressoThreadRegistry
extends ContextAccessImpl {
    private static final int DEFAULT_THREAD_ARRAY_SIZE = 8;
    private final TruffleLogger logger = TruffleLogger.getLogger((String)"java", EspressoThreadRegistry.class);
    private final Set<StaticObject> activeThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Object activeThreadLock = new Object(){};
    private final AtomicLong nextThreadId = new AtomicLong(2L);
    private Object[] guestThreads = new Object[8];
    @CompilerDirectives.CompilationFinal
    private boolean mainThreadCreated = false;
    @CompilerDirectives.CompilationFinal
    private StaticObject mainThreadGroup = null;
    @CompilerDirectives.CompilationFinal
    private long mainThreadId = -1L;
    @CompilerDirectives.CompilationFinal
    private StaticObject guestMainThread = null;
    @CompilerDirectives.CompilationFinal
    private long finalizerThreadId = -1L;
    @CompilerDirectives.CompilationFinal
    private StaticObject guestFinalizerThread = null;
    @CompilerDirectives.CompilationFinal
    private long referenceHandlerThreadId = -1L;
    @CompilerDirectives.CompilationFinal
    private StaticObject guestReferenceHandlerThread = null;
    public final AtomicLong createdThreadCount = new AtomicLong();
    public final AtomicLong peakThreadCount = new AtomicLong();

    public EspressoThreadRegistry(EspressoContext context) {
        super(context);
    }

    @CompilerDirectives.TruffleBoundary
    public StaticObject[] activeThreads() {
        return this.activeThreads.toArray(StaticObject.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMainThread(Thread thread, StaticObject guest) {
        Object object = this.activeThreadLock;
        synchronized (object) {
            this.mainThreadId = EspressoThreadRegistry.getThreadId(thread);
            this.guestMainThread = guest;
        }
        this.activeThreads.add(guest);
        this.getContext().registerCurrentThread(guest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(Thread host, StaticObject guest) {
        Object object;
        this.activeThreads.add(guest);
        this.createdThreadCount.incrementAndGet();
        this.peakThreadCount.updateAndGet(new LongUnaryOperator(){

            @Override
            public long applyAsLong(long oldPeak) {
                return Math.max(oldPeak, (long)EspressoThreadRegistry.this.activeThreads.size());
            }
        });
        if (this.finalizerThreadId == -1L && this.getMeta().java_lang_ref_Finalizer$FinalizerThread == guest.getKlass()) {
            object = this.activeThreadLock;
            synchronized (object) {
                if (this.finalizerThreadId == -1L) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.finalizerThreadId = EspressoThreadRegistry.getThreadId(host);
                    this.guestFinalizerThread = guest;
                    return;
                }
            }
        }
        if (this.referenceHandlerThreadId == -1L && this.getMeta().java_lang_ref_Reference$ReferenceHandler == guest.getKlass()) {
            object = this.activeThreadLock;
            synchronized (object) {
                if (this.referenceHandlerThreadId == -1L) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.referenceHandlerThreadId = EspressoThreadRegistry.getThreadId(host);
                    this.guestReferenceHandlerThread = guest;
                    return;
                }
            }
        }
        this.pushThread(Math.toIntExact(EspressoThreadRegistry.getThreadId(host)), guest);
        if (host == Thread.currentThread()) {
            this.getContext().registerCurrentThread(guest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN"}, justification="Removing a thread from the active set is the state change we need.")
    public boolean unregisterThread(StaticObject thread) {
        if (!this.activeThreads.remove(thread)) {
            return false;
        }
        this.logger.fine(() -> {
            String guestName = this.getThreadAccess().getThreadName(thread);
            long guestId = this.getThreadAccess().getThreadId(thread);
            return String.format("unregisterThread([GUEST:%s, %d])", guestName, guestId);
        });
        Thread hostThread = this.getThreadAccess().getHost(thread);
        int id = Math.toIntExact(EspressoThreadRegistry.getThreadId(hostThread));
        Object object = this.activeThreadLock;
        synchronized (object) {
            if ((long)id == this.mainThreadId) {
                this.mainThreadId = -1L;
                this.guestMainThread = null;
            } else if ((long)id == this.finalizerThreadId) {
                this.guestFinalizerThread = null;
                this.finalizerThreadId = -1L;
            } else if ((long)id == this.referenceHandlerThreadId) {
                this.guestReferenceHandlerThread = null;
                this.referenceHandlerThreadId = -1L;
            } else {
                Object[] threads = this.guestThreads;
                int threadIndex = EspressoThreadRegistry.getThreadIndex(id, threads);
                if (this.getThreadAccess().isAlive(thread)) {
                    assert (threads[threadIndex] == thread);
                    threads[threadIndex] = null;
                } else if (0 <= threadIndex && threadIndex < threads.length && threads[threadIndex] == thread) {
                    threads[threadIndex] = null;
                }
            }
        }
        this.getLanguage().getThreadLocalState().clearCurrentThread(thread);
        this.getContext().notifyShutdownSynchronizer();
        return true;
    }

    public StaticObject getGuestThreadFromHost(Thread host) {
        int id = Math.toIntExact(EspressoThreadRegistry.getThreadId(host));
        if ((long)id == this.mainThreadId) {
            return this.guestMainThread;
        }
        if ((long)id == this.finalizerThreadId) {
            return this.guestFinalizerThread;
        }
        if ((long)id == this.referenceHandlerThreadId) {
            return this.guestReferenceHandlerThread;
        }
        Object[] threads = this.guestThreads;
        if (threads[0] == null) {
            return null;
        }
        int index = EspressoThreadRegistry.getThreadIndex(id, threads);
        if (index <= 0 || index >= threads.length) {
            return null;
        }
        return (StaticObject)threads[index];
    }

    public StaticObject getMainThread() {
        return this.guestMainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticObject createGuestThreadFromHost(Thread hostThread, Meta meta, VM vm, String name, StaticObject threadGroup, boolean managedByEspresso) {
        if (meta == null) {
            return null;
        }
        Object object = this.activeThreadLock;
        synchronized (object) {
            StaticObject exisitingThread = this.getGuestThreadFromHost(hostThread);
            if (exisitingThread != null) {
                return exisitingThread;
            }
            StaticObject effectiveThreadGroup = threadGroup;
            if (effectiveThreadGroup == null || StaticObject.isNull(effectiveThreadGroup)) {
                effectiveThreadGroup = this.getContext().getMainThreadGroup();
            }
            vm.attachThread(hostThread);
            StaticObject guestThread = meta.java_lang_Thread.allocateInstance(this.getContext());
            if (this.getJavaVersion().java17OrEarlier()) {
                this.getThreadAccess().setPriority(guestThread, 5);
            }
            this.getThreadAccess().setEETopAlive(guestThread);
            this.getThreadAccess().initializeHiddenFields(guestThread, hostThread, managedByEspresso);
            this.registerThread(hostThread, guestThread);
            assert (this.getThreadAccess().getCurrentGuestThread() != null);
            if (name == null) {
                meta.java_lang_Thread_init_ThreadGroup_Runnable.invokeDirectSpecial(guestThread, effectiveThreadGroup, StaticObject.NULL);
            } else {
                meta.java_lang_Thread_init_ThreadGroup_String.invokeDirectSpecial(guestThread, effectiveThreadGroup, meta.toGuestString(name));
            }
            if (this.getJavaVersion().java17OrEarlier()) {
                meta.java_lang_ThreadGroup_add.invokeDirectVirtual(effectiveThreadGroup, guestThread);
            }
            this.getThreadAccess().setState(guestThread, State.RUNNABLE.value);
            this.logger.fine(() -> {
                String guestName = this.getThreadAccess().getThreadName(guestThread);
                long guestId = this.getThreadAccess().getThreadId(guestThread);
                return String.format("createGuestThreadFromHost: [HOST:%s, %d], [GUEST:%s, %d]", hostThread.getName(), EspressoThreadRegistry.getThreadId(hostThread), guestName, guestId);
            });
            return guestThread;
        }
    }

    public void createMainThread(Meta meta) {
        this.getNativeAccess().prepareThread();
        this.createMainThreadGroup(meta);
        StaticObject mainThread = meta.java_lang_Thread.allocateInstance(this.getContext());
        Thread hostThread = Thread.currentThread();
        if (this.getJavaVersion().java17OrEarlier()) {
            this.getThreadAccess().setPriority(mainThread, 5);
        }
        this.getThreadAccess().setEETopAlive(mainThread);
        this.getThreadAccess().initializeHiddenFields(mainThread, hostThread, false);
        this.registerMainThread(hostThread, mainThread);
        meta.java_lang_Thread_init_ThreadGroup_String.invokeDirectSpecial(mainThread, this.mainThreadGroup, meta.toGuestString("main"));
        this.getThreadAccess().setState(mainThread, State.RUNNABLE.value);
        this.mainThreadCreated = true;
        this.logger.fine(() -> {
            String guestName = this.getThreadAccess().getThreadName(mainThread);
            long guestId = this.getThreadAccess().getThreadId(mainThread);
            return String.format("createMainThread: [HOST:%s, %d], [GUEST:%s, %d]", hostThread.getName(), EspressoThreadRegistry.getThreadId(hostThread), guestName, guestId);
        });
    }

    private void createMainThreadGroup(Meta meta) {
        assert (this.mainThreadGroup == null);
        StaticObject systemThreadGroup = meta.java_lang_ThreadGroup.allocateInstance(this.getContext());
        meta.java_lang_ThreadGroup.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void).invokeDirectSpecial(systemThreadGroup);
        this.mainThreadGroup = meta.java_lang_ThreadGroup.allocateInstance(this.getContext());
        meta.java_lang_ThreadGroup.lookupDeclaredMethod(Symbol.Name._init_, Symbol.Signature._void_ThreadGroup_String).invokeDirectSpecial(this.mainThreadGroup, systemThreadGroup, meta.toGuestString("main"));
    }

    public boolean isMainThreadCreated() {
        return this.mainThreadCreated;
    }

    public StaticObject getMainThreadGroup() {
        return this.mainThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushThread(int id, StaticObject self) {
        Object object = this.activeThreadLock;
        synchronized (object) {
            int threadIndex;
            Object[] threads = this.guestThreads;
            if (threads[0] == null) {
                threads[0] = id - 1;
            }
            if ((threadIndex = EspressoThreadRegistry.getThreadIndex(id, threads)) >= threads.length || threadIndex < 1) {
                this.refactorGuestThreads(id, self);
                return;
            }
            assert (threads[threadIndex] == null);
            threads[threadIndex] = self;
        }
    }

    private void refactorGuestThreads(int id, StaticObject self) {
        assert (Thread.holdsLock(this.activeThreadLock));
        Object[] oldThreads = this.guestThreads;
        int minID = id;
        int maxID = id;
        ArrayList<StaticObject> toRelocate = new ArrayList<StaticObject>();
        for (int i = 1; i < oldThreads.length; ++i) {
            if (oldThreads[i] == null) continue;
            StaticObject guestThread = (StaticObject)oldThreads[i];
            if (!this.getThreadAccess().isAlive(guestThread)) continue;
            Thread hostThread = this.getThreadAccess().getHost(guestThread);
            int hostID = Math.toIntExact(EspressoThreadRegistry.getThreadId(hostThread));
            if (hostID < minID) {
                minID = hostID;
            }
            if (hostID > maxID) {
                maxID = hostID;
            }
            toRelocate.add(guestThread);
        }
        int span = maxID - minID;
        int newLength = 1;
        newLength += span;
        newLength += Math.max(toRelocate.size() + 1, span / 2);
        newLength = Math.max(newLength, 8);
        Object[] newThreads = new Object[newLength];
        int newOffset = minID - 1;
        newThreads[0] = newOffset;
        for (StaticObject guestThread : toRelocate) {
            int hostId = Math.toIntExact(EspressoThreadRegistry.getThreadId(this.getThreadAccess().getHost(guestThread)));
            newThreads[hostId - newOffset] = guestThread;
        }
        newThreads[id - newOffset] = self;
        this.guestThreads = newThreads;
    }

    private static int getThreadIndex(int id, Object[] threads) {
        return id - (Integer)threads[0];
    }

    public static long getThreadId(Thread thread) {
        return thread.getId();
    }

    public long nextThreadId() {
        return this.nextThreadId.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void resetPeakThreadCount() {
        Object object = this.activeThreadLock;
        synchronized (object) {
            this.peakThreadCount.set(this.activeThreads.size());
        }
    }

    private EspressoLock getCurrentPendingMonitor(StaticObject thread) {
        StaticObject obj = (StaticObject)this.getMeta().HIDDEN_THREAD_PENDING_MONITOR.getHiddenObject(thread);
        if (obj == null) {
            return null;
        }
        return obj.getLock(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticObject[] findDeadlocks(boolean objectMonitorsOnly) {
        assert (objectMonitorsOnly);
        Object object = this.activeThreadLock;
        synchronized (object) {
            StaticObject[] threads;
            ThreadsAccess threadAccess = this.getThreadAccess();
            for (StaticObject thread : threads = this.activeThreads()) {
                if (threadAccess.isVirtualOrCarrierThread(thread)) continue;
                threadAccess.setDepthFirstNumber(thread, -1);
            }
            int globalDepthFirstNumber = 0;
            ArrayList<StaticObject> deadLockedGuestThreads = new ArrayList<StaticObject>();
            block4: for (StaticObject thread : threads) {
                if (threadAccess.isVirtualOrCarrierThread(thread) || threadAccess.getDepthFirstNumber(thread) >= 0) continue;
                int startDepthFirstNumber = globalDepthFirstNumber;
                threadAccess.setDepthFirstNumber(thread, globalDepthFirstNumber++);
                DeadlockCycle cycle = new DeadlockCycle(thread);
                StaticObject currentThread = thread;
                EspressoLock waitingToLockMonitor = this.getCurrentPendingMonitor(currentThread);
                while (waitingToLockMonitor != null) {
                    Thread ownerThread = waitingToLockMonitor.getOwnerThread();
                    if (ownerThread == null) {
                        cycle.addTo(deadLockedGuestThreads);
                        continue block4;
                    }
                    currentThread = this.getGuestThreadFromHost(ownerThread);
                    if (currentThread == null || threadAccess.isVirtualOrCarrierThread(currentThread)) continue block4;
                    cycle = new DeadlockCycle(currentThread, cycle);
                    int currentThreadDFN = threadAccess.getDepthFirstNumber(currentThread);
                    if (currentThreadDFN >= 0) {
                        if (currentThreadDFN < startDepthFirstNumber || currentThread == cycle.prev.thread) continue block4;
                        cycle.addTo(deadLockedGuestThreads);
                        continue block4;
                    }
                    threadAccess.setDepthFirstNumber(currentThread, globalDepthFirstNumber++);
                    waitingToLockMonitor = this.getCurrentPendingMonitor(currentThread);
                }
            }
            return deadLockedGuestThreads.toArray(StaticObject.EMPTY_ARRAY);
        }
    }

    private static final class DeadlockCycle {
        DeadlockCycle prev;
        final StaticObject thread;

        DeadlockCycle(StaticObject thread) {
            this.thread = thread;
        }

        DeadlockCycle(StaticObject thread, DeadlockCycle prev) {
            this.thread = thread;
            this.prev = prev;
        }

        void addTo(List<StaticObject> threads) {
            DeadlockCycle p = this;
            while (p != null) {
                threads.add(p.thread);
                p = p.prev;
            }
        }
    }
}

