/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.threads;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.blocking.GuestInterrupter;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.threads.GuestRunnable;
import com.oracle.truffle.espresso.threads.KillStatus;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.SuspendLock;

public final class ThreadsAccess
extends ContextAccessImpl
implements GuestInterrupter<StaticObject> {
    public static final long ALIVE_EETOP = 3405691582L;
    private final Meta meta;

    @Override
    public void guestInterrupt(Thread t, StaticObject guest) {
        StaticObject g = guest;
        if (g == null) {
            g = this.getThreadFromHost(t);
        }
        this.doInterrupt(g);
    }

    @Override
    public boolean isGuestInterrupted(Thread t, StaticObject guest) {
        StaticObject g = guest;
        if (g == null) {
            g = this.getThreadFromHost(t);
        }
        return this.isInterrupted(g, false);
    }

    @Override
    public StaticObject getCurrentGuestThread() {
        return this.getContext().getCurrentPlatformThread();
    }

    public ThreadsAccess(Meta meta) {
        super(meta.getContext());
        this.meta = meta;
    }

    private StaticObject getThreadFromHost(Thread t) {
        if (t == Thread.currentThread()) {
            return this.getCurrentGuestThread();
        }
        return this.getContext().getGuestThreadFromHost(t);
    }

    public String getThreadName(StaticObject thread) {
        if (thread == null) {
            return "<unknown>";
        }
        return this.meta.toHostString(this.meta.java_lang_Thread_name.getObject(thread));
    }

    public long getThreadId(StaticObject thread) {
        if (thread == null) {
            return -1L;
        }
        return (Long)this.meta.java_lang_Thread_tid.get(thread);
    }

    public Thread getHost(StaticObject guest) {
        return (Thread)this.meta.HIDDEN_HOST_THREAD.getHiddenObject(guest);
    }

    public int getState(StaticObject guest) {
        if (this.meta.getJavaVersion().java17OrEarlier()) {
            return this.meta.java_lang_Thread_threadStatus.getInt(guest);
        }
        StaticObject holder = this.meta.java_lang_Thread_holder.getObject(guest);
        if (StaticObject.isNull(holder)) {
            return State.NEW.value;
        }
        return this.meta.java_lang_Thread$FieldHolder_threadStatus.getInt(holder);
    }

    void setPriority(StaticObject thread, int priority) {
        if (this.meta.getJavaVersion().java17OrEarlier()) {
            this.meta.java_lang_Thread_priority.setInt(thread, priority);
        } else {
            StaticObject holder = this.meta.java_lang_Thread_holder.getObject(thread);
            this.meta.java_lang_Thread$FieldHolder_priority.setInt(holder, priority);
        }
    }

    void setEETopAlive(StaticObject thread) {
        this.meta.java_lang_Thread_eetop.setLong(thread, 3405691582L);
    }

    void setEETopDead(StaticObject thread) {
        this.meta.java_lang_Thread_eetop.setLong(thread, 0L);
    }

    long getEETop(StaticObject thread) {
        return this.meta.java_lang_Thread_eetop.getLong(thread);
    }

    int fromRunnable(StaticObject self, State state) {
        int old = this.getState(self);
        assert ((old & State.RUNNABLE.value) != 0 || old == State.NEW.value) : old;
        this.setState(self, state.value);
        this.fullSafePoint(self);
        return old;
    }

    void restoreState(StaticObject self, int toRestore) {
        try {
            this.fullSafePoint(self);
        }
        finally {
            this.setState(self, toRestore);
        }
    }

    void setState(StaticObject self, int state) {
        if (this.meta.getJavaVersion().java17OrEarlier()) {
            this.meta.java_lang_Thread_threadStatus.setInt(self, state);
        } else {
            StaticObject holder = this.meta.java_lang_Thread_holder.getObject(self);
            this.meta.java_lang_Thread$FieldHolder_threadStatus.setInt(holder, state);
        }
    }

    int getPriority(StaticObject thread) {
        if (this.getJavaVersion().java17OrEarlier()) {
            return this.meta.java_lang_Thread_priority.getInt(thread);
        }
        StaticObject holder = this.meta.java_lang_Thread_holder.getObject(thread);
        return this.meta.java_lang_Thread$FieldHolder_priority.getInt(holder);
    }

    public boolean isDaemon(StaticObject thread) {
        if (this.getJavaVersion().java17OrEarlier()) {
            return this.meta.java_lang_Thread_daemon.getBoolean(thread);
        }
        StaticObject holder = this.meta.java_lang_Thread_holder.getObject(thread);
        return this.meta.java_lang_Thread$FieldHolder_daemon.getBoolean(holder);
    }

    public void setDaemon(StaticObject thread, boolean daemon) {
        if (this.getJavaVersion().java17OrEarlier()) {
            this.meta.java_lang_Thread_daemon.setBoolean(thread, daemon);
        } else {
            StaticObject holder = this.meta.java_lang_Thread_holder.getObject(thread);
            this.meta.java_lang_Thread$FieldHolder_daemon.setBoolean(holder, daemon);
        }
    }

    public StaticObject getThreadGroup(StaticObject thread) {
        if (this.getJavaVersion().java19OrLater()) {
            int state = this.getState(thread);
            if (state == State.TERMINATED.value) {
                return StaticObject.NULL;
            }
            if (this.isVirtualThread(thread)) {
                return this.meta.java_lang_Thread$Constants_VTHREAD_GROUP.getObject(this.meta.java_lang_Thread$Constants.getStatics());
            }
            StaticObject holder = this.meta.java_lang_Thread_holder.getObject(thread);
            return this.meta.java_lang_Thread$FieldHolder_group.getObject(holder);
        }
        return this.meta.java_lang_Thread_threadGroup.getObject(thread);
    }

    public boolean isVirtualThread(StaticObject thread) {
        assert (!StaticObject.isNull(thread));
        return this.meta.java_lang_BaseVirtualThread.isAssignableFrom(thread.getKlass());
    }

    public boolean isVirtualOrCarrierThread(StaticObject thread) {
        assert (!StaticObject.isNull(thread));
        return this.meta.java_lang_BaseVirtualThread.isAssignableFrom(thread.getKlass());
    }

    private int updateState(StaticObject self, State state) {
        int old = this.getState(self);
        int value = old | state.value;
        this.setState(self, value);
        return old;
    }

    public void fullSafePoint(StaticObject thread) {
        assert (thread == this.getContext().getCurrentPlatformThread());
        this.handleStop(thread);
        this.handleSuspend(thread);
    }

    void handleSuspend(StaticObject current) {
        DeprecationSupport support = this.getDeprecationSupport(current, false);
        if (support == null) {
            return;
        }
        support.handleSuspend();
    }

    void handleStop(StaticObject current) {
        DeprecationSupport support = this.getDeprecationSupport(current, false);
        if (support == null) {
            return;
        }
        support.handleStop();
    }

    public boolean isInterrupted(StaticObject guest, boolean clear) {
        if (this.getContext().getJavaVersion().java13OrEarlier() && !this.isAlive(guest)) {
            return false;
        }
        boolean isInterrupted = this.meta.HIDDEN_INTERRUPTED.getBoolean(guest, true);
        if (clear) {
            Thread host = this.getHost(guest);
            EspressoError.guarantee(host == Thread.currentThread(), "Thread#isInterrupted(true) is only supported for the current thread.");
            if (host != null && host.isInterrupted()) {
                Thread.interrupted();
            }
            this.clearInterruptStatus(guest);
        }
        return isInterrupted;
    }

    public void callInterrupt(StaticObject guestThread) {
        assert (guestThread != null && this.getMeta().java_lang_Thread.isAssignableFrom(guestThread.getKlass()));
        this.getMeta().java_lang_Thread_interrupt.invokeDirectVirtual(guestThread);
    }

    public void interrupt(StaticObject guest) {
        this.getContext().getBlockingSupport().guestInterrupt(this.getHost(guest), guest);
    }

    private void doInterrupt(StaticObject guest) {
        if (this.getContext().getJavaVersion().java13OrEarlier() && this.isAlive(guest)) {
            this.meta.HIDDEN_INTERRUPTED.setBoolean(guest, true, true);
        }
    }

    public void clearInterruptEvent() {
        assert (!this.getContext().getJavaVersion().java13OrEarlier());
        Thread.interrupted();
    }

    public void clearInterruptStatus(StaticObject guest) {
        this.meta.HIDDEN_INTERRUPTED.setBoolean(guest, false, true);
    }

    public boolean isAlive(StaticObject guest) {
        int state = this.getState(guest);
        return state != State.NEW.value && state != State.TERMINATED.value;
    }

    public boolean isExecutingGuestCode(StaticObject guest) {
        int state = this.getState(guest);
        return state == State.RUNNABLE.value;
    }

    public boolean isManaged(StaticObject guest) {
        return this.meta.HIDDEN_ESPRESSO_MANAGED.getBoolean(guest, true);
    }

    public Thread createJavaThread(StaticObject guest, DirectCallNode exit, DirectCallNode dispatch) {
        Thread host = this.getContext().getEnv().newTruffleThreadBuilder((Runnable)new GuestRunnable(this.getContext(), guest, exit, dispatch)).build();
        this.initializeHiddenFields(guest, host, true);
        host.setDaemon(this.isDaemon(guest));
        host.setPriority(this.getPriority(guest));
        if (this.isInterrupted(guest, false)) {
            host.interrupt();
        }
        String guestName = this.getContext().getThreadAccess().getThreadName(guest);
        host.setName(guestName);
        this.getThreadAccess().setEETopAlive(guest);
        this.getContext().registerThread(host, guest);
        this.setState(guest, State.RUNNABLE.value);
        return host;
    }

    public void initializeHiddenFields(StaticObject guest, Thread host, boolean isManaged) {
        this.meta.HIDDEN_HOST_THREAD.setHiddenObject(guest, host);
        this.meta.HIDDEN_ESPRESSO_MANAGED.setBoolean(guest, isManaged);
        this.meta.HIDDEN_THREAD_PARK_LOCK.setHiddenObject(guest, EspressoLock.create(this.getContext().getBlockingSupport()));
    }

    public void suspend(StaticObject guest) {
        if (!this.isAlive(guest)) {
            return;
        }
        DeprecationSupport support = this.getDeprecationSupport(guest, true);
        assert (support != null);
        support.suspend();
    }

    public void resume(StaticObject guest) {
        DeprecationSupport support = this.getDeprecationSupport(guest, false);
        if (support == null) {
            return;
        }
        support.resume();
    }

    public void stop(StaticObject guest) {
        this.stop(guest, null);
    }

    public void stop(StaticObject guest, StaticObject throwable) {
        DeprecationSupport support = this.getDeprecationSupport(guest, true);
        assert (support != null);
        support.stop(throwable);
    }

    public void kill(StaticObject guest) {
        DeprecationSupport support = this.getDeprecationSupport(guest, true);
        support.kill();
    }

    public void terminate(StaticObject thread) {
        this.terminate(thread, null);
    }

    void terminate(StaticObject thread, DirectCallNode exit) {
        DeprecationSupport support = this.getDeprecationSupport(thread, true);
        support.exit();
        long eetop = this.getEETop(thread);
        if (eetop != 0L) {
            assert (eetop == 3405691582L);
            if (!this.getContext().isTruffleClosed()) {
                try {
                    if (exit == null) {
                        this.meta.java_lang_Thread_exit.invokeDirectSpecial(thread);
                    } else {
                        exit.call(new Object[]{thread});
                    }
                }
                catch (AbstractTruffleException abstractTruffleException) {
                    // empty catch block
                }
            }
            this.setTerminateStatusAndNotify(thread);
        } else assert (this.getState(thread) == State.TERMINATED.value);
    }

    public boolean terminateIfStillborn(StaticObject guest) {
        if (this.isStillborn(guest)) {
            this.setTerminateStatusAndNotify(guest);
            return true;
        }
        return false;
    }

    private void setTerminateStatusAndNotify(StaticObject guest) {
        guest.getLock(this.getContext()).lock();
        try {
            this.setState(guest, State.TERMINATED.value);
            this.setEETopDead(guest);
            guest.getLock(this.getContext()).signalAll();
        }
        finally {
            guest.getLock(this.getContext()).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStillborn(StaticObject guest) {
        if (this.getContext().isClosing() || this.getContext().isTruffleClosed()) {
            return true;
        }
        StaticObject staticObject = guest;
        synchronized (staticObject) {
            DeprecationSupport support = (DeprecationSupport)this.meta.HIDDEN_DEPRECATION_SUPPORT.getHiddenObject(guest, true);
            if (support != null) {
                return support.status != KillStatus.NORMAL;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeprecationSupport getDeprecationSupport(StaticObject guest, boolean initIfNull) {
        DeprecationSupport support = (DeprecationSupport)this.meta.HIDDEN_DEPRECATION_SUPPORT.getHiddenObject(guest);
        if (initIfNull && support == null) {
            StaticObject staticObject = guest;
            synchronized (staticObject) {
                support = (DeprecationSupport)this.meta.HIDDEN_DEPRECATION_SUPPORT.getHiddenObject(guest, true);
                if (support == null) {
                    support = new DeprecationSupport(guest);
                    this.meta.HIDDEN_DEPRECATION_SUPPORT.setHiddenObject(guest, support, true);
                }
            }
        }
        return support;
    }

    public void setDepthFirstNumber(StaticObject thread, int i) {
        this.meta.HIDDEN_THREAD_DEPTH_FIRST_NUMBER.setHiddenObject(thread, i);
    }

    public int getDepthFirstNumber(StaticObject thread) {
        return (Integer)this.meta.HIDDEN_THREAD_DEPTH_FIRST_NUMBER.getHiddenObject(thread);
    }

    public StaticObject getScopedValueCache(StaticObject platformThread) {
        StaticObject cache = (StaticObject)this.meta.HIDDEN_THREAD_SCOPED_VALUE_CACHE.getHiddenObject(platformThread);
        if (cache == null) {
            return StaticObject.NULL;
        }
        return cache;
    }

    public void setScopedValueCache(StaticObject platformThread, StaticObject cache) {
        this.meta.HIDDEN_THREAD_SCOPED_VALUE_CACHE.setHiddenObject(platformThread, cache);
    }

    private final class DeprecationSupport {
        private final StaticObject thread;
        private volatile StaticObject throwable = null;
        private volatile KillStatus status = KillStatus.NORMAL;
        private SuspendLock suspendLock = null;

        DeprecationSupport(StaticObject thread) {
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void suspend() {
            SuspendLock lock = this.suspendLock;
            if (lock == null) {
                DeprecationSupport deprecationSupport = this;
                synchronized (deprecationSupport) {
                    this.suspendLock = lock = new SuspendLock(ThreadsAccess.this, this.thread);
                }
            }
            lock.suspend();
        }

        void resume() {
            SuspendLock lock = this.suspendLock;
            if (lock == null) {
                return;
            }
            lock.resume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop(StaticObject death) {
            StopAction action = null;
            DeprecationSupport deprecationSupport = this;
            synchronized (deprecationSupport) {
                KillStatus s = this.status;
                if (s.canStop()) {
                    this.throwable = death;
                    action = this.updateKillState(KillStatus.STOP);
                }
            }
            if (action != null) {
                ThreadsAccess.this.getContext().getEnv().submitThreadLocal(new Thread[]{action.host}, (ThreadLocalAction)action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            StopAction action;
            DeprecationSupport deprecationSupport = this;
            synchronized (deprecationSupport) {
                action = this.updateKillState(KillStatus.KILL);
            }
            if (action != null) {
                ThreadsAccess.this.getContext().getEnv().submitThreadLocal(new Thread[]{action.host}, (ThreadLocalAction)action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void exit() {
            StopAction action;
            DeprecationSupport deprecationSupport = this;
            synchronized (deprecationSupport) {
                action = this.updateKillState(KillStatus.EXITING);
            }
            if (action != null) {
                ThreadsAccess.this.getContext().getEnv().submitThreadLocal(new Thread[]{action.host}, (ThreadLocalAction)action);
            }
        }

        private StopAction updateKillState(KillStatus state) {
            assert (Thread.holdsLock(this));
            this.status = state;
            if (state.asyncThrows()) {
                Thread host = ThreadsAccess.this.getHost(this.thread);
                if (host == null) {
                    return null;
                }
                if (host != Thread.currentThread()) {
                    ThreadsAccess.this.interrupt(host);
                    return new StopAction(host);
                }
                this.handleStop();
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        void handleSuspend() {
            SuspendLock lock = this.suspendLock;
            if (lock == null) {
                return;
            }
            lock.selfSuspend();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        void handleStop() {
            switch (this.status) {
                case NORMAL: 
                case EXITING: {
                    return;
                }
                case STOP: {
                    DeprecationSupport deprecationSupport = this;
                    synchronized (deprecationSupport) {
                        KillStatus s = this.status;
                        if (s == KillStatus.STOP) {
                            StopAction action = this.updateKillState(KillStatus.NORMAL);
                            assert (action == null);
                            StaticObject deathThrowable = this.throwable;
                            throw deathThrowable != null ? ThreadsAccess.this.meta.throwException(deathThrowable) : ThreadsAccess.this.meta.throwException(ThreadsAccess.this.meta.java_lang_ThreadDeath);
                        }
                        if (s == KillStatus.KILL) {
                            throw new EspressoExitException(ThreadsAccess.this.meta.getContext().getExitStatus());
                        }
                        assert (s == KillStatus.NORMAL || s == KillStatus.EXITING) : s;
                        return;
                    }
                }
                case KILL: {
                    throw new EspressoExitException(ThreadsAccess.this.meta.getContext().getExitStatus());
                }
            }
            throw EspressoError.shouldNotReachHere();
        }

        private class StopAction
        extends ThreadLocalAction {
            final Thread host;

            StopAction(Thread host) {
                super(true, false);
                this.host = host;
            }

            protected void perform(ThreadLocalAction.Access access) {
                DeprecationSupport.this.handleStop();
            }
        }
    }
}

