/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.verifier.Operand;

final class ArrayOperand
extends Operand {
    private final int dimensions;
    private final Operand elemental;
    private Operand component = null;

    ArrayOperand(Operand elemental, int dimensions) {
        super(JavaKind.Object);
        assert (!elemental.isArrayType());
        if (dimensions > 255) {
            throw MethodVerifier.failVerify("Creating array of dimension > 255");
        }
        this.dimensions = dimensions;
        this.elemental = elemental;
    }

    ArrayOperand(Operand elemental) {
        this(elemental, 1);
    }

    @Override
    boolean compliesWith(Operand other) {
        if (other.isArrayType()) {
            if (other.getDimensions() < this.getDimensions()) {
                return other.getElemental().isReference() && (other.getElemental().getType() == Symbol.Type.java_lang_Object || other.getElemental().getType() == Symbol.Type.java_lang_Cloneable || other.getElemental().getType() == Symbol.Type.java_io_Serializable);
            }
            if (other.getDimensions() == this.getDimensions()) {
                return this.elemental.compliesWith(other.getElemental());
            }
            return false;
        }
        return other.isTopOperand() || other.isReference() && (other.getType() == Symbol.Type.java_lang_Object || other.getType() == Symbol.Type.java_lang_Cloneable || other.getType() == Symbol.Type.java_io_Serializable);
    }

    @Override
    Operand mergeWith(Operand other) {
        int thisDim;
        assert (!this.compliesWithInMerge(other)) : "mergeWith method should only be called for non-compatible operands.";
        if (!other.isReference()) {
            return null;
        }
        if (other.isNull()) {
            return this;
        }
        if (!other.isArrayType()) {
            return MethodVerifier.jlObject;
        }
        Operand thisElemental = this.getElemental();
        Operand otherElemental = other.getElemental();
        int otherDim = other.getDimensions();
        if (otherDim == (thisDim = this.getDimensions())) {
            if (thisElemental.isPrimitive() || otherElemental.isPrimitive()) {
                assert (!this.compliesWithInMerge(other));
                if (thisDim == 1) {
                    return MethodVerifier.jlObject;
                }
                return new ArrayOperand(MethodVerifier.jlObject, thisDim - 1);
            }
            return new ArrayOperand(thisElemental.mergeWith(otherElemental), thisDim);
        }
        Operand smallestElemental = thisDim < otherDim ? thisElemental : otherElemental;
        int newDim = Math.min(thisDim, otherDim);
        if (smallestElemental.isPrimitive()) {
            if (newDim == 1) {
                return MethodVerifier.jlObject;
            }
            return new ArrayOperand(MethodVerifier.jlObject, newDim - 1);
        }
        if (smallestElemental.getType() == Symbol.Type.java_lang_Cloneable || smallestElemental.getType() == Symbol.Type.java_io_Serializable) {
            return new ArrayOperand(smallestElemental, newDim);
        }
        return new ArrayOperand(MethodVerifier.jlObject, newDim);
    }

    @Override
    boolean isReference() {
        return true;
    }

    @Override
    boolean isArrayType() {
        return true;
    }

    @Override
    Operand getComponent() {
        if (this.component == null) {
            this.component = this.dimensions == 1 ? this.elemental : new ArrayOperand(this.elemental, this.dimensions - 1);
        }
        return this.component;
    }

    @Override
    Operand getElemental() {
        return this.elemental;
    }

    public String toString() {
        if (this.dimensions == 1) {
            return "[" + String.valueOf(this.getElemental());
        }
        return "[dim:" + this.dimensions + "]" + String.valueOf(this.getElemental());
    }

    @Override
    int getDimensions() {
        return this.dimensions;
    }
}

