/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.verifier.Operand;
import com.oracle.truffle.espresso.verifier.ReferenceOperand;
import com.oracle.truffle.espresso.verifier.ReturnAddressOperand;
import com.oracle.truffle.espresso.verifier.StackFrame;
import com.oracle.truffle.espresso.verifier.SubroutineModificationStack;
import com.oracle.truffle.espresso.verifier.UninitReferenceOperand;

final class Locals {
    Operand[] registers;
    SubroutineModificationStack subRoutineModifications;

    Locals(MethodVerifier mv) {
        Operand[] parsedSig = mv.getOperandSig(mv.getSig());
        int sigSize = mv.isStatic() ? 0 : 1;
        for (int i = 0; i < parsedSig.length - 1; ++i) {
            Operand op = parsedSig[i];
            sigSize += MethodVerifier.isType2(op) ? 2 : 1;
        }
        MethodVerifier.formatGuarantee(sigSize <= mv.getMaxLocals(), "Too many method arguments for the number of locals !");
        this.registers = new Operand[mv.getMaxLocals()];
        int index = 0;
        if (!mv.isStatic()) {
            this.registers[index++] = Symbol.Name._init_.equals(mv.getMethodName()) ? new UninitReferenceOperand(mv.getThisKlass(), mv.getThisKlass()) : new ReferenceOperand(mv.getThisKlass(), mv.getThisKlass());
        }
        for (int i = 0; i < parsedSig.length - 1; ++i) {
            Operand op = parsedSig[i];
            this.registers[index++] = op.getKind().isStackInt() ? MethodVerifier.Int : op;
            if (!MethodVerifier.isType2(op)) continue;
            this.registers[index++] = MethodVerifier.Invalid;
        }
        while (index < mv.getMaxLocals()) {
            this.registers[index] = MethodVerifier.Invalid;
            ++index;
        }
    }

    Locals(Operand[] registers) {
        this.registers = registers;
    }

    Operand[] extract() {
        return (Operand[])this.registers.clone();
    }

    Operand load(int index, Operand expected) {
        Operand op = this.registers[index];
        MethodVerifier.verifyGuarantee(op.compliesWith(expected), "Incompatible register type. Expected: " + String.valueOf(expected) + ", found: " + String.valueOf(op));
        if (MethodVerifier.isType2(expected)) {
            MethodVerifier.verifyGuarantee(this.registers[index + 1].isTopOperand(), "Loading corrupted long primitive from locals!");
        }
        return op;
    }

    Operand loadRef(int index) {
        Operand op = this.registers[index];
        MethodVerifier.verifyGuarantee(op.isReference(), "Incompatible register type. Expected a reference, found: " + String.valueOf(op));
        return op;
    }

    ReturnAddressOperand loadReturnAddress(int index) {
        Operand op = this.registers[index];
        MethodVerifier.verifyGuarantee(op.isReturnAddress(), "Incompatible register type. Expected a ReturnAddress, found: " + String.valueOf(op));
        return (ReturnAddressOperand)op;
    }

    void store(int index, Operand op) {
        boolean subRoutine = this.subRoutineModifications != null;
        this.registers[index] = op;
        if (subRoutine) {
            this.subRoutineModifications.subRoutineModifications[index] = true;
        }
        if (index >= 1 && MethodVerifier.isType2(this.registers[index - 1])) {
            this.registers[index - 1] = MethodVerifier.Invalid;
            if (subRoutine) {
                this.subRoutineModifications.subRoutineModifications[index - 1] = true;
            }
        }
        if (MethodVerifier.isType2(op)) {
            this.registers[index + 1] = MethodVerifier.Invalid;
            if (subRoutine) {
                this.subRoutineModifications.subRoutineModifications[index + 1] = true;
            }
        }
    }

    int mergeInto(StackFrame frame) {
        assert (this.registers.length == frame.locals.length);
        Operand[] frameLocals = frame.locals;
        for (int i = 0; i < this.registers.length; ++i) {
            if (this.registers[i].compliesWithInMerge(frameLocals[i])) continue;
            return i;
        }
        return -1;
    }

    void initUninit(UninitReferenceOperand toInit, Operand stackOp) {
        for (int i = 0; i < this.registers.length; ++i) {
            if (!this.registers[i].isUninit() || ((UninitReferenceOperand)this.registers[i]).newBCI != toInit.newBCI) continue;
            this.registers[i] = stackOp;
        }
    }
}

