/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.analysis.frame.EspressoFrameDescriptor;
import com.oracle.truffle.espresso.analysis.frame.FrameType;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.ExceptionHandler;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.ParserException;
import com.oracle.truffle.espresso.classfile.attributes.CodeAttribute;
import com.oracle.truffle.espresso.classfile.attributes.StackMapTableAttribute;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeLookupSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeTableSwitch;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.classfile.descriptors.Validation;
import com.oracle.truffle.espresso.classfile.descriptors.ValidationException;
import com.oracle.truffle.espresso.classfile.perf.DebugCloseable;
import com.oracle.truffle.espresso.classfile.perf.DebugTimer;
import com.oracle.truffle.espresso.constantpool.RuntimeConstantPool;
import com.oracle.truffle.espresso.impl.ContextAccess;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Member;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.verifier.ArrayOperand;
import com.oracle.truffle.espresso.verifier.Locals;
import com.oracle.truffle.espresso.verifier.Operand;
import com.oracle.truffle.espresso.verifier.OperandStack;
import com.oracle.truffle.espresso.verifier.PrimitiveOperand;
import com.oracle.truffle.espresso.verifier.ReferenceOperand;
import com.oracle.truffle.espresso.verifier.ReturnAddressOperand;
import com.oracle.truffle.espresso.verifier.StackFrame;
import com.oracle.truffle.espresso.verifier.StackMapFrameParser;
import com.oracle.truffle.espresso.verifier.SubroutineModificationStack;
import com.oracle.truffle.espresso.verifier.UninitReferenceOperand;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;
import java.util.Arrays;

public final class MethodVerifier
implements ContextAccess,
StackMapFrameParser.FrameBuilder<StackFrame> {
    public static final DebugTimer VERIFIER_TIMER = DebugTimer.create("verifier");
    private final ObjectKlass thisKlass;
    private final RuntimeConstantPool pool;
    private final boolean useStackMaps;
    private final int majorVersion;
    private final Symbol<Symbol.Name> methodName;
    private final boolean isStatic;
    private final Symbol<Symbol.Type>[] sig;
    private final BytecodeStream code;
    private final int maxStack;
    private final int maxLocals;
    private final StackMapTableAttribute stackMapTableAttribute;
    private final ExceptionHandler[] exceptionHandlers;
    private final int[] bciStates;
    private final StackFrame[] stackFrames;
    private final byte[] handlerStatus;
    private boolean stackMapInitialized = false;
    private boolean calledConstructor = false;
    private final WorkingQueue queue = new WorkingQueue();
    static final PrimitiveOperand Int = new PrimitiveOperand(JavaKind.Int);
    static final PrimitiveOperand Byte = new PrimitiveOperand(JavaKind.Byte);
    static final PrimitiveOperand Char = new PrimitiveOperand(JavaKind.Char);
    static final PrimitiveOperand Short = new PrimitiveOperand(JavaKind.Short);
    static final PrimitiveOperand Float = new PrimitiveOperand(JavaKind.Float);
    static final PrimitiveOperand Double = new PrimitiveOperand(JavaKind.Double);
    static final PrimitiveOperand Long = new PrimitiveOperand(JavaKind.Long);
    static final PrimitiveOperand Void = new PrimitiveOperand(JavaKind.Void);
    static final PrimitiveOperand Invalid = new PrimitiveOperand(JavaKind.Illegal);
    final PrimitiveOperand booleanOperand;
    static final PrimitiveOperand ByteOrBoolean = new PrimitiveOperand(JavaKind.Byte){

        @Override
        boolean compliesWith(Operand other) {
            return other.isTopOperand() || other.getKind() == JavaKind.Boolean || other.getKind() == JavaKind.Byte;
        }

        @Override
        Operand mergeWith(Operand other) {
            if (other == this) {
                throw EspressoError.shouldNotReachHere("Invalid invariant: ByteOrBoolean operand in stack.");
            }
            if (other.isPrimitive()) {
                if (other == Byte) {
                    return Byte;
                }
                if (other.getKind() == JavaKind.Boolean) {
                    return other;
                }
            }
            return null;
        }

        @Override
        public PrimitiveOperand toStack() {
            return Byte;
        }
    };
    static final ReferenceOperand jlObject = new ReferenceOperand((Symbol)Symbol.Type.java_lang_Object, null){

        @Override
        Klass getKlass() {
            return EspressoContext.get(null).getMeta().java_lang_Object;
        }
    };
    static final Operand Null = new Operand(JavaKind.Object){

        @Override
        boolean compliesWith(Operand other) {
            return other.isTopOperand() || other.isReference();
        }

        @Override
        Operand mergeWith(Operand other) {
            if (!other.isReference()) {
                return null;
            }
            return other;
        }

        @Override
        boolean isReference() {
            return true;
        }

        @Override
        boolean isNull() {
            return true;
        }

        public String toString() {
            return "null";
        }

        @Override
        Operand getComponent() {
            return this;
        }
    };
    private final Operand jlClass;
    private final Operand jlString;
    private final Operand jliMethodType;
    private final Operand jliMethodHandle;
    private final Operand jlThrowable;
    private final Operand returnOperand;
    private final Operand thisOperand;
    private static final int UNREACHABLE = 0;
    private static final int UNSEEN = 1;
    private static final int DONE = 2;
    private static final int JUMP_TARGET = 4;
    private static final byte UNENCOUNTERED = 1;
    private static final byte NONVERIFIED = 2;
    private static final byte VERIFIED = 4;
    private static final byte CALLEDCONSTRUCTOR = 8;
    private static final byte NOCONSTRUCTORCALLED = 16;
    private static final byte RETURNED_TO = 64;
    private static final int RETURN_MASK = -65536;
    private int targetBci = -1;

    Symbol<Symbol.Type>[] getSig() {
        return this.sig;
    }

    boolean isStatic() {
        return this.isStatic;
    }

    int getMaxStack() {
        return this.maxStack;
    }

    int getMaxLocals() {
        return this.maxLocals;
    }

    Klass getThisKlass() {
        return this.thisKlass;
    }

    Symbol<Symbol.Name> getMethodName() {
        return this.methodName;
    }

    @Override
    public EspressoContext getContext() {
        return this.thisKlass.getContext();
    }

    private boolean earlierThan49() {
        return this.majorVersion < 49;
    }

    private boolean earlierThan51() {
        return this.majorVersion < 51;
    }

    private boolean version55OrLater() {
        return this.majorVersion >= 55;
    }

    private boolean version51OrEarlier() {
        return this.majorVersion <= 51;
    }

    private boolean version51OrLater() {
        return this.majorVersion >= 51;
    }

    private static boolean checkStatus(int status, int toCheck) {
        return (status & toCheck) != 0;
    }

    private static int setStatus(int status, int toSet) {
        return status & 0xFFFF0000 | toSet;
    }

    private void checkAndSetReturnedTo(int target, int retBCI) {
        if ((this.bciStates[target] & 0x40) == 64) {
            MethodVerifier.verifyGuarantee(this.bciStates[target] >>> 16 == retBCI, "Multiple returns to single jsr ");
        }
        this.bciStates[target] = 0x40 | retBCI << 16;
    }

    private MethodVerifier(CodeAttribute codeAttribute, Method m, boolean useStackMaps) {
        this.code = new BytecodeStream(codeAttribute.getOriginalCode());
        this.maxStack = codeAttribute.getMaxStack();
        this.maxLocals = codeAttribute.getMaxLocals();
        this.bciStates = new int[this.code.endBCI()];
        this.stackFrames = new StackFrame[this.code.endBCI()];
        this.stackMapTableAttribute = codeAttribute.getStackMapFrame();
        this.majorVersion = codeAttribute.getMajorVersion();
        this.useStackMaps = useStackMaps;
        this.pool = m.getRuntimeConstantPool();
        this.sig = m.getParsedSignature();
        this.isStatic = m.isStatic();
        this.thisKlass = m.getDeclaringKlass();
        this.methodName = m.getName();
        this.exceptionHandlers = m.getExceptionHandlers();
        this.handlerStatus = new byte[this.exceptionHandlers.length];
        Arrays.fill(this.handlerStatus, (byte)1);
        this.jlClass = new ReferenceOperand(Symbol.Type.java_lang_Class, (Klass)this.thisKlass);
        this.jlString = new ReferenceOperand(Symbol.Type.java_lang_String, (Klass)this.thisKlass);
        this.jliMethodType = new ReferenceOperand(Symbol.Type.java_lang_invoke_MethodType, (Klass)this.thisKlass);
        this.jliMethodHandle = new ReferenceOperand(Symbol.Type.java_lang_invoke_MethodHandle, (Klass)this.thisKlass);
        this.jlThrowable = new ReferenceOperand(Symbol.Type.java_lang_Throwable, (Klass)this.thisKlass);
        this.booleanOperand = this.getJavaVersion().java9OrLater() ? new PrimitiveOperand(JavaKind.Boolean) : Byte;
        this.thisOperand = new ReferenceOperand(this.thisKlass, (Klass)this.thisKlass);
        this.returnOperand = this.kindToOperand(Signatures.returnType(this.sig));
    }

    private MethodVerifier(CodeAttribute codeAttribute, Method m) {
        this(codeAttribute, m, codeAttribute.useStackMaps());
    }

    static void formatGuarantee(boolean guarantee, String s) {
        if (!guarantee) {
            throw MethodVerifier.failFormat(s);
        }
    }

    static void verifyGuarantee(boolean guarantee, String s) {
        if (!guarantee) {
            throw MethodVerifier.failVerify(s);
        }
    }

    static VerifierError failFormat(String s) {
        throw new VerifierError(s, VerifierError.Kind.ClassFormat);
    }

    static VerifierError failFormatNoFallback(String s) {
        throw new VerifierError(s, VerifierError.Kind.ClassFormat, false);
    }

    static VerifierError failVerify(String s) {
        throw new VerifierError(s, VerifierError.Kind.Verify);
    }

    static VerifierError failNoClassDefFound(String s) {
        throw new VerifierError(s, VerifierError.Kind.NoClassDefFound);
    }

    public static boolean needsVerify(EspressoLanguage language, StaticObject classLoader) {
        switch (language.getVerifyMode()) {
            case NONE: {
                return false;
            }
            case REMOTE: {
                return !StaticObject.isNull(classLoader);
            }
            case ALL: {
                return true;
            }
        }
        return true;
    }

    public static MethodVerifier verify(Method m) {
        CodeAttribute codeAttribute = m.getCodeAttribute();
        assert (!m.isAbstract() && !m.isNative() || codeAttribute == null) : "Abstract method has code: " + String.valueOf(m);
        if (codeAttribute == null) {
            if (m.isAbstract() || m.isNative()) {
                return null;
            }
            throw MethodVerifier.failFormat("Concrete method has no code attribute: " + String.valueOf(m));
        }
        try (DebugCloseable t = VERIFIER_TIMER.scope(m.getContext().getTimers());){
            MethodVerifier verifier = new MethodVerifier(codeAttribute, m);
            try {
                verifier.verify();
            }
            catch (VerifierError e) {
                if (verifier.shouldFallBack(e)) {
                    verifier = new MethodVerifier(codeAttribute, m, false);
                    verifier.verify();
                }
                throw e;
            }
            catch (ParserException.ClassFormatError e) {
                throw MethodVerifier.failFormat(e.getMessage());
            }
            MethodVerifier methodVerifier = verifier;
            return methodVerifier;
        }
    }

    public EspressoFrameDescriptor getForBci(int target) {
        StackFrame frame = this.stackFrames[target];
        int closest = target;
        while (frame == null) {
            frame = this.stackFrames[--closest];
        }
        if (closest == target) {
            return this.toDescriptor(frame);
        }
        assert (frame != null);
        this.targetBci = target;
        Arrays.fill(this.bciStates, 1);
        this.startVerify(closest, frame.extractStack(this.maxStack), frame.extractLocals());
        frame = this.stackFrames[target];
        assert (frame != null);
        this.targetBci = -1;
        return this.toDescriptor(frame);
    }

    private EspressoFrameDescriptor toDescriptor(StackFrame frame) {
        Object[] stackKinds = new FrameType[this.getMaxStack()];
        Object[] localKinds = new FrameType[this.getMaxLocals()];
        Arrays.fill(stackKinds, FrameType.ILLEGAL);
        Arrays.fill(localKinds, FrameType.ILLEGAL);
        int builderPos = 0;
        int stackPos = 0;
        while (stackPos < frame.top) {
            Operand op = frame.stack[stackPos];
            stackKinds[builderPos] = this.opToFrameType(op);
            if (MethodVerifier.isType2(op)) {
                stackKinds[++builderPos] = FrameType.ILLEGAL;
            }
            ++stackPos;
            ++builderPos;
        }
        for (int i = 0; i < frame.locals.length; ++i) {
            Operand op = frame.locals[i];
            localKinds[i] = this.opToFrameType(op);
        }
        return new EspressoFrameDescriptor((FrameType[])stackKinds, (FrameType[])localKinds, frame.top);
    }

    private FrameType opToFrameType(Operand op) {
        FrameType ft = op == null ? FrameType.ILLEGAL : (op.isPrimitive() ? FrameType.forPrimitive(op.getKind()) : (op.isArrayType() ? FrameType.forType(this.getTypes().arrayOf(op.getElemental().getType(), op.getDimensions())) : FrameType.forType(op.getType())));
        return ft;
    }

    private boolean shouldFallBack(VerifierError e) {
        if (!e.allowFallback) {
            return false;
        }
        if (this.majorVersion == 50) {
            if (this.stackMapInitialized) {
                return e.kind != VerifierError.Kind.ClassFormat;
            }
            return true;
        }
        return false;
    }

    private void initVerifier() {
        int opcode;
        Arrays.fill(this.bciStates, 0);
        int bci = 0;
        while (bci < this.code.endBCI()) {
            opcode = this.code.currentBC(bci);
            MethodVerifier.verifyGuarantee(opcode < 203, "invalid bytecode: " + opcode);
            this.verifyEnoughBytecodes(opcode, bci);
            this.bciStates[bci] = MethodVerifier.setStatus(this.bciStates[bci], 1);
            bci = this.code.nextBCI(bci);
            MethodVerifier.verifyGuarantee(bci <= this.code.endBCI(), "Incomplete bytecode");
        }
        bci = 0;
        if (!this.useStackMaps) {
            while (bci < this.code.endBCI()) {
                opcode = this.code.currentBC(bci);
                if (Bytecodes.isBranch(opcode)) {
                    int target = this.code.readBranchDest(bci);
                    this.validateBCI(target);
                    this.bciStates[target] = MethodVerifier.setStatus(this.bciStates[bci], 4);
                }
                if (opcode == 170 || opcode == 171) {
                    this.initSwitch(bci, opcode);
                }
                bci = this.code.nextBCI(bci);
                if (opcode != 168 && opcode != 201) continue;
                this.bciStates[bci] = 4;
            }
        }
    }

    private void verifyEnoughBytecodes(int opcode, int curBCI) {
        switch (opcode) {
            case 170: {
                MethodVerifier.verifyGuarantee(BytecodeSwitch.getAlignedBci(curBCI) + 8 + 4 < this.code.endBCI(), "SWITCH instruction does not have enough follow-up bytes to be valid.");
                return;
            }
            case 171: {
                MethodVerifier.verifyGuarantee(BytecodeSwitch.getAlignedBci(curBCI) + 4 + 4 < this.code.endBCI(), "SWITCH instruction does not have enough follow-up bytes to be valid.");
                return;
            }
            case 196: {
                MethodVerifier.verifyGuarantee(curBCI + 1 < this.code.endBCI(), "WIDE bytecode does not have a follow up instruction.");
                return;
            }
        }
    }

    private void initSwitch(int bci, int opCode) {
        if (opCode == 171) {
            int target;
            BytecodeLookupSwitch switchHelper = BytecodeLookupSwitch.INSTANCE;
            int low = 0;
            int high = switchHelper.numberOfCases(this.code, bci);
            MethodVerifier.verifyGuarantee(high >= 0, "number of keys in LOOKUPSWITCH less than 0");
            int oldKey = 0;
            boolean init = false;
            for (int i = low; i < high; ++i) {
                int newKey = switchHelper.keyAt(this.code, bci, i - low);
                if (init) {
                    MethodVerifier.verifyGuarantee(newKey > oldKey, "Unsorted keys in LOOKUPSWITCH");
                }
                init = true;
                oldKey = newKey;
                target = switchHelper.targetAt(this.code, bci, i - low);
                this.validateBCI(target);
                this.bciStates[target] = MethodVerifier.setStatus(this.bciStates[bci], 4);
            }
            target = switchHelper.defaultTarget(this.code, bci);
            this.validateBCI(target);
            this.bciStates[target] = MethodVerifier.setStatus(this.bciStates[bci], 4);
        } else if (opCode == 170) {
            int target;
            int high;
            BytecodeTableSwitch switchHelper = BytecodeTableSwitch.INSTANCE;
            int low = switchHelper.lowKey(this.code, bci);
            MethodVerifier.verifyGuarantee(low <= (high = switchHelper.highKey(this.code, bci)), "low must be less than or equal to high in TABLESWITCH.");
            MethodVerifier.verifyGuarantee(high - low + 1 >= 0, "too many keys in tableswitch");
            for (int i = low; i != high + 1; ++i) {
                target = switchHelper.targetAt(this.code, bci, i - low);
                this.validateBCI(target);
                this.bciStates[target] = MethodVerifier.setStatus(this.bciStates[bci], 4);
            }
            target = switchHelper.defaultTarget(this.code, bci);
            this.validateBCI(target);
        } else {
            throw EspressoError.shouldNotReachHere();
        }
    }

    private void initStackFrames() throws ParserException.ClassFormatError {
        StackFrame previous = new StackFrame(this);
        assert (this.stackFrames.length > 0);
        int bci = 0;
        this.registerStackMapFrame(bci, previous);
        if (!this.useStackMaps || this.stackMapTableAttribute == null) {
            return;
        }
        if (this.stackMapTableAttribute == StackMapTableAttribute.EMPTY) {
            throw EspressoError.shouldNotReachHere("Class " + this.thisKlass.getExternalName() + " was determined to not need verification, but verification was invoked.");
        }
        StackMapFrameParser.parse(this, this.stackMapTableAttribute, previous, this.computeLastLocal(previous));
    }

    private int computeLastLocal(StackFrame previous) {
        int last = this.isStatic() ? 0 : 1;
        for (int i = 0; i < this.getSig().length - 1; ++i) {
            if (!MethodVerifier.isType2(previous.locals[last++])) continue;
            ++last;
        }
        return last - 1;
    }

    @Override
    public void registerStackMapFrame(int bci, StackFrame frame) {
        this.validateFrameBCI(bci);
        this.stackFrames[bci] = frame;
    }

    @Override
    public StackMapFrameParser.FrameAndLocalEffect newFullFrame(VerificationTypeInfo[] stack, VerificationTypeInfo[] locals, int lastLocal) {
        OperandStack fullStack = new OperandStack(this.maxStack);
        int stackPos = 0;
        for (VerificationTypeInfo vti : stack) {
            Operand op = this.getOperandFromVerificationType(vti);
            MethodVerifier.formatGuarantee((stackPos += op.slots()) <= this.maxStack, "Full frame entry has a bigger stack than maxStack.");
            fullStack.push(op);
        }
        Object[] newLocals = new Operand[this.maxLocals];
        Arrays.fill(newLocals, Invalid);
        int pos = -1;
        for (VerificationTypeInfo vti : locals) {
            Operand op = this.getOperandFromVerificationType(vti);
            MethodVerifier.setLocal((Operand[])newLocals, op, ++pos, "Full frame entry in stack map has more locals than allowed.");
            if (!MethodVerifier.isType2(op)) continue;
            MethodVerifier.setLocal((Operand[])newLocals, Invalid, ++pos, "Full frame entry in stack map has more locals than allowed.");
        }
        return new StackMapFrameParser.FrameAndLocalEffect(new StackFrame(fullStack, (Operand[])newLocals), pos - lastLocal);
    }

    static void setLocal(Operand[] locals, Operand op, int pos, String message) {
        MethodVerifier.formatGuarantee(pos >= 0 && pos < locals.length, message);
        locals[pos] = op;
    }

    Operand getOperandFromVerificationType(VerificationTypeInfo vti) {
        switch (vti.getTag()) {
            case 0: {
                return Invalid;
            }
            case 1: {
                return Int;
            }
            case 2: {
                return Float;
            }
            case 3: {
                return Double;
            }
            case 4: {
                return Long;
            }
            case 5: {
                return Null;
            }
            case 6: {
                return new UninitReferenceOperand(this.thisKlass, (Klass)this.thisKlass);
            }
            case 7: {
                return this.spawnFromType(vti.getType(this.pool, this.thisKlass, this.code));
            }
            case 8: {
                int newOffset = vti.getNewOffset();
                this.validateFormatBCI(newOffset);
                MethodVerifier.formatGuarantee(this.code.currentBC(newOffset) == 187, "NewObject in stack map not referencing a NEW instruction! " + Bytecodes.nameOf(this.code.currentBC(newOffset)));
                return new UninitReferenceOperand(vti.getType(this.pool, this.thisKlass, this.code), this.thisKlass, newOffset);
            }
        }
        throw EspressoError.shouldNotReachHere("Unrecognized VerificationTypeInfo: " + String.valueOf(vti));
    }

    private synchronized void verify() {
        MethodVerifier.verifyGuarantee(this.code.endBCI() > 0, "Control flow falls through code end");
        this.initVerifier();
        this.initStackFrames();
        this.stackMapInitialized = true;
        this.validateExceptionHandlers();
        this.validateUnconditionalJumps();
        this.verifyReachableCode();
        this.verifyUnreachableStackMaps();
    }

    private void validateUnconditionalJumps() {
        if (this.useStackMaps) {
            int bci = 0;
            while (bci < this.code.endBCI()) {
                int nextBCI = this.code.nextBCI(bci);
                if (Bytecodes.isStop(this.code.currentBC(bci)) && nextBCI < this.code.endBCI()) {
                    MethodVerifier.verifyGuarantee(this.stackFrames[nextBCI] != null, "Control flow stop does not have a stack map at next instruction!");
                }
                bci = nextBCI;
            }
        }
    }

    private void validateExceptionHandlers() {
        MethodVerifier.verifyGuarantee(this.exceptionHandlers.length == 0 || this.maxStack >= 1, "Method with exception handlers has a zero max stack value.");
        for (ExceptionHandler handler : this.exceptionHandlers) {
            this.validateFormatBCI(handler.getHandlerBCI());
            int startBCI = handler.getStartBCI();
            this.validateFormatBCI(startBCI);
            int endBCI = handler.getEndBCI();
            MethodVerifier.formatGuarantee(endBCI > startBCI, "End BCI of handler is before start BCI");
            MethodVerifier.formatGuarantee(endBCI >= 0, "negative branch target: " + endBCI);
            MethodVerifier.formatGuarantee(endBCI <= this.code.endBCI(), "Control flow falls through code end");
            if (handler.catchTypeCPI() != 0) {
                Klass catchType = this.pool.resolvedKlassAt(this.thisKlass, handler.catchTypeCPI());
                MethodVerifier.verifyGuarantee(this.getMeta().java_lang_Throwable.isAssignableFrom(catchType), "Illegal exception handler catch type: " + String.valueOf(catchType));
            }
            if (endBCI == this.code.endBCI()) continue;
            MethodVerifier.formatGuarantee(this.bciStates[endBCI] != 0, "Jump to the middle of an instruction: " + endBCI);
        }
    }

    private void processQueue() {
        while (!this.queue.isEmpty()) {
            QueueElement toVerify = this.queue.pop();
            this.calledConstructor = toVerify.constructorCalled;
            Locals locals = toVerify.frame.extractLocals();
            locals.subRoutineModifications = toVerify.frame.subroutineModificationStack;
            this.startVerify(toVerify.bci, toVerify.frame.extractStack(this.maxStack), locals);
        }
    }

    private void verifyReachableCode() {
        OperandStack stack = new OperandStack(this.maxStack);
        Locals locals = new Locals(this);
        this.startVerify(0, stack, locals);
        do {
            this.processQueue();
            this.verifyExceptionHandlers();
        } while (!this.queue.isEmpty());
    }

    private void verifyUnreachableStackMaps() {
        for (int stackBCI = 0; stackBCI < this.stackFrames.length; ++stackBCI) {
            if (this.stackFrames[stackBCI] == null || !MethodVerifier.checkStatus(this.bciStates[stackBCI], 1)) continue;
            this.queue.push(stackBCI, new QueueElement(stackBCI, this.stackFrames[stackBCI], true));
        }
        while (!this.queue.isEmpty()) {
            this.processQueue();
            this.verifyExceptionHandlers();
        }
    }

    private static byte setStatus(byte oldStatus, byte newStatus) {
        return (byte)(newStatus | oldStatus & 0x18);
    }

    private static boolean isStatus(byte status, byte toCheck) {
        return (status & toCheck) != 0;
    }

    private static byte setConstructorStatus(byte oldStatus, byte constructorStatus) {
        if ((oldStatus & 0x10) > 0) {
            return oldStatus;
        }
        return (byte)(oldStatus | constructorStatus);
    }

    private static boolean isCalledConstructor(byte status) {
        return (status & 8) > 0;
    }

    private void verifyExceptionHandlers() {
        boolean updated;
        boolean redo;
        do {
            redo = false;
            updated = false;
            for (int i = 0; i < this.exceptionHandlers.length; ++i) {
                ExceptionHandler handler = this.exceptionHandlers[i];
                if (MethodVerifier.isStatus(this.handlerStatus[i], (byte)2)) {
                    updated = redo;
                    boolean constructorStatus = this.calledConstructor;
                    if (MethodVerifier.isCalledConstructor(this.handlerStatus[i])) {
                        this.calledConstructor = true;
                    }
                    this.verifyHandler(handler);
                    this.calledConstructor = constructorStatus;
                    this.handlerStatus[i] = MethodVerifier.setStatus(this.handlerStatus[i], (byte)4);
                    continue;
                }
                if (!MethodVerifier.isStatus(this.handlerStatus[i], (byte)1)) continue;
                redo = true;
            }
        } while (redo && updated);
    }

    private void verifyHandler(ExceptionHandler handler) {
        OperandStack stack;
        Locals locals;
        int handlerBCI = handler.getHandlerBCI();
        StackFrame frame = this.stackFrames[handlerBCI];
        if (frame == null) {
            Object[] registers = new Operand[this.maxLocals];
            Arrays.fill(registers, Invalid);
            locals = new Locals((Operand[])registers);
            stack = new OperandStack(this.maxStack);
            Symbol<Symbol.Type> catchType = handler.getCatchType();
            stack.push(catchType == null ? this.jlThrowable : new ReferenceOperand(catchType, (Klass)this.thisKlass));
        } else {
            stack = frame.extractStack(this.maxStack);
            locals = frame.extractLocals();
        }
        this.startVerify(handlerBCI, stack, locals);
    }

    private void branch(int bci, OperandStack stack, Locals locals) {
        this.validateBCI(bci);
        StackFrame frame = this.mergeFrames(stack, locals, this.stackFrames[bci]);
        if (frame != this.stackFrames[bci] || !MethodVerifier.checkStatus(this.bciStates[bci], 2)) {
            this.bciStates[bci] = MethodVerifier.setStatus(this.bciStates[bci], 4);
            this.stackFrames[bci] = frame;
            QueueElement toPush = new QueueElement(bci, frame, this.calledConstructor);
            this.queue.push(bci, toPush);
        }
    }

    private void validateBCI(int bci) {
        MethodVerifier.verifyGuarantee(bci < this.code.endBCI(), "Control flow falls through code end");
        MethodVerifier.verifyGuarantee(bci >= 0, "negative branch target: " + bci);
        MethodVerifier.verifyGuarantee(this.bciStates[bci] != 0, "Jump to the middle of an instruction: " + bci);
    }

    private void validateFormatBCI(int bci) {
        MethodVerifier.formatGuarantee(bci < this.code.endBCI(), "Control flow falls through code end");
        MethodVerifier.formatGuarantee(bci >= 0, "negative branch target: " + bci);
        MethodVerifier.formatGuarantee(this.bciStates[bci] != 0, "Jump to the middle of an instruction: " + bci);
    }

    private void validateFrameBCI(int bci) {
        MethodVerifier.verifyGuarantee(bci < this.code.endBCI(), "StackFrame offset falls outside of method");
        MethodVerifier.verifyGuarantee(bci >= 0, "negative stack frame offset: " + bci);
        MethodVerifier.verifyGuarantee(this.bciStates[bci] != 0, "StackFrame offset falls to the middle of an instruction: " + bci);
    }

    private void startVerify(int bci, OperandStack seedStack, Locals seedLocals) {
        int previousBCI;
        OperandStack stack = seedStack;
        Locals locals = seedLocals;
        int nextBCI = bci;
        boolean constructorCalledStatus = this.calledConstructor;
        do {
            previousBCI = nextBCI;
            if (this.stackFrames[nextBCI] != null || MethodVerifier.checkStatus(this.bciStates[nextBCI], 4)) {
                StackFrame frame = this.mergeFrames(stack, locals, this.stackFrames[nextBCI]);
                if (frame != this.stackFrames[nextBCI]) {
                    this.bciStates[nextBCI] = MethodVerifier.setStatus(this.bciStates[bci], 4);
                    this.stackFrames[nextBCI] = frame;
                }
                stack = frame.extractStack(this.maxStack);
                locals = frame.extractLocals();
                locals.subRoutineModifications = seedLocals.subRoutineModifications;
            }
            if (this.stackFrames[nextBCI] != null && MethodVerifier.checkStatus(this.bciStates[nextBCI], 2)) {
                this.calledConstructor = constructorCalledStatus;
                return;
            }
            this.checkExceptionHandlers(nextBCI, locals);
            if (nextBCI == this.targetBci) {
                this.stackFrames[nextBCI] = MethodVerifier.spawnStackFrame(stack, locals);
                return;
            }
            nextBCI = this.verifySafe(nextBCI, stack, locals);
            this.validateBCI(nextBCI);
        } while (previousBCI != nextBCI);
        this.calledConstructor = constructorCalledStatus;
    }

    static void validateOrFailVerification(PoolConstant poolConstant, ConstantPool pool) {
        try {
            poolConstant.validate(pool);
        }
        catch (ValidationException e) {
            throw MethodVerifier.failVerify(e.getMessage());
        }
    }

    private void checkExceptionHandlers(int nextBCI, Locals locals) {
        for (int i = 0; i < this.exceptionHandlers.length; ++i) {
            ExceptionHandler handler = this.exceptionHandlers[i];
            if (!handler.covers(nextBCI)) continue;
            OperandStack stack = new OperandStack(1);
            Symbol<Symbol.Type> catchType = handler.getCatchType();
            stack.push(catchType == null ? this.jlThrowable : new ReferenceOperand(catchType, (Klass)this.thisKlass));
            StackFrame oldFrame = this.stackFrames[handler.getHandlerBCI()];
            StackFrame newFrame = this.mergeFrames(stack, locals, oldFrame);
            if (MethodVerifier.isStatus(this.handlerStatus[i], (byte)1) || oldFrame != newFrame) {
                this.handlerStatus[i] = MethodVerifier.setStatus(this.handlerStatus[i], (byte)2);
            }
            this.handlerStatus[i] = this.calledConstructor ? MethodVerifier.setConstructorStatus(this.handlerStatus[i], (byte)8) : MethodVerifier.setConstructorStatus(this.handlerStatus[i], (byte)16);
            this.stackFrames[handler.getHandlerBCI()] = newFrame;
        }
    }

    private int verifySafe(int bci, OperandStack stack, Locals locals) {
        try {
            return this.verify(bci, stack, locals);
        }
        catch (IndexOutOfBoundsException e) {
            throw MethodVerifier.failVerify("Inconsistent Stack/Local access: " + e.getMessage() + ", in: " + String.valueOf(this.thisKlass.getType()) + "." + String.valueOf(this.methodName));
        }
    }

    private Operand ldcFromTag(PoolConstant pc) {
        switch (pc.tag()) {
            case INTEGER: {
                return Int;
            }
            case FLOAT: {
                return Float;
            }
            case LONG: {
                return Long;
            }
            case DOUBLE: {
                return Double;
            }
            case CLASS: {
                return this.jlClass;
            }
            case STRING: {
                return this.jlString;
            }
            case METHODHANDLE: {
                MethodVerifier.formatGuarantee(this.version51OrLater(), "LDC for MethodHandleConstant in classfile version < 51");
                return this.jliMethodHandle;
            }
            case METHODTYPE: {
                MethodVerifier.formatGuarantee(this.version51OrLater(), "LDC for MethodType in classfile version < 51");
                return this.jliMethodType;
            }
            case DYNAMIC: {
                MethodVerifier.formatGuarantee(this.version55OrLater(), "LDC for Dynamic in classfile version < 55");
                DynamicConstant constant = (DynamicConstant)pc;
                return this.kindToOperand(constant.getTypeSymbol(this.pool));
            }
        }
        throw MethodVerifier.failVerify("invalid CP load: " + String.valueOf((Object)pc.tag()));
    }

    private int verify(int bci, OperandStack stack, Locals locals) {
        MethodVerifier.verifyGuarantee(this.bciStates[bci] != 0, "Jump to the middle of an instruction: " + bci);
        this.bciStates[bci] = MethodVerifier.setStatus(this.bciStates[bci], 2);
        int curOpcode = this.code.opcode(bci);
        MethodVerifier.verifyGuarantee(curOpcode < 204, "invalid bytecode: " + this.code.readUByte(bci));
        block148: while (true) {
            switch (curOpcode) {
                case 0: {
                    break block148;
                }
                case 1: {
                    stack.push(Null);
                    break block148;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stack.pushInt();
                    break block148;
                }
                case 9: 
                case 10: {
                    stack.pushLong();
                    break block148;
                }
                case 11: 
                case 12: 
                case 13: {
                    stack.pushFloat();
                    break block148;
                }
                case 14: 
                case 15: {
                    stack.pushDouble();
                    break block148;
                }
                case 16: {
                    stack.pushInt();
                    break block148;
                }
                case 17: {
                    stack.pushInt();
                    break block148;
                }
                case 18: 
                case 19: {
                    PoolConstant pc = this.poolAt(this.code.readCPI(bci));
                    MethodVerifier.validateOrFailVerification(pc, this.pool);
                    Operand op = this.ldcFromTag(pc);
                    MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(op), "Loading Long or Double with LDC or LDC_W, please use LDC2_W.");
                    if (this.earlierThan49()) {
                        MethodVerifier.verifyGuarantee(op == Int || op == Float || op.getType() == this.jlString.getType(), "Loading non Int, Float or String with LDC in classfile version < 49.0");
                    }
                    stack.push(op);
                    break block148;
                }
                case 20: {
                    PoolConstant pc = this.poolAt(this.code.readCPI(bci));
                    MethodVerifier.validateOrFailVerification(pc, this.pool);
                    Operand op = this.ldcFromTag(pc);
                    MethodVerifier.verifyGuarantee(MethodVerifier.isType2(op), "Loading non-Long or Double with LDC2_W, please use LDC or LDC_W.");
                    stack.push(op);
                    break block148;
                }
                case 21: {
                    locals.load(this.code.readLocalIndex(bci), Int);
                    stack.pushInt();
                    break block148;
                }
                case 22: {
                    locals.load(this.code.readLocalIndex(bci), Long);
                    stack.pushLong();
                    break block148;
                }
                case 23: {
                    locals.load(this.code.readLocalIndex(bci), Float);
                    stack.pushFloat();
                    break block148;
                }
                case 24: {
                    locals.load(this.code.readLocalIndex(bci), Double);
                    stack.pushDouble();
                    break block148;
                }
                case 25: {
                    stack.push(locals.loadRef(this.code.readLocalIndex(bci)));
                    break block148;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    locals.load(curOpcode - 26, Int);
                    stack.pushInt();
                    break block148;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    locals.load(curOpcode - 30, Long);
                    stack.pushLong();
                    break block148;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    locals.load(curOpcode - 34, Float);
                    stack.pushFloat();
                    break block148;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    locals.load(curOpcode - 38, Double);
                    stack.pushDouble();
                    break block148;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    stack.push(locals.loadRef(curOpcode - 42));
                    break block148;
                }
                case 46: {
                    MethodVerifier.xaload(stack, Int);
                    break block148;
                }
                case 47: {
                    MethodVerifier.xaload(stack, Long);
                    break block148;
                }
                case 48: {
                    MethodVerifier.xaload(stack, Float);
                    break block148;
                }
                case 49: {
                    MethodVerifier.xaload(stack, Double);
                    break block148;
                }
                case 50: {
                    stack.popInt();
                    Operand op = stack.popArray();
                    MethodVerifier.verifyGuarantee(op == Null || op.getComponent().isReference(), "Loading reference from " + String.valueOf(op) + " array.");
                    stack.push(op.getComponent());
                    break block148;
                }
                case 51: {
                    MethodVerifier.xaload(stack, ByteOrBoolean);
                    break block148;
                }
                case 52: {
                    MethodVerifier.xaload(stack, Char);
                    break block148;
                }
                case 53: {
                    MethodVerifier.xaload(stack, Short);
                    break block148;
                }
                case 54: {
                    stack.popInt();
                    locals.store(this.code.readLocalIndex(bci), Int);
                    break block148;
                }
                case 55: {
                    stack.popLong();
                    locals.store(this.code.readLocalIndex(bci), Long);
                    break block148;
                }
                case 56: {
                    stack.popFloat();
                    locals.store(this.code.readLocalIndex(bci), Float);
                    break block148;
                }
                case 57: {
                    stack.popDouble();
                    locals.store(this.code.readLocalIndex(bci), Double);
                    break block148;
                }
                case 58: {
                    locals.store(this.code.readLocalIndex(bci), stack.popObjOrRA());
                    break block148;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    stack.popInt();
                    locals.store(curOpcode - 59, Int);
                    break block148;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    stack.popLong();
                    locals.store(curOpcode - 63, Long);
                    break block148;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    stack.popFloat();
                    locals.store(curOpcode - 67, Float);
                    break block148;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    stack.popDouble();
                    locals.store(curOpcode - 71, Double);
                    break block148;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    locals.store(curOpcode - 75, stack.popObjOrRA());
                    break block148;
                }
                case 79: {
                    MethodVerifier.xastore(stack, Int);
                    break block148;
                }
                case 80: {
                    MethodVerifier.xastore(stack, Long);
                    break block148;
                }
                case 81: {
                    MethodVerifier.xastore(stack, Float);
                    break block148;
                }
                case 82: {
                    MethodVerifier.xastore(stack, Double);
                    break block148;
                }
                case 83: {
                    Operand toStore = stack.popRef();
                    stack.popInt();
                    Operand array = stack.popArray();
                    MethodVerifier.verifyGuarantee(array == Null || array.getComponent().isReference(), "Trying to store " + String.valueOf(toStore) + " in " + String.valueOf(array));
                    break block148;
                }
                case 84: {
                    MethodVerifier.xastore(stack, ByteOrBoolean);
                    break block148;
                }
                case 85: {
                    MethodVerifier.xastore(stack, Char);
                    break block148;
                }
                case 86: {
                    MethodVerifier.xastore(stack, Short);
                    break block148;
                }
                case 87: {
                    stack.pop();
                    break block148;
                }
                case 88: {
                    stack.pop2();
                    break block148;
                }
                case 89: {
                    stack.dup();
                    break block148;
                }
                case 90: {
                    stack.dupx1();
                    break block148;
                }
                case 91: {
                    stack.dupx2();
                    break block148;
                }
                case 92: {
                    stack.dup2();
                    break block148;
                }
                case 93: {
                    stack.dup2x1();
                    break block148;
                }
                case 94: {
                    stack.dup2x2();
                    break block148;
                }
                case 95: {
                    stack.swap();
                    break block148;
                }
                case 96: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 97: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 98: {
                    stack.popFloat();
                    stack.popFloat();
                    stack.pushFloat();
                    break block148;
                }
                case 99: {
                    stack.popDouble();
                    stack.popDouble();
                    stack.pushDouble();
                    break block148;
                }
                case 100: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 101: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 102: {
                    stack.popFloat();
                    stack.popFloat();
                    stack.pushFloat();
                    break block148;
                }
                case 103: {
                    stack.popDouble();
                    stack.popDouble();
                    stack.pushDouble();
                    break block148;
                }
                case 104: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 105: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 106: {
                    stack.popFloat();
                    stack.popFloat();
                    stack.pushFloat();
                    break block148;
                }
                case 107: {
                    stack.popDouble();
                    stack.popDouble();
                    stack.pushDouble();
                    break block148;
                }
                case 108: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 109: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 110: {
                    stack.popFloat();
                    stack.popFloat();
                    stack.pushFloat();
                    break block148;
                }
                case 111: {
                    stack.popDouble();
                    stack.popDouble();
                    stack.pushDouble();
                    break block148;
                }
                case 112: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 113: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 114: {
                    stack.popFloat();
                    stack.popFloat();
                    stack.pushFloat();
                    break block148;
                }
                case 115: {
                    stack.popDouble();
                    stack.popDouble();
                    stack.pushDouble();
                    break block148;
                }
                case 116: {
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 117: {
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 118: {
                    stack.popFloat();
                    stack.pushFloat();
                    break block148;
                }
                case 119: {
                    stack.popDouble();
                    stack.pushDouble();
                    break block148;
                }
                case 120: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 121: {
                    stack.popInt();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 122: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 123: {
                    stack.popInt();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 124: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 125: {
                    stack.popInt();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 126: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 127: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 128: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 129: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 130: {
                    stack.popInt();
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 131: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushLong();
                    break block148;
                }
                case 132: {
                    locals.load(this.code.readLocalIndex(bci), Int);
                    break block148;
                }
                case 133: {
                    stack.popInt();
                    stack.pushLong();
                    break block148;
                }
                case 134: {
                    stack.popInt();
                    stack.pushFloat();
                    break block148;
                }
                case 135: {
                    stack.popInt();
                    stack.pushDouble();
                    break block148;
                }
                case 136: {
                    stack.popLong();
                    stack.pushInt();
                    break block148;
                }
                case 137: {
                    stack.popLong();
                    stack.pushFloat();
                    break block148;
                }
                case 138: {
                    stack.popLong();
                    stack.pushDouble();
                    break block148;
                }
                case 139: {
                    stack.popFloat();
                    stack.pushInt();
                    break block148;
                }
                case 140: {
                    stack.popFloat();
                    stack.pushLong();
                    break block148;
                }
                case 141: {
                    stack.popFloat();
                    stack.pushDouble();
                    break block148;
                }
                case 142: {
                    stack.popDouble();
                    stack.pushInt();
                    break block148;
                }
                case 143: {
                    stack.popDouble();
                    stack.pushLong();
                    break block148;
                }
                case 144: {
                    stack.popDouble();
                    stack.pushFloat();
                    break block148;
                }
                case 145: {
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 146: {
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 147: {
                    stack.popInt();
                    stack.pushInt();
                    break block148;
                }
                case 148: {
                    stack.popLong();
                    stack.popLong();
                    stack.pushInt();
                    break block148;
                }
                case 149: 
                case 150: {
                    stack.popFloat();
                    stack.popFloat();
                    stack.pushInt();
                    break block148;
                }
                case 151: 
                case 152: {
                    stack.popDouble();
                    stack.popDouble();
                    stack.pushInt();
                    break block148;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    stack.popInt();
                    this.branch(this.code.readBranchDest(bci), stack, locals);
                    break block148;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    stack.popInt();
                    stack.popInt();
                    this.branch(this.code.readBranchDest(bci), stack, locals);
                    break block148;
                }
                case 165: 
                case 166: {
                    stack.popRef();
                    stack.popRef();
                    this.branch(this.code.readBranchDest(bci), stack, locals);
                    break block148;
                }
                case 167: 
                case 200: {
                    this.branch(this.code.readBranchDest(bci), stack, locals);
                    return bci;
                }
                case 198: 
                case 199: {
                    stack.popRef();
                    this.branch(this.code.readBranchDest(bci), stack, locals);
                    break block148;
                }
                case 168: 
                case 201: {
                    this.verifyJSR(bci, stack, locals);
                    return bci;
                }
                case 169: {
                    this.verifyRET(bci, stack, locals);
                    return bci;
                }
                case 170: {
                    return this.verifyTableSwitch(bci, stack, locals);
                }
                case 171: {
                    return this.verifyLookupSwitch(bci, stack, locals);
                }
                case 172: {
                    stack.pop(Int);
                    MethodVerifier.verifyGuarantee(this.returnOperand.getKind().isStackInt(), "Found an IRETURN when return type is " + String.valueOf(this.returnOperand));
                    return bci;
                }
                case 173: {
                    this.doReturn(stack, Long);
                    return bci;
                }
                case 174: {
                    this.doReturn(stack, Float);
                    return bci;
                }
                case 175: {
                    this.doReturn(stack, Double);
                    return bci;
                }
                case 176: {
                    stack.popRef(this.returnOperand);
                    return bci;
                }
                case 177: {
                    MethodVerifier.verifyGuarantee(this.returnOperand == Void, "Encountered RETURN, but method return type is not void: " + String.valueOf(this.returnOperand));
                    if (MethodVerifier.isInstanceInit(this.methodName) && this.thisKlass.getType() != Symbol.Type.java_lang_Object) {
                        MethodVerifier.verifyGuarantee(this.calledConstructor, "Did not call super() or this() in constructor " + String.valueOf(this.thisKlass.getType()) + "." + String.valueOf(this.methodName));
                    }
                    return bci;
                }
                case 178: 
                case 180: {
                    this.verifyGetField(bci, stack, curOpcode);
                    break block148;
                }
                case 179: 
                case 181: {
                    this.verifyPutField(bci, stack, curOpcode);
                    break block148;
                }
                case 182: {
                    this.verifyInvokeVirtual(bci, stack);
                    break block148;
                }
                case 183: {
                    this.verifyInvokeSpecial(bci, stack, locals);
                    break block148;
                }
                case 184: {
                    this.verifyInvokeStatic(bci, stack);
                    break block148;
                }
                case 185: {
                    this.verifyInvokeInterface(bci, stack);
                    break block148;
                }
                case 187: {
                    this.verifyNew(bci, stack);
                    break block148;
                }
                case 188: {
                    this.verifyNewPrimitiveArray(bci, stack);
                    break block148;
                }
                case 189: {
                    this.verifyNewObjectArray(bci, stack);
                    break block148;
                }
                case 190: {
                    stack.popArray();
                    stack.pushInt();
                    break block148;
                }
                case 191: {
                    stack.popRef(this.jlThrowable);
                    return bci;
                }
                case 192: {
                    this.verifyCheckCast(bci, stack);
                    break block148;
                }
                case 193: {
                    this.verifyInstanceOf(bci, stack);
                    break block148;
                }
                case 194: {
                    stack.popRef();
                    break block148;
                }
                case 195: {
                    stack.popRef();
                    break block148;
                }
                case 196: {
                    curOpcode = this.code.currentBC(bci);
                    MethodVerifier.verifyGuarantee(MethodVerifier.wideOpcodes(curOpcode), "invalid widened opcode: " + Bytecodes.nameOf(curOpcode));
                    continue block148;
                }
                case 197: {
                    this.verifyMultiNewArray(bci, stack);
                    break block148;
                }
                case 202: {
                    break block148;
                }
                case 186: {
                    this.verifyInvokeDynamic(bci, stack);
                    break block148;
                }
                case 203: {
                    break block148;
                }
                case 204: {
                    break block148;
                }
            }
            break;
        }
        return this.code.nextBCI(bci);
    }

    private void verifyInvokeDynamic(int bci, OperandStack stack) {
        MethodVerifier.verifyGuarantee(this.code.readByte(bci + 2) == 0 && this.code.readByte(bci + 3) == 0, "bytes 3 and 4 after invokedynamic must be 0.");
        PoolConstant pc = this.poolAt(this.code.readCPI(bci));
        MethodVerifier.verifyGuarantee(pc.tag() == ConstantPool.Tag.INVOKEDYNAMIC, "Invalid CP constant for INVOKEDYNAMIC: " + pc.toString());
        MethodVerifier.validateOrFailVerification(pc, this.pool);
        InvokeDynamicConstant idc = (InvokeDynamicConstant)pc;
        Symbol<Symbol.Name> name = idc.getName(this.pool);
        MethodVerifier.verifyGuarantee(!MethodVerifier.isInstanceInit(name) && !MethodVerifier.isClassInit(name), "Invalid bootstrap method name: " + String.valueOf(name));
        Operand[] parsedSig = this.getOperandSig(idc.getSignature(this.pool));
        assert (parsedSig.length > 0) : "Empty descriptor for method";
        for (int i = parsedSig.length - 2; i >= 0; --i) {
            stack.pop(parsedSig[i]);
        }
        Operand returnKind = parsedSig[parsedSig.length - 1];
        if (returnKind != Void) {
            stack.push(returnKind);
        }
    }

    private Symbol<Symbol.Type> getTypeFromPool(int c, String s) {
        PoolConstant pc = this.poolAt(c);
        MethodVerifier.verifyGuarantee(pc.tag() == ConstantPool.Tag.CLASS, s + pc.toString());
        MethodVerifier.validateOrFailVerification(pc, this.pool);
        ClassConstant cc = (ClassConstant)pc;
        assert (Validation.validClassNameEntry(cc.getName(this.pool)));
        Symbol<Symbol.Type> type = this.getTypes().fromName(cc.getName(this.pool));
        return type;
    }

    private void verifyMultiNewArray(int bci, OperandStack stack) {
        Symbol<Symbol.Type> type = this.getTypeFromPool(this.code.readCPI(bci), "Invalid CP constant for MULTIANEWARRAY: ");
        MethodVerifier.verifyGuarantee(Types.isArray(type), "Class " + String.valueOf(type) + " for MULTINEWARRAY is not an array type.");
        int dim = this.code.readUByte(bci + 3);
        MethodVerifier.verifyGuarantee(dim > 0, "Negative or 0 dimension for MULTIANEWARRAY: " + dim);
        MethodVerifier.verifyGuarantee(Types.getArrayDimensions(type) >= dim, "Incompatible dimensions from constant pool: " + Types.getArrayDimensions(type) + " and instruction: " + dim);
        for (int i = 0; i < dim; ++i) {
            stack.popInt();
        }
        stack.push(this.kindToOperand(type));
    }

    private void verifyInstanceOf(int bci, OperandStack stack) {
        stack.popRef();
        Symbol<Symbol.Type> type = this.getTypeFromPool(this.code.readCPI(bci), "Invalid CP constant for INSTANCEOF: ");
        MethodVerifier.verifyGuarantee(!Types.isPrimitive(type), "Primitive type for INSTANCEOF: " + String.valueOf(type));
        stack.pushInt();
    }

    private void verifyCheckCast(int bci, OperandStack stack) {
        Operand stacKOp = stack.popRef();
        Symbol<Symbol.Type> type = this.getTypeFromPool(this.code.readCPI(bci), "Invalid CP constant for CHECKCAST: ");
        MethodVerifier.verifyGuarantee(!Types.isPrimitive(type), "Primitive type for CHECKCAST: " + String.valueOf(type));
        Operand castOp = this.spawnFromType(type);
        if (stacKOp.isUninit() && !castOp.isArrayType()) {
            stack.push(new UninitReferenceOperand(type, this.thisKlass, ((UninitReferenceOperand)stacKOp).newBCI));
        } else {
            stack.push(castOp);
        }
    }

    private void verifyNewObjectArray(int bci, OperandStack stack) {
        char cpi = this.code.readCPI(bci);
        Symbol<Symbol.Type> type = this.getTypeFromPool(cpi, "Invalid CP constant for ANEWARRAY: ");
        MethodVerifier.verifyGuarantee(!Types.isPrimitive(type), "Primitive type for ANEWARRAY: " + String.valueOf(type));
        stack.popInt();
        Operand ref = this.spawnFromType(type);
        if (ref.isArrayType()) {
            stack.push(new ArrayOperand(ref.getElemental(), ref.getDimensions() + 1));
        } else {
            stack.push(new ArrayOperand(ref));
        }
    }

    private PoolConstant poolAt(int cpi) {
        MethodVerifier.verifyGuarantee(cpi < this.pool.length() && cpi > 0, "Invalid constant pool access at " + cpi + ", pool length: " + this.pool.length());
        return this.pool.at(cpi);
    }

    private void verifyNewPrimitiveArray(int bci, OperandStack stack) {
        byte jvmType = this.code.readByte(bci);
        MethodVerifier.verifyGuarantee(jvmType >= 4 && jvmType <= 11, "invalid jvmPrimitiveType for NEWARRAY: " + jvmType);
        stack.popInt();
        stack.push(this.fromJVMType(jvmType));
    }

    private void verifyNew(int bci, OperandStack stack) {
        Symbol<Symbol.Type> type = this.getTypeFromPool(this.code.readCPI(bci), "Invalid CP constant for NEW: ");
        MethodVerifier.verifyGuarantee(!Types.isPrimitive(type) && !Types.isArray(type), "use NEWARRAY for creating array or primitive type: " + String.valueOf(type));
        UninitReferenceOperand op = new UninitReferenceOperand(type, this.thisKlass, bci);
        stack.push(op);
    }

    private void verifyPutField(int bci, OperandStack stack, int curOpcode) {
        PoolConstant pc = this.poolAt(this.code.readCPI(bci));
        MethodVerifier.verifyGuarantee(pc.tag() == ConstantPool.Tag.FIELD_REF, "Invalid CP constant for PUTFIELD: " + pc.toString());
        MethodVerifier.validateOrFailVerification(pc, this.pool);
        FieldRefConstant frc = (FieldRefConstant)pc;
        assert (Validation.validFieldDescriptor(frc.getType(this.pool)));
        Symbol<Symbol.Type> fieldDesc = frc.getType(this.pool);
        Operand toPut = stack.pop(this.kindToOperand(fieldDesc));
        MethodVerifier.checkInit(toPut);
        if (curOpcode == 181) {
            assert (Validation.validClassNameEntry(frc.getHolderKlassName(this.pool)));
            Symbol<Symbol.Type> fieldHolderType = this.getTypes().fromName(frc.getHolderKlassName(this.pool));
            Operand fieldHolder = this.kindToOperand(fieldHolderType);
            Operand receiver = this.checkInitAccess(stack.popRef(fieldHolder), fieldHolder);
            MethodVerifier.verifyGuarantee(!receiver.isArrayType(), "Trying to access field of an array type: " + String.valueOf(receiver));
            if (!receiver.isUninitThis()) {
                this.checkProtectedMember(receiver, fieldHolderType, frc, false);
            }
        }
    }

    private void verifyGetField(int bci, OperandStack stack, int curOpcode) {
        PoolConstant pc = this.poolAt(this.code.readCPI(bci));
        MethodVerifier.verifyGuarantee(pc.tag() == ConstantPool.Tag.FIELD_REF, "Invalid CP constant for GETFIELD: " + pc.toString());
        MethodVerifier.validateOrFailVerification(pc, this.pool);
        FieldRefConstant frc = (FieldRefConstant)pc;
        assert (Validation.validFieldDescriptor(frc.getType(this.pool)));
        Symbol<Symbol.Type> type = frc.getType(this.pool);
        if (curOpcode == 180) {
            assert (Validation.validClassNameEntry(frc.getHolderKlassName(this.pool)));
            Symbol<Symbol.Type> fieldHolderType = this.getTypes().fromName(frc.getHolderKlassName(this.pool));
            Operand fieldHolder = this.kindToOperand(fieldHolderType);
            Operand receiver = this.checkInitAccess(stack.popRef(fieldHolder), fieldHolder);
            this.checkProtectedMember(receiver, fieldHolderType, frc, false);
            MethodVerifier.verifyGuarantee(!receiver.isArrayType(), "Trying to access field of an array type: " + String.valueOf(receiver));
        }
        Operand op = this.kindToOperand(type);
        stack.push(op);
    }

    private int verifyLookupSwitch(int bci, OperandStack stack, Locals locals) {
        stack.popInt();
        BytecodeLookupSwitch switchHelper = BytecodeLookupSwitch.INSTANCE;
        if (this.version51OrEarlier()) {
            for (int j = bci + 1; j < BytecodeSwitch.getAlignedBci(bci); ++j) {
                MethodVerifier.verifyGuarantee(this.code.readUByte(j) == 0, "non-zero padding for LOOKUPSWITCH");
            }
        }
        boolean low = false;
        int high = switchHelper.numberOfCases(this.code, bci) - 1;
        int previousKey = 0;
        if (high > 0) {
            previousKey = switchHelper.keyAt(this.code, bci, 0);
        }
        for (int i = 0; i <= high; ++i) {
            int thisKey = switchHelper.keyAt(this.code, bci, i);
            if (i > 0) {
                MethodVerifier.verifyGuarantee(thisKey > previousKey, "Unsorted keys in LookupSwitch");
            }
            this.branch(bci + switchHelper.offsetAt(this.code, bci, i), stack, locals);
            previousKey = thisKey;
        }
        return switchHelper.defaultTarget(this.code, bci);
    }

    private int verifyTableSwitch(int bci, OperandStack stack, Locals locals) {
        stack.popInt();
        BytecodeTableSwitch switchHelper = BytecodeTableSwitch.INSTANCE;
        if (this.version51OrEarlier()) {
            for (int j = bci + 1; j < BytecodeSwitch.getAlignedBci(bci); ++j) {
                MethodVerifier.verifyGuarantee(this.code.readUByte(j) == 0, "non-zero padding for TABLESWITCH");
            }
        }
        int low = switchHelper.lowKey(this.code, bci);
        int high = switchHelper.highKey(this.code, bci);
        for (int i = low; i != high + 1; ++i) {
            this.branch(switchHelper.targetAt(this.code, bci, i - low), stack, locals);
        }
        return switchHelper.defaultTarget(this.code, bci);
    }

    private void verifyJSR(int bci, OperandStack stack, Locals locals) {
        MethodVerifier.verifyGuarantee(this.earlierThan51(), "JSR/RET bytecode in version >= 51");
        if (this.stackFrames[bci] == null) {
            this.stackFrames[bci] = MethodVerifier.spawnStackFrame(stack, locals);
        }
        int targetBCI = this.code.readBranchDest(bci);
        stack.push(new ReturnAddressOperand(bci, targetBCI));
        locals.subRoutineModifications = new SubroutineModificationStack(locals.subRoutineModifications, new boolean[this.maxLocals], bci);
        this.branch(targetBCI, stack, locals);
        this.bciStates[bci] = MethodVerifier.setStatus(this.bciStates[bci], 2);
    }

    private void verifyRET(int bci, OperandStack stack, Locals locals) {
        MethodVerifier.verifyGuarantee(this.earlierThan51(), "JSR/RET bytecode in version >= 51");
        int pos = 0;
        ReturnAddressOperand ra = locals.loadReturnAddress(this.code.readLocalIndex(bci));
        ReturnAddressOperand prev = null;
        while (pos < ra.targetBCIs.size()) {
            prev = ra;
            int target = ra.targetBCIs.get(pos++);
            this.checkAndSetReturnedTo(target, bci);
            Locals toMerge = this.getSubroutineReturnLocals(target, locals);
            this.branch(this.code.nextBCI(target), stack, toMerge);
            ra = locals.loadReturnAddress(this.code.readLocalIndex(bci));
            if (ra == prev) continue;
            pos = 0;
        }
    }

    private MethodRefConstant getMethodRefConstant(int bci) {
        PoolConstant pc = this.poolAt(this.code.readCPI(bci));
        MethodVerifier.verifyGuarantee(pc instanceof MethodRefConstant, "Invalid CP constant for a MethodRef: " + pc.getClass().getName());
        MethodVerifier.validateOrFailVerification(pc, this.pool);
        return (MethodRefConstant)pc;
    }

    private static boolean isClassInit(Symbol<Symbol.Name> calledMethodName) {
        return Symbol.Name._clinit_.equals(calledMethodName);
    }

    private static boolean isInstanceInit(Symbol<Symbol.Name> calledMethodName) {
        return Symbol.Name._init_.equals(calledMethodName);
    }

    private Operand popSignatureGetReturnOp(OperandStack stack, MethodRefConstant mrc) {
        Symbol<Symbol.Signature> calledMethodSignature = mrc.getSignature(this.pool);
        Operand[] parsedSig = this.getOperandSig(calledMethodSignature);
        assert (parsedSig.length > 0) : "Method ref with no return value !";
        for (int i = parsedSig.length - 2; i >= 0; --i) {
            stack.pop(parsedSig[i]);
        }
        return parsedSig[parsedSig.length - 1];
    }

    private void verifyInvokeInterface(int bci, OperandStack stack) {
        MethodVerifier.verifyGuarantee(this.code.readUByte(bci + 4) == 0, "4th byte after INVOKEINTERFACE must be 0.");
        MethodRefConstant mrc = this.getMethodRefConstant(bci);
        Symbol<Symbol.Name> calledMethodName = mrc.getName(this.pool);
        MethodVerifier.verifyGuarantee(!MethodVerifier.isClassInit(calledMethodName), "Invocation of class initializer!");
        MethodVerifier.verifyGuarantee(!MethodVerifier.isInstanceInit(calledMethodName), "Invocation of instance initializer with opcode other than INVOKESPECIAL");
        Symbol<Symbol.Signature> calledMethodSignature = mrc.getSignature(this.pool);
        Operand[] parsedSig = this.getOperandSig(calledMethodSignature);
        assert (parsedSig.length > 0) : "Method ref with no return value !";
        int count = this.code.readUByte(bci + 3);
        MethodVerifier.verifyGuarantee(count > 0, "Invalid count argument for INVOKEINTERFACE: " + count);
        int descCount = 1;
        for (int i = parsedSig.length - 2; i >= 0; --i) {
            ++descCount;
            if (MethodVerifier.isType2(parsedSig[i])) {
                ++descCount;
            }
            stack.pop(parsedSig[i]);
        }
        MethodVerifier.verifyGuarantee(count == descCount, "Inconsistent redundant argument count for INVOKEINTERFACE.");
        assert (Validation.validClassNameEntry(mrc.getHolderKlassName(this.pool)));
        Symbol<Symbol.Type> methodHolder = this.getTypes().fromName(mrc.getHolderKlassName(this.pool));
        Operand methodHolderOp = this.kindToOperand(methodHolder);
        MethodVerifier.checkInit(stack.popRef(methodHolderOp));
        Operand returnOp = parsedSig[parsedSig.length - 1];
        if (returnOp != Void) {
            stack.push(returnOp);
        }
    }

    private void verifyInvokeStatic(int bci, OperandStack stack) {
        Symbol<Symbol.Name> calledMethodName;
        MethodRefConstant mrc = this.getMethodRefConstant(bci);
        if (this.version51OrEarlier()) {
            MethodVerifier.verifyGuarantee(mrc.tag() != ConstantPool.Tag.INTERFACE_METHOD_REF, "invokeStatic refers to an interface method with classfile version " + this.majorVersion);
        }
        MethodVerifier.verifyGuarantee(!MethodVerifier.isClassInit(calledMethodName = mrc.getName(this.pool)), "Invocation of class initializer!");
        MethodVerifier.verifyGuarantee(!MethodVerifier.isInstanceInit(calledMethodName), "Invocation of instance initializer with opcode other than INVOKESPECIAL");
        Operand returnOp = this.popSignatureGetReturnOp(stack, mrc);
        assert (Validation.validClassNameEntry(mrc.getHolderKlassName(this.pool)));
        if (returnOp != Void) {
            stack.push(returnOp);
        }
    }

    private void verifyInvokeSpecial(int bci, OperandStack stack, Locals locals) {
        Symbol<Symbol.Name> calledMethodName;
        MethodRefConstant mrc = this.getMethodRefConstant(bci);
        if (this.version51OrEarlier()) {
            MethodVerifier.verifyGuarantee(mrc.tag() != ConstantPool.Tag.INTERFACE_METHOD_REF, "invokeSpecial refers to an interface method with classfile version " + this.majorVersion);
        }
        MethodVerifier.verifyGuarantee(!MethodVerifier.isClassInit(calledMethodName = mrc.getName(this.pool)), "Invocation of class initializer!");
        Operand returnOp = this.popSignatureGetReturnOp(stack, mrc);
        assert (Validation.validClassNameEntry(mrc.getHolderKlassName(this.pool)));
        Symbol<Symbol.Type> methodHolder = this.getTypes().fromName(mrc.getHolderKlassName(this.pool));
        Operand methodHolderOp = this.kindToOperand(methodHolder);
        if (MethodVerifier.isInstanceInit(calledMethodName)) {
            UninitReferenceOperand toInit = (UninitReferenceOperand)stack.popUninitRef(methodHolderOp);
            if (toInit.isUninitThis()) {
                MethodVerifier.verifyGuarantee(Symbol.Name._init_.equals(this.methodName), "Encountered UninitializedThis outside of Constructor: " + String.valueOf(toInit));
                boolean isValidInitThis = toInit.getType() == methodHolder || toInit.getKlass().getSuperKlass().getType() == methodHolder;
                MethodVerifier.verifyGuarantee(isValidInitThis, "<init> method must call this.<init> or super.<init>");
                this.calledConstructor = true;
            } else {
                MethodVerifier.verifyGuarantee(this.code.opcode(toInit.newBCI) == 187, "There is no NEW bytecode at bci: " + toInit.newBCI);
                MethodVerifier.verifyGuarantee(toInit.getType() == methodHolder, "Calling wrong initializer for a new object.");
            }
            Operand stackOp = stack.initUninit(toInit);
            locals.initUninit(toInit, stackOp);
            this.checkProtectedMember(stackOp, methodHolder, mrc, true);
        } else {
            MethodVerifier.verifyGuarantee(this.checkMethodSpecialAccess(methodHolderOp), "invokespecial must specify a method in this class or a super class");
            Operand stackOp = MethodVerifier.checkInit(stack.popRef(methodHolderOp));
            MethodVerifier.verifyGuarantee(this.checkReceiverSpecialAccess(stackOp), "Invalid use of INVOKESPECIAL");
        }
        if (returnOp != Void) {
            stack.push(returnOp);
        }
    }

    private void verifyInvokeVirtual(int bci, OperandStack stack) {
        MethodRefConstant mrc = this.getMethodRefConstant(bci);
        Symbol<Symbol.Name> calledMethodName = mrc.getName(this.pool);
        MethodVerifier.verifyGuarantee(!MethodVerifier.isClassInit(calledMethodName), "Invocation of class initializer!");
        MethodVerifier.verifyGuarantee(!MethodVerifier.isInstanceInit(calledMethodName), "Invocation of instance initializer with opcode other than INVOKESPECIAL");
        Operand returnOp = this.popSignatureGetReturnOp(stack, mrc);
        assert (Validation.validClassNameEntry(mrc.getHolderKlassName(this.pool)));
        Symbol<Symbol.Type> methodHolder = this.getTypes().fromName(mrc.getHolderKlassName(this.pool));
        Operand methodHolderOp = this.kindToOperand(methodHolder);
        Operand stackOp = MethodVerifier.checkInit(stack.popRef(methodHolderOp));
        this.checkProtectedMember(stackOp, methodHolder, mrc, true);
        if (returnOp != Void) {
            stack.push(returnOp);
        }
    }

    private Locals getSubroutineReturnLocals(int target, Locals locals) {
        int i;
        SubroutineModificationStack subRoutineModifications = locals.subRoutineModifications;
        MethodVerifier.verifyGuarantee(subRoutineModifications != null, "RET outside of a subroutine");
        boolean[] subroutineBitArray = subRoutineModifications.subRoutineModifications;
        SubroutineModificationStack nested = subRoutineModifications.next;
        Locals jsrLocals = this.stackFrames[target].extractLocals();
        Operand[] registers = new Operand[this.maxLocals];
        boolean nestedRet = jsrLocals.subRoutineModifications != null;
        int depthRoutine = locals.subRoutineModifications.depth();
        int depthRet = nestedRet ? jsrLocals.subRoutineModifications.depth() : 0;
        MethodVerifier.verifyGuarantee(depthRet < depthRoutine, "RET increases subroutine depth.");
        while (depthRoutine - depthRet > 1) {
            for (i = 0; i < subroutineBitArray.length; ++i) {
                if (subroutineBitArray[i]) {
                    nested.subRoutineModifications[i] = true;
                    continue;
                }
                if (!nested.subRoutineModifications[i]) continue;
                subroutineBitArray[i] = true;
            }
            nested = nested.next;
            --depthRoutine;
        }
        for (i = 0; i < this.maxLocals; ++i) {
            if (subroutineBitArray[i]) {
                registers[i] = locals.registers[i];
                if (nested == null) continue;
                nested.subRoutineModifications[i] = true;
                continue;
            }
            registers[i] = jsrLocals.registers[i];
        }
        Locals res = new Locals(registers);
        res.subRoutineModifications = nested;
        return res;
    }

    private boolean checkReceiverSpecialAccess(Operand stackOp) {
        return stackOp.compliesWith(this.thisOperand) || this.isMagicAccessor() || this.checkReceiverHostAccess(stackOp);
    }

    private boolean checkReceiverHostAccess(Operand stackOp) {
        if (this.thisKlass.getHostClass() != null) {
            return this.thisKlass.getHostClass().isAssignableFrom(stackOp.getKlass());
        }
        return false;
    }

    private boolean checkMethodSpecialAccess(Operand methodHolder) {
        return this.thisOperand.compliesWith(methodHolder) || this.isMagicAccessor() || this.checkHostAccess(methodHolder);
    }

    private boolean isMagicAccessor() {
        return this.getMeta().sun_reflect_MagicAccessorImpl.isAssignableFrom(this.thisOperand.getKlass());
    }

    private boolean checkHostAccess(Operand methodHolder) {
        if (this.thisKlass.getHostClass() != null) {
            return methodHolder.getKlass().isAssignableFrom(this.thisKlass.getHostClass());
        }
        return false;
    }

    private void checkProtectedMember(Operand stackOp, Symbol<Symbol.Type> holderType, MemberRefConstant mrc, boolean method) {
        if (stackOp.getType() == this.thisKlass.getType()) {
            return;
        }
        for (ObjectKlass superKlass = this.thisKlass.getSuperKlass(); superKlass != null; superKlass = ((Klass)superKlass).getSuperKlass()) {
            if (superKlass.getType() != holderType) continue;
            Operand holderOp = this.kindToOperand(holderType);
            Member member = method ? holderOp.getKlass().lookupMethod(mrc.getName(this.pool), ((MethodRefConstant)mrc).getSignature(this.pool)) : holderOp.getKlass().lookupField(mrc.getName(this.pool), ((FieldRefConstant)mrc).getType(this.pool));
            if (member == null || !member.isProtected()) {
                return;
            }
            if (!this.thisKlass.getRuntimePackage().contentEquals(Types.getRuntimePackage(holderType))) {
                if (method && stackOp.isArrayType() && Symbol.Type.java_lang_Object.equals(holderType) && Symbol.Name.clone.equals(member.getName())) {
                    return;
                }
                MethodVerifier.verifyGuarantee(stackOp.compliesWith(this.thisOperand), "Illegal protected field access");
            }
            return;
        }
    }

    private void doReturn(OperandStack stack, Operand toReturn) {
        Operand op = stack.pop(toReturn);
        MethodVerifier.verifyGuarantee(op.compliesWith(this.returnOperand), "Invalid return: " + String.valueOf(op) + ", expected: " + String.valueOf(this.returnOperand));
    }

    static boolean isType2(Operand k) {
        return k == Long || k == Double;
    }

    private Operand checkInitAccess(Operand op, Operand holder) {
        if (op.isUninit()) {
            if (MethodVerifier.isInstanceInit(this.methodName) && holder.getType() == this.thisKlass.getType()) {
                return op;
            }
            throw MethodVerifier.failVerify("Accessing field or calling method of an uninitialized reference.");
        }
        return op;
    }

    private static Operand checkInit(Operand op) {
        MethodVerifier.verifyGuarantee(!op.isUninit(), "Accessing field or calling method of an uninitialized reference.");
        return op;
    }

    private Operand fromJVMType(byte jvmType) {
        switch (jvmType) {
            case 4: {
                return new ArrayOperand(this.booleanOperand);
            }
            case 5: {
                return new ArrayOperand(Char);
            }
            case 6: {
                return new ArrayOperand(Float);
            }
            case 7: {
                return new ArrayOperand(Double);
            }
            case 8: {
                return new ArrayOperand(Byte);
            }
            case 9: {
                return new ArrayOperand(Short);
            }
            case 10: {
                return new ArrayOperand(Int);
            }
            case 11: {
                return new ArrayOperand(Long);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    Operand[] getOperandSig(Symbol<Symbol.Type>[] toParse) {
        Operand[] operandSig = new Operand[toParse.length];
        for (int i = 0; i < operandSig.length; ++i) {
            Symbol<Symbol.Type> type = toParse[i];
            operandSig[i] = this.kindToOperand(type);
        }
        return operandSig;
    }

    private Operand[] getOperandSig(Symbol<Symbol.Signature> toParse) {
        return this.getOperandSig(this.getSignatures().parsed(toParse));
    }

    private Operand kindToOperand(Symbol<Symbol.Type> type) {
        switch (Types.getJavaKind(type)) {
            case Boolean: {
                return this.booleanOperand;
            }
            case Byte: {
                return Byte;
            }
            case Short: {
                return Short;
            }
            case Char: {
                return Char;
            }
            case Int: {
                return Int;
            }
            case Float: {
                return Float;
            }
            case Long: {
                return Long;
            }
            case Double: {
                return Double;
            }
            case Void: {
                return Void;
            }
            case Object: {
                return this.spawnFromType(type);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    private Operand spawnFromType(Symbol<Symbol.Type> type) {
        if (Types.isArray(type)) {
            return new ArrayOperand(this.kindToOperand(this.getTypes().getElementalType(type)), Types.getArrayDimensions(type));
        }
        return new ReferenceOperand(type, (Klass)this.thisKlass);
    }

    private static void xaload(OperandStack stack, PrimitiveOperand kind) {
        stack.popInt();
        Operand op = stack.popArray();
        MethodVerifier.verifyGuarantee(op == Null || kind.compliesWith(op.getComponent()), "Loading " + String.valueOf(kind) + " from " + String.valueOf(op) + " array.");
        stack.push(kind.toStack());
    }

    private static void xastore(OperandStack stack, PrimitiveOperand kind) {
        stack.pop(kind);
        stack.popInt();
        Operand array = stack.popArray();
        MethodVerifier.verifyGuarantee(array == Null || kind.compliesWith(array.getComponent()), "got array of type: " + String.valueOf(array) + ", while storing a " + String.valueOf(kind));
    }

    private static boolean wideOpcodes(int op) {
        return op >= 21 && op <= 25 || op >= 54 && op <= 58 || op == 169 || op == 132;
    }

    public StackFrame mergeFrames(OperandStack stack, Locals locals, StackFrame stackMap) {
        if (stackMap == null) {
            MethodVerifier.verifyGuarantee(!this.useStackMaps, "No stack frame on jump target");
            return MethodVerifier.spawnStackFrame(stack, locals);
        }
        Operand[] mergedStack = null;
        int mergeIndex = stack.mergeInto(stackMap);
        if (mergeIndex != -1) {
            MethodVerifier.verifyGuarantee(!this.useStackMaps, "Wrong stack map frames in class file.");
            mergedStack = new Operand[stackMap.stack.length];
            System.arraycopy(stackMap.stack, 0, mergedStack, 0, mergeIndex);
            for (int i = mergeIndex; i < mergedStack.length; ++i) {
                Operand stackOp = stack.stack[i];
                Operand frameOp = stackMap.stack[i];
                if (!stackOp.compliesWithInMerge(frameOp)) {
                    Operand result = stackOp.mergeWith(frameOp);
                    MethodVerifier.verifyGuarantee(result != null, "Cannot merge " + String.valueOf(stackOp) + " with " + String.valueOf(frameOp));
                    mergedStack[i] = result;
                    continue;
                }
                mergedStack[i] = frameOp;
            }
        }
        Operand[] mergedLocals = null;
        mergeIndex = locals.mergeInto(stackMap);
        if (mergeIndex != -1) {
            MethodVerifier.verifyGuarantee(!this.useStackMaps, "Wrong local map frames in class file: " + String.valueOf(this.thisKlass) + "." + String.valueOf(this.methodName));
            mergedLocals = new Operand[this.maxLocals];
            Operand[] frameLocals = stackMap.locals;
            System.arraycopy(frameLocals, 0, mergedLocals, 0, mergeIndex);
            for (int i = mergeIndex; i < mergedLocals.length; ++i) {
                Operand localsOp = locals.registers[i];
                Operand frameOp = frameLocals[i];
                if (!localsOp.compliesWithInMerge(frameOp)) {
                    Operand result = localsOp.mergeWith(frameOp);
                    if (result == null) {
                        mergedLocals[i] = Invalid;
                        continue;
                    }
                    mergedLocals[i] = result;
                    continue;
                }
                mergedLocals[i] = frameOp;
            }
        }
        stackMap.mergeSubroutines(locals.subRoutineModifications);
        if (mergedStack == null && mergedLocals == null) {
            return stackMap;
        }
        if (mergedStack == null) {
            return new StackFrame(stack, mergedLocals, stackMap.subroutineModificationStack);
        }
        return new StackFrame(mergedStack, stack.size, stack.top, mergedLocals == null ? locals.registers : mergedLocals, stackMap.subroutineModificationStack);
    }

    private static StackFrame spawnStackFrame(OperandStack stack, Locals locals) {
        return new StackFrame(stack, locals);
    }

    @Override
    public String toExternalString() {
        return this.getThisKlass().getExternalName() + "." + String.valueOf(this.getMethodName());
    }

    private static class WorkingQueue {
        QueueElement first;
        QueueElement last;

        WorkingQueue() {
        }

        boolean isEmpty() {
            return this.first == null;
        }

        void push(int bci, QueueElement elem) {
            QueueElement current = this.lookup(bci);
            if (current == null) {
                if (this.first == null) {
                    this.last = this.first = elem;
                } else {
                    this.last.next = elem;
                    elem.prev = this.last;
                    this.last = this.last.next;
                }
            } else {
                this.replace(current, elem);
            }
        }

        QueueElement pop() {
            assert (this.first != null);
            QueueElement res = this.first;
            this.first = this.first.next;
            return res;
        }

        void replace(QueueElement oldElem, QueueElement newElem) {
            if (this.first == oldElem) {
                this.first = newElem;
            }
            if (this.last == oldElem) {
                this.last = newElem;
            }
            newElem.next = oldElem.next;
            newElem.prev = oldElem.prev;
            if (oldElem.prev != null) {
                oldElem.prev.next = newElem;
            }
            if (oldElem.next != null) {
                oldElem.next.prev = newElem;
            }
        }

        QueueElement lookup(int bci) {
            QueueElement current = this.first;
            while (current != null && current.bci != bci) {
                current = current.next;
            }
            return current;
        }
    }

    public static class VerifierError
    extends Error {
        private static final long serialVersionUID = 7039576945173150725L;
        private final Kind kind;
        private final boolean allowFallback;

        VerifierError(String message, Kind kind) {
            this(message, kind, true);
        }

        VerifierError(String message, Kind kind, boolean allowFallback) {
            super(message);
            this.kind = kind;
            this.allowFallback = allowFallback;
        }

        public Kind kind() {
            return this.kind;
        }

        public static enum Kind {
            Verify,
            ClassFormat,
            NoClassDefFound;

        }
    }

    private static class QueueElement {
        final int bci;
        final StackFrame frame;
        final boolean constructorCalled;
        QueueElement prev;
        QueueElement next;

        QueueElement(int bci, StackFrame frame, boolean calledConstructor) {
            this.bci = bci;
            this.frame = frame;
            this.constructorCalled = calledConstructor;
        }
    }
}

