/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.verifier.Operand;

class PrimitiveOperand
extends Operand {
    PrimitiveOperand(JavaKind kind) {
        super(kind);
    }

    @Override
    boolean isPrimitive() {
        return true;
    }

    @Override
    boolean compliesWith(Operand other) {
        return other.isTopOperand() || other == this;
    }

    @Override
    Operand mergeWith(Operand other) {
        assert (!this.compliesWithInMerge(other)) : "mergeWith method should only be called for non-compatible operands.";
        return this == other ? this : null;
    }

    public String toString() {
        return this.kind.toString();
    }

    public PrimitiveOperand toStack() {
        return this;
    }
}

