/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;

final class PrimitiveTypeInfo
extends VerificationTypeInfo {
    private static final PrimitiveTypeInfo Bogus = new PrimitiveTypeInfo(0);
    private static final PrimitiveTypeInfo Integer = new PrimitiveTypeInfo(1);
    private static final PrimitiveTypeInfo Float = new PrimitiveTypeInfo(2);
    private static final PrimitiveTypeInfo Double = new PrimitiveTypeInfo(3);
    private static final PrimitiveTypeInfo Long = new PrimitiveTypeInfo(4);
    private static final PrimitiveTypeInfo Null = new PrimitiveTypeInfo(5);
    private final int tag;

    private PrimitiveTypeInfo(int tag) {
        this.tag = tag;
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    static VerificationTypeInfo get(int tag) {
        switch (tag) {
            case 0: {
                return Bogus;
            }
            case 1: {
                return Integer;
            }
            case 2: {
                return Float;
            }
            case 3: {
                return Double;
            }
            case 4: {
                return Long;
            }
            case 5: {
                return Null;
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    @Override
    public Symbol<Symbol.Type> getType(ConstantPool pool, ObjectKlass thisKlass, BytecodeStream bs) {
        switch (this.tag) {
            case 1: {
                return Symbol.Type._int;
            }
            case 2: {
                return Symbol.Type._float;
            }
            case 3: {
                return Symbol.Type._double;
            }
            case 4: {
                return Symbol.Type._long;
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    @Override
    public boolean isNull() {
        return this.tag == 5;
    }

    @Override
    public boolean isIllegal() {
        return this.tag == 0;
    }
}

