/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;

final class ReferenceVariable
extends VerificationTypeInfo {
    private final int constantPoolOffset;

    ReferenceVariable(int constantPoolOffset) {
        this.constantPoolOffset = constantPoolOffset;
    }

    @Override
    public int getTag() {
        return 7;
    }

    @Override
    public int getConstantPoolOffset() {
        return this.constantPoolOffset;
    }

    @Override
    protected String fromCP(Klass klass) {
        return String.valueOf(klass.getConstantPool().classAt(this.constantPoolOffset).getName(klass.getConstantPool()));
    }

    @Override
    public Symbol<Symbol.Type> getType(ConstantPool pool, ObjectKlass thisKlass, BytecodeStream bs) {
        Types types = thisKlass.getMeta().getTypes();
        return types.fromName(pool.classAt(this.getConstantPoolOffset()).getName(pool));
    }
}

