/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.verifier.Operand;
import com.oracle.truffle.espresso.verifier.PrimitiveOperand;
import java.util.ArrayList;

final class ReturnAddressOperand
extends PrimitiveOperand {
    final ArrayList<Integer> targetBCIs = new ArrayList();
    final int subroutineBCI;

    ReturnAddressOperand(int target, int subroutineBCI) {
        super(JavaKind.ReturnAddress);
        this.targetBCIs.add(target);
        this.subroutineBCI = subroutineBCI;
    }

    private ReturnAddressOperand(ArrayList<Integer> bcis, int subroutineBCI) {
        super(JavaKind.ReturnAddress);
        this.targetBCIs.addAll(bcis);
        this.subroutineBCI = subroutineBCI;
    }

    @Override
    boolean isReturnAddress() {
        return true;
    }

    @Override
    boolean compliesWith(Operand other) {
        if (other.isTopOperand()) {
            return true;
        }
        if (other.isReturnAddress()) {
            ReturnAddressOperand ra = (ReturnAddressOperand)other;
            if (ra.subroutineBCI != this.subroutineBCI) {
                return false;
            }
            for (Integer target : this.targetBCIs) {
                if (ra.targetBCIs.contains(target)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    Operand mergeWith(Operand other) {
        assert (!this.compliesWithInMerge(other)) : "mergeWith method should only be called for non-compatible operands.";
        if (!other.isReturnAddress()) {
            return null;
        }
        ReturnAddressOperand otherRA = (ReturnAddressOperand)other;
        if (otherRA.subroutineBCI != this.subroutineBCI) {
            return null;
        }
        ReturnAddressOperand ra = new ReturnAddressOperand(otherRA.targetBCIs, this.subroutineBCI);
        for (Integer target : this.targetBCIs) {
            if (ra.targetBCIs.contains(target)) continue;
            ra.targetBCIs.add(target);
        }
        return ra;
    }
}

