/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.verifier.Locals;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.verifier.Operand;
import com.oracle.truffle.espresso.verifier.OperandStack;
import com.oracle.truffle.espresso.verifier.StackMapFrameParser;
import com.oracle.truffle.espresso.verifier.SubroutineModificationStack;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;

class StackFrame
implements StackMapFrameParser.FrameState {
    final Operand[] stack;
    final int stackSize;
    final int top;
    final Operand[] locals;
    final SubroutineModificationStack subroutineModificationStack;

    StackFrame(OperandStack stack, Locals locals) {
        this.stack = stack.extract();
        this.stackSize = stack.size;
        this.top = stack.top;
        this.locals = locals.extract();
        this.subroutineModificationStack = locals.subRoutineModifications;
    }

    StackFrame(OperandStack stack, Operand[] locals) {
        this(stack, locals, null);
    }

    StackFrame(OperandStack stack, Operand[] locals, SubroutineModificationStack sms) {
        this.stack = stack.extract();
        this.stackSize = stack.size;
        this.top = stack.top;
        this.locals = locals;
        this.subroutineModificationStack = sms;
    }

    StackFrame(MethodVerifier mv) {
        this(new OperandStack(mv.getMaxStack()), new Locals(mv));
    }

    StackFrame(Operand[] stack, int stackSize, int top, Operand[] locals) {
        this.stack = stack;
        this.stackSize = stackSize;
        this.top = top;
        this.locals = locals;
        this.subroutineModificationStack = null;
    }

    StackFrame(Operand[] stack, int stackSize, int top, Operand[] locals, SubroutineModificationStack sms) {
        this.stack = stack;
        this.stackSize = stackSize;
        this.top = top;
        this.locals = locals;
        this.subroutineModificationStack = sms;
    }

    OperandStack extractStack(int maxStack) {
        OperandStack res = new OperandStack(maxStack);
        System.arraycopy(this.stack, 0, res.stack, 0, this.top);
        res.size = this.stackSize;
        res.top = this.top;
        return res;
    }

    Locals extractLocals() {
        Locals newLocals = new Locals((Operand[])this.locals.clone());
        newLocals.subRoutineModifications = this.subroutineModificationStack;
        return newLocals;
    }

    void mergeSubroutines(SubroutineModificationStack other) {
        if (this.subroutineModificationStack == null) {
            return;
        }
        if (other == this.subroutineModificationStack) {
            return;
        }
        this.subroutineModificationStack.merge(other);
    }

    @Override
    public StackFrame sameNoStack() {
        return new StackFrame(Operand.EMPTY_ARRAY, 0, 0, this.locals);
    }

    @Override
    public StackFrame sameLocalsWith1Stack(VerificationTypeInfo vfi, StackMapFrameParser.FrameBuilder<?> builder) {
        if (builder instanceof MethodVerifier) {
            MethodVerifier verifier = (MethodVerifier)builder;
            Operand op = verifier.getOperandFromVerificationType(vfi);
            MethodVerifier.formatGuarantee(op.slots() <= verifier.getMaxStack(), "Stack map entry requires more stack than allowed by maxStack.");
            OperandStack newStack = new OperandStack(2);
            newStack.push(op);
            return new StackFrame(newStack, this.locals);
        }
        throw EspressoError.shouldNotReachHere();
    }

    @Override
    public StackMapFrameParser.FrameAndLocalEffect chop(int chop, int lastLocal) {
        Operand[] newLocals = (Operand[])this.locals.clone();
        int pos = lastLocal;
        for (int i = 0; i < chop; ++i) {
            MethodVerifier.formatGuarantee(pos >= 0, "Chop frame entry chops more locals than existing.");
            Operand op = newLocals[pos];
            if (op.isTopOperand() && pos > 0 && MethodVerifier.isType2(newLocals[pos - 1])) {
                --pos;
            }
            newLocals[pos] = MethodVerifier.Invalid;
            --pos;
        }
        return new StackMapFrameParser.FrameAndLocalEffect(new StackFrame(Operand.EMPTY_ARRAY, 0, 0, newLocals), pos - lastLocal);
    }

    @Override
    public StackMapFrameParser.FrameAndLocalEffect append(VerificationTypeInfo[] vfis, StackMapFrameParser.FrameBuilder<?> builder, int lastLocal) {
        if (builder instanceof MethodVerifier) {
            MethodVerifier verifier = (MethodVerifier)builder;
            MethodVerifier.verifyGuarantee(vfis.length > 0, "Empty Append Frame in the StackmapTable");
            Operand[] newLocals = (Operand[])this.locals.clone();
            int pos = lastLocal;
            for (VerificationTypeInfo vti : vfis) {
                Operand op = verifier.getOperandFromVerificationType(vti);
                MethodVerifier.setLocal(newLocals, op, ++pos, "Append frame entry in stack map appends more locals than allowed.");
                if (!MethodVerifier.isType2(op)) continue;
                MethodVerifier.setLocal(newLocals, MethodVerifier.Invalid, ++pos, "Append frame entry in stack map appends more locals than allowed.");
            }
            return new StackMapFrameParser.FrameAndLocalEffect(new StackFrame(Operand.EMPTY_ARRAY, 0, 0, newLocals), pos - lastLocal);
        }
        throw EspressoError.shouldNotReachHere();
    }
}

