/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.jni.NativeEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.GenerateNativeEnv;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_Thread;
import com.oracle.truffle.espresso.threads.EspressoThreadRegistry;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.ThreadsAccess;
import com.oracle.truffle.espresso.vm.ManagementImpl;
import com.oracle.truffle.espresso.vm.ManagementImplCollector;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;

@GenerateNativeEnv(target=ManagementImpl.class, prependEnv=true)
public final class Management
extends NativeEnv {
    private static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", Management.class);
    public static final int JMM_CLASS_LOADED_COUNT = 1;
    public static final int JMM_CLASS_UNLOADED_COUNT = 2;
    public static final int JMM_THREAD_TOTAL_COUNT = 3;
    public static final int JMM_THREAD_LIVE_COUNT = 4;
    public static final int JMM_THREAD_PEAK_COUNT = 5;
    public static final int JMM_THREAD_DAEMON_COUNT = 6;
    public static final int JMM_JVM_INIT_DONE_TIME_MS = 7;
    public static final int JMM_COMPILE_TOTAL_TIME_MS = 8;
    public static final int JMM_GC_TIME_MS = 9;
    public static final int JMM_GC_COUNT = 10;
    public static final int JMM_JVM_UPTIME_MS = 11;
    public static final int JMM_INTERNAL_ATTRIBUTE_INDEX = 100;
    public static final int JMM_CLASS_LOADED_BYTES = 101;
    public static final int JMM_CLASS_UNLOADED_BYTES = 102;
    public static final int JMM_TOTAL_CLASSLOAD_TIME_MS = 103;
    public static final int JMM_VM_GLOBAL_COUNT = 104;
    public static final int JMM_SAFEPOINT_COUNT = 105;
    public static final int JMM_TOTAL_SAFEPOINTSYNC_TIME_MS = 106;
    public static final int JMM_TOTAL_STOPPED_TIME_MS = 107;
    public static final int JMM_TOTAL_APP_TIME_MS = 108;
    public static final int JMM_VM_THREAD_COUNT = 109;
    public static final int JMM_CLASS_INIT_TOTAL_COUNT = 110;
    public static final int JMM_CLASS_INIT_TOTAL_TIME_MS = 111;
    public static final int JMM_METHOD_DATA_SIZE_BYTES = 112;
    public static final int JMM_CLASS_VERIFY_TOTAL_TIME_MS = 113;
    public static final int JMM_SHARED_CLASS_LOADED_COUNT = 114;
    public static final int JMM_SHARED_CLASS_UNLOADED_COUNT = 115;
    public static final int JMM_SHARED_CLASS_LOADED_BYTES = 116;
    public static final int JMM_SHARED_CLASS_UNLOADED_BYTES = 117;
    public static final int JMM_OS_ATTRIBUTE_INDEX = 200;
    public static final int JMM_OS_PROCESS_ID = 201;
    public static final int JMM_OS_MEM_TOTAL_PHYSICAL_BYTES = 202;
    public static final int JMM_GC_EXT_ATTRIBUTE_INFO_SIZE = 401;
    public static final int JMM_VERBOSE_GC = 21;
    public static final int JMM_VERBOSE_CLASS = 22;
    public static final int JMM_THREAD_CONTENTION_MONITORING = 23;
    public static final int JMM_THREAD_CPU_TIME = 24;
    public static final int JMM_THREAD_ALLOCATED_MEMORY = 25;
    public static final int JMM_STAT_PEAK_THREAD_COUNT = 801;
    public static final int JMM_STAT_THREAD_CONTENTION_COUNT = 802;
    public static final int JMM_STAT_THREAD_CONTENTION_TIME = 803;
    public static final int JMM_STAT_THREAD_CONTENTION_STAT = 804;
    public static final int JMM_STAT_PEAK_POOL_USAGE = 805;
    public static final int JMM_STAT_GC_STAT = 806;
    public static final int JMM_VERSION_1 = 0x20010000;
    public static final int JMM_VERSION_1_0 = 0x20010000;
    public static final int JMM_VERSION_1_1 = 0x20010100;
    public static final int JMM_VERSION_1_2 = 0x20010200;
    public static final int JMM_VERSION_1_2_1 = 0x20010201;
    public static final int JMM_VERSION_1_2_2 = 0x20010202;
    public static final int JMM_VERSION_1_2_3 = 536936963;
    public static final int JMM_VERSION_2 = 0x20020000;
    public static final int JMM_VERSION_3 = 0x20030000;
    public static final int JMM_VERSION_4 = 0x20040000;
    @CompilerDirectives.CompilationFinal
    private @Pointer TruffleObject managementPtr;
    @CompilerDirectives.CompilationFinal
    private int managementVersion;
    private final @Pointer TruffleObject initializeManagementContext;
    private final @Pointer TruffleObject disposeManagementContext;
    private static final List<CallableFromNative.Factory> MANAGEMENT_IMPL_FACTORIES = ManagementImplCollector.getInstances(CallableFromNative.Factory.class);
    private final ConcurrentHashMap<MemoryPoolMXBean, StaticObject> memoryPools = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StaticObject> memoryPoolsByName = new ConcurrentHashMap();
    private final ConcurrentHashMap<StaticObject, MemoryPoolMXBean> reverseMemoryPools = new ConcurrentHashMap();
    @CompilerDirectives.CompilationFinal
    private Klass memoryPoolMXBeanKlass;
    private final ConcurrentHashMap<MemoryManagerMXBean, StaticObject> memoryManagers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StaticObject> memoryManagersByName = new ConcurrentHashMap();
    private final ConcurrentHashMap<StaticObject, MemoryManagerMXBean> reverseMemoryManagers = new ConcurrentHashMap();
    @CompilerDirectives.CompilationFinal
    private Klass memoryManagerMXBeanKlass;
    @CompilerDirectives.CompilationFinal
    private Method memoryUsageInit;
    private boolean JMM_VERBOSE_GC_state = false;
    private boolean JMM_VERBOSE_CLASS_state = false;
    private boolean JMM_THREAD_CONTENTION_MONITORING_state = false;
    private boolean JMM_THREAD_CPU_TIME_state = false;
    private boolean JMM_THREAD_ALLOCATED_MEMORY_state = false;

    public Management(EspressoContext context, TruffleObject mokapotLibrary) {
        super(context);
        assert (context.getEspressoEnv().EnableManagement);
        this.initializeManagementContext = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "initializeManagementContext", NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.INT));
        this.disposeManagementContext = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "disposeManagementContext", NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.INT, NativeType.POINTER));
    }

    @Override
    protected TruffleLogger getLogger() {
        return LOGGER;
    }

    public static boolean isSupportedManagementVersion(int version) {
        return version == 0x20010000 || version == 0x20020000 || version == 0x20030000 || version == 0x20040000;
    }

    public TruffleObject getManagement(int version) {
        if (!Management.isSupportedManagementVersion(version)) {
            return RawPointer.nullInstance();
        }
        if (this.managementPtr == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.managementPtr = this.initializeAndGetEnv(this.initializeManagementContext, version);
            this.managementVersion = version;
            assert (this.getUncached().isPointer((Object)this.managementPtr));
            assert (this.managementPtr != null && !this.getUncached().isNull((Object)this.managementPtr));
        } else if (version != this.managementVersion) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getContext().getLogger().warning("Asking for a different management version that previously requested.\nPreviously requested: " + this.managementVersion + ", currently requested: " + version);
            return RawPointer.nullInstance();
        }
        return this.managementPtr;
    }

    public void dispose() {
        if (this.managementPtr != null) {
            try {
                this.getUncached().execute((Object)this.disposeManagementContext, new Object[]{this.managementPtr, this.managementVersion, RawPointer.nullInstance()});
                this.managementPtr = null;
                this.managementVersion = 0;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw EspressoError.shouldNotReachHere("Cannot dispose Espresso management (mokapot).");
            }
        }
    }

    @Override
    protected List<CallableFromNative.Factory> getCollector() {
        return MANAGEMENT_IMPL_FACTORIES;
    }

    @Override
    protected String getName() {
        return "Management";
    }

    public int GetVersion() {
        if (this.managementVersion <= 536936963) {
            return 536936963;
        }
        return this.managementVersion;
    }

    public int GetOptionalSupport(@Pointer TruffleObject supportPtr) {
        if (!this.getUncached().isNull((Object)supportPtr)) {
            ByteBuffer supportBuf = NativeUtils.directByteBuffer(supportPtr, 8L);
            supportBuf.putInt(0);
            return 0;
        }
        return -1;
    }

    private static void validateThreadIdArray(EspressoLanguage language, Meta meta, @JavaType(value=long[].class) StaticObject threadIds, SubstitutionProfiler profiler) {
        assert (threadIds.isArray());
        int numThreads = threadIds.length(language);
        for (int i = 0; i < numThreads; ++i) {
            long tid = ((long[])threadIds.unwrap(language))[i];
            if (tid > 0L) continue;
            profiler.profile(3);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Invalid thread ID entry");
        }
    }

    private static void validateThreadInfoArray(Meta meta, @JavaType(internalName="[Ljava/lang/management/ThreadInfo;") StaticObject infoArray, SubstitutionProfiler profiler) {
        Klass component;
        Klass infoArrayKlass = infoArray.getKlass();
        if (infoArray.isArray() && !meta.java_lang_management_ThreadInfo.equals(component = ((ArrayKlass)infoArrayKlass).getComponentType())) {
            profiler.profile(4);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "infoArray element type is not ThreadInfo class");
        }
    }

    public int GetThreadInfo(@JavaType(value=long[].class) StaticObject ids, int maxDepth, @JavaType(value=Object[].class) StaticObject infoArray, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(ids)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        Management.validateThreadIdArray(language, meta, ids, profiler);
        Management.validateThreadInfoArray(meta, infoArray, profiler);
        int idsLength = ids.length(language);
        StaticObject[] activeThreads = this.getContext().getActiveThreads();
        StaticObject[] threads = new StaticObject[idsLength];
        for (int i = 0; i < idsLength; ++i) {
            long id = this.getInterpreterToVM().getArrayLong(language, i, ids);
            threads[i] = this.findThreadById(activeThreads, id);
        }
        this.fillThreadInfos(threads, infoArray, maxDepth, language, meta, profiler, null);
        return 0;
    }

    private StaticObject findThreadById(StaticObject[] activeThreads, long id) {
        StaticObject thread = StaticObject.NULL;
        for (int j = 0; j < activeThreads.length; ++j) {
            if (this.getThreadAccess().getThreadId(activeThreads[j]) != id) continue;
            thread = activeThreads[j];
            break;
        }
        return thread;
    }

    private void fillThreadInfos(StaticObject[] threads, StaticObject infoArray, int maxDepth, EspressoLanguage language, Meta meta, SubstitutionProfiler profiler, Node node) {
        if (StaticObject.isNull(infoArray)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        if (maxDepth < -1) {
            profiler.profile(1);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Invalid maxDepth");
        }
        int actualMaxDepth = maxDepth < 0 ? Integer.MAX_VALUE : maxDepth;
        Management.validateThreadInfoArray(meta, infoArray, profiler);
        if (threads.length != infoArray.length(language)) {
            profiler.profile(2);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "The length of the given ThreadInfo array does not match the length of the given array of thread IDs");
        }
        Method init = meta.java_lang_management_ThreadInfo.lookupDeclaredMethod(Symbol.Name._init_, this.getSignatures().makeRaw(Symbol.Type._void, Symbol.Type.java_lang_Thread, Symbol.Type._int, Symbol.Type.java_lang_Object, Symbol.Type.java_lang_Thread, Symbol.Type._long, Symbol.Type._long, Symbol.Type._long, Symbol.Type._long, Symbol.Type.java_lang_StackTraceElement_array));
        for (int i = 0; i < threads.length; ++i) {
            StaticObject thread = threads[i];
            if (StaticObject.isNull(thread) || !this.getThreadAccess().isAlive(thread) || this.getThreadAccess().isVirtualThread(thread)) {
                this.getInterpreterToVM().setArrayObject(language, StaticObject.NULL, i, infoArray);
                continue;
            }
            int threadStatus = meta.getThreadAccess().getState(thread);
            StaticObject lockObj = StaticObject.NULL;
            StaticObject lockOwner = StaticObject.NULL;
            if ((threadStatus & State.BLOCKED.value) != 0) {
                lockObj = (StaticObject)meta.HIDDEN_THREAD_PENDING_MONITOR.getHiddenObject(thread);
            } else if ((threadStatus & (State.WAITING.value | State.TIMED_WAITING.value)) != 0) {
                lockObj = (StaticObject)meta.HIDDEN_THREAD_WAITING_MONITOR.getHiddenObject(thread);
            }
            if (lockObj == null) {
                lockObj = StaticObject.NULL;
            } else if (StaticObject.notNull(lockObj)) {
                Thread hostOwner;
                Thread thread2 = hostOwner = StaticObject.isNull(lockObj) ? null : lockObj.getLock(this.getContext()).getOwnerThread();
                if (hostOwner != null && hostOwner.isAlive() && (lockOwner = this.getContext().getGuestThreadFromHost(hostOwner)) == null) {
                    lockOwner = StaticObject.NULL;
                }
            }
            long blockedCount = Target_java_lang_Thread.getThreadCounter(thread, meta.HIDDEN_THREAD_BLOCKED_COUNT);
            long waitedCount = Target_java_lang_Thread.getThreadCounter(thread, meta.HIDDEN_THREAD_WAITED_COUNT);
            StaticObject stackTrace = Target_java_lang_Thread.getStackTrace(thread, actualMaxDepth, this.getContext(), node);
            StaticObject threadInfo = meta.java_lang_management_ThreadInfo.allocateInstance(this.getContext());
            init.invokeDirectSpecial(threadInfo, thread, threadStatus, lockObj, lockOwner, blockedCount, -1L, waitedCount, -1L, stackTrace);
            this.getInterpreterToVM().setArrayObject(language, threadInfo, i, infoArray);
        }
    }

    public @JavaType(value=String[].class) StaticObject GetInputArgumentArray(@Inject EspressoLanguage language) {
        return this.getVM().JVM_GetVmArguments(language);
    }

    public @JavaType(value=String[].class) StaticObject GetInputArguments(@Inject EspressoLanguage language) {
        return this.getVM().JVM_GetVmArguments(language);
    }

    private Klass getMemoryPoolMXBeanKlass() {
        if (this.memoryPoolMXBeanKlass == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.memoryPoolMXBeanKlass = this.getMeta().resolveSymbolOrFail(Symbol.Type.java_lang_management_MemoryPoolMXBean, StaticObject.NULL, StaticObject.NULL);
        }
        return this.memoryPoolMXBeanKlass;
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Object[].class) StaticObject GetMemoryPools(@JavaType(value=Object.class) StaticObject manager, final @Inject Meta meta) {
        if (StaticObject.isNull(manager)) {
            if (this.memoryPoolsByName.isEmpty()) {
                final List<MemoryPoolMXBean> hostBeans = ManagementFactory.getMemoryPoolMXBeans();
                return this.getMemoryPoolMXBeanKlass().allocateReferenceArray(hostBeans.size(), new IntFunction<StaticObject>(){
                    final /* synthetic */ Management this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public StaticObject apply(int i) {
                        MemoryPoolMXBean hostBean = (MemoryPoolMXBean)hostBeans.get(i);
                        StaticObject guestBean = this.this$0.memoryPools.computeIfAbsent(hostBean, h -> {
                            this.this$0.getLogger().fine(() -> "GetMemoryPools: creating " + h.getName());
                            StaticObject name = meta.toGuestString(h.getName());
                            boolean isHeap = h.getType() == MemoryType.HEAP;
                            long usageThreshold = h.isUsageThresholdSupported() ? 0L : -1L;
                            long gcThreshold = h.isCollectionUsageThresholdSupported() ? 0L : -1L;
                            return (StaticObject)meta2.sun_management_ManagementFactory_createMemoryPool.invokeDirectStatic(name, isHeap, usageThreshold, gcThreshold);
                        });
                        MemoryPoolMXBean hostProbe = this.this$0.reverseMemoryPools.putIfAbsent(guestBean, hostBean);
                        assert (hostProbe == null || hostProbe == hostBean);
                        StaticObject guestProbe = this.this$0.memoryPoolsByName.putIfAbsent(hostBean.getName(), guestBean);
                        assert (guestProbe == null || guestProbe == guestBean);
                        return guestBean;
                    }
                });
            }
            final Iterator<StaticObject> iterator = this.memoryPoolsByName.values().iterator();
            return this.getMemoryPoolMXBeanKlass().allocateReferenceArray(this.memoryPoolsByName.size(), new IntFunction<StaticObject>(){
                final /* synthetic */ Management this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StaticObject apply(int i) {
                    return (StaticObject)iterator.next();
                }
            });
        }
        MemoryManagerMXBean hostBean = this.reverseMemoryManagers.get(manager);
        if (hostBean == null) {
            return StaticObject.NULL;
        }
        final String[] poolNames = hostBean.getMemoryPoolNames();
        this.GetMemoryPools(StaticObject.NULL, meta);
        return this.getMemoryPoolMXBeanKlass().allocateReferenceArray(poolNames.length, new IntFunction<StaticObject>(){
            final /* synthetic */ Management this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public StaticObject apply(int i) {
                String name = poolNames[i];
                StaticObject guestBean = this.this$0.memoryPoolsByName.get(name);
                this.this$0.getLogger().fine(() -> "GetMemoryPools: found " + name + " by name");
                assert (guestBean != null);
                return guestBean;
            }
        });
    }

    private Klass getMemoryManagerMXBeanKlass() {
        if (this.memoryManagerMXBeanKlass == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.memoryManagerMXBeanKlass = this.getMeta().resolveSymbolOrFail(Symbol.Type.java_lang_management_MemoryManagerMXBean, StaticObject.NULL, StaticObject.NULL);
        }
        return this.memoryManagerMXBeanKlass;
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Object[].class) StaticObject GetMemoryManagers(@JavaType(value=Object.class) StaticObject pool, final @Inject Meta meta) {
        if (StaticObject.isNull(pool)) {
            if (this.memoryManagersByName.isEmpty()) {
                final List<MemoryManagerMXBean> hostBeans = ManagementFactory.getMemoryManagerMXBeans();
                return this.getMemoryManagerMXBeanKlass().allocateReferenceArray(hostBeans.size(), new IntFunction<StaticObject>(){
                    final /* synthetic */ Management this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public StaticObject apply(int i) {
                        MemoryManagerMXBean hostBean = (MemoryManagerMXBean)hostBeans.get(i);
                        Function<MemoryManagerMXBean, StaticObject> factory = hostBean instanceof GarbageCollectorMXBean ? h -> {
                            this.this$0.getLogger().fine(() -> "GetMemoryManagers: creating " + h.getName());
                            return (StaticObject)meta2.sun_management_ManagementFactory_createGarbageCollector.invokeDirectStatic(meta.toGuestString(h.getName()), StaticObject.NULL);
                        } : h -> {
                            this.this$0.getLogger().fine(() -> "GetMemoryManagers: creating " + h.getName());
                            return (StaticObject)meta2.sun_management_ManagementFactory_createMemoryManager.invokeDirectStatic(meta.toGuestString(h.getName()));
                        };
                        StaticObject guestBean = this.this$0.memoryManagers.computeIfAbsent(hostBean, factory);
                        MemoryManagerMXBean hostProbe = this.this$0.reverseMemoryManagers.putIfAbsent(guestBean, hostBean);
                        assert (hostProbe == null || hostProbe == hostBean);
                        StaticObject guestProbe = this.this$0.memoryManagersByName.putIfAbsent(hostBean.getName(), guestBean);
                        assert (guestProbe == null || guestProbe == guestBean);
                        return guestBean;
                    }
                });
            }
            final Iterator<StaticObject> iterator = this.memoryManagersByName.values().iterator();
            return this.getMemoryManagerMXBeanKlass().allocateReferenceArray(this.memoryManagersByName.size(), new IntFunction<StaticObject>(){
                final /* synthetic */ Management this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StaticObject apply(int i) {
                    return (StaticObject)iterator.next();
                }
            });
        }
        MemoryPoolMXBean hostBean = this.reverseMemoryPools.get(pool);
        if (hostBean == null) {
            return StaticObject.NULL;
        }
        final String[] managerNames = hostBean.getMemoryManagerNames();
        this.GetMemoryManagers(StaticObject.NULL, meta);
        return this.getMemoryManagerMXBeanKlass().allocateReferenceArray(managerNames.length, new IntFunction<StaticObject>(){
            final /* synthetic */ Management this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public StaticObject apply(int i) {
                String name = managerNames[i];
                StaticObject guestBean = this.this$0.memoryManagersByName.get(name);
                this.this$0.getLogger().fine(() -> "GetMemoryManagers: found " + name + " by name");
                assert (guestBean != null);
                return guestBean;
            }
        });
    }

    private Method getMemoryUsageInit() {
        if (this.memoryUsageInit == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.memoryUsageInit = this.getMeta().java_lang_management_MemoryUsage.lookupDeclaredMethod(Symbol.Name._init_, this.getSignatures().makeRaw(Symbol.Type._void, Symbol.Type._long, Symbol.Type._long, Symbol.Type._long, Symbol.Type._long));
        }
        return this.memoryUsageInit;
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Object.class) StaticObject GetMemoryPoolUsage(@JavaType(value=Object.class) StaticObject pool, @Inject Meta meta) {
        if (StaticObject.isNull(pool)) {
            return StaticObject.NULL;
        }
        MemoryPoolMXBean hostBean = this.reverseMemoryPools.get(pool);
        if (hostBean == null) {
            return StaticObject.NULL;
        }
        return this.asGuestUsage(hostBean.getUsage(), meta);
    }

    private StaticObject asGuestUsage(MemoryUsage usage, Meta meta) {
        StaticObject guestUsage = meta.java_lang_management_MemoryUsage.allocateInstance(this.getContext());
        this.getMemoryUsageInit().invokeDirectSpecial(guestUsage, usage.getInit(), usage.getUsed(), usage.getCommitted(), usage.getMax());
        return guestUsage;
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Object.class) StaticObject GetPeakMemoryPoolUsage(@JavaType(value=Object.class) StaticObject pool, @Inject Meta meta) {
        if (StaticObject.isNull(pool)) {
            return StaticObject.NULL;
        }
        MemoryPoolMXBean hostBean = this.reverseMemoryPools.get(pool);
        if (hostBean == null) {
            return StaticObject.NULL;
        }
        return this.asGuestUsage(hostBean.getPeakUsage(), meta);
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Object.class) StaticObject GetPoolCollectionUsage(@JavaType(value=Object.class) StaticObject pool, @Inject Meta meta) {
        if (StaticObject.isNull(pool)) {
            return StaticObject.NULL;
        }
        MemoryPoolMXBean hostBean = this.reverseMemoryPools.get(pool);
        if (hostBean == null) {
            return StaticObject.NULL;
        }
        return this.asGuestUsage(hostBean.getCollectionUsage(), meta);
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Object.class) StaticObject GetMemoryUsage(boolean heap, @Inject Meta meta) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage usage = heap ? memoryMXBean.getHeapMemoryUsage() : memoryMXBean.getNonHeapMemoryUsage();
        return this.asGuestUsage(usage, meta);
    }

    @CompilerDirectives.TruffleBoundary
    public long GetLongAttribute(@JavaType(value=Object.class) StaticObject obj, int att) {
        if (StaticObject.isNull(obj)) {
            switch (att) {
                case 7: {
                    return TimeUnit.NANOSECONDS.toMillis(this.getContext().initDoneTimeNanos);
                }
                case 1: {
                    return this.getRegistries().getLoadedClassesCount();
                }
                case 2: {
                    return 0L;
                }
                case 11: {
                    long elapsedNanos = System.nanoTime() - this.getContext().initDoneTimeNanos;
                    return TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
                }
                case 201: {
                    return ProcessHandle.current().pid();
                }
                case 6: {
                    int daemonCount = 0;
                    ThreadsAccess threadAccess = this.getContext().getThreadAccess();
                    for (StaticObject t : this.getContext().getActiveThreads()) {
                        if (!threadAccess.isDaemon(t)) continue;
                        ++daemonCount;
                    }
                    return daemonCount;
                }
                case 5: {
                    return this.getContext().getPeakThreadCount();
                }
                case 4: {
                    return this.getContext().getActiveThreads().length;
                }
                case 3: {
                    return this.getContext().getCreatedThreadCount();
                }
            }
        } else {
            MemoryManagerMXBean hostBean = this.reverseMemoryManagers.get(obj);
            if (hostBean == null) {
                LOGGER.warning(() -> "Unknown guest memory manager for object of type " + String.valueOf(obj.getKlass()));
                return -1L;
            }
            switch (att) {
                case 9: {
                    if (!(hostBean instanceof GarbageCollectorMXBean)) {
                        LOGGER.warning(() -> "Not a GC bean, got a " + String.valueOf(hostBean.getClass()));
                        return -1L;
                    }
                    GarbageCollectorMXBean hostGCBean = (GarbageCollectorMXBean)hostBean;
                    return hostGCBean.getCollectionTime();
                }
                case 10: {
                    if (!(hostBean instanceof GarbageCollectorMXBean)) {
                        LOGGER.warning(() -> "Not a GC bean, got a " + String.valueOf(hostBean.getClass()));
                        return -1L;
                    }
                    GarbageCollectorMXBean hostGCBean = (GarbageCollectorMXBean)hostBean;
                    return hostGCBean.getCollectionCount();
                }
            }
        }
        this.getLogger().warning(() -> "Unknown long attribute: " + att);
        return -1L;
    }

    @CompilerDirectives.TruffleBoundary
    public int GetLongAttributes(@JavaType(value=Object.class) StaticObject obj, @Pointer TruffleObject atts, int count, @Pointer TruffleObject result) {
        int numAtts = 0;
        ByteBuffer attsBuffer = NativeUtils.directByteBuffer(atts, count, JavaKind.Int);
        ByteBuffer resBuffer = NativeUtils.directByteBuffer(result, count, JavaKind.Long);
        for (int i = 0; i < count; ++i) {
            int att = attsBuffer.getInt();
            long res = this.GetLongAttribute(obj, att);
            resBuffer.putLong(res);
            if (res == -1L) continue;
            ++numAtts;
        }
        return numAtts;
    }

    public boolean GetBoolAttribute(int att) {
        switch (att) {
            case 21: {
                return this.JMM_VERBOSE_GC_state;
            }
            case 22: {
                return this.JMM_VERBOSE_CLASS_state;
            }
            case 23: {
                return this.JMM_THREAD_CONTENTION_MONITORING_state;
            }
            case 24: {
                return this.JMM_THREAD_CPU_TIME_state;
            }
            case 25: {
                return this.JMM_THREAD_ALLOCATED_MEMORY_state;
            }
        }
        this.getLogger().warning(() -> "Unknown bool attribute: " + att);
        return false;
    }

    public boolean SetBoolAttribute(int att, boolean flag) {
        switch (att) {
            case 21: {
                this.JMM_VERBOSE_GC_state = flag;
                return this.JMM_VERBOSE_GC_state;
            }
            case 22: {
                this.JMM_VERBOSE_CLASS_state = flag;
                return this.JMM_VERBOSE_CLASS_state;
            }
            case 23: {
                this.JMM_THREAD_CONTENTION_MONITORING_state = flag;
                return this.JMM_THREAD_CONTENTION_MONITORING_state;
            }
            case 24: {
                this.JMM_THREAD_CPU_TIME_state = flag;
                return this.JMM_THREAD_CPU_TIME_state;
            }
            case 25: {
                this.JMM_THREAD_ALLOCATED_MEMORY_state = flag;
                return this.JMM_THREAD_ALLOCATED_MEMORY_state;
            }
        }
        this.getLogger().warning(() -> "Unknown bool attribute: " + att);
        return false;
    }

    public int GetVMGlobals(@JavaType(value=Object[].class) StaticObject names, @Pointer TruffleObject globalsPtr, int count, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (this.getUncached().isNull((Object)globalsPtr)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        if (StaticObject.notNull(names)) {
            StaticObject[] entries;
            if (!names.getKlass().equals(meta.java_lang_String.array())) {
                profiler.profile(1);
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Array element type is not String class");
            }
            for (StaticObject entry : entries = (StaticObject[])names.unwrap(language)) {
                if (StaticObject.isNull(entry)) {
                    profiler.profile(2);
                    throw meta.throwNullPointerException();
                }
                this.getLogger().fine(() -> "GetVMGlobals: " + meta.toHostString(entry));
            }
        }
        return 0;
    }

    public @JavaType(internalName="[Ljava/lang/management/ThreadInfo;") StaticObject DumpThreads(@JavaType(value=long[].class) StaticObject ids, boolean lockedMonitors, boolean lockedSynchronizers, int maybeMaxDepth, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        int maxDepth = this.managementVersion >= 0x20020000 ? maybeMaxDepth : Integer.MAX_VALUE;
        if (StaticObject.isNull(ids)) {
            StaticObject[] activeThreads = this.getContext().getActiveThreads();
            StaticObject result = this.getMeta().java_lang_management_ThreadInfo.allocateReferenceArray(activeThreads.length);
            this.fillThreadInfos(activeThreads, result, maxDepth, language, meta, profiler, null);
            return result;
        }
        StaticObject result = this.getMeta().java_lang_management_ThreadInfo.allocateReferenceArray(ids.length(language));
        if (this.GetThreadInfo(ids, maxDepth, result, language, meta, profiler) != 0) {
            return StaticObject.NULL;
        }
        return result;
    }

    public long GetOneThreadAllocatedMemory(long threadId) {
        StaticObject[] activeThreads = this.getContext().getActiveThreads();
        StaticObject thread = this.findThreadById(activeThreads, threadId);
        if (StaticObject.isNull(thread)) {
            return -1L;
        }
        return 0L;
    }

    public void GetThreadAllocatedMemory(@JavaType(value=long[].class) StaticObject ids, @JavaType(value=long[].class) StaticObject sizeArray, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(ids) || StaticObject.isNull(sizeArray)) {
            profiler.profile(0);
            throw meta.throwException(meta.java_lang_NullPointerException);
        }
        Management.validateThreadIdArray(language, meta, ids, profiler);
        if (ids.length(language) != sizeArray.length(language)) {
            profiler.profile(1);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "The length of the given long array does not match the length of the given array of thread IDs");
        }
        StaticObject[] activeThreads = this.getContext().getActiveThreads();
        for (int i = 0; i < ids.length(language); ++i) {
            long id = this.getInterpreterToVM().getArrayLong(language, i, ids);
            StaticObject thread = this.findThreadById(activeThreads, id);
            if (StaticObject.isNull(thread)) {
                this.getInterpreterToVM().setArrayLong(language, -1L, i, sizeArray);
                continue;
            }
            this.getInterpreterToVM().setArrayLong(language, 0L, i, sizeArray);
        }
    }

    public @JavaType(value=Thread[].class) StaticObject FindCircularBlockedThreads(@Inject Meta meta) {
        return this.FindDeadlocks(true, meta);
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Thread[].class) StaticObject FindDeadlocks(boolean objectMonitorsOnly, @Inject Meta meta) {
        if (!objectMonitorsOnly) {
            this.getLogger().warning(() -> "Calling unimplemented Management.FindDeadlocks(false)");
            return StaticObject.createArray(meta.java_lang_Thread.getArrayClass(), StaticObject.EMPTY_ARRAY, this.getContext());
        }
        Thread initiatingThread = Thread.currentThread();
        EspressoThreadRegistry threadRegistry = this.getContext().getEspressoEnv().getThreadRegistry();
        FindDeadLocksAction action = new FindDeadLocksAction(initiatingThread, threadRegistry, objectMonitorsOnly);
        Future future = this.getContext().getEnv().submitThreadLocal(null, (ThreadLocalAction)action);
        TruffleSafepoint.setBlockedThreadInterruptible(null, f -> {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }, (Object)future);
        assert (action.results != null);
        return StaticObject.createArray(meta.java_lang_Thread.getArrayClass(), action.results, this.getContext());
    }

    public boolean ResetStatistic(long obj, int type) {
        switch (type) {
            case 801: {
                this.getContext().resetPeakThreadCount();
                return true;
            }
        }
        this.getLogger().warning(() -> "Calling ResetStatistic with unimplemented type (" + type + ")");
        return false;
    }

    private static class FindDeadLocksAction
    extends ThreadLocalAction {
        private final Thread initiatingThread;
        private final EspressoThreadRegistry threadRegistry;
        private final boolean objectMonitorsOnly;
        private StaticObject[] results;

        public FindDeadLocksAction(Thread initiatingThread, EspressoThreadRegistry threadRegistry, boolean objectMonitorsOnly) {
            super(false, true);
            this.initiatingThread = initiatingThread;
            this.threadRegistry = threadRegistry;
            this.objectMonitorsOnly = objectMonitorsOnly;
        }

        protected void perform(ThreadLocalAction.Access access) {
            if (access.getThread() == this.initiatingThread) {
                this.results = this.threadRegistry.findDeadlocks(this.objectMonitorsOnly);
            }
        }
    }
}

