/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public final class UnsafeAccess {
    private static final Unsafe UNSAFE;

    private UnsafeAccess() {
    }

    public static Unsafe get() {
        return UNSAFE;
    }

    public static void checkAllowed(Meta meta) {
        if (!meta.getContext().getEspressoEnv().NativeAccessAllowed) {
            throw meta.throwExceptionWithMessage(meta.java_lang_UnsupportedOperationException, "Cannot perform unsafe operations unless the Context allows native access");
        }
    }

    public static Unsafe getIfAllowed(Meta meta) {
        UnsafeAccess.checkAllowed(meta);
        return UNSAFE;
    }

    public static void initializeGuestUnsafeConstants(Meta meta) {
        StaticObject staticStorage = meta.jdk_internal_misc_UnsafeConstants.tryInitializeAndGetStatics();
        meta.jdk_internal_misc_UnsafeConstants_ADDRESS_SIZE0.set(staticStorage, UNSAFE.addressSize());
        meta.jdk_internal_misc_UnsafeConstants_PAGE_SIZE.set(staticStorage, UNSAFE.pageSize());
        meta.jdk_internal_misc_UnsafeConstants_BIG_ENDIAN.set(staticStorage, ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN);
        meta.jdk_internal_misc_UnsafeConstants_UNALIGNED_ACCESS.set(staticStorage, Target_sun_misc_Unsafe.unalignedAccess0(StaticObject.NULL));
        meta.jdk_internal_misc_UnsafeConstants_DATA_CACHE_LINE_FLUSH_SIZE.set(staticStorage, 0);
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }
}

