/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.npe;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.Local;
import com.oracle.truffle.espresso.classfile.attributes.LocalVariableTable;
import com.oracle.truffle.espresso.classfile.bytecode.Bytecodes;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.descriptors.Signatures;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.MetaUtil;
import com.oracle.truffle.espresso.vm.npe.Analysis;
import com.oracle.truffle.espresso.vm.npe.SimulatedStack;
import com.oracle.truffle.espresso.vm.npe.StackObject;

final class MessageBuildHelper {
    static final int MAX_DETAIL = 5;
    static final int INVALID_BYTECODE = -1;
    static final int EXPLICIT_NPE = -2;

    private MessageBuildHelper() {
    }

    public static String buildCause(Analysis analysis, int bci) {
        int slot = MessageBuildHelper.getSlot(analysis, bci);
        if (slot == -2) {
            return null;
        }
        if (slot == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        MessageBuildHelper.appendFailedAction(analysis, sb, bci);
        MessageBuildHelper.appendCause(analysis, sb, bci, slot);
        return sb.toString();
    }

    private static boolean appendCause(Analysis analysis, StringBuilder sb, int bci, int slot) {
        if (MessageBuildHelper.appendCause(analysis, sb, bci, slot, 5, false, " because \"")) {
            sb.append("\" is null");
            return true;
        }
        return false;
    }

    private static boolean appendCause(Analysis analysis, StringBuilder sb, int currentBci, int slot, int maxDetail, boolean isInner, String prefix) {
        if (maxDetail <= 0) {
            return false;
        }
        SimulatedStack stack = analysis.stackAt(currentBci);
        if (stack == null) {
            return false;
        }
        StackObject obj = stack.top(slot);
        if (!obj.hasBci()) {
            return false;
        }
        int bci = obj.originBci();
        int opcode = analysis.bs.currentBC(bci);
        if (maxDetail == 5 && prefix != null && !Bytecodes.isInvoke(opcode)) {
            sb.append(prefix);
        }
        switch (opcode) {
            case 26: 
            case 42: {
                MessageBuildHelper.appendLocalVar(analysis, sb, bci, 0, !stack.isLocalSlotWritten(0));
                return true;
            }
            case 27: 
            case 43: {
                MessageBuildHelper.appendLocalVar(analysis, sb, bci, 1, !stack.isLocalSlotWritten(1));
                return true;
            }
            case 28: 
            case 44: {
                MessageBuildHelper.appendLocalVar(analysis, sb, bci, 2, !stack.isLocalSlotWritten(2));
                return true;
            }
            case 29: 
            case 45: {
                MessageBuildHelper.appendLocalVar(analysis, sb, bci, 3, !stack.isLocalSlotWritten(3));
                return true;
            }
            case 21: 
            case 25: {
                int index = analysis.bs.readLocalIndex(bci);
                MessageBuildHelper.appendLocalVar(analysis, sb, bci, index, !stack.isLocalSlotWritten(index));
                return true;
            }
            case 1: {
                sb.append("null");
                return true;
            }
            case 2: {
                sb.append("-1");
                return true;
            }
            case 3: {
                sb.append("0");
                return true;
            }
            case 4: {
                sb.append("1");
                return true;
            }
            case 5: {
                sb.append("2");
                return true;
            }
            case 6: {
                sb.append("3");
                return true;
            }
            case 7: {
                sb.append("4");
                return true;
            }
            case 8: {
                sb.append("5");
                return true;
            }
            case 16: {
                sb.append(analysis.bs.readByte(bci));
                return true;
            }
            case 17: {
                sb.append(analysis.bs.readShort(bci));
                return true;
            }
            case 46: 
            case 50: {
                if (!MessageBuildHelper.appendCause(analysis, sb, bci, 1, maxDetail - 1, isInner, null)) {
                    sb.append("<array>");
                }
                sb.append("[");
                if (!MessageBuildHelper.appendCause(analysis, sb, bci, 0, maxDetail, true, null)) {
                    sb.append("...");
                }
                sb.append("]");
                return true;
            }
            case 178: {
                MessageBuildHelper.appendStaticField(analysis, sb, bci);
                return true;
            }
            case 180: {
                if (MessageBuildHelper.appendCause(analysis, sb, bci, 0, maxDetail - 1, isInner, null)) {
                    sb.append(".");
                }
                sb.append(analysis.getFieldName(bci));
                return true;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                if (maxDetail == 5 && !isInner) {
                    sb.append(" because the return value of \"");
                }
                MessageBuildHelper.appendMethodCall(analysis, sb, bci);
                return true;
            }
        }
        return false;
    }

    private static void appendStaticField(Analysis analysis, StringBuilder sb, int bci) {
        ConstantPool pool = analysis.m.getConstantPool();
        FieldRefConstant ref = pool.fieldAt(analysis.bs.readCPI(bci));
        Symbol<Symbol.Name> klassName = ref.getHolderKlassName(pool);
        Symbol<Symbol.Name> fieldName = ref.getName(pool);
        MessageBuildHelper.appendClassName(sb, klassName);
        sb.append(".").append(fieldName);
    }

    private static void appendMethodCall(Analysis analysis, StringBuilder sb, int bci) {
        ConstantPool pool = analysis.m.getConstantPool();
        MethodRefConstant ref = pool.methodAt(analysis.bs.readCPI(bci));
        Symbol<Symbol.Name> klassName = ref.getHolderKlassName(pool);
        Symbol<Symbol.Name> methodName = ref.getName(pool);
        Symbol<Symbol.Signature> signature = ref.getSignature(pool);
        MessageBuildHelper.appendClassName(sb, klassName);
        sb.append(".").append(methodName).append("(");
        MessageBuildHelper.appendSignature(analysis.getSignatures(), sb, signature);
        sb.append(")");
    }

    private static void appendClassType(StringBuilder sb, Symbol<Symbol.Type> classType) {
        String n = MetaUtil.internalNameToJava(classType.toString(), true, false);
        MessageBuildHelper.appendClassName(sb, n);
    }

    private static void appendClassName(StringBuilder sb, Symbol<Symbol.Name> className) {
        String n = className.toString().replace("/", ".");
        MessageBuildHelper.appendClassName(sb, n);
    }

    private static void appendClassName(StringBuilder sb, String className) {
        String n = className;
        if (n.startsWith("java.lang.Object") || n.startsWith("java.lang.String")) {
            n = n.substring("java.lang.".length());
        }
        sb.append(n);
    }

    private static void appendSignature(Signatures signatures, StringBuilder sb, Symbol<Symbol.Signature> signature) {
        Symbol<Symbol.Type>[] sig = signatures.parsed(signature);
        boolean first = true;
        for (int i = 0; i < Signatures.parameterCount(sig); ++i) {
            Symbol<Symbol.Type> type = sig[i];
            if (!first) {
                sb.append(", ");
            }
            MessageBuildHelper.appendClassType(sb, type);
            first = false;
        }
    }

    private static void appendLocalVar(Analysis analysis, StringBuilder sb, int bci, int slot, boolean isParameter) {
        Method m = analysis.m;
        LocalVariableTable table = m.getLocalVariableTable();
        if (table != LocalVariableTable.EMPTY_LVT) {
            Local local;
            try {
                local = table.getLocal(slot, bci);
            }
            catch (IllegalStateException e) {
                local = null;
            }
            if (local != null) {
                sb.append(local.getNameAsString());
                return;
            }
        }
        if (!isParameter) {
            sb.append("<local").append(slot).append(">");
            return;
        }
        if (!m.isStatic() && slot == 0) {
            sb.append("this");
            return;
        }
        int currentSlot = m.isStatic() ? 0 : 1;
        int paramIndex = 1;
        Symbol<Symbol.Type>[] sig = m.getParsedSignature();
        for (int i = 0; i < Signatures.parameterCount(sig); ++i) {
            Symbol<Symbol.Type> type = Signatures.parameterType(sig, i);
            int slots = Types.slotCount(type);
            if (slot >= currentSlot && slot < currentSlot + slots) {
                sb.append("<parameter").append(paramIndex).append(">");
                return;
            }
            ++paramIndex;
            currentSlot += slots;
        }
        sb.append("<local").append(slot).append(">");
    }

    static int getSlot(Analysis analysis, int bci) {
        int opcode = analysis.bs.currentBC(bci);
        switch (opcode) {
            case 180: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return 0;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return 1;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return 2;
            }
            case 80: 
            case 82: {
                return 3;
            }
            case 181: {
                return Types.slotCount(analysis.getFieldType(bci));
            }
            case 182: 
            case 183: 
            case 185: {
                Symbol<Symbol.Name> name = analysis.getInvokeName(bci, opcode);
                if (name == Symbol.Name._init_) {
                    return -2;
                }
                return Signatures.slotsForParameters(analysis.getInvokeSignature(bci, opcode));
            }
        }
        return -1;
    }

    static void appendFailedAction(Analysis analysis, StringBuilder sb, int bci) {
        int opcode = analysis.bs.currentBC(bci);
        switch (opcode) {
            case 46: {
                sb.append("Cannot load from int array");
                break;
            }
            case 48: {
                sb.append("Cannot load from float array");
                break;
            }
            case 50: {
                sb.append("Cannot load from object array");
                break;
            }
            case 51: {
                sb.append("Cannot load from byte/boolean array");
                break;
            }
            case 52: {
                sb.append("Cannot load from char array");
                break;
            }
            case 53: {
                sb.append("Cannot load from short array");
                break;
            }
            case 47: {
                sb.append("Cannot load from long array");
                break;
            }
            case 49: {
                sb.append("Cannot load from double array");
                break;
            }
            case 79: {
                sb.append("Cannot store to int array");
                break;
            }
            case 81: {
                sb.append("Cannot store to float array");
                break;
            }
            case 83: {
                sb.append("Cannot store to object array");
                break;
            }
            case 84: {
                sb.append("Cannot store to byte/boolean array");
                break;
            }
            case 85: {
                sb.append("Cannot store to char array");
                break;
            }
            case 86: {
                sb.append("Cannot store to short array");
                break;
            }
            case 80: {
                sb.append("Cannot store to long array");
                break;
            }
            case 82: {
                sb.append("Cannot store to double array");
                break;
            }
            case 190: {
                sb.append("Cannot read the array length");
                break;
            }
            case 191: {
                sb.append("Cannot throw exception");
                break;
            }
            case 194: {
                sb.append("Cannot enter synchronized block");
                break;
            }
            case 195: {
                sb.append("Cannot exit synchronized block");
                break;
            }
            case 180: {
                sb.append("Cannot read field \"").append(analysis.getFieldName(bci)).append("\"");
                break;
            }
            case 181: {
                sb.append("Cannot assign field \"").append(analysis.getFieldName(bci)).append("\"");
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                sb.append("Cannot invoke \"");
                MessageBuildHelper.appendMethodCall(analysis, sb, bci);
                sb.append("\"");
                break;
            }
            default: {
                throw EspressoError.shouldNotReachHere("Invalid bytecode for NPE encountered: " + Bytecodes.nameOf(opcode));
            }
        }
    }
}

