/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.npe;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.JavaKind;
import com.oracle.truffle.espresso.classfile.descriptors.Symbol;
import com.oracle.truffle.espresso.classfile.descriptors.Types;
import com.oracle.truffle.espresso.meta.EspressoError;

enum StackType {
    VOID(0),
    INT(1),
    LONG(2),
    FLOAT(1),
    DOUBLE(2),
    OBJECT(1),
    ARRAY(1),
    ADDRESS(1),
    CONFLICT(1);

    private final int slots;

    private StackType(int slots) {
        this.slots = slots;
    }

    boolean hasTwoSlots() {
        return this.slots() == 2;
    }

    int slots() {
        return this.slots;
    }

    static StackType forType(Symbol<Symbol.Type> type) {
        if (Types.isArray(type)) {
            return ARRAY;
        }
        return StackType.forJavaKind(Types.getJavaKind(type));
    }

    private static StackType forJavaKind(JavaKind javaKind) {
        switch (javaKind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: {
                return INT;
            }
            case Float: {
                return FLOAT;
            }
            case Long: {
                return LONG;
            }
            case Double: {
                return DOUBLE;
            }
            case Object: {
                return OBJECT;
            }
            case Void: {
                return VOID;
            }
        }
        throw EspressoError.shouldNotReachHere("Invalid JavaKind: " + String.valueOf((Object)javaKind));
    }

    static StackType forTag(ConstantPool.Tag tag) {
        switch (tag) {
            case INTEGER: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case CLASS: 
            case STRING: 
            case METHODHANDLE: 
            case METHODTYPE: 
            case DYNAMIC: {
                return OBJECT;
            }
        }
        throw EspressoError.shouldNotReachHere("Invalid tag for LDC: " + String.valueOf((Object)tag));
    }

    static StackType rtype(int opcode) {
        switch (opcode) {
            case 1: 
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: 
            case 187: {
                return OBJECT;
            }
            case 188: 
            case 189: 
            case 197: {
                return ARRAY;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 190: 
            case 193: {
                return INT;
            }
            case 9: 
            case 10: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 140: 
            case 143: {
                return LONG;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return FLOAT;
            }
            case 14: 
            case 15: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return DOUBLE;
            }
        }
        return VOID;
    }
}

