/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.jni.JNIHandles;
import com.oracle.truffle.espresso.vm.structs.MemberInfo;
import com.oracle.truffle.espresso.vm.structs.MemberOffsetGetter;
import com.oracle.truffle.espresso.vm.structs.Structs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JavaMemberOffsetGetter
implements MemberOffsetGetter {
    private final Map<String, Long> memberInfos;

    public JavaMemberOffsetGetter(JNIHandles handles, TruffleObject memberInfo, Structs structs) {
        this.memberInfos = JavaMemberOffsetGetter.buildInfos(handles, structs, memberInfo);
    }

    private static Map<String, Long> buildInfos(JNIHandles handles, Structs structs, TruffleObject info) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        InteropLibrary library = InteropLibrary.getUncached();
        assert (!library.isNull((Object)info));
        TruffleObject current = NativeUtils.dereferencePointerPointer(library, info);
        while (!library.isNull((Object)current)) {
            MemberInfo.MemberInfoWrapper wrapper = structs.memberInfo.wrap(handles, current);
            long offset = wrapper.offset();
            String str = NativeUtils.interopPointerToString(wrapper.id());
            map.put(str, offset);
            current = wrapper.next();
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public long getInfo(String structName) {
        if (this.memberInfos.containsKey(structName)) {
            return this.memberInfos.get(structName);
        }
        return -1L;
    }
}

