/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.jni.JNIHandles;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.structs.MemberOffsetGetter;
import com.oracle.truffle.espresso.vm.structs.StructStorage;
import com.oracle.truffle.espresso.vm.structs.StructWrapper;

public final class JvmtiStackInfo
extends StructStorage<JvmtiStackInfoWrapper> {
    final int thread;
    final int state;
    final int frame_buffer;
    final int frame_count;

    JvmtiStackInfo(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiStackInfo"));
        this.thread = (int)offsetGetter.getOffset("_jvmtiStackInfo", "thread");
        this.state = (int)offsetGetter.getOffset("_jvmtiStackInfo", "state");
        this.frame_buffer = (int)offsetGetter.getOffset("_jvmtiStackInfo", "frame_buffer");
        this.frame_count = (int)offsetGetter.getOffset("_jvmtiStackInfo", "frame_count");
    }

    @Override
    public JvmtiStackInfoWrapper wrap(JNIHandles handles, TruffleObject pointer) {
        return new JvmtiStackInfoWrapper(handles, pointer);
    }

    public final class JvmtiStackInfoWrapper
    extends StructWrapper {
        JvmtiStackInfoWrapper(JNIHandles handles, TruffleObject pointer) {
            super(handles, pointer, JvmtiStackInfo.this.structSize);
        }

        public StaticObject thread() {
            return this.getObject(JvmtiStackInfo.this.thread);
        }

        public void thread(StaticObject valueToPut) {
            this.putObject(JvmtiStackInfo.this.thread, valueToPut);
        }

        public int state() {
            return this.getInt(JvmtiStackInfo.this.state);
        }

        public void state(int valueToPut) {
            this.putInt(JvmtiStackInfo.this.state, valueToPut);
        }

        public TruffleObject frameBuffer() {
            return this.getPointer(JvmtiStackInfo.this.frame_buffer);
        }

        public void frameBuffer(TruffleObject valueToPut) {
            this.putPointer(JvmtiStackInfo.this.frame_buffer, valueToPut);
        }

        public int frameCount() {
            return this.getInt(JvmtiStackInfo.this.frame_count);
        }

        public void frameCount(int valueToPut) {
            this.putInt(JvmtiStackInfo.this.frame_count, valueToPut);
        }
    }
}

