/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.jni.JNIHandles;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.structs.MemberOffsetGetter;
import com.oracle.truffle.espresso.vm.structs.StructStorage;
import com.oracle.truffle.espresso.vm.structs.StructWrapper;

public final class JvmtiThreadInfo
extends StructStorage<JvmtiThreadInfoWrapper> {
    final int name;
    final int priority;
    final int is_daemon;
    final int thread_group;
    final int context_class_loader;

    JvmtiThreadInfo(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiThreadInfo"));
        this.name = (int)offsetGetter.getOffset("_jvmtiThreadInfo", "name");
        this.priority = (int)offsetGetter.getOffset("_jvmtiThreadInfo", "priority");
        this.is_daemon = (int)offsetGetter.getOffset("_jvmtiThreadInfo", "is_daemon");
        this.thread_group = (int)offsetGetter.getOffset("_jvmtiThreadInfo", "thread_group");
        this.context_class_loader = (int)offsetGetter.getOffset("_jvmtiThreadInfo", "context_class_loader");
    }

    @Override
    public JvmtiThreadInfoWrapper wrap(JNIHandles handles, TruffleObject pointer) {
        return new JvmtiThreadInfoWrapper(handles, pointer);
    }

    public final class JvmtiThreadInfoWrapper
    extends StructWrapper {
        JvmtiThreadInfoWrapper(JNIHandles handles, TruffleObject pointer) {
            super(handles, pointer, JvmtiThreadInfo.this.structSize);
        }

        public TruffleObject name() {
            return this.getPointer(JvmtiThreadInfo.this.name);
        }

        public void name(TruffleObject valueToPut) {
            this.putPointer(JvmtiThreadInfo.this.name, valueToPut);
        }

        public int priority() {
            return this.getInt(JvmtiThreadInfo.this.priority);
        }

        public void priority(int valueToPut) {
            this.putInt(JvmtiThreadInfo.this.priority, valueToPut);
        }

        public boolean isDaemon() {
            return this.getBoolean(JvmtiThreadInfo.this.is_daemon);
        }

        public void isDaemon(boolean valueToPut) {
            this.putBoolean(JvmtiThreadInfo.this.is_daemon, valueToPut);
        }

        public StaticObject threadGroup() {
            return this.getObject(JvmtiThreadInfo.this.thread_group);
        }

        public void threadGroup(StaticObject valueToPut) {
            this.putObject(JvmtiThreadInfo.this.thread_group, valueToPut);
        }

        public StaticObject contextClassLoader() {
            return this.getObject(JvmtiThreadInfo.this.context_class_loader);
        }

        public void contextClassLoader(StaticObject valueToPut) {
            this.putObject(JvmtiThreadInfo.this.context_class_loader, valueToPut);
        }
    }
}

