/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.espresso.classfile.perf.DebugCloseable;
import com.oracle.truffle.espresso.classfile.perf.DebugTimer;
import com.oracle.truffle.espresso.ffi.Callback;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.vm.structs.Structs;

public final class StructsAccess {
    private static final DebugTimer STRUCTS_TIMER = DebugTimer.create("native struct creation");

    private StructsAccess() {
    }

    public static Structs getStructs(EspressoContext context, TruffleObject mokapotLibrary) {
        TruffleObject initializeStructs = context.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "initializeStructs", NativeSignature.create(NativeType.VOID, NativeType.POINTER));
        TruffleObject lookupMemberOffset = context.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "lookupMemberOffset", NativeSignature.create(NativeType.LONG, NativeType.POINTER, NativeType.POINTER));
        return StructsAccess.initializeStructs(context, initializeStructs, lookupMemberOffset);
    }

    private static Structs initializeStructs(final EspressoContext context, TruffleObject initializeStructs, final TruffleObject lookupMemberOffset) {
        try (DebugCloseable timer = STRUCTS_TIMER.scope(context.getTimers());){
            final Structs[] box = new Structs[1];
            Callback doInitStructs = new Callback(1, new Callback.Function(){

                @Override
                @CompilerDirectives.TruffleBoundary
                public Object call(Object ... args) {
                    TruffleObject memberInfoPtr = (TruffleObject)args[0];
                    box[0] = new Structs(context.getHandles(), memberInfoPtr, lookupMemberOffset);
                    return RawPointer.nullInstance();
                }
            });
            @Pointer TruffleObject closure = context.getNativeAccess().createNativeClosure(doInitStructs, NativeSignature.create(NativeType.VOID, NativeType.POINTER));
            try {
                InteropLibrary.getUncached().execute((Object)initializeStructs, new Object[]{closure});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw EspressoError.shouldNotReachHere();
            }
            Structs structs = box[0];
            return structs;
        }
    }
}

