/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.resources.libs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import java.io.IOException;
import java.nio.file.Path;

@InternalResource.Id(value="espresso-libs", componentId="java", optional=true)
public final class EspressoLibsResources
implements InternalResource {
    private static Path basePath(InternalResource.Env env) {
        return Path.of("META-INF", "resources", "java", "espresso-libs", env.getOS().toString(), env.getCPUArchitecture().toString());
    }

    public void unpackFiles(InternalResource.Env env, Path targetDirectory) throws IOException {
        Path base = EspressoLibsResources.basePath(env);
        env.unpackResourceFiles(base.resolve("files"), targetDirectory, base);
    }

    public String versionHash(InternalResource.Env env) {
        try {
            Path hashResource = EspressoLibsResources.basePath(env).resolve("sha256");
            return (String)env.readResourceLines(hashResource).get(0);
        }
        catch (IOException ioe) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ioe);
        }
    }
}

