/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile;

import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import java.util.Objects;

public final class ExceptionHandler {
    public static final ExceptionHandler[] EMPTY_ARRAY = new ExceptionHandler[0];
    private final char startBCI;
    private final char endBCI;
    private final char handlerBCI;
    private final char catchTypeCPI;
    private final Symbol<Type> catchType;

    public ExceptionHandler(int startBCI, int endBCI, int catchBCI, int catchTypeCPI, Symbol<Type> catchType) {
        this.startBCI = (char)startBCI;
        this.endBCI = (char)endBCI;
        this.handlerBCI = (char)catchBCI;
        this.catchTypeCPI = (char)catchTypeCPI;
        this.catchType = catchType;
    }

    public int getStartBCI() {
        return this.startBCI;
    }

    public int getEndBCI() {
        return this.endBCI;
    }

    public int getHandlerBCI() {
        return this.handlerBCI;
    }

    public int catchTypeCPI() {
        return this.catchTypeCPI;
    }

    public boolean isCatchAll() {
        return this.catchTypeCPI == '\u0000';
    }

    public boolean covers(int bci) {
        return this.startBCI <= bci && bci < this.endBCI;
    }

    public Symbol<Type> getCatchType() {
        return this.catchType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExceptionHandler)) {
            return false;
        }
        ExceptionHandler that = (ExceptionHandler)obj;
        if (this.startBCI != that.startBCI || this.endBCI != that.endBCI || this.handlerBCI != that.handlerBCI || this.catchTypeCPI != that.catchTypeCPI) {
            return false;
        }
        return Objects.equals(this.catchType, that.catchType);
    }

    public String toString() {
        return "ExceptionHandler<startBCI=" + this.getStartBCI() + ", endBCI=" + this.getEndBCI() + ", handlerBCI=" + this.getHandlerBCI() + ", catchTypeCPI=" + String.valueOf(this.getCatchType()) + ", catchType=" + String.valueOf(this.getCatchType()) + ">";
    }

    public int hashCode() {
        return this.catchTypeCPI ^ this.endBCI ^ this.handlerBCI;
    }
}

