/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public final class BootstrapMethodsAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.BootstrapMethods;
    private final Entry[] entries;

    public Entry[] getEntries() {
        return this.entries;
    }

    public BootstrapMethodsAttribute(Symbol<Name> name, Entry[] entries) {
        assert (name == NAME);
        this.entries = entries;
    }

    public Entry at(int index) {
        return this.entries[index];
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }

    public static final class Entry {
        final char bootstrapMethodRef;
        final char[] bootstrapArguments;

        public int numBootstrapArguments() {
            return this.bootstrapArguments.length;
        }

        public Entry(char bootstrapMethodRef, char[] bootstrapArguments) {
            this.bootstrapMethodRef = bootstrapMethodRef;
            this.bootstrapArguments = bootstrapArguments;
        }

        public char argAt(int index) {
            return this.bootstrapArguments[index];
        }

        public char getBootstrapMethodRef() {
            return this.bootstrapMethodRef;
        }
    }
}

