/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public final class InnerClassesAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.InnerClasses;
    public static InnerClassesAttribute EMPTY = new InnerClassesAttribute(NAME, new long[0]);
    private final long[] packedEntries;

    public int entryCount() {
        return this.packedEntries.length;
    }

    public Entry entryAt(int index) {
        return Entry.unpack(this.packedEntries[index]);
    }

    public InnerClassesAttribute(Symbol<Name> name, long[] packedEntries) {
        assert (name == NAME);
        this.packedEntries = packedEntries;
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }

    public static class Entry {
        public final int innerClassIndex;
        public final int outerClassIndex;
        public final int innerNameIndex;
        public final int innerClassAccessFlags;

        public Entry(int innerClassIndex, int outerClassIndex, int innerNameIndex, int innerClassAccessFlags) {
            this.innerClassIndex = innerClassIndex;
            this.outerClassIndex = outerClassIndex;
            this.innerNameIndex = innerNameIndex;
            this.innerClassAccessFlags = innerClassAccessFlags;
        }

        public static Entry unpack(long packedEntry) {
            return new Entry((int)(packedEntry & 0xFFFFL), (int)(packedEntry >>> 16 & 0xFFFFL), (int)(packedEntry >>> 32 & 0xFFFFL), (int)(packedEntry >>> 48 & 0xFFFFL));
        }

        public long pack() {
            return (long)(this.innerClassIndex & 0xFFFF) | (long)(this.outerClassIndex & 0xFFFF) << 16 | (long)(this.innerNameIndex & 0xFFFF) << 32 | (long)(this.innerClassAccessFlags & 0xFFFF) << 48;
        }
    }
}

