/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.shared.verifier.StackMapFrame;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;
import java.io.PrintStream;

final class AppendFrame
extends StackMapFrame {
    private final int offsetDelta;
    private final VerificationTypeInfo[] newLocals;

    AppendFrame(int frameType, int offsetDelta, VerificationTypeInfo[] newLocals) {
        super(frameType);
        this.offsetDelta = offsetDelta;
        this.newLocals = newLocals;
    }

    @Override
    public int getOffset() {
        return this.offsetDelta;
    }

    @Override
    public VerificationTypeInfo[] getLocals() {
        return this.newLocals;
    }

    @Override
    public void print(ConstantPool pool, PrintStream out) {
        super.print(pool, out);
        out.println("            Add Locals: [");
        for (VerificationTypeInfo vti : this.newLocals) {
            out.println("                " + vti.toString(pool));
        }
        out.println("            ]");
        out.println("        }");
    }
}

