/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.Operand;
import com.oracle.svm.espresso.shared.verifier.ReferenceOperand;

final class UninitReferenceOperand<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>>
extends ReferenceOperand<R, C, M, F> {
    final int newBCI;

    UninitReferenceOperand(Symbol<Type> type) {
        super(type);
        this.newBCI = -1;
    }

    UninitReferenceOperand(Symbol<Type> type, int newBCI) {
        super(type);
        this.newBCI = newBCI;
    }

    UninitReferenceOperand(C klass) {
        super(klass);
        this.newBCI = -1;
    }

    @Override
    boolean isUninit() {
        return true;
    }

    @Override
    boolean compliesWithInMerge(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        if (other.isUninit()) {
            return this.compliesWith(other, methodVerifier);
        }
        return other.isTopOperand();
    }

    @Override
    Operand<R, C, M, F> mergeWith(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        assert (!this.compliesWithInMerge(other, methodVerifier)) : "mergeWith method should only be called for non-compatible operands.";
        if (other.isUninit()) {
            return super.mergeWith(other, methodVerifier);
        }
        return null;
    }

    ReferenceOperand<R, C, M, F> init() {
        if (this.klass == null) {
            return new ReferenceOperand(this.type);
        }
        return new ReferenceOperand(this.klass);
    }

    @Override
    boolean isUninitThis() {
        return this.newBCI == -1;
    }
}

