/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.options;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public final class OptionType<T> {
    private final String name;
    private final Function<String, T> stringConverter;
    private final Consumer<T> validator;
    private final T defaultValue;
    private static final Map<Class<?>, OptionType<?>> DEFAULTTYPES = new HashMap();

    public OptionType(String name, T defaultValue, Function<String, T> stringConverter, Consumer<T> validator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(stringConverter);
        Objects.requireNonNull(validator);
        this.name = name;
        this.stringConverter = stringConverter;
        this.defaultValue = defaultValue;
        this.validator = validator;
    }

    public OptionType(String name, T defaultValue, Function<String, T> stringConverter) {
        this(name, defaultValue, stringConverter, new Consumer<T>(){

            @Override
            public void accept(T t) {
            }
        });
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public T convert(String value) {
        T v = this.stringConverter.apply(value);
        this.validate(v);
        return v;
    }

    public void validate(T value) {
        this.validator.accept(value);
    }

    public String toString() {
        return "OptionType[name=" + this.name + ", defaultValue=" + this.defaultValue + "]";
    }

    public static <T> OptionType<T> defaultType(T value) {
        return OptionType.defaultType(value.getClass());
    }

    public static <T> OptionType<T> defaultType(Class<T> clazz) {
        return DEFAULTTYPES.get(clazz);
    }

    static {
        DEFAULTTYPES.put(Boolean.class, new OptionType<Boolean>("Boolean", false, new Function<String, Boolean>(){

            @Override
            public Boolean apply(String t) {
                if ("true".equals(t)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(t)) {
                    return Boolean.FALSE;
                }
                throw new IllegalArgumentException(String.format("Invalid boolean option value '%s'. The value of the option must be '%s' or '%s'.", t, "true", "false"));
            }
        }));
        DEFAULTTYPES.put(Byte.class, new OptionType<Byte>("Byte", (byte)0, new Function<String, Byte>(){

            @Override
            public Byte apply(String t) {
                try {
                    return Byte.parseByte(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Integer.class, new OptionType<Integer>("Integer", 0, new Function<String, Integer>(){

            @Override
            public Integer apply(String t) {
                try {
                    return Integer.parseInt(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Long.class, new OptionType<Long>("Long", 0L, new Function<String, Long>(){

            @Override
            public Long apply(String t) {
                try {
                    return Long.parseLong(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Float.class, new OptionType<Float>("Float", Float.valueOf(0.0f), new Function<String, Float>(){

            @Override
            public Float apply(String t) {
                try {
                    return Float.valueOf(Float.parseFloat(t));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Double.class, new OptionType<Double>("Double", 0.0, new Function<String, Double>(){

            @Override
            public Double apply(String t) {
                try {
                    return Double.parseDouble(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(String.class, new OptionType<String>("String", "0", new Function<String, String>(){

            @Override
            public String apply(String t) {
                return t;
            }
        }));
    }
}

