/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

public final class Source {
    private static volatile AbstractPolyglotImpl.AbstractSourceImpl IMPL;
    final String language;
    final Object impl;
    private static final Source EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AbstractPolyglotImpl.AbstractSourceImpl getImpl() {
        if (IMPL != null) return IMPL;
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            if (IMPL != null) return IMPL;
            IMPL = Engine.getImpl().getSourceImpl();
            SourceSection.IMPL = Engine.getImpl().getSourceSectionImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return IMPL;
        }
    }

    Source(String language, Object impl) {
        this.language = language;
        this.impl = impl;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getName() {
        return Source.getImpl().getName(this.impl);
    }

    public String getPath() {
        return Source.getImpl().getPath(this.impl);
    }

    public boolean isInteractive() {
        return Source.getImpl().isInteractive(this.impl);
    }

    public URL getURL() {
        return Source.getImpl().getURL(this.impl);
    }

    public URI getURI() {
        return Source.getImpl().getURI(this.impl);
    }

    public Reader getReader() {
        return Source.getImpl().getReader(this.impl);
    }

    public InputStream getInputStream() {
        return Source.getImpl().getInputStream(this.impl);
    }

    public int getLength() {
        return Source.getImpl().getLength(this.impl);
    }

    public CharSequence getCharacters() {
        return Source.getImpl().getCode(this.impl);
    }

    @Deprecated
    public CharSequence getCode() {
        return Source.getImpl().getCode(this.impl);
    }

    public CharSequence getCharacters(int lineNumber) {
        return Source.getImpl().getCode(this.impl, lineNumber);
    }

    @Deprecated
    public CharSequence getCode(int lineNumber) {
        return Source.getImpl().getCode(this.impl, lineNumber);
    }

    public int getLineCount() {
        return Source.getImpl().getLineCount(this.impl);
    }

    public int getLineNumber(int offset) throws IllegalArgumentException {
        return Source.getImpl().getLineNumber(this.impl, offset);
    }

    public int getColumnNumber(int offset) throws IllegalArgumentException {
        return Source.getImpl().getColumnNumber(this.impl, offset);
    }

    public int getLineStartOffset(int lineNumber) throws IllegalArgumentException {
        return Source.getImpl().getLineStartOffset(this.impl, lineNumber);
    }

    public int getLineLength(int lineNumber) throws IllegalArgumentException {
        return Source.getImpl().getLineLength(this.impl, lineNumber);
    }

    public boolean isInternal() {
        return Source.getImpl().isInternal(this.impl);
    }

    public String toString() {
        return Source.getImpl().toString(this.impl);
    }

    public int hashCode() {
        return Source.getImpl().hashCode(this.impl);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Source)) {
            return false;
        }
        Object otherImpl = ((Source)obj).impl;
        return Source.getImpl().equals(this.impl, otherImpl);
    }

    public static Builder newBuilder(String language, CharSequence characters, String name) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder(language, characters).name(name);
    }

    public static Builder newBuilder(String language, File source) {
        Source source2 = EMPTY;
        source2.getClass();
        return source2.new Builder(language, source);
    }

    public static Builder newBuilder(String language, URL source) {
        Source source2 = EMPTY;
        source2.getClass();
        return source2.new Builder(language, source);
    }

    public static Builder newBuilder(String language, Reader source, String name) {
        Source source2 = EMPTY;
        source2.getClass();
        return source2.new Builder(language, source).name(name);
    }

    public static Source create(String language, CharSequence source) {
        return Source.newBuilder(language, source, "Unnamed").buildLiteral();
    }

    public static String findLanguage(File file) throws IOException {
        return Source.getImpl().findLanguage(file);
    }

    public static String findLanguage(String mimeType) {
        return Source.getImpl().findLanguage(mimeType);
    }

    static {
        EMPTY = new Source(null, null);
    }

    public class Builder {
        private final String language;
        private final Object origin;
        private URI uri;
        private String name;
        private boolean interactive;
        private boolean internal;
        private CharSequence content;

        Builder(String language, Object origin) {
            Objects.requireNonNull(language);
            Objects.requireNonNull(origin);
            this.language = language;
            this.origin = origin;
        }

        public Builder name(String newName) {
            Objects.requireNonNull(newName);
            this.name = newName;
            return this;
        }

        public Builder content(String code) {
            return this.content((CharSequence)code);
        }

        public Builder content(CharSequence code) {
            Objects.requireNonNull(code);
            this.content = code;
            return this;
        }

        public Builder interactive(boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public Builder internal(boolean internal) {
            this.internal = internal;
            return this;
        }

        public Builder uri(URI newUri) {
            Objects.requireNonNull(newUri);
            this.uri = newUri;
            return this;
        }

        public Source build() throws IOException {
            return Source.getImpl().build(this.language, this.origin, this.uri, this.name, this.content, this.interactive, this.internal);
        }

        public Source buildLiteral() {
            if (!(this.origin instanceof CharSequence)) {
                throw new UnsupportedOperationException("This method is only supported for string literal. Use build() instead.");
            }
            try {
                return this.build();
            }
            catch (IOException e) {
                throw new AssertionError("No error expected.", e);
            }
        }
    }
}

