/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Handler;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;

public final class Context
implements AutoCloseable {
    final AbstractPolyglotImpl.AbstractContextImpl impl;
    private static final Context EMPTY = new Context(null);

    Context(AbstractPolyglotImpl.AbstractContextImpl impl) {
        this.impl = impl;
    }

    public Engine getEngine() {
        return this.impl.getEngineImpl(this);
    }

    public Value eval(Source source) {
        return this.impl.eval(source.getLanguage(), source.impl);
    }

    public Value eval(String languageId, CharSequence source) {
        return this.eval(Source.create(languageId, source));
    }

    public Value getPolyglotBindings() {
        return this.impl.getPolyglotBindings();
    }

    public Value getBindings(String languageId) {
        return this.impl.getBindings(languageId);
    }

    public boolean initialize(String languageId) {
        return this.impl.initializeLanguage(languageId);
    }

    public Value asValue(Object hostValue) {
        return this.impl.asValue(hostValue);
    }

    public void enter() {
        this.impl.explicitEnter(this);
    }

    public void leave() {
        this.impl.explicitLeave(this);
    }

    public void close(boolean cancelIfExecuting) {
        this.impl.close(this, cancelIfExecuting);
    }

    @Override
    public void close() {
        this.close(false);
    }

    public static Context getCurrent() {
        return Engine.getImpl().getCurrentContext();
    }

    public static Context create(String ... permittedLanguages) {
        return Context.newBuilder(permittedLanguages).build();
    }

    public static Builder newBuilder(String ... permittedLanguages) {
        Context context = EMPTY;
        context.getClass();
        return context.new Builder(permittedLanguages);
    }

    public final class Builder {
        private Engine sharedEngine;
        private String[] onlyLanguages;
        private OutputStream out;
        private OutputStream err;
        private InputStream in;
        private Map<String, String> options;
        private Map<String, String[]> arguments;
        private Predicate<String> hostClassFilter;
        private Boolean allowHostAccess;
        private Boolean allowNativeAccess;
        private Boolean allowCreateThread;
        private boolean allowAllAccess;
        private Boolean allowIO;
        private Boolean allowHostClassLoading;
        private FileSystem customFileSystem;
        private Handler customLogHandler;

        Builder(String ... onlyLanguages) {
            Objects.requireNonNull(onlyLanguages);
            for (String onlyLanguage : onlyLanguages) {
                Objects.requireNonNull(onlyLanguage);
            }
            this.onlyLanguages = onlyLanguages;
        }

        public Builder engine(Engine engine) {
            Objects.requireNonNull(engine);
            this.sharedEngine = engine;
            return this;
        }

        public Builder out(OutputStream out) {
            Objects.requireNonNull(out);
            this.out = out;
            return this;
        }

        public Builder err(OutputStream err) {
            Objects.requireNonNull(err);
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            Objects.requireNonNull(in);
            this.in = in;
            return this;
        }

        public Builder allowHostAccess(boolean enabled) {
            this.allowHostAccess = enabled;
            return this;
        }

        public Builder allowNativeAccess(boolean enabled) {
            this.allowNativeAccess = enabled;
            return this;
        }

        public Builder allowCreateThread(boolean enabled) {
            this.allowCreateThread = enabled;
            return this;
        }

        public Builder allowAllAccess(boolean enabled) {
            this.allowAllAccess = enabled;
            return this;
        }

        public Builder allowHostClassLoading(boolean enabled) {
            this.allowHostClassLoading = enabled;
            return this;
        }

        public Builder hostClassFilter(Predicate<String> classFilter) {
            Objects.requireNonNull(classFilter);
            this.hostClassFilter = classFilter;
            return this;
        }

        public Builder option(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            this.options.put(key, value);
            return this;
        }

        public Builder options(Map<String, String> options) {
            for (String key : options.keySet()) {
                this.option(key, options.get(key));
            }
            return this;
        }

        public Builder arguments(String language, String[] args) {
            Objects.requireNonNull(language);
            Objects.requireNonNull(args);
            String[] newArgs = args;
            if (args.length > 0) {
                newArgs = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    newArgs[i] = Objects.requireNonNull(args[i]);
                }
            }
            if (this.arguments == null) {
                this.arguments = new HashMap<String, String[]>();
            }
            this.arguments.put(language, newArgs);
            return this;
        }

        public Builder allowIO(boolean enabled) {
            this.allowIO = enabled;
            return this;
        }

        public Builder fileSystem(FileSystem fileSystem) {
            Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            this.customFileSystem = fileSystem;
            return this;
        }

        public Builder logHandler(Handler logHandler) {
            Objects.requireNonNull(logHandler, "Hanlder must be non null.");
            this.customLogHandler = logHandler;
            return this;
        }

        public Context build() {
            if (this.allowHostAccess == null) {
                this.allowHostAccess = this.allowAllAccess;
            }
            if (this.allowNativeAccess == null) {
                this.allowNativeAccess = this.allowAllAccess;
            }
            if (this.allowCreateThread == null) {
                this.allowCreateThread = this.allowAllAccess;
            }
            if (this.allowIO == null) {
                this.allowIO = this.allowAllAccess;
            }
            if (this.allowHostClassLoading == null) {
                this.allowHostClassLoading = this.allowAllAccess;
            }
            if (!this.allowIO.booleanValue() && this.customFileSystem != null) {
                throw new IllegalStateException("Cannot install custom FileSystem when IO is disabled.");
            }
            Engine engine = this.sharedEngine;
            if (engine == null) {
                Engine.Builder engineBuilder = Engine.newBuilder().options(this.options == null ? Collections.emptyMap() : this.options);
                if (this.out != null) {
                    engineBuilder.out(this.out);
                }
                if (this.err != null) {
                    engineBuilder.err(this.err);
                }
                if (this.in != null) {
                    engineBuilder.in(this.in);
                }
                if (this.customLogHandler != null) {
                    engineBuilder.logHandler(this.customLogHandler);
                }
                engineBuilder.setBoundEngine(true);
                engine = engineBuilder.build();
                return engine.impl.createContext(null, null, null, this.allowHostAccess, this.allowNativeAccess, this.allowCreateThread, this.allowIO, this.allowHostClassLoading, this.hostClassFilter, Collections.emptyMap(), this.arguments == null ? Collections.emptyMap() : this.arguments, this.onlyLanguages, this.customFileSystem, this.customLogHandler);
            }
            return engine.impl.createContext(this.out, this.err, this.in, this.allowHostAccess, this.allowNativeAccess, this.allowCreateThread, this.allowIO, this.allowHostClassLoading, this.hostClassFilter, this.options == null ? Collections.emptyMap() : this.options, this.arguments == null ? Collections.emptyMap() : this.arguments, this.onlyLanguages, this.customFileSystem, this.customLogHandler);
        }
    }
}

