/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Handler;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.management.ExecutionEvent;

public abstract class AbstractPolyglotImpl {
    APIAccess api;
    MonitoringAccess monitoring;

    protected AbstractPolyglotImpl() {
        if (!this.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotImpl") && !this.getClass().getName().equals("org.graalvm.polyglot.Engine$PolyglotInvalid")) {
            throw new AssertionError((Object)"Only one implementation Engine.Impl allowed.");
        }
    }

    public final void setMonitoring(MonitoringAccess monitoring) {
        this.monitoring = monitoring;
    }

    public final void setConstructors(APIAccess constructors) {
        this.api = constructors;
    }

    public APIAccess getAPIAccess() {
        return this.api;
    }

    public MonitoringAccess getMonitoring() {
        return this.monitoring;
    }

    public abstract Engine buildEngine(OutputStream var1, OutputStream var2, InputStream var3, Map<String, String> var4, long var5, TimeUnit var7, boolean var8, long var9, boolean var11, boolean var12, Handler var13);

    public abstract void preInitializeEngine();

    public abstract void resetPreInitializedEngine();

    public abstract AbstractSourceImpl getSourceImpl();

    public abstract AbstractSourceSectionImpl getSourceSectionImpl();

    public abstract AbstractExecutionListenerImpl getExecutionListenerImpl();

    public abstract Path findHome();

    public abstract Class<?> loadLanguageClass(String var1);

    public Context getCurrentContext() {
        throw new IllegalStateException("No current context is available. Make sure the Java method is invoked by a Graal guest language or a context is entered using Context.enter().");
    }

    public abstract Collection<Engine> findActiveEngines();

    public static abstract class AbstractValueImpl {
        protected AbstractValueImpl(AbstractPolyglotImpl impl) {
            Objects.requireNonNull(impl);
        }

        public boolean hasArrayElements(Object receiver) {
            return false;
        }

        public Value getArrayElement(Object receiver, long index) {
            return this.getArrayElementUnsupported(receiver);
        }

        public final Value getArrayElementUnsupported(Object receiver) {
            throw this.unsupported(receiver, "getArrayElement(long)", "hasArrayElements()");
        }

        public void setArrayElement(Object receiver, long index, Object value) {
            this.setArrayElementUnsupported(receiver);
        }

        public final void setArrayElementUnsupported(Object receiver) {
            throw this.unsupported(receiver, "setArrayElement(long, Object)", "hasArrayElements()");
        }

        public boolean removeArrayElement(Object receiver, long index) {
            return this.removeArrayElementUnsupported(receiver);
        }

        public final boolean removeArrayElementUnsupported(Object receiver) {
            throw this.unsupported(receiver, "removeArrayElement(long, Object)", null);
        }

        public long getArraySize(Object receiver) {
            return this.getArraySizeUnsupported(receiver);
        }

        public final long getArraySizeUnsupported(Object receiver) {
            throw this.unsupported(receiver, "getArraySize()", "hasArrayElements()");
        }

        public boolean hasMembers(Object receiver) {
            return false;
        }

        public Value getMember(Object receiver, String key) {
            return this.getMemberUnsupported(receiver, key);
        }

        public final Value getMemberUnsupported(Object receiver, String key) {
            throw this.unsupported(receiver, "getMember(String)", "hasMembers()");
        }

        public boolean hasMember(Object receiver, String key) {
            return false;
        }

        public Set<String> getMemberKeys(Object receiver) {
            return Collections.emptySet();
        }

        public void putMember(Object receiver, String key, Object member) {
            this.putMemberUnsupported(receiver);
        }

        public final void putMemberUnsupported(Object receiver) {
            throw this.unsupported(receiver, "putMember(String, Object)", "hasMembers()");
        }

        public boolean removeMember(Object receiver, String key) {
            return this.removeMemberUnsupported(receiver);
        }

        public final boolean removeMemberUnsupported(Object receiver) {
            throw this.unsupported(receiver, "removeMember(String, Object)", null);
        }

        public boolean canExecute(Object receiver) {
            return false;
        }

        public Value execute(Object receiver, Object[] arguments) {
            return this.executeUnsupported(receiver);
        }

        public Value execute(Object receiver) {
            return this.executeUnsupported(receiver);
        }

        public final Value executeUnsupported(Object receiver) {
            throw this.unsupported(receiver, "execute(Object...)", "canExecute()");
        }

        public boolean canInstantiate(Object receiver) {
            return false;
        }

        public Value newInstance(Object receiver, Object[] arguments) {
            return this.newInstanceUnsupported(receiver);
        }

        public final Value newInstanceUnsupported(Object receiver) {
            throw this.unsupported(receiver, "newInstance(Object...)", "canInstantiate()");
        }

        public void executeVoid(Object receiver, Object[] arguments) {
            this.executeVoidUnsupported(receiver);
        }

        public void executeVoid(Object receiver) {
            this.executeVoidUnsupported(receiver);
        }

        public final void executeVoidUnsupported(Object receiver) {
            throw this.unsupported(receiver, "executeVoid(Object...)", "canExecute()");
        }

        public boolean isString(Object receiver) {
            return false;
        }

        public String asString(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, String.class, "asString()", "isString()");
            }
            throw this.cannotConvert(receiver, String.class, "asString()", "isString()", "Invalid coercion.");
        }

        public boolean isBoolean(Object receiver) {
            return false;
        }

        public boolean asBoolean(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, Boolean.TYPE, "asBoolean()", "isBoolean()");
            }
            throw this.cannotConvert(receiver, Boolean.TYPE, "asBoolean()", "isBoolean()", "Invalid or lossy primitive coercion.");
        }

        public boolean fitsInInt(Object receiver) {
            return false;
        }

        public int asInt(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, Integer.TYPE, "asInt()", "fitsInInt()");
            }
            throw this.cannotConvert(receiver, Integer.TYPE, "asInt()", "fitsInInt()", "Invalid or lossy primitive coercion.");
        }

        public boolean fitsInLong(Object receiver) {
            return false;
        }

        public long asLong(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, Long.TYPE, "asLong()", "fitsInLong()");
            }
            throw this.cannotConvert(receiver, Long.TYPE, "asLong()", "fitsInLong()", "Invalid or lossy primitive coercion.");
        }

        public boolean fitsInDouble(Object receiver) {
            return false;
        }

        public double asDouble(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, Double.TYPE, "asDouble()", "fitsInDouble()");
            }
            throw this.cannotConvert(receiver, Double.TYPE, "asDouble()", "fitsInDouble()", "Invalid or lossy primitive coercion.");
        }

        public boolean fitsInFloat(Object receiver) {
            return false;
        }

        public float asFloat(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, Float.TYPE, "asFloat()", "fitsInFloat()");
            }
            throw this.cannotConvert(receiver, Float.TYPE, "asFloat()", "fitsInFloat()", "Invalid or lossy primitive coercion.");
        }

        public boolean isNull(Object receiver) {
            return false;
        }

        public boolean isNativePointer(Object receiver) {
            return false;
        }

        public boolean fitsInByte(Object receiver) {
            return false;
        }

        public byte asByte(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, Byte.TYPE, "asByte()", "fitsInByte()");
            }
            throw this.cannotConvert(receiver, Byte.TYPE, "asByte()", "fitsInByte()", "Invalid or lossy primitive coercion.");
        }

        public boolean fitsInShort(Object receiver) {
            return false;
        }

        public short asShort(Object receiver) {
            if (this.isNull(receiver)) {
                throw this.nullCoercion(receiver, Short.TYPE, "asShort()", "fitsInShort()");
            }
            throw this.cannotConvert(receiver, Short.TYPE, "asShort()", "fitsInShort()", "Invalid or lossy primitive coercion.");
        }

        public long asNativePointer(Object receiver) {
            return this.asNativePointerUnsupported(receiver);
        }

        public final long asNativePointerUnsupported(Object receiver) {
            throw this.cannotConvert(receiver, Long.TYPE, "asNativePointer()", "isNativeObject()", "Value cannot be converted to a native pointer.");
        }

        public boolean isHostObject(Object receiver) {
            return false;
        }

        public boolean isProxyObject(Object receiver) {
            return false;
        }

        public Object asHostObject(Object receiver) {
            throw this.cannotConvert(receiver, null, "asHostObject()", "isHostObject()", "Value is not a host object.");
        }

        public Object asProxyObject(Object receiver) {
            throw this.cannotConvert(receiver, null, "asProxyObject()", "isProxyObject()", "Value is not a proxy object.");
        }

        protected abstract RuntimeException unsupported(Object var1, String var2, String var3);

        protected abstract RuntimeException cannotConvert(Object var1, Class<?> var2, String var3, String var4, String var5);

        protected abstract RuntimeException nullCoercion(Object var1, Class<?> var2, String var3, String var4);

        public abstract String toString(Object var1);

        public abstract Value getMetaObject(Object var1);

        public boolean isNumber(Object receiver) {
            return false;
        }

        public abstract <T> T as(Object var1, Class<T> var2);

        public abstract <T> T as(Object var1, TypeLiteral<T> var2);

        public abstract SourceSection getSourceLocation(Object var1);
    }

    public static abstract class AbstractLanguageImpl {
        protected AbstractLanguageImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract String getName();

        public abstract String getImplementationName();

        public abstract boolean isInteractive();

        public abstract String getVersion();

        public abstract String getId();

        public abstract OptionDescriptors getOptions();

        public abstract Set<String> getMimeTypes();

        public abstract String getDefaultMimeType();
    }

    public static abstract class AbstractInstrumentImpl {
        protected AbstractInstrumentImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract String getId();

        public abstract String getName();

        public abstract OptionDescriptors getOptions();

        public abstract String getVersion();

        public abstract <T> T lookup(Class<T> var1);
    }

    public static abstract class AbstractStackFrameImpl {
        protected AbstractStackFrameImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract StackTraceElement toHostFrame();

        public abstract SourceSection getSourceLocation();

        public abstract String getRootName();

        public abstract Language getLanguage();

        public abstract boolean isHostFrame();

        public abstract String toStringImpl(int var1);
    }

    public static abstract class AbstractExceptionImpl {
        protected AbstractExceptionImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract boolean isInternalError();

        public abstract boolean isCancelled();

        public abstract boolean isExit();

        public abstract int getExitStatus();

        public abstract Iterable<PolyglotException.StackFrame> getPolyglotStackTrace();

        public abstract boolean isSyntaxError();

        public abstract Value getGuestObject();

        public abstract boolean isIncompleteSource();

        public abstract void onCreate(PolyglotException var1);

        public abstract void printStackTrace(PrintStream var1);

        public abstract void printStackTrace(PrintWriter var1);

        public abstract StackTraceElement[] getStackTrace();

        public abstract String getMessage();

        public abstract boolean isHostException();

        public abstract Throwable asHostException();

        public abstract SourceSection getSourceLocation();
    }

    public static abstract class AbstractEngineImpl {
        protected AbstractEngineImpl(AbstractPolyglotImpl impl) {
            Objects.requireNonNull(impl);
        }

        public abstract Language requirePublicLanguage(String var1);

        public abstract Instrument requirePublicInstrument(String var1);

        public abstract void close(Engine var1, boolean var2);

        public abstract Map<String, Instrument> getInstruments();

        public abstract Map<String, Language> getLanguages();

        public abstract String getVersion();

        public abstract OptionDescriptors getOptions();

        public abstract Context createContext(OutputStream var1, OutputStream var2, InputStream var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, Predicate<String> var9, Map<String, String> var10, Map<String, String[]> var11, String[] var12, FileSystem var13, Handler var14);

        public abstract String getImplementationName();
    }

    public static abstract class AbstractContextImpl {
        protected AbstractContextImpl(AbstractPolyglotImpl impl) {
            if (!this.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotContextImpl")) {
                throw new AssertionError((Object)"Only one implementation of AbstractContextImpl allowed.");
            }
        }

        public abstract boolean initializeLanguage(String var1);

        public abstract Value eval(String var1, Object var2);

        public abstract Engine getEngineImpl(Context var1);

        public abstract void close(Context var1, boolean var2);

        public abstract Value asValue(Object var1);

        public abstract void explicitEnter(Context var1);

        public abstract void explicitLeave(Context var1);

        public abstract Value getBindings(String var1);

        public abstract Value getPolyglotBindings();
    }

    public static abstract class AbstractSourceSectionImpl {
        protected AbstractSourceSectionImpl(AbstractPolyglotImpl polyglotImpl) {
            Objects.requireNonNull(polyglotImpl);
        }

        public abstract boolean isAvailable(Object var1);

        public abstract int getStartLine(Object var1);

        public abstract int getStartColumn(Object var1);

        public abstract int getEndLine(Object var1);

        public abstract int getEndColumn(Object var1);

        public abstract int getCharIndex(Object var1);

        public abstract int getCharLength(Object var1);

        public abstract int getCharEndIndex(Object var1);

        public abstract CharSequence getCode(Object var1);

        public abstract String toString(Object var1);

        public abstract int hashCode(Object var1);

        public abstract boolean equals(Object var1, Object var2);
    }

    public static abstract class AbstractSourceImpl {
        protected final AbstractPolyglotImpl engineImpl;

        protected AbstractSourceImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
            this.engineImpl = engineImpl;
        }

        public abstract Source build(String var1, Object var2, URI var3, String var4, String var5, Object var6, boolean var7, boolean var8, boolean var9) throws IOException;

        public abstract String getName(Object var1);

        public abstract String getPath(Object var1);

        public abstract boolean isInteractive(Object var1);

        public abstract URL getURL(Object var1);

        public abstract URI getURI(Object var1);

        public abstract Reader getReader(Object var1);

        public abstract InputStream getInputStream(Object var1);

        public abstract int getLength(Object var1);

        public abstract CharSequence getCode(Object var1);

        public abstract CharSequence getCode(Object var1, int var2);

        public abstract int getLineCount(Object var1);

        public abstract int getLineNumber(Object var1, int var2);

        public abstract int getColumnNumber(Object var1, int var2);

        public abstract int getLineStartOffset(Object var1, int var2);

        public abstract int getLineLength(Object var1, int var2);

        public abstract String toString(Object var1);

        public abstract int hashCode(Object var1);

        public abstract boolean equals(Object var1, Object var2);

        public abstract boolean isInternal(Object var1);

        public abstract String findLanguage(File var1) throws IOException;

        public abstract String findLanguage(URL var1) throws IOException;

        public abstract String findLanguage(String var1);

        public abstract String findMimeType(File var1) throws IOException;

        public abstract String findMimeType(URL var1) throws IOException;

        public abstract ByteSequence getBytes(Object var1);

        public abstract boolean hasCharacters(Object var1);

        public abstract boolean hasBytes(Object var1);

        public abstract String getMimeType(Object var1);
    }

    public static abstract class AbstractExecutionListenerImpl {
        protected AbstractExecutionListenerImpl(AbstractPolyglotImpl engineImpl) {
            Objects.requireNonNull(engineImpl);
        }

        public abstract List<Value> getInputValues(Object var1);

        public abstract SourceSection getLocation(Object var1);

        public abstract String getRootName(Object var1);

        public abstract Value getReturnValue(Object var1);

        public abstract boolean isExpression(Object var1);

        public abstract boolean isStatement(Object var1);

        public abstract boolean isRoot(Object var1);

        public abstract void closeExecutionListener(Object var1);

        public abstract Object attachExecutionListener(Engine var1, Consumer<ExecutionEvent> var2, Consumer<ExecutionEvent> var3, boolean var4, boolean var5, boolean var6, Predicate<Source> var7, Predicate<String> var8, boolean var9, boolean var10, boolean var11);

        public abstract PolyglotException getException(Object var1);
    }

    public static abstract class APIAccess {
        protected APIAccess() {
            if (!this.getClass().getCanonicalName().equals("org.graalvm.polyglot.Engine.APIAccessImpl")) {
                throw new AssertionError((Object)("Only one implementation of APIAccess allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract Engine newEngine(AbstractEngineImpl var1);

        public abstract Context newContext(AbstractContextImpl var1);

        public abstract PolyglotException newLanguageException(String var1, AbstractExceptionImpl var2);

        public abstract Language newLanguage(AbstractLanguageImpl var1);

        public abstract Instrument newInstrument(AbstractInstrumentImpl var1);

        public abstract Value newValue(Object var1, AbstractValueImpl var2);

        public abstract Source newSource(String var1, Object var2);

        public abstract SourceSection newSourceSection(Source var1, Object var2);

        public abstract Object getReceiver(Value var1);

        public abstract AbstractValueImpl getImpl(Value var1);

        public abstract AbstractEngineImpl getImpl(Engine var1);

        public abstract AbstractExceptionImpl getImpl(PolyglotException var1);

        public abstract AbstractStackFrameImpl getImpl(PolyglotException.StackFrame var1);

        public abstract AbstractLanguageImpl getImpl(Language var1);

        public abstract AbstractInstrumentImpl getImpl(Instrument var1);

        public abstract PolyglotException.StackFrame newPolyglotStackTraceElement(PolyglotException var1, AbstractStackFrameImpl var2);
    }

    public static abstract class MonitoringAccess {
        protected MonitoringAccess() {
            if (!this.getClass().getCanonicalName().equals("org.graalvm.polyglot.management.ExecutionListener.MonitoringAccessImpl")) {
                throw new AssertionError((Object)("Only one implementation of MonitoringAccessImpl allowed. " + this.getClass().getCanonicalName()));
            }
        }

        public abstract ExecutionEvent newExecutionEvent(Object var1);
    }
}

