/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.io;

import java.util.Arrays;
import org.graalvm.polyglot.io.ByteSequence;

final class ByteArraySequence
implements ByteSequence {
    private final byte[] buffer;
    private final int start;
    private final int length;

    ByteArraySequence(byte[] buffer, int start, int length) {
        assert (buffer.length >= start + length);
        assert (start >= 0);
        assert (length >= 0);
        this.buffer = buffer;
        this.start = start;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte byteAt(int index) {
        int resolvedIndex = this.start + index;
        if (resolvedIndex >= this.start + this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.buffer[resolvedIndex];
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buffer, this.start, this.start + this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ByteArraySequence) {
            ByteArraySequence other = (ByteArraySequence)obj;
            if (this.buffer == other.buffer) {
                return this.start == other.start && this.length == other.length;
            }
            if (this.length != other.length) {
                return false;
            }
            int otherStart = other.start;
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[this.start + i] == other.buffer[otherStart + i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)obj;
            if (this.length != other.length()) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[this.start + i] == other.byteAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.start; i < this.start + this.length; ++i) {
            result = 31 * result + this.buffer[i];
        }
        return result;
    }

    @Override
    public ByteSequence subSequence(int startIndex, int endIndex) {
        int l = endIndex - startIndex;
        if (l < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(l));
        }
        int realStartIndex = this.start + startIndex;
        if (realStartIndex < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(startIndex));
        }
        if (realStartIndex + l > this.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(realStartIndex + l));
        }
        return new ByteArraySequence(this.buffer, realStartIndex, l);
    }
}

