/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.MapIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSMapIterator;
import com.oracle.truffle.js.runtime.builtins.JSMapIteratorObject;
import com.oracle.truffle.js.runtime.builtins.JSMapObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class MapIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<MapIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new MapIteratorPrototypeBuiltins();

    protected MapIteratorPrototypeBuiltins() {
        super(JSMapIterator.PROTOTYPE_NAME, MapIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, MapIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return MapIteratorPrototypeBuiltinsFactory.MapIteratorNextNodeGen.create(context, builtin, MapIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum MapIteratorPrototype implements BuiltinEnum<MapIteratorPrototype>
    {
        next(0);

        private final int length;

        private MapIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class MapIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;

        public MapIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        }

        @Specialization
        protected final JSObject doMapIterator(VirtualFrame frame, JSMapIteratorObject iterator, @Cached InlinedConditionProfile detachedProf, @Cached InlinedConditionProfile doneProf, @Cached InlinedConditionProfile iterKindKey, @Cached InlinedConditionProfile iterKindValue) {
            Object result;
            Object map = iterator.getIteratedObject();
            if (detachedProf.profile((Node)this, map == Undefined.instance)) {
                return this.createIterResultObjectNode.execute(frame, (Object)Undefined.instance, true);
            }
            assert (map instanceof JSMapObject);
            JSHashMap.Cursor mapCursor = iterator.getNextIndex();
            int itemKind = iterator.getIterationKind();
            if (doneProf.profile((Node)this, !mapCursor.advance())) {
                iterator.setIteratedObject((Object)Undefined.instance);
                return this.createIterResultObjectNode.execute(frame, (Object)Undefined.instance, true);
            }
            Object elementKey = mapCursor.getKey();
            Object elementValue = mapCursor.getValue();
            if (iterKindKey.profile((Node)this, itemKind == 1)) {
                result = elementKey;
            } else if (iterKindValue.profile((Node)this, itemKind == 2)) {
                result = elementValue;
            } else {
                assert (itemKind == 3);
                result = JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{elementKey, elementValue});
            }
            return this.createIterResultObjectNode.execute(frame, result, false);
        }

        @Fallback
        protected static JSObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not a Map Iterator");
        }
    }
}

