/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CachedGetPropertyNodeGen;
import com.oracle.truffle.js.nodes.access.FrequencyBasedPolymorphicAccessNode;
import com.oracle.truffle.js.nodes.access.JSProxyPropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

@ImportStatic(value={JSRuntime.class})
abstract class CachedGetPropertyNode
extends JavaScriptBaseNode {
    static final int MAX_DEPTH = 2;
    protected final JSContext context;

    CachedGetPropertyNode(JSContext context) {
        this.context = context;
    }

    public abstract Object execute(JSDynamicObject var1, Object var2, Object var3, Object var4);

    static CachedGetPropertyNode create(JSContext context) {
        return CachedGetPropertyNodeGen.create(context);
    }

    @Specialization(guards={"cachedKey != null", "!isArrayIndex(cachedKey)", "propertyKeyEquals(equalsNode, cachedKey, key)"}, limit="MAX_DEPTH")
    Object doCachedKey(JSDynamicObject target, Object key, Object receiver, Object defaultValue, @Cached(value="propertyKeyOrNull(key)") Object cachedKey, @Cached(value="create(cachedKey, context)") PropertyGetNode propertyNode, @Cached @Cached.Shared(value="strEq") TruffleString.EqualNode equalsNode) {
        return propertyNode.getValueOrDefault((Object)target, receiver, defaultValue);
    }

    @Specialization(guards={"isArrayIndex(index)", "!isJSProxy(target)"})
    Object doIntIndex(JSDynamicObject target, int index, Object receiver, Object defaultValue, @Cached @Cached.Shared(value="jsclassProfile") JSClassProfile jsclassProfile) {
        return JSObject.getOrDefault(target, index, receiver, defaultValue, jsclassProfile, (Node)this);
    }

    @Specialization(guards={"!isJSProxy(target)", "toArrayIndexNode.isResultArrayIndex(maybeIndex)"}, replaces={"doIntIndex"}, limit="1")
    Object doArrayIndex(JSDynamicObject target, Object key, Object receiver, Object defaultValue, @Cached(value="createNoToPropertyKey()") ToArrayIndexNode toArrayIndexNode, @Bind(value="toArrayIndexNode.execute(key)") Object maybeIndex, @Cached @Cached.Shared(value="jsclassProfile") JSClassProfile jsclassProfile) {
        long index = (Long)maybeIndex;
        return JSObject.getOrDefault(target, index, receiver, defaultValue, jsclassProfile, (Node)this);
    }

    @Specialization(guards={"isJSProxy(target)"})
    protected Object doProxy(JSDynamicObject target, Object index, Object receiver, Object defaultValue, @Cached(value="create(context)") JSProxyPropertyGetNode proxyGet) {
        return proxyGet.executeWithReceiver((Object)target, receiver, index, defaultValue);
    }

    @Specialization(replaces={"doCachedKey", "doArrayIndex", "doProxy"})
    static Object doGeneric(JSDynamicObject target, Object key, Object receiver, Object defaultValue, @Bind(value="this") Node node, @Cached RequireObjectCoercibleNode requireObjectCoercibleNode, @Cached ToArrayIndexNode toArrayIndexNode, @Cached InlinedConditionProfile getType, @Cached @Cached.Shared(value="jsclassProfile") JSClassProfile jsclassProfile, @Cached InlinedConditionProfile highFrequency, @Cached(value="create(context)") FrequencyBasedPolymorphicAccessNode.FrequencyBasedPropertyGetNode hotKey, @Cached @Cached.Shared(value="strEq") TruffleString.EqualNode equalsNode) {
        requireObjectCoercibleNode.executeVoid((Object)target);
        Object arrayIndex = toArrayIndexNode.execute(key);
        if (getType.profile(node, arrayIndex instanceof Long)) {
            return JSObject.getOrDefault(target, (Long)arrayIndex, receiver, defaultValue, jsclassProfile, node);
        }
        Object maybeRead = hotKey.executeFastGet(arrayIndex, (Object)target, equalsNode);
        if (highFrequency.profile(node, maybeRead != null)) {
            return maybeRead;
        }
        return JSObject.getOrDefault(target, arrayIndex, receiver, defaultValue, jsclassProfile, node);
    }

    static Object propertyKeyOrNull(Object key) {
        return JSRuntime.isPropertyKey(key) ? key : null;
    }
}

