/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.ArrayIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSArrayIterator;
import com.oracle.truffle.js.runtime.builtins.JSArrayIteratorObject;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ArrayIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayIteratorPrototypeBuiltins();

    protected ArrayIteratorPrototypeBuiltins() {
        super(JSArrayIterator.PROTOTYPE_NAME, ArrayIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return ArrayIteratorPrototypeBuiltinsFactory.ArrayIteratorNextNodeGen.create(context, builtin, ArrayIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayIteratorPrototype implements BuiltinEnum<ArrayIteratorPrototype>
    {
        next(0);

        private final int length;

        private ArrayIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class ArrayIteratorNextNode
    extends JSBuiltinNode {
        protected ArrayIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSObject doArrayIterator(VirtualFrame frame, JSArrayIteratorObject iterator, @Cached(value="create(getContext())") CreateIterResultObjectNode createIterResultObjectNode, @Cached(value="create(getContext())") JSGetLengthNode getLengthNode, @Cached(value="create(getContext())") ReadElementNode readElementNode, @Cached(inline=true) LongToIntOrDoubleNode toJSIndex, @Cached InlinedBranchProfile errorBranch, @Cached InlinedBranchProfile useAfterCloseBranch, @Cached InlinedConditionProfile isTypedArrayProfile) {
            Object result;
            long length;
            Object array = iterator.getIteratedObject();
            if (array == Undefined.instance) {
                useAfterCloseBranch.enter((Node)this);
                return createIterResultObjectNode.execute(frame, (Object)Undefined.instance, true);
            }
            long index = iterator.getNextIndex();
            int itemKind = iterator.getIterationKind();
            if (isTypedArrayProfile.profile((Node)this, JSArrayBufferView.isJSArrayBufferView(array))) {
                JSTypedArrayObject typedArray = (JSTypedArrayObject)((Object)array);
                if (JSArrayBufferView.hasDetachedBuffer(typedArray, this.getContext())) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeError("Cannot perform Array Iterator.prototype.next on a detached ArrayBuffer");
                }
                length = JSArrayBufferView.typedArrayGetLength(typedArray);
            } else {
                length = getLengthNode.executeLong(array);
            }
            if (index >= length) {
                iterator.setIteratedObject((Object)Undefined.instance);
                return createIterResultObjectNode.execute(frame, (Object)Undefined.instance, true);
            }
            iterator.setNextIndex(index + 1L);
            if (itemKind == 1) {
                return createIterResultObjectNode.execute(frame, toJSIndex.execute(this, index), false);
            }
            Object elementValue = readElementNode.executeWithTargetAndIndex(array, index);
            if (itemKind == 2) {
                result = elementValue;
            } else {
                assert (itemKind == 3);
                result = JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{toJSIndex.execute(this, index), elementValue});
            }
            return createIterResultObjectNode.execute(frame, result, false);
        }

        @Fallback
        protected JSObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not an Array Iterator");
        }
    }
}

