/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.SetPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSetIterator;
import com.oracle.truffle.js.runtime.builtins.JSSetObject;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class SetPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SetPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SetPrototypeBuiltins();
    public static final JSBuiltinsContainer NEW_SET_BUILTINS = new NewSetPrototypeBuiltins();

    protected SetPrototypeBuiltins() {
        super(JSSet.PROTOTYPE_NAME, SetPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SetPrototype builtinEnum) {
        switch (builtinEnum) {
            case clear: {
                return SetPrototypeBuiltinsFactory.JSSetClearNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case delete: {
                return SetPrototypeBuiltinsFactory.JSSetDeleteNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case add: {
                return SetPrototypeBuiltinsFactory.JSSetAddNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case has: {
                return SetPrototypeBuiltinsFactory.JSSetHasNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case forEach: {
                return SetPrototypeBuiltinsFactory.JSSetForEachNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case values: {
                return SetPrototypeBuiltinsFactory.CreateSetIteratorNodeGen.create(context, builtin, 2, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case entries: {
                return SetPrototypeBuiltinsFactory.CreateSetIteratorNodeGen.create(context, builtin, 3, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case size: {
                return SetPrototypeBuiltinsFactory.SetGetSizeNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum SetPrototype implements BuiltinEnum<SetPrototype>
    {
        clear(0),
        delete(1),
        add(1),
        has(1),
        forEach(1),
        values(0),
        entries(0),
        size(0);

        private final int length;

        private SetPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == size;
        }
    }

    public static abstract class JSSetClearNode
    extends JSBuiltinNode {
        public JSSetClearNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static JSDynamicObject clear(JSSetObject thisObj) {
            JSSet.getInternalSet(thisObj).clear();
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static JSDynamicObject notSet(Object thisObj) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetDeleteNode
    extends JSSetOperation {
        public JSSetDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean delete(JSSetObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSSet.getInternalSet(thisObj).remove(normalizedKey);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetAddNode
    extends JSSetOperation {
        public JSSetAddNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject add(JSSetObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            JSSet.getInternalSet(thisObj).put(normalizedKey, PRESENT);
            return thisObj;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static JSDynamicObject notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetHasNode
    extends JSSetOperation {
        public JSSetHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean has(JSSetObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSSet.getInternalSet(thisObj).has(normalizedKey);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean hasNoObject(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetForEachNode
    extends JSBuiltinNode {
        public JSSetForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isCallable.executeBoolean(callback)"}, limit="1")
        protected Object forEachFunction(JSSetObject thisObj, JSDynamicObject callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @Cached(value="createCall()") JSFunctionCallNode callNode) {
            JSHashMap map = JSSet.getInternalSet(thisObj);
            JSHashMap.Cursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object key = cursor.getKey();
                callNode.executeCall(JSArguments.create(thisArg, (Object)callback, new Object[]{key, key, thisObj}));
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isCallable.executeBoolean(callback)"}, limit="1")
        protected static Object forEachFunctionNoFunction(JSSetObject thisObj, Object callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            throw Errors.createTypeErrorCallableExpected();
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static Object forEachFunctionNoSet(Object thisObj, Object callback, Object thisArg) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class CreateSetIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;

        protected CreateSetIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.iterationKind = iterationKind;
        }

        @Specialization
        protected final JSObject doSet(JSSetObject set) {
            return JSSetIterator.create(this.getContext(), this.getRealm(), (Object)set, JSSet.getInternalSet(set).getEntries(), this.iterationKind);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static JSObject doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError("not a Set");
        }
    }

    public static abstract class SetGetSizeNode
    extends JSBuiltinNode {
        public SetGetSizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static int doSet(JSSetObject thisObj) {
            return JSSet.getSetSize(thisObj);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static int notSet(Object thisObj) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static final class NewSetPrototypeBuiltins
    extends JSBuiltinsContainer.SwitchEnum<NewSetPrototype> {
        protected NewSetPrototypeBuiltins() {
            super(NewSetPrototype.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, NewSetPrototype builtinEnum) {
            switch (builtinEnum) {
                case union: {
                    return SetPrototypeBuiltinsFactory.JSSetUnionNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case intersection: {
                    return SetPrototypeBuiltinsFactory.JSSetIntersectionNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case difference: {
                    return SetPrototypeBuiltinsFactory.JSSetDifferenceNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case symmetricDifference: {
                    return SetPrototypeBuiltinsFactory.JSSetSymmetricDifferenceNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case isSubsetOf: {
                    return SetPrototypeBuiltinsFactory.JSSetIsSubsetOfNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case isSupersetOf: {
                    return SetPrototypeBuiltinsFactory.JSSetIsSupersetOfNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case isDisjointFrom: {
                    return SetPrototypeBuiltinsFactory.JSSetIsDisjointFromNodeGen.create(context, builtin, NewSetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum NewSetPrototype implements BuiltinEnum<NewSetPrototype>
        {
            union(1),
            intersection(1),
            difference(1),
            symmetricDifference(1),
            isSubsetOf(1),
            isSupersetOf(1),
            isDisjointFrom(1);

            private final int length;

            private NewSetPrototype(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static abstract class JSSetIsDisjointFromNode
    extends JSSetNewOperation {
        public JSSetIsDisjointFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Boolean isDisjointFrom(JSSetObject set, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile notCallableError) {
            Object hasCheck = this.getHasFunction((Object)set);
            if (!this.isCallable(hasCheck)) {
                notCallableError.enter((Node)this);
                throw Errors.createTypeErrorCallableExpected();
            }
            IteratorRecord iteratorRecord = getIteratorNode.execute(this, iterable);
            try {
                Object nextValue;
                Object has;
                do {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return Boolean.TRUE;
                    }
                    nextValue = this.iteratorValueNode.execute(next);
                } while ((has = this.call(hasCheck, (Object)set, nextValue)) != Boolean.TRUE);
                return Boolean.FALSE;
            }
            catch (AbstractTruffleException ex) {
                this.iteratorError.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetIsSupersetOfNode
    extends JSSetNewOperation {
        public JSSetIsSupersetOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Boolean isSupersetOf(JSSetObject set, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile notCallableError) {
            Object hasCheck = this.getHasFunction((Object)set);
            if (!this.isCallable(hasCheck)) {
                notCallableError.enter((Node)this);
                throw Errors.createTypeErrorCallableExpected();
            }
            IteratorRecord iteratorRecord = getIteratorNode.execute(this, iterable);
            try {
                Object nextValue;
                Object has;
                do {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return Boolean.TRUE;
                    }
                    nextValue = this.iteratorValueNode.execute(next);
                } while ((has = this.call(hasCheck, (Object)set, nextValue)) != Boolean.FALSE);
                return Boolean.FALSE;
            }
            catch (AbstractTruffleException ex) {
                this.iteratorError.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetIsSubsetOfNode
    extends JSSetNewOperation {
        public JSSetIsSubsetOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Boolean isSubsetOf(JSSetObject set, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile needCreateNewBranch, @Cached InlinedBranchProfile isObjectError) {
            IteratorRecord iteratorRecord = getIteratorNode.execute(this, (Object)set);
            if (!JSRuntime.isObject(iterable)) {
                isObjectError.enter((Node)this);
                throw Errors.createTypeErrorNotIterable(iterable, this);
            }
            JSDynamicObject otherSet = (JSDynamicObject)((Object)iterable);
            Object hasCheck = this.getHasFunction((Object)otherSet);
            if (!this.isCallable(hasCheck)) {
                needCreateNewBranch.enter((Node)this);
                otherSet = (JSDynamicObject)((Object)this.constructSet(new Object[0]));
                this.addEntryFromIterable((Object)otherSet, iterable, this.getAddFunction((Object)otherSet), getIteratorNode);
                hasCheck = this.getHasFunction((Object)otherSet);
            }
            try {
                Object nextValue;
                Object has;
                do {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return Boolean.TRUE;
                    }
                    nextValue = this.iteratorValueNode.execute(next);
                } while ((has = this.call(hasCheck, (Object)otherSet, nextValue)) != Boolean.FALSE);
                return Boolean.FALSE;
            }
            catch (AbstractTruffleException ex) {
                this.iteratorError.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetSymmetricDifferenceNode
    extends JSSetNewOperation {
        public JSSetSymmetricDifferenceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject symmetricDifference(JSSetObject set, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile removerError) {
            JSDynamicObject newSet = (JSDynamicObject)((Object)this.constructSet(new Object[]{set}));
            Object remover = this.getRemoveFunction((Object)newSet);
            if (!this.isCallable(remover)) {
                removerError.enter((Node)this);
                throw Errors.createTypeErrorCallableExpected();
            }
            Object adder = this.getAddFunction((Object)newSet);
            if (!this.isCallable(adder)) {
                this.adderError.enter();
                throw Errors.createTypeErrorCallableExpected();
            }
            IteratorRecord iteratorRecord = getIteratorNode.execute(this, iterable);
            try {
                while (true) {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return newSet;
                    }
                    Object nextValue = this.iteratorValueNode.execute(next);
                    Object removed = this.call(remover, (Object)newSet, nextValue);
                    if (removed != Boolean.FALSE) continue;
                    this.call(adder, (Object)newSet, nextValue);
                }
            }
            catch (AbstractTruffleException ex) {
                this.iteratorError.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetDifferenceNode
    extends JSSetNewOperation {
        public JSSetDifferenceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject difference(JSSetObject set, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile removerError) {
            JSDynamicObject newSet = (JSDynamicObject)((Object)this.constructSet(new Object[]{set}));
            Object remover = this.getRemoveFunction((Object)newSet);
            if (!this.isCallable(remover)) {
                removerError.enter((Node)this);
                throw Errors.createTypeErrorCallableExpected();
            }
            IteratorRecord iteratorRecord = getIteratorNode.execute(this, iterable);
            try {
                while (true) {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return newSet;
                    }
                    Object nextValue = this.iteratorValueNode.execute(next);
                    this.call(remover, (Object)newSet, nextValue);
                }
            }
            catch (AbstractTruffleException ex) {
                this.iteratorError.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetIntersectionNode
    extends JSSetNewOperation {
        public JSSetIntersectionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject intersection(JSSetObject set, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile hasError) {
            JSDynamicObject newSet = (JSDynamicObject)((Object)this.constructSet(new Object[0]));
            Object hasCheck = this.getHasFunction((Object)set);
            if (!this.isCallable(hasCheck)) {
                hasError.enter((Node)this);
                throw Errors.createTypeErrorCallableExpected();
            }
            Object adder = this.getAddFunction((Object)newSet);
            if (!this.isCallable(adder)) {
                this.adderError.enter();
                throw Errors.createTypeErrorCallableExpected();
            }
            IteratorRecord iteratorRecord = getIteratorNode.execute(this, iterable);
            try {
                while (true) {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return newSet;
                    }
                    Object nextValue = this.iteratorValueNode.execute(next);
                    Object has = this.call(hasCheck, (Object)set, nextValue);
                    if (has != Boolean.TRUE) continue;
                    this.call(adder, (Object)newSet, nextValue);
                }
            }
            catch (AbstractTruffleException ex) {
                this.iteratorError.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetUnionNode
    extends JSSetNewOperation {
        public JSSetUnionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject union(JSSetObject set, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode) {
            JSDynamicObject newSet = (JSDynamicObject)((Object)this.constructSet(new Object[]{set}));
            Object adder = this.getAddFunction((Object)newSet);
            this.addEntryFromIterable((Object)newSet, iterable, adder, getIteratorNode);
            return newSet;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    protected static abstract class JSSetNewOperation
    extends JSSetOperation {
        @Node.Child
        protected IteratorStepNode iteratorStepNode;
        @Node.Child
        protected IteratorValueNode iteratorValueNode;
        @Node.Child
        protected IteratorCloseNode iteratorCloseNode;
        @Node.Child
        protected JSFunctionCallNode callFunctionNode;
        @Node.Child
        protected PropertyGetNode getAddNode;
        @Node.Child
        protected PropertyGetNode getRemoveNode;
        @Node.Child
        protected PropertyGetNode getHasNode;
        @Node.Child
        protected IsCallableNode isCallableNode;
        protected final BranchProfile iteratorError = BranchProfile.create();
        protected final BranchProfile adderError = BranchProfile.create();

        protected JSSetNewOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.iteratorStepNode = IteratorStepNode.create();
            this.iteratorValueNode = IteratorValueNode.create();
            this.iteratorCloseNode = IteratorCloseNode.create(context);
        }

        protected Object addEntryFromIterable(Object target, Object iterable, Object adder, GetIteratorNode getIteratorNode) {
            if (!this.isCallable(adder)) {
                this.adderError.enter();
                throw Errors.createTypeErrorCallableExpected();
            }
            IteratorRecord iteratorRecord = getIteratorNode.execute(this, iterable);
            try {
                while (true) {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return target;
                    }
                    Object nextValue = this.iteratorValueNode.execute(next);
                    this.call(adder, target, nextValue);
                }
            }
            catch (AbstractTruffleException ex) {
                this.iteratorError.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        protected final void iteratorCloseAbrupt(Object iterator) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iterator);
        }

        protected Object call(Object function, Object target, Object ... userArguments) {
            if (this.callFunctionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callFunctionNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.callFunctionNode.executeCall(JSArguments.create(target, function, userArguments));
        }

        protected final Object getAddFunction(Object object) {
            if (this.getAddNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getAddNode = (PropertyGetNode)this.insert(PropertyGetNode.create(Strings.ADD, false, this.getContext()));
            }
            return this.getAddNode.getValue(object);
        }

        protected final Object getRemoveFunction(Object object) {
            if (this.getRemoveNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getRemoveNode = (PropertyGetNode)this.insert(PropertyGetNode.create(Strings.DELETE, false, this.getContext()));
            }
            return this.getRemoveNode.getValue(object);
        }

        protected final Object getHasFunction(Object object) {
            if (this.getHasNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getHasNode = (PropertyGetNode)this.insert(PropertyGetNode.create(Strings.HAS, false, this.getContext()));
            }
            return this.getHasNode.getValue(object);
        }

        protected final Object constructSet(Object ... arguments) {
            JSFunctionObject ctr = this.getRealm().getSetConstructor();
            return JSRuntime.construct((Object)ctr, arguments);
        }

        protected final boolean isCallable(Object object) {
            if (this.isCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isCallableNode = (IsCallableNode)this.insert(IsCallableNode.create());
            }
            return this.isCallableNode.executeBoolean(object);
        }
    }

    public static abstract class JSSetOperation
    extends JSBuiltinNode {
        protected static final Object PRESENT = new Object();
        @Node.Child
        private JSCollectionsNormalizeNode normalizeNode;

        public JSSetOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object normalize(Object value) {
            if (this.normalizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.normalizeNode = (JSCollectionsNormalizeNode)this.insert(JSCollectionsNormalizeNodeGen.create());
            }
            return this.normalizeNode.execute(value);
        }
    }
}

