/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import java.nio.ByteOrder;

@ExportLibrary(value=InteropLibrary.class, delegateTo="arrayView")
public final class InteropBufferView
implements TruffleObject {
    private final int viewByteOffset;
    private final int viewByteLength;
    final JSArrayBufferObject arrayBuffer;
    final JSTypedArrayObject arrayView;

    public InteropBufferView(JSArrayBufferObject arrayBuffer, int byteOffset, int byteLength, JSTypedArrayObject arrayView) {
        assert (byteOffset >= 0) : byteOffset;
        assert (byteLength >= 0) : byteLength;
        this.viewByteOffset = byteOffset;
        this.viewByteLength = byteLength;
        this.arrayBuffer = arrayBuffer;
        this.arrayView = arrayView;
    }

    @ExportMessage
    public boolean hasBufferElements() {
        return true;
    }

    @ExportMessage
    public long getBufferSize() {
        return this.viewByteLength;
    }

    private long checkFromIndexSize(long fromIndex, int size) throws InvalidBufferOffsetException {
        long bufferByteOffset = (long)this.viewByteOffset + fromIndex;
        long bufferByteLength = this.viewByteLength;
        if ((fromIndex | (long)size) < 0L || (long)size > bufferByteLength - fromIndex) {
            throw InvalidBufferOffsetException.create((long)fromIndex, (long)size);
        }
        return bufferByteOffset;
    }

    @ExportMessage
    byte readBufferByte(long byteOffset, @CachedLibrary(value="this.arrayBuffer") InteropLibrary bufferInterop) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return bufferInterop.readBufferByte((Object)this.arrayBuffer, this.checkFromIndexSize(byteOffset, 1));
    }

    @ExportMessage
    short readBufferShort(ByteOrder order, long byteOffset, @CachedLibrary(value="this.arrayBuffer") InteropLibrary bufferInterop) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return bufferInterop.readBufferShort((Object)this.arrayBuffer, order, this.checkFromIndexSize(byteOffset, 2));
    }

    @ExportMessage
    int readBufferInt(ByteOrder order, long byteOffset, @CachedLibrary(value="this.arrayBuffer") InteropLibrary bufferInterop) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return bufferInterop.readBufferInt((Object)this.arrayBuffer, order, this.checkFromIndexSize(byteOffset, 4));
    }

    @ExportMessage
    long readBufferLong(ByteOrder order, long byteOffset, @CachedLibrary(value="this.arrayBuffer") InteropLibrary bufferInterop) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return bufferInterop.readBufferLong((Object)this.arrayBuffer, order, this.checkFromIndexSize(byteOffset, 8));
    }

    @ExportMessage
    float readBufferFloat(ByteOrder order, long byteOffset, @CachedLibrary(value="this.arrayBuffer") InteropLibrary bufferInterop) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return bufferInterop.readBufferFloat((Object)this.arrayBuffer, order, this.checkFromIndexSize(byteOffset, 4));
    }

    @ExportMessage
    double readBufferDouble(ByteOrder order, long byteOffset, @CachedLibrary(value="this.arrayBuffer") InteropLibrary bufferInterop) throws UnsupportedMessageException, InvalidBufferOffsetException {
        return bufferInterop.readBufferDouble((Object)this.arrayBuffer, order, this.checkFromIndexSize(byteOffset, 8));
    }

    @ExportMessage
    boolean isBufferWritable() {
        return false;
    }

    @ExportMessage
    void writeBufferByte(long byteOffset, byte value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    void writeBufferShort(ByteOrder order, long byteOffset, short value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    void writeBufferInt(ByteOrder order, long byteOffset, int value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    void writeBufferLong(ByteOrder order, long byteOffset, long value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    void writeBufferFloat(ByteOrder order, long byteOffset, float value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    void writeBufferDouble(ByteOrder order, long byteOffset, double value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }
}

