/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.promise.TriggerPromiseReactionsNode;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSErrorObject;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.PromiseReactionRecord;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

public class RejectPromiseNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private TriggerPromiseReactionsNode triggerPromiseReactions;
    private final ConditionProfile unhandledProf = ConditionProfile.create();

    protected RejectPromiseNode(JSContext context) {
        this.context = context;
        this.triggerPromiseReactions = TriggerPromiseReactionsNode.create(context);
    }

    public static RejectPromiseNode create(JSContext context) {
        return new RejectPromiseNode(context);
    }

    public Object execute(JSPromiseObject promise, Object reason) {
        assert (JSPromise.isPending(promise));
        if (this.context.isOptionAsyncStackTraces() && JSError.isJSError(reason)) {
            RejectPromiseNode.materializeLazyStackTrace((JSErrorObject)reason);
        }
        SimpleArrayList<PromiseReactionRecord> reactions = promise.getPromiseRejectReactions();
        promise.setPromiseResult(reason);
        promise.clearPromiseReactions();
        JSPromise.setPromiseState(promise, 2);
        if (this.unhandledProf.profile(!promise.isHandled())) {
            this.context.notifyPromiseRejectionTracker(promise, 0, reason, JSAgent.get(this));
        }
        return this.triggerPromiseReactions.execute(reactions, reason);
    }

    @CompilerDirectives.TruffleBoundary
    private static void materializeLazyStackTrace(JSErrorObject error) {
        assert (JSError.isJSError(error));
        GraalJSException exception = JSError.getException(error);
        if (exception != null) {
            exception.getJSStackTrace();
        }
    }
}

