// CheckStyle: start generated
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSArrayDeleteRangeNode#denseArray}
 *     Activation probability: 0.48333
 *     With/without class size: 13/4 bytes
 *   Specialization {@link JSArrayDeleteRangeNode#sparseArray}
 *     Activation probability: 0.33333
 *     With/without class size: 10/4 bytes
 *   Specialization {@link JSArrayDeleteRangeNode#doUncached}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(JSArrayDeleteRangeNode.class)
@SuppressWarnings("javadoc")
public final class JSArrayDeleteRangeNodeGen extends JSArrayDeleteRangeNode implements Introspection.Provider {

    static final ReferenceField<DenseArrayData> DENSE_ARRAY_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "denseArray_cache", DenseArrayData.class);
    static final ReferenceField<SparseArrayData> SPARSE_ARRAY_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "sparseArray_cache", SparseArrayData.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSArrayDeleteRangeNode#denseArray}
     *   1: SpecializationActive {@link JSArrayDeleteRangeNode#doUncached}
     *   2: SpecializationActive {@link JSArrayDeleteRangeNode#sparseArray}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSArrayDeleteRangeNode#denseArray}
     *   Parameter: {@link DeletePropertyNode} deletePropertyNode</pre>
     */
    @Child private DeletePropertyNode deleteProperty;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSArrayDeleteRangeNode#sparseArray}
     *   Parameter: {@link JSArrayNextElementIndexNode} nextElementIndexNode</pre>
     */
    @Child private JSArrayNextElementIndexNode nextElementIndex;
    @UnsafeAccessedField @CompilationFinal private DenseArrayData denseArray_cache;
    @UnsafeAccessedField @CompilationFinal private SparseArrayData sparseArray_cache;

    private JSArrayDeleteRangeNodeGen(JSContext context, boolean orThrow) {
        super(context, orThrow);
    }

    @ExplodeLoop
    @Override
    public void execute(JSDynamicObject arg0Value, ScriptArray arg1Value, long arg2Value, long arg3Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.denseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode)] || SpecializationActive[JSArrayDeleteRangeNode.sparseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode, JSArrayNextElementIndexNode)] || SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.denseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode)] */) {
                DenseArrayData s0_ = this.denseArray_cache;
                while (s0_ != null) {
                    {
                        DeletePropertyNode deleteProperty_ = this.deleteProperty;
                        if (deleteProperty_ != null) {
                            if ((s0_.cachedArrayType_.isInstance(arg1Value))) {
                                assert DSLSupport.assertIdempotence((!(s0_.cachedArrayType_.isHolesType())));
                                denseArray(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedArrayType_, deleteProperty_);
                                return;
                            }
                        }
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.sparseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
                SparseArrayData s1_ = this.sparseArray_cache;
                while (s1_ != null) {
                    {
                        DeletePropertyNode deleteProperty_1 = this.deleteProperty;
                        if (deleteProperty_1 != null) {
                            JSArrayNextElementIndexNode nextElementIndex_ = this.nextElementIndex;
                            if (nextElementIndex_ != null) {
                                if ((s1_.cachedArrayType_.isInstance(arg1Value))) {
                                    assert DSLSupport.assertIdempotence((s1_.cachedArrayType_.isHolesType()));
                                    sparseArray(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedArrayType_, deleteProperty_1, nextElementIndex_);
                                    return;
                                }
                            }
                        }
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
                {
                    DeletePropertyNode deleteProperty_2 = this.deleteProperty;
                    if (deleteProperty_2 != null) {
                        JSArrayNextElementIndexNode nextElementIndex_1 = this.nextElementIndex;
                        if (nextElementIndex_1 != null) {
                            doUncached(arg0Value, arg1Value, arg2Value, arg3Value, deleteProperty_2, nextElementIndex_1);
                            return;
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        return;
    }

    private void executeAndSpecialize(JSDynamicObject arg0Value, ScriptArray arg1Value, long arg2Value, long arg3Value) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
            while (true) {
                int count0_ = 0;
                DenseArrayData s0_ = DENSE_ARRAY_CACHE_UPDATER.getVolatile(this);
                DenseArrayData s0_original = s0_;
                while (s0_ != null) {
                    {
                        DeletePropertyNode deleteProperty_ = this.deleteProperty;
                        if (deleteProperty_ != null) {
                            if ((s0_.cachedArrayType_.isInstance(arg1Value))) {
                                assert DSLSupport.assertIdempotence((!(s0_.cachedArrayType_.isHolesType())));
                                break;
                            }
                        }
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    {
                        ScriptArray cachedArrayType__ = (arg1Value);
                        if ((cachedArrayType__.isInstance(arg1Value)) && (!(cachedArrayType__.isHolesType())) && count0_ < (5)) {
                            s0_ = new DenseArrayData(s0_original);
                            s0_.cachedArrayType_ = cachedArrayType__;
                            DeletePropertyNode deleteProperty_;
                            DeletePropertyNode deleteProperty__shared = this.deleteProperty;
                            if (deleteProperty__shared != null) {
                                deleteProperty_ = deleteProperty__shared;
                            } else {
                                deleteProperty_ = this.insert((DeletePropertyNode.create(orThrow, context)));
                                if (deleteProperty_ == null) {
                                    throw new IllegalStateException("Specialization 'denseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode)' contains a shared cache with name 'deletePropertyNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.deleteProperty == null) {
                                this.deleteProperty = deleteProperty_;
                            }
                            if (!DENSE_ARRAY_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[JSArrayDeleteRangeNode.denseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s0_ != null) {
                    denseArray(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedArrayType_, this.deleteProperty);
                    return;
                }
                break;
            }
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
            while (true) {
                int count1_ = 0;
                SparseArrayData s1_ = SPARSE_ARRAY_CACHE_UPDATER.getVolatile(this);
                SparseArrayData s1_original = s1_;
                while (s1_ != null) {
                    {
                        DeletePropertyNode deleteProperty_1 = this.deleteProperty;
                        if (deleteProperty_1 != null) {
                            JSArrayNextElementIndexNode nextElementIndex_ = this.nextElementIndex;
                            if (nextElementIndex_ != null) {
                                if ((s1_.cachedArrayType_.isInstance(arg1Value))) {
                                    assert DSLSupport.assertIdempotence((s1_.cachedArrayType_.isHolesType()));
                                    break;
                                }
                            }
                        }
                    }
                    count1_++;
                    s1_ = s1_.next_;
                }
                if (s1_ == null) {
                    {
                        ScriptArray cachedArrayType__1 = (arg1Value);
                        if ((cachedArrayType__1.isInstance(arg1Value)) && (cachedArrayType__1.isHolesType()) && count1_ < (5)) {
                            s1_ = new SparseArrayData(s1_original);
                            s1_.cachedArrayType_ = cachedArrayType__1;
                            DeletePropertyNode deleteProperty_1;
                            DeletePropertyNode deleteProperty_1_shared = this.deleteProperty;
                            if (deleteProperty_1_shared != null) {
                                deleteProperty_1 = deleteProperty_1_shared;
                            } else {
                                deleteProperty_1 = this.insert((DeletePropertyNode.create(orThrow, context)));
                                if (deleteProperty_1 == null) {
                                    throw new IllegalStateException("Specialization 'sparseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode, JSArrayNextElementIndexNode)' contains a shared cache with name 'deletePropertyNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.deleteProperty == null) {
                                this.deleteProperty = deleteProperty_1;
                            }
                            JSArrayNextElementIndexNode nextElementIndex_;
                            JSArrayNextElementIndexNode nextElementIndex__shared = this.nextElementIndex;
                            if (nextElementIndex__shared != null) {
                                nextElementIndex_ = nextElementIndex__shared;
                            } else {
                                nextElementIndex_ = this.insert((JSArrayNextElementIndexNode.create(context)));
                                if (nextElementIndex_ == null) {
                                    throw new IllegalStateException("Specialization 'sparseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode, JSArrayNextElementIndexNode)' contains a shared cache with name 'nextElementIndexNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.nextElementIndex == null) {
                                this.nextElementIndex = nextElementIndex_;
                            }
                            if (!SPARSE_ARRAY_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b100 /* add SpecializationActive[JSArrayDeleteRangeNode.sparseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode, JSArrayNextElementIndexNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s1_ != null) {
                    sparseArray(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedArrayType_, this.deleteProperty, this.nextElementIndex);
                    return;
                }
                break;
            }
        }
        DeletePropertyNode deleteProperty_2;
        DeletePropertyNode deleteProperty_2_shared = this.deleteProperty;
        if (deleteProperty_2_shared != null) {
            deleteProperty_2 = deleteProperty_2_shared;
        } else {
            deleteProperty_2 = this.insert((DeletePropertyNode.create(orThrow, context)));
            if (deleteProperty_2 == null) {
                throw new IllegalStateException("Specialization 'doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)' contains a shared cache with name 'deletePropertyNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.deleteProperty == null) {
            VarHandle.storeStoreFence();
            this.deleteProperty = deleteProperty_2;
        }
        JSArrayNextElementIndexNode nextElementIndex_1;
        JSArrayNextElementIndexNode nextElementIndex_1_shared = this.nextElementIndex;
        if (nextElementIndex_1_shared != null) {
            nextElementIndex_1 = nextElementIndex_1_shared;
        } else {
            nextElementIndex_1 = this.insert((JSArrayNextElementIndexNode.create(context)));
            if (nextElementIndex_1 == null) {
                throw new IllegalStateException("Specialization 'doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)' contains a shared cache with name 'nextElementIndexNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.nextElementIndex == null) {
            VarHandle.storeStoreFence();
            this.nextElementIndex = nextElementIndex_1;
        }
        this.denseArray_cache = null;
        this.sparseArray_cache = null;
        state_0 = state_0 & 0xfffffffa /* remove SpecializationActive[JSArrayDeleteRangeNode.denseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode)], SpecializationActive[JSArrayDeleteRangeNode.sparseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode, JSArrayNextElementIndexNode)] */;
        state_0 = state_0 | 0b10 /* add SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */;
        this.state_0_ = state_0;
        doUncached(arg0Value, arg1Value, arg2Value, arg3Value, deleteProperty_2, nextElementIndex_1);
        return;
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                DenseArrayData s0_ = this.denseArray_cache;
                SparseArrayData s1_ = this.sparseArray_cache;
                if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "denseArray";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.denseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode)] */) {
            {
                DeletePropertyNode deleteProperty_ = this.deleteProperty;
                if (deleteProperty_ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    DenseArrayData s0_ = this.denseArray_cache;
                    while (s0_ != null) {
                        cached.add(Arrays.<Object>asList(s0_.cachedArrayType_, this.deleteProperty));
                        s0_ = s0_.next_;
                    }
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "sparseArray";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.sparseArray(JSDynamicObject, ScriptArray, long, long, ScriptArray, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
            {
                DeletePropertyNode deleteProperty_1 = this.deleteProperty;
                if (deleteProperty_1 != null) {
                    JSArrayNextElementIndexNode nextElementIndex_ = this.nextElementIndex;
                    if (nextElementIndex_ != null) {
                        s[1] = (byte)0b01 /* active */;
                        ArrayList<Object> cached = new ArrayList<>();
                        SparseArrayData s1_ = this.sparseArray_cache;
                        while (s1_ != null) {
                            cached.add(Arrays.<Object>asList(s1_.cachedArrayType_, this.deleteProperty, this.nextElementIndex));
                            s1_ = s1_.next_;
                        }
                        s[2] = cached;
                    }
                }
            }
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUncached";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayDeleteRangeNode.doUncached(JSDynamicObject, ScriptArray, long, long, DeletePropertyNode, JSArrayNextElementIndexNode)] */) {
            {
                DeletePropertyNode deleteProperty_2 = this.deleteProperty;
                if (deleteProperty_2 != null) {
                    JSArrayNextElementIndexNode nextElementIndex_1 = this.nextElementIndex;
                    if (nextElementIndex_1 != null) {
                        s[1] = (byte)0b01 /* active */;
                        ArrayList<Object> cached = new ArrayList<>();
                        cached.add(Arrays.<Object>asList(this.deleteProperty, this.nextElementIndex));
                        s[2] = cached;
                    }
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static JSArrayDeleteRangeNode create(JSContext context, boolean orThrow) {
        return new JSArrayDeleteRangeNodeGen(context, orThrow);
    }

    @GeneratedBy(JSArrayDeleteRangeNode.class)
    @DenyReplace
    private static final class DenseArrayData implements SpecializationDataNode {

        @CompilationFinal final DenseArrayData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSArrayDeleteRangeNode#denseArray}
         *   Parameter: {@link ScriptArray} cachedArrayType</pre>
         */
        @CompilationFinal ScriptArray cachedArrayType_;

        DenseArrayData(DenseArrayData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSArrayDeleteRangeNode.class)
    @DenyReplace
    private static final class SparseArrayData implements SpecializationDataNode {

        @CompilationFinal final SparseArrayData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSArrayDeleteRangeNode#sparseArray}
         *   Parameter: {@link ScriptArray} cachedArrayType</pre>
         */
        @CompilationFinal ScriptArray cachedArrayType_;

        SparseArrayData(SparseArrayData next_) {
            this.next_ = next_;
        }

    }
}
