// CheckStyle: start generated
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.FromCodePointNode;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.interop.InteropFunction;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link ImportValueNode#fromInt}
 *     Activation probability: 0.10588
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ImportValueNode#fromString}
 *     Activation probability: 0.10000
 *     With/without class size: 6/4 bytes
 *   Specialization {@link ImportValueNode#fromTruffleString}
 *     Activation probability: 0.09412
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ImportValueNode#fromBoolean}
 *     Activation probability: 0.08824
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ImportValueNode#fromBigInt}
 *     Activation probability: 0.08235
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromLong}
 *     Activation probability: 0.07647
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromDouble}
 *     Activation probability: 0.07059
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromNumber(byte)}
 *     Activation probability: 0.06471
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromNumber(short)}
 *     Activation probability: 0.05882
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromNumber(float)}
 *     Activation probability: 0.05294
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromChar}
 *     Activation probability: 0.04706
 *     With/without class size: 4/4 bytes
 *   Specialization {@link ImportValueNode#fromDynamicObject}
 *     Activation probability: 0.04118
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromInteropFunction}
 *     Activation probability: 0.03529
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromJSException}
 *     Activation probability: 0.02941
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromException}
 *     Activation probability: 0.02353
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fromTruffleObject}
 *     Activation probability: 0.01765
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ImportValueNode#fallbackCase}
 *     Activation probability: 0.01176
 *     With/without class size: 4/4 bytes
 * </pre>
 */
@GeneratedBy(ImportValueNode.class)
@SuppressWarnings("javadoc")
public final class ImportValueNodeGen extends ImportValueNode implements Introspection.Provider {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ImportValueNode#fromInt}
     *   1: SpecializationActive {@link ImportValueNode#fromString}
     *   2: SpecializationActive {@link ImportValueNode#fromTruffleString}
     *   3: SpecializationActive {@link ImportValueNode#fromBoolean}
     *   4: SpecializationActive {@link ImportValueNode#fromBigInt}
     *   5: SpecializationActive {@link ImportValueNode#fromLong}
     *   6: SpecializationActive {@link ImportValueNode#fromDouble}
     *   7: SpecializationActive {@link ImportValueNode#fromNumber(byte)}
     *   8: SpecializationActive {@link ImportValueNode#fromNumber(short)}
     *   9: SpecializationActive {@link ImportValueNode#fromNumber(float)}
     *   10: SpecializationActive {@link ImportValueNode#fromChar}
     *   11: SpecializationActive {@link ImportValueNode#fromDynamicObject}
     *   12: SpecializationActive {@link ImportValueNode#fromInteropFunction}
     *   13: SpecializationActive {@link ImportValueNode#fromJSException}
     *   14: SpecializationActive {@link ImportValueNode#fromException}
     *   15: SpecializationActive {@link ImportValueNode#fromTruffleObject}
     *   16: SpecializationActive {@link ImportValueNode#fallbackCase}
     *   17-19: ImplicitCast[type=double, index=0]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ImportValueNode#fromTruffleString}
     *   Parameter: {@link SwitchEncodingNode} switchEncodingNode</pre>
     */
    @Child private SwitchEncodingNode switchEncodingNode;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ImportValueNode#fromString}
     *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre>
     */
    @Child private FromJavaStringNode fromString_fromJavaStringNode_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ImportValueNode#fromChar}
     *   Parameter: {@link FromCodePointNode} fromCodePointNode</pre>
     */
    @Child private FromCodePointNode fromChar_fromCodePointNode_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ImportValueNode#fallbackCase}
     *   Parameter: {@link InteropLibrary} interop</pre>
     */
    @Child private InteropLibrary fallback_interop_;

    private ImportValueNodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ImportValueNode.fromString(String, FromJavaStringNode)] */) && arg0Value instanceof String) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ImportValueNode.fromTruffleString(TruffleString, SwitchEncodingNode)] */) && arg0Value instanceof TruffleString) {
            return false;
        }
        if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ImportValueNode.fromBoolean(boolean)] */) && arg0Value instanceof Boolean) {
            return false;
        }
        if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[ImportValueNode.fromBigInt(BigInt)] */) && arg0Value instanceof BigInt) {
            return false;
        }
        if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[ImportValueNode.fromLong(long)] */) && arg0Value instanceof Long) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(byte)] */) && arg0Value instanceof Byte) {
            return false;
        }
        if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(short)] */) && arg0Value instanceof Short) {
            return false;
        }
        if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(float)] */) && arg0Value instanceof Float) {
            return false;
        }
        if (!((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ImportValueNode.fromChar(char, FromCodePointNode)] */) && arg0Value instanceof Character) {
            return false;
        }
        if (!((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ImportValueNode.fromDynamicObject(JSDynamicObject)] */) && arg0Value instanceof JSDynamicObject) {
            return false;
        }
        if (!((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromInteropFunction(InteropFunction)] */) && arg0Value instanceof InteropFunction) {
            return false;
        }
        if (!((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromJSException(JSException)] */) && arg0Value instanceof JSException) {
            return false;
        }
        if (!((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromException(UserScriptException)] */) && arg0Value instanceof UserScriptException) {
            return false;
        }
        if (arg0Value instanceof TruffleObject) {
            TruffleObject arg0Value_ = (TruffleObject) arg0Value;
            if ((!(ImportValueNode.isSpecial(arg0Value_)))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1ffff) != 0 /* is SpecializationActive[ImportValueNode.fromInt(int)] || SpecializationActive[ImportValueNode.fromString(String, FromJavaStringNode)] || SpecializationActive[ImportValueNode.fromTruffleString(TruffleString, SwitchEncodingNode)] || SpecializationActive[ImportValueNode.fromBoolean(boolean)] || SpecializationActive[ImportValueNode.fromBigInt(BigInt)] || SpecializationActive[ImportValueNode.fromLong(long)] || SpecializationActive[ImportValueNode.fromDouble(double)] || SpecializationActive[ImportValueNode.fromNumber(byte)] || SpecializationActive[ImportValueNode.fromNumber(short)] || SpecializationActive[ImportValueNode.fromNumber(float)] || SpecializationActive[ImportValueNode.fromChar(char, FromCodePointNode)] || SpecializationActive[ImportValueNode.fromDynamicObject(JSDynamicObject)] || SpecializationActive[ImportValueNode.fromInteropFunction(InteropFunction)] || SpecializationActive[ImportValueNode.fromJSException(JSException)] || SpecializationActive[ImportValueNode.fromException(UserScriptException)] || SpecializationActive[ImportValueNode.fromTruffleObject(TruffleObject)] || SpecializationActive[ImportValueNode.fallbackCase(Object, InteropLibrary, SwitchEncodingNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[ImportValueNode.fromInt(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ImportValueNode.fromInt(arg0Value_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ImportValueNode.fromString(String, FromJavaStringNode)] */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                {
                    FromJavaStringNode fromJavaStringNode__ = this.fromString_fromJavaStringNode_;
                    if (fromJavaStringNode__ != null) {
                        return ImportValueNode.fromString(arg0Value_, fromJavaStringNode__);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ImportValueNode.fromTruffleString(TruffleString, SwitchEncodingNode)] */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                {
                    SwitchEncodingNode switchEncodingNode_ = this.switchEncodingNode;
                    if (switchEncodingNode_ != null) {
                        return ImportValueNode.fromTruffleString(arg0Value_, switchEncodingNode_);
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ImportValueNode.fromBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return ImportValueNode.fromBoolean(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ImportValueNode.fromBigInt(BigInt)] */ && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return ImportValueNode.fromBigInt(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ImportValueNode.fromLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ImportValueNode.fromLong(arg0Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ImportValueNode.fromDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                return ImportValueNode.fromDouble(arg0Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(byte)] */ && arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(short)] */ && arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ImportValueNode.fromChar(char, FromCodePointNode)] */ && arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                {
                    FromCodePointNode fromCodePointNode__ = this.fromChar_fromCodePointNode_;
                    if (fromCodePointNode__ != null) {
                        return ImportValueNode.fromChar(arg0Value_, fromCodePointNode__);
                    }
                }
            }
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ImportValueNode.fromDynamicObject(JSDynamicObject)] */ && arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
                return ImportValueNode.fromDynamicObject(arg0Value_);
            }
            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromInteropFunction(InteropFunction)] */ && arg0Value instanceof InteropFunction) {
                InteropFunction arg0Value_ = (InteropFunction) arg0Value;
                return ImportValueNode.fromInteropFunction(arg0Value_);
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromJSException(JSException)] */ && arg0Value instanceof JSException) {
                JSException arg0Value_ = (JSException) arg0Value;
                return ImportValueNode.fromJSException(arg0Value_);
            }
            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromException(UserScriptException)] */ && arg0Value instanceof UserScriptException) {
                UserScriptException arg0Value_ = (UserScriptException) arg0Value;
                return ImportValueNode.fromException(arg0Value_);
            }
            if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromTruffleObject(TruffleObject)] */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                if ((!(ImportValueNode.isSpecial(arg0Value_)))) {
                    return ImportValueNode.fromTruffleObject(arg0Value_);
                }
            }
            if ((state_0 & 0x10000) != 0 /* is SpecializationActive[ImportValueNode.fallbackCase(Object, InteropLibrary, SwitchEncodingNode)] */) {
                {
                    InteropLibrary interop__ = this.fallback_interop_;
                    if (interop__ != null) {
                        SwitchEncodingNode switchEncodingNode_1 = this.switchEncodingNode;
                        if (switchEncodingNode_1 != null) {
                            if (fallbackGuard_(state_0, arg0Value)) {
                                return ImportValueNode.fallbackCase(arg0Value, interop__, switchEncodingNode_1);
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[ImportValueNode.fromInt(int)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromInt(arg0Value_);
        }
        if (arg0Value instanceof String) {
            String arg0Value_ = (String) arg0Value;
            FromJavaStringNode fromJavaStringNode__ = this.insert((FromJavaStringNode.create()));
            Objects.requireNonNull(fromJavaStringNode__, "Specialization 'fromString(String, FromJavaStringNode)' cache 'fromJavaStringNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromString_fromJavaStringNode_ = fromJavaStringNode__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ImportValueNode.fromString(String, FromJavaStringNode)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromString(arg0Value_, fromJavaStringNode__);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString) arg0Value;
            SwitchEncodingNode switchEncodingNode_;
            SwitchEncodingNode switchEncodingNode__shared = this.switchEncodingNode;
            if (switchEncodingNode__shared != null) {
                switchEncodingNode_ = switchEncodingNode__shared;
            } else {
                switchEncodingNode_ = this.insert((SwitchEncodingNode.create()));
                if (switchEncodingNode_ == null) {
                    throw new IllegalStateException("Specialization 'fromTruffleString(TruffleString, SwitchEncodingNode)' contains a shared cache with name 'switchEncodingNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.switchEncodingNode == null) {
                VarHandle.storeStoreFence();
                this.switchEncodingNode = switchEncodingNode_;
            }
            state_0 = state_0 | 0b100 /* add SpecializationActive[ImportValueNode.fromTruffleString(TruffleString, SwitchEncodingNode)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromTruffleString(arg0Value_, switchEncodingNode_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[ImportValueNode.fromBoolean(boolean)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ImportValueNode.fromBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromBigInt(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[ImportValueNode.fromLong(long)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromLong(arg0Value_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 = (state_0 | (doubleCast0 << 17) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[ImportValueNode.fromDouble(double)] */;
                this.state_0_ = state_0;
                return ImportValueNode.fromDouble(arg0Value_);
            }
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (byte) arg0Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[ImportValueNode.fromNumber(byte)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromNumber(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (short) arg0Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ImportValueNode.fromNumber(short)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromNumber(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ImportValueNode.fromNumber(float)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromNumber(arg0Value_);
        }
        if (arg0Value instanceof Character) {
            char arg0Value_ = (char) arg0Value;
            FromCodePointNode fromCodePointNode__ = this.insert((FromCodePointNode.create()));
            Objects.requireNonNull(fromCodePointNode__, "Specialization 'fromChar(char, FromCodePointNode)' cache 'fromCodePointNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fromChar_fromCodePointNode_ = fromCodePointNode__;
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ImportValueNode.fromChar(char, FromCodePointNode)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromChar(arg0Value_, fromCodePointNode__);
        }
        if (arg0Value instanceof JSDynamicObject) {
            JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ImportValueNode.fromDynamicObject(JSDynamicObject)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromDynamicObject(arg0Value_);
        }
        if (arg0Value instanceof InteropFunction) {
            InteropFunction arg0Value_ = (InteropFunction) arg0Value;
            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ImportValueNode.fromInteropFunction(InteropFunction)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromInteropFunction(arg0Value_);
        }
        if (arg0Value instanceof JSException) {
            JSException arg0Value_ = (JSException) arg0Value;
            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[ImportValueNode.fromJSException(JSException)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromJSException(arg0Value_);
        }
        if (arg0Value instanceof UserScriptException) {
            UserScriptException arg0Value_ = (UserScriptException) arg0Value;
            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[ImportValueNode.fromException(UserScriptException)] */;
            this.state_0_ = state_0;
            return ImportValueNode.fromException(arg0Value_);
        }
        if (arg0Value instanceof TruffleObject) {
            TruffleObject arg0Value_ = (TruffleObject) arg0Value;
            if ((!(ImportValueNode.isSpecial(arg0Value_)))) {
                state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[ImportValueNode.fromTruffleObject(TruffleObject)] */;
                this.state_0_ = state_0;
                return ImportValueNode.fromTruffleObject(arg0Value_);
            }
        }
        InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
        Objects.requireNonNull(interop__, "Specialization 'fallbackCase(Object, InteropLibrary, SwitchEncodingNode)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.fallback_interop_ = interop__;
        SwitchEncodingNode switchEncodingNode_1;
        SwitchEncodingNode switchEncodingNode_1_shared = this.switchEncodingNode;
        if (switchEncodingNode_1_shared != null) {
            switchEncodingNode_1 = switchEncodingNode_1_shared;
        } else {
            switchEncodingNode_1 = this.insert((SwitchEncodingNode.create()));
            if (switchEncodingNode_1 == null) {
                throw new IllegalStateException("Specialization 'fallbackCase(Object, InteropLibrary, SwitchEncodingNode)' contains a shared cache with name 'switchEncodingNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.switchEncodingNode == null) {
            VarHandle.storeStoreFence();
            this.switchEncodingNode = switchEncodingNode_1;
        }
        state_0 = state_0 | 0x10000 /* add SpecializationActive[ImportValueNode.fallbackCase(Object, InteropLibrary, SwitchEncodingNode)] */;
        this.state_0_ = state_0;
        return ImportValueNode.fallbackCase(arg0Value, interop__, switchEncodingNode_1);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1ffff) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0x1ffff) & ((state_0 & 0x1ffff) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[18];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "fromInt";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ImportValueNode.fromInt(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "fromString";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ImportValueNode.fromString(String, FromJavaStringNode)] */) {
            {
                FromJavaStringNode fromJavaStringNode__ = this.fromString_fromJavaStringNode_;
                if (fromJavaStringNode__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.fromString_fromJavaStringNode_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "fromTruffleString";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ImportValueNode.fromTruffleString(TruffleString, SwitchEncodingNode)] */) {
            {
                SwitchEncodingNode switchEncodingNode_ = this.switchEncodingNode;
                if (switchEncodingNode_ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.switchEncodingNode));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "fromBoolean";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ImportValueNode.fromBoolean(boolean)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "fromBigInt";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ImportValueNode.fromBigInt(BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "fromLong";
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ImportValueNode.fromLong(long)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "fromDouble";
        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ImportValueNode.fromDouble(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(byte)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(short)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ImportValueNode.fromNumber(float)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "fromChar";
        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ImportValueNode.fromChar(char, FromCodePointNode)] */) {
            {
                FromCodePointNode fromCodePointNode__ = this.fromChar_fromCodePointNode_;
                if (fromCodePointNode__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.fromChar_fromCodePointNode_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "fromDynamicObject";
        if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ImportValueNode.fromDynamicObject(JSDynamicObject)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "fromInteropFunction";
        if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromInteropFunction(InteropFunction)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "fromJSException";
        if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromJSException(JSException)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "fromException";
        if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromException(UserScriptException)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "fromTruffleObject";
        if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[ImportValueNode.fromTruffleObject(TruffleObject)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[16] = s;
        s = new Object[3];
        s[0] = "fallbackCase";
        if ((state_0 & 0x10000) != 0 /* is SpecializationActive[ImportValueNode.fallbackCase(Object, InteropLibrary, SwitchEncodingNode)] */) {
            {
                InteropLibrary interop__ = this.fallback_interop_;
                if (interop__ != null) {
                    SwitchEncodingNode switchEncodingNode_1 = this.switchEncodingNode;
                    if (switchEncodingNode_1 != null) {
                        s[1] = (byte)0b01 /* active */;
                        ArrayList<Object> cached = new ArrayList<>();
                        cached.add(Arrays.<Object>asList(this.fallback_interop_, this.switchEncodingNode));
                        s[2] = cached;
                    }
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[17] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static ImportValueNode create() {
        return new ImportValueNodeGen();
    }

    @NeverDefault
    public static ImportValueNode getUncached() {
        return ImportValueNodeGen.UNCACHED;
    }

    @GeneratedBy(ImportValueNode.class)
    @DenyReplace
    private static final class Uncached extends ImportValueNode {

        @TruffleBoundary
        @Override
        public Object executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ImportValueNode.fromInt(arg0Value_);
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return ImportValueNode.fromString(arg0Value_, (FromJavaStringNode.getUncached()));
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                return ImportValueNode.fromTruffleString(arg0Value_, (SwitchEncodingNode.getUncached()));
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return ImportValueNode.fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return ImportValueNode.fromBigInt(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ImportValueNode.fromLong(arg0Value_);
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return ImportValueNode.fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (byte) arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (short) arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = (char) arg0Value;
                return ImportValueNode.fromChar(arg0Value_, (FromCodePointNode.getUncached()));
            }
            if (arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
                return ImportValueNode.fromDynamicObject(arg0Value_);
            }
            if (arg0Value instanceof InteropFunction) {
                InteropFunction arg0Value_ = (InteropFunction) arg0Value;
                return ImportValueNode.fromInteropFunction(arg0Value_);
            }
            if (arg0Value instanceof JSException) {
                JSException arg0Value_ = (JSException) arg0Value;
                return ImportValueNode.fromJSException(arg0Value_);
            }
            if (arg0Value instanceof UserScriptException) {
                UserScriptException arg0Value_ = (UserScriptException) arg0Value;
                return ImportValueNode.fromException(arg0Value_);
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                if ((!(ImportValueNode.isSpecial(arg0Value_)))) {
                    return ImportValueNode.fromTruffleObject(arg0Value_);
                }
            }
            return ImportValueNode.fallbackCase(arg0Value, (INTEROP_LIBRARY_.getUncached()), (SwitchEncodingNode.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
