// CheckStyle: start generated
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSArrayToDenseObjectArrayNode#fromDenseArray}
 *     Activation probability: 0.48333
 *     With/without class size: 13/4 bytes
 *   Specialization {@link JSArrayToDenseObjectArrayNode#fromSparseArray}
 *     Activation probability: 0.33333
 *     With/without class size: 12/4 bytes
 *   Specialization {@link JSArrayToDenseObjectArrayNode#doUncached}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(JSArrayToDenseObjectArrayNode.class)
@SuppressWarnings("javadoc")
public final class JSArrayToDenseObjectArrayNodeGen extends JSArrayToDenseObjectArrayNode implements Introspection.Provider {

    private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    static final ReferenceField<FromDenseArrayData> FROM_DENSE_ARRAY_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fromDenseArray_cache", FromDenseArrayData.class);
    static final ReferenceField<FromSparseArrayData> FROM_SPARSE_ARRAY_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "fromSparseArray_cache", FromSparseArrayData.class);
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSArrayToDenseObjectArrayNode#fromSparseArray}
     *   Parameter: {@link InlinedBranchProfile} growProfile
     *   Inline method: {@link InlinedBranchProfile#inline}</pre>
     */
    private static final InlinedBranchProfile INLINED_GROW_BRANCH = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(3, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSArrayToDenseObjectArrayNode#fromDenseArray}
     *   1: SpecializationActive {@link JSArrayToDenseObjectArrayNode#doUncached}
     *   2: SpecializationActive {@link JSArrayToDenseObjectArrayNode#fromSparseArray}
     *   3: InlinedCache
     *        Specialization: {@link JSArrayToDenseObjectArrayNode#fromSparseArray}
     *        Parameter: {@link InlinedBranchProfile} growProfile
     *        Inline method: {@link InlinedBranchProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSArrayToDenseObjectArrayNode#fromDenseArray}
     *   Parameter: {@link ReadElementNode} readNode</pre>
     */
    @Child private ReadElementNode readElement;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSArrayToDenseObjectArrayNode#fromSparseArray}
     *   Parameter: {@link JSArrayNextElementIndexNode} nextElementIndexNode</pre>
     */
    @Child private JSArrayNextElementIndexNode nextElementIndex;
    @UnsafeAccessedField @CompilationFinal private FromDenseArrayData fromDenseArray_cache;
    @UnsafeAccessedField @Child private FromSparseArrayData fromSparseArray_cache;

    private JSArrayToDenseObjectArrayNodeGen(JSContext context) {
        super(context);
    }

    @ExplodeLoop
    @Override
    public Object[] executeObjectArray(JSDynamicObject arg0Value, ScriptArray arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.fromDenseArray(JSDynamicObject, ScriptArray, long, ScriptArray, ReadElementNode)] || SpecializationActive[JSArrayToDenseObjectArrayNode.fromSparseArray(JSDynamicObject, ScriptArray, long, ScriptArray, Node, JSArrayNextElementIndexNode, InlinedBranchProfile)] || SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.fromDenseArray(JSDynamicObject, ScriptArray, long, ScriptArray, ReadElementNode)] */) {
                FromDenseArrayData s0_ = this.fromDenseArray_cache;
                while (s0_ != null) {
                    {
                        ReadElementNode readElement_ = this.readElement;
                        if (readElement_ != null) {
                            if ((s0_.cachedArrayType_.isInstance(arg1Value))) {
                                assert DSLSupport.assertIdempotence((!(s0_.cachedArrayType_.isHolesType())));
                                if ((!(s0_.cachedArrayType_.hasHoles(arg0Value))) && (s0_.cachedArrayType_.firstElementIndex(arg0Value) == 0)) {
                                    return JSArrayToDenseObjectArrayNode.fromDenseArray(arg0Value, arg1Value, arg2Value, s0_.cachedArrayType_, readElement_);
                                }
                            }
                        }
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.fromSparseArray(JSDynamicObject, ScriptArray, long, ScriptArray, Node, JSArrayNextElementIndexNode, InlinedBranchProfile)] */) {
                FromSparseArrayData s1_ = this.fromSparseArray_cache;
                while (s1_ != null) {
                    {
                        JSArrayNextElementIndexNode nextElementIndex_ = this.nextElementIndex;
                        if (nextElementIndex_ != null) {
                            if ((s1_.cachedArrayType_.isInstance(arg1Value)) && (s1_.cachedArrayType_.isHolesType() || s1_.cachedArrayType_.hasHoles(arg0Value))) {
                                Node node__ = (this);
                                return JSArrayToDenseObjectArrayNode.fromSparseArray(arg0Value, arg1Value, arg2Value, s1_.cachedArrayType_, node__, nextElementIndex_, INLINED_GROW_BRANCH);
                            }
                        }
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */) {
                {
                    JSArrayNextElementIndexNode nextElementIndex_1 = this.nextElementIndex;
                    if (nextElementIndex_1 != null) {
                        ReadElementNode readElement_1 = this.readElement;
                        if (readElement_1 != null) {
                            return doUncached(arg0Value, arg1Value, arg2Value, nextElementIndex_1, readElement_1, INLINED_GROW_BRANCH);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object[] executeAndSpecialize(JSDynamicObject arg0Value, ScriptArray arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */) {
            while (true) {
                int count0_ = 0;
                FromDenseArrayData s0_ = FROM_DENSE_ARRAY_CACHE_UPDATER.getVolatile(this);
                FromDenseArrayData s0_original = s0_;
                while (s0_ != null) {
                    {
                        ReadElementNode readElement_ = this.readElement;
                        if (readElement_ != null) {
                            if ((s0_.cachedArrayType_.isInstance(arg1Value))) {
                                assert DSLSupport.assertIdempotence((!(s0_.cachedArrayType_.isHolesType())));
                                if ((!(s0_.cachedArrayType_.hasHoles(arg0Value))) && (s0_.cachedArrayType_.firstElementIndex(arg0Value) == 0)) {
                                    break;
                                }
                            }
                        }
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    {
                        ScriptArray cachedArrayType__ = (arg1Value);
                        if ((cachedArrayType__.isInstance(arg1Value)) && (!(cachedArrayType__.isHolesType())) && (!(cachedArrayType__.hasHoles(arg0Value))) && (cachedArrayType__.firstElementIndex(arg0Value) == 0) && count0_ < (5)) {
                            s0_ = new FromDenseArrayData(s0_original);
                            s0_.cachedArrayType_ = cachedArrayType__;
                            ReadElementNode readElement_;
                            ReadElementNode readElement__shared = this.readElement;
                            if (readElement__shared != null) {
                                readElement_ = readElement__shared;
                            } else {
                                readElement_ = this.insert((ReadElementNode.create(context)));
                                if (readElement_ == null) {
                                    throw new IllegalStateException("Specialization 'fromDenseArray(JSDynamicObject, ScriptArray, long, ScriptArray, ReadElementNode)' contains a shared cache with name 'readNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.readElement == null) {
                                this.readElement = readElement_;
                            }
                            if (!FROM_DENSE_ARRAY_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[JSArrayToDenseObjectArrayNode.fromDenseArray(JSDynamicObject, ScriptArray, long, ScriptArray, ReadElementNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s0_ != null) {
                    return JSArrayToDenseObjectArrayNode.fromDenseArray(arg0Value, arg1Value, arg2Value, s0_.cachedArrayType_, this.readElement);
                }
                break;
            }
        }
        {
            Node node__ = null;
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */) {
                while (true) {
                    int count1_ = 0;
                    FromSparseArrayData s1_ = FROM_SPARSE_ARRAY_CACHE_UPDATER.getVolatile(this);
                    FromSparseArrayData s1_original = s1_;
                    while (s1_ != null) {
                        {
                            JSArrayNextElementIndexNode nextElementIndex_ = this.nextElementIndex;
                            if (nextElementIndex_ != null) {
                                if ((s1_.cachedArrayType_.isInstance(arg1Value)) && (s1_.cachedArrayType_.isHolesType() || s1_.cachedArrayType_.hasHoles(arg0Value))) {
                                    node__ = (this);
                                    break;
                                }
                            }
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        {
                            ScriptArray cachedArrayType__1 = (arg1Value);
                            if ((cachedArrayType__1.isInstance(arg1Value)) && (cachedArrayType__1.isHolesType() || cachedArrayType__1.hasHoles(arg0Value)) && count1_ < (5)) {
                                s1_ = this.insert(new FromSparseArrayData(s1_original));
                                s1_.cachedArrayType_ = cachedArrayType__1;
                                node__ = (this);
                                JSArrayNextElementIndexNode nextElementIndex_;
                                JSArrayNextElementIndexNode nextElementIndex__shared = this.nextElementIndex;
                                if (nextElementIndex__shared != null) {
                                    nextElementIndex_ = nextElementIndex__shared;
                                } else {
                                    nextElementIndex_ = s1_.insert((JSArrayNextElementIndexNode.create(context)));
                                    if (nextElementIndex_ == null) {
                                        throw new IllegalStateException("Specialization 'fromSparseArray(JSDynamicObject, ScriptArray, long, ScriptArray, Node, JSArrayNextElementIndexNode, InlinedBranchProfile)' contains a shared cache with name 'nextElementIndexNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (this.nextElementIndex == null) {
                                    this.nextElementIndex = nextElementIndex_;
                                }
                                if (!FROM_SPARSE_ARRAY_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[JSArrayToDenseObjectArrayNode.fromSparseArray(JSDynamicObject, ScriptArray, long, ScriptArray, Node, JSArrayNextElementIndexNode, InlinedBranchProfile)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s1_ != null) {
                        return JSArrayToDenseObjectArrayNode.fromSparseArray(arg0Value, arg1Value, arg2Value, s1_.cachedArrayType_, node__, this.nextElementIndex, INLINED_GROW_BRANCH);
                    }
                    break;
                }
            }
        }
        JSArrayNextElementIndexNode nextElementIndex_1;
        JSArrayNextElementIndexNode nextElementIndex_1_shared = this.nextElementIndex;
        if (nextElementIndex_1_shared != null) {
            nextElementIndex_1 = nextElementIndex_1_shared;
        } else {
            nextElementIndex_1 = this.insert((JSArrayNextElementIndexNode.create(context)));
            if (nextElementIndex_1 == null) {
                throw new IllegalStateException("Specialization 'doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)' contains a shared cache with name 'nextElementIndexNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.nextElementIndex == null) {
            VarHandle.storeStoreFence();
            this.nextElementIndex = nextElementIndex_1;
        }
        ReadElementNode readElement_1;
        ReadElementNode readElement_1_shared = this.readElement;
        if (readElement_1_shared != null) {
            readElement_1 = readElement_1_shared;
        } else {
            readElement_1 = this.insert((ReadElementNode.create(context)));
            if (readElement_1 == null) {
                throw new IllegalStateException("Specialization 'doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)' contains a shared cache with name 'readNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
            }
        }
        if (this.readElement == null) {
            VarHandle.storeStoreFence();
            this.readElement = readElement_1;
        }
        this.fromDenseArray_cache = null;
        this.fromSparseArray_cache = null;
        state_0 = state_0 & 0xfffffffa /* remove SpecializationActive[JSArrayToDenseObjectArrayNode.fromDenseArray(JSDynamicObject, ScriptArray, long, ScriptArray, ReadElementNode)], SpecializationActive[JSArrayToDenseObjectArrayNode.fromSparseArray(JSDynamicObject, ScriptArray, long, ScriptArray, Node, JSArrayNextElementIndexNode, InlinedBranchProfile)] */;
        state_0 = state_0 | 0b10 /* add SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */;
        this.state_0_ = state_0;
        return doUncached(arg0Value, arg1Value, arg2Value, nextElementIndex_1, readElement_1, INLINED_GROW_BRANCH);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b111) & ((state_0 & 0b111) - 1)) == 0 /* is-single  */) {
                FromDenseArrayData s0_ = this.fromDenseArray_cache;
                FromSparseArrayData s1_ = this.fromSparseArray_cache;
                if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "fromDenseArray";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.fromDenseArray(JSDynamicObject, ScriptArray, long, ScriptArray, ReadElementNode)] */) {
            {
                ReadElementNode readElement_ = this.readElement;
                if (readElement_ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    FromDenseArrayData s0_ = this.fromDenseArray_cache;
                    while (s0_ != null) {
                        cached.add(Arrays.<Object>asList(s0_.cachedArrayType_, this.readElement));
                        s0_ = s0_.next_;
                    }
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "fromSparseArray";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.fromSparseArray(JSDynamicObject, ScriptArray, long, ScriptArray, Node, JSArrayNextElementIndexNode, InlinedBranchProfile)] */) {
            {
                JSArrayNextElementIndexNode nextElementIndex_ = this.nextElementIndex;
                if (nextElementIndex_ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    FromSparseArrayData s1_ = this.fromSparseArray_cache;
                    while (s1_ != null) {
                        cached.add(Arrays.<Object>asList(s1_.cachedArrayType_, this.nextElementIndex, INLINED_GROW_BRANCH));
                        s1_ = s1_.next_;
                    }
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUncached";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSArrayToDenseObjectArrayNode.doUncached(JSDynamicObject, ScriptArray, long, JSArrayNextElementIndexNode, ReadElementNode, InlinedBranchProfile)] */) {
            {
                JSArrayNextElementIndexNode nextElementIndex_1 = this.nextElementIndex;
                if (nextElementIndex_1 != null) {
                    ReadElementNode readElement_1 = this.readElement;
                    if (readElement_1 != null) {
                        s[1] = (byte)0b01 /* active */;
                        ArrayList<Object> cached = new ArrayList<>();
                        cached.add(Arrays.<Object>asList(this.nextElementIndex, this.readElement, INLINED_GROW_BRANCH));
                        s[2] = cached;
                    }
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static JSArrayToDenseObjectArrayNode create(JSContext context) {
        return new JSArrayToDenseObjectArrayNodeGen(context);
    }

    @GeneratedBy(JSArrayToDenseObjectArrayNode.class)
    @DenyReplace
    private static final class FromDenseArrayData implements SpecializationDataNode {

        @CompilationFinal final FromDenseArrayData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSArrayToDenseObjectArrayNode#fromDenseArray}
         *   Parameter: {@link ScriptArray} cachedArrayType</pre>
         */
        @CompilationFinal ScriptArray cachedArrayType_;

        FromDenseArrayData(FromDenseArrayData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSArrayToDenseObjectArrayNode.class)
    @DenyReplace
    private static final class FromSparseArrayData extends Node implements SpecializationDataNode {

        @Child FromSparseArrayData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSArrayToDenseObjectArrayNode#fromSparseArray}
         *   Parameter: {@link ScriptArray} cachedArrayType</pre>
         */
        @CompilationFinal ScriptArray cachedArrayType_;

        FromSparseArrayData(FromSparseArrayData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
