// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSBitwiseXorConstantNode#doInteger}
 *     Activation probability: 0.17364
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doSafeInteger}
 *     Activation probability: 0.15727
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doDouble}
 *     Activation probability: 0.14091
 *     With/without class size: 6/4 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doIntegerThrows}
 *     Activation probability: 0.12455
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doDoubleThrows}
 *     Activation probability: 0.10818
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doBigIntThrows}
 *     Activation probability: 0.09182
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doBigInt}
 *     Activation probability: 0.07545
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doOverloaded}
 *     Activation probability: 0.05909
 *     With/without class size: 5/4 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doGeneric}
 *     Activation probability: 0.04273
 *     With/without class size: 4/4 bytes
 *   Specialization {@link JSBitwiseXorConstantNode#doGenericBigIntCase}
 *     Activation probability: 0.02636
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(JSBitwiseXorConstantNode.class)
@SuppressWarnings("javadoc")
public final class JSBitwiseXorConstantNodeGen extends JSBitwiseXorConstantNode implements Introspection.Provider {

    private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSBitwiseXorConstantNode#doGeneric}
     *   Parameter: {@link InlinedConditionProfile} profileIsBigInt
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_IS_BIG_INT = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(13, 2)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSBitwiseXorConstantNode#doInteger}
     *   1: SpecializationActive {@link JSBitwiseXorConstantNode#doGeneric}
     *   2: SpecializationActive {@link JSBitwiseXorConstantNode#doSafeInteger}
     *   3: SpecializationActive {@link JSBitwiseXorConstantNode#doDouble}
     *   4: SpecializationActive {@link JSBitwiseXorConstantNode#doIntegerThrows}
     *   5: SpecializationActive {@link JSBitwiseXorConstantNode#doGenericBigIntCase}
     *   6: SpecializationActive {@link JSBitwiseXorConstantNode#doDoubleThrows}
     *   7: SpecializationActive {@link JSBitwiseXorConstantNode#doBigIntThrows}
     *   8: SpecializationActive {@link JSBitwiseXorConstantNode#doBigInt}
     *   9: SpecializationActive {@link JSBitwiseXorConstantNode#doOverloaded}
     *   10-12: ImplicitCast[type=double, index=0]
     *   13-14: InlinedCache
     *        Specialization: {@link JSBitwiseXorConstantNode#doGeneric}
     *        Parameter: {@link InlinedConditionProfile} profileIsBigInt
     *        Inline method: {@link InlinedConditionProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSBitwiseXorConstantNode#doGeneric}
     *   Parameter: {@link JSToNumericNode} toNumeric</pre>
     */
    @Child private JSToNumericNode toNumeric;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSBitwiseXorConstantNode#doDouble}
     *   Parameter: {@link JSToInt32Node} leftInt32</pre>
     */
    @Child private JSToInt32Node double_leftInt32_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSBitwiseXorConstantNode#doOverloaded}
     *   Parameter: {@link JSOverloadedBinaryNode} overloadedOperatorNode</pre>
     */
    @Child private JSOverloadedBinaryNode overloaded_overloadedOperatorNode_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSBitwiseXorConstantNode#doGeneric}
     *   Parameter: {@link JavaScriptNode} innerXorNode</pre>
     */
    @Child private JavaScriptNode generic_innerXorNode_;

    private JSBitwiseXorConstantNodeGen(JavaScriptNode left, Object rightValue) {
        super(left, rightValue);
    }

    @Override
    public Object executeObject(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1100101111) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] || SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] || SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] || SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */ && operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (int) operandNodeValue;
                assert DSLSupport.assertIdempotence((isInt));
                return doInteger(operandNodeValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] */ && operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
                assert DSLSupport.assertIdempotence((isInt));
                return doSafeInteger(operandNodeValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue)) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue);
                {
                    JSToInt32Node leftInt32__ = this.double_leftInt32_;
                    if (leftInt32__ != null) {
                        assert DSLSupport.assertIdempotence((isInt));
                        return doDouble(operandNodeValue_, leftInt32__);
                    }
                }
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] */ && operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                assert DSLSupport.assertIdempotence((!(isInt)));
                return doBigInt(operandNodeValue_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] */ && operandNodeValue instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
                {
                    JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
                    }
                }
            }
            if ((state_0 & 0b100010) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                    {
                        JSToNumericNode toNumeric_ = this.toNumeric;
                        if (toNumeric_ != null) {
                            JavaScriptNode innerXorNode__ = this.generic_innerXorNode_;
                            if (innerXorNode__ != null) {
                                if ((!(hasOverloadedOperators(operandNodeValue)))) {
                                    assert DSLSupport.assertIdempotence((isInt));
                                    return doGeneric(operandNodeValue, toNumeric_, INLINED_IS_BIG_INT, innerXorNode__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                    {
                        JSToNumericNode toNumeric_1 = this.toNumeric;
                        if (toNumeric_1 != null) {
                            if ((!(hasOverloadedOperators(operandNodeValue)))) {
                                assert DSLSupport.assertIdempotence((!(isInt)));
                                return doGenericBigIntCase(operandNodeValue, toNumeric_1, INLINED_IS_BIG_INT);
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1100101111) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] || SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] || SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] || SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */ && operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (int) operandNodeValue;
                assert DSLSupport.assertIdempotence((isInt));
                return doInteger(operandNodeValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] */ && operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
                assert DSLSupport.assertIdempotence((isInt));
                return doSafeInteger(operandNodeValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue)) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue);
                {
                    JSToInt32Node leftInt32__ = this.double_leftInt32_;
                    if (leftInt32__ != null) {
                        assert DSLSupport.assertIdempotence((isInt));
                        return doDouble(operandNodeValue_, leftInt32__);
                    }
                }
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] */ && operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                assert DSLSupport.assertIdempotence((!(isInt)));
                return doBigInt(operandNodeValue_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] */ && operandNodeValue instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
                {
                    JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
                    }
                }
            }
            if ((state_0 & 0b100010) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                    {
                        JSToNumericNode toNumeric_ = this.toNumeric;
                        if (toNumeric_ != null) {
                            JavaScriptNode innerXorNode__ = this.generic_innerXorNode_;
                            if (innerXorNode__ != null) {
                                if ((!(hasOverloadedOperators(operandNodeValue)))) {
                                    assert DSLSupport.assertIdempotence((isInt));
                                    return doGeneric(operandNodeValue, toNumeric_, INLINED_IS_BIG_INT, innerXorNode__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                    {
                        JSToNumericNode toNumeric_1 = this.toNumeric;
                        if (toNumeric_1 != null) {
                            if ((!(hasOverloadedOperators(operandNodeValue)))) {
                                assert DSLSupport.assertIdempotence((!(isInt)));
                                return doGenericBigIntCase(operandNodeValue, toNumeric_1, INLINED_IS_BIG_INT);
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1100101110) == 0 /* only-active SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */ && ((state_0 & 0b1100101111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b1100100111) == 0 /* only-active SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */ && ((state_0 & 0b1100101111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */;
        assert DSLSupport.assertIdempotence((isInt));
        return doInteger(operandNodeValue_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b1100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */;
        {
            JSToInt32Node leftInt32__ = this.double_leftInt32_;
            if (leftInt32__ != null) {
                assert DSLSupport.assertIdempotence((isInt));
                return doDouble(operandNodeValue_, leftInt32__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) ? (Object) operandNodeValue_int : (Object) operandNodeValue_));
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b1100101111) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] || SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] || SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] || SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                assert DSLSupport.assertIdempotence((isInt));
                return doInteger(operandNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] */ && operandNodeValue_ instanceof SafeInteger) {
                SafeInteger operandNodeValue__ = (SafeInteger) operandNodeValue_;
                assert DSLSupport.assertIdempotence((isInt));
                return doSafeInteger(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                {
                    JSToInt32Node leftInt32__ = this.double_leftInt32_;
                    if (leftInt32__ != null) {
                        assert DSLSupport.assertIdempotence((isInt));
                        return doDouble(operandNodeValue__, leftInt32__);
                    }
                }
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                assert DSLSupport.assertIdempotence((!(isInt)));
                return doBigInt(operandNodeValue__);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] */ && operandNodeValue_ instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue__ = (JSOverloadedOperatorsObject) operandNodeValue_;
                {
                    JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue__, overloadedOperatorNode__);
                    }
                }
            }
            if ((state_0 & 0b100010) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                    {
                        JSToNumericNode toNumeric_ = this.toNumeric;
                        if (toNumeric_ != null) {
                            JavaScriptNode innerXorNode__ = this.generic_innerXorNode_;
                            if (innerXorNode__ != null) {
                                if ((!(hasOverloadedOperators(operandNodeValue_)))) {
                                    assert DSLSupport.assertIdempotence((isInt));
                                    return doGeneric(operandNodeValue_, toNumeric_, INLINED_IS_BIG_INT, innerXorNode__);
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                    {
                        JSToNumericNode toNumeric_1 = this.toNumeric;
                        if (toNumeric_1 != null) {
                            if ((!(hasOverloadedOperators(operandNodeValue_)))) {
                                assert DSLSupport.assertIdempotence((!(isInt)));
                                return doGenericBigIntCase(operandNodeValue_, toNumeric_1, INLINED_IS_BIG_INT);
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1000000010) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        if ((state_0 & 0b1100) == 0 /* only-active SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */ && ((state_0 & 0b1101) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */)) {
            return executeInt_int3(state_0, frameValue);
        } else if ((state_0 & 0b101) == 0 /* only-active SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */ && ((state_0 & 0b1101) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */)) {
            return executeInt_double4(state_0, frameValue);
        } else {
            return executeInt_generic5(state_0, frameValue);
        }
    }

    private int executeInt_int3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */;
        assert DSLSupport.assertIdempotence((isInt));
        return doInteger(operandNodeValue_);
    }

    private int executeInt_double4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b1100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */;
        {
            JSToInt32Node leftInt32__ = this.double_leftInt32_;
            if (leftInt32__ != null) {
                assert DSLSupport.assertIdempotence((isInt));
                return doDouble(operandNodeValue_, leftInt32__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) ? (Object) operandNodeValue_int : (Object) operandNodeValue_)));
    }

    private int executeInt_generic5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b1101) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] || SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                assert DSLSupport.assertIdempotence((isInt));
                return doInteger(operandNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] */ && operandNodeValue_ instanceof SafeInteger) {
                SafeInteger operandNodeValue__ = (SafeInteger) operandNodeValue_;
                assert DSLSupport.assertIdempotence((isInt));
                return doSafeInteger(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                {
                    JSToInt32Node leftInt32__ = this.double_leftInt32_;
                    if (leftInt32__ != null) {
                        assert DSLSupport.assertIdempotence((isInt));
                        return doDouble(operandNodeValue__, leftInt32__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b1111110010) == 0 /* only-active SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
                executeInt(frameValue);
                return;
            } else if ((state_0 & 0b1100101111) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] || SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] || SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] || SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] || SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] || SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                execute(frameValue);
                return;
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
        if ((state_0 & 0b11000000) == 0 /* only-active SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] */ && ((state_0 & 0b11010000) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] */)) {
            executeVoid_int6(state_0, frameValue);
            return;
        } else if ((state_0 & 0b10010000) == 0 /* only-active SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] */ && ((state_0 & 0b11010000) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] */)) {
            executeVoid_double7(state_0, frameValue);
            return;
        } else {
            executeVoid_generic8(state_0, frameValue);
            return;
        }
    }

    private void executeVoid_int6(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(ex.getResult());
            return;
        }
        assert (state_0 & 0b10000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] */;
        assert DSLSupport.assertIdempotence((!(isInt)));
        doIntegerThrows(operandNodeValue_);
        return;
    }

    private void executeVoid_double7(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b1100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111111111) != 0  /* is-not SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] && SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] && SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] && SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] && SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] && SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] && SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] && SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(ex.getResult());
            return;
        }
        assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] */;
        assert DSLSupport.assertIdempotence((!(isInt)));
        doDoubleThrows(operandNodeValue_);
        return;
    }

    private void executeVoid_generic8(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b11010000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] || SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] || SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] */) {
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                assert DSLSupport.assertIdempotence((!(isInt)));
                doIntegerThrows(operandNodeValue__);
                return;
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                assert DSLSupport.assertIdempotence((!(isInt)));
                doDoubleThrows(operandNodeValue__);
                return;
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                assert DSLSupport.assertIdempotence((isInt));
                doBigIntThrows(operandNodeValue__);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(operandNodeValue_);
        return;
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */ && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            if ((isInt)) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */;
                this.state_0_ = state_0;
                return doInteger(operandNodeValue_);
            }
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */ && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
            if ((isInt)) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] */;
                this.state_0_ = state_0;
                return doSafeInteger(operandNodeValue_);
            }
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                if ((isInt)) {
                    JSToInt32Node leftInt32__ = this.insert((JSToInt32Node.create()));
                    Objects.requireNonNull(leftInt32__, "Specialization 'doDouble(double, JSToInt32Node)' cache 'leftInt32' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.double_leftInt32_ = leftInt32__;
                    state_0 = (state_0 | (doubleCast0 << 10) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */;
                    this.state_0_ = state_0;
                    return doDouble(operandNodeValue_, leftInt32__);
                }
            }
        }
        if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */ && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            if ((!(isInt))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] */;
                this.state_0_ = state_0;
                doIntegerThrows(operandNodeValue_);
                return null;
            }
        }
        if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                if ((!(isInt))) {
                    state_0 = (state_0 | (doubleCast0 << 10) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] */;
                    this.state_0_ = state_0;
                    doDoubleThrows(operandNodeValue_);
                    return null;
                }
            }
        }
        if (operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                if ((isInt)) {
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] */;
                    this.state_0_ = state_0;
                    doBigIntThrows(operandNodeValue_);
                    return null;
                }
            }
            if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                if ((!(isInt))) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] */;
                    this.state_0_ = state_0;
                    return doBigInt(operandNodeValue_);
                }
            }
        }
        if (operandNodeValue instanceof JSOverloadedOperatorsObject) {
            JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
            JSOverloadedBinaryNode overloadedOperatorNode__ = this.insert((JSOverloadedBinaryNode.createNumeric(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "Specialization 'doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)' cache 'overloadedOperatorNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
        }
        if ((!(hasOverloadedOperators(operandNodeValue))) && (isInt)) {
            JSToNumericNode toNumeric_;
            JSToNumericNode toNumeric__shared = this.toNumeric;
            if (toNumeric__shared != null) {
                toNumeric_ = toNumeric__shared;
            } else {
                toNumeric_ = this.insert((JSToNumericNode.create()));
                if (toNumeric_ == null) {
                    throw new IllegalStateException("Specialization 'doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)' contains a shared cache with name 'toNumeric' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumeric == null) {
                VarHandle.storeStoreFence();
                this.toNumeric = toNumeric_;
            }
            JavaScriptNode innerXorNode__ = this.insert((makeCopy()));
            Objects.requireNonNull(innerXorNode__, "Specialization 'doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)' cache 'innerXorNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.generic_innerXorNode_ = innerXorNode__;
            this.double_leftInt32_ = null;
            state_0 = state_0 & 0xffffff72 /* remove SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)], SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)], SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)], SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] */;
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */;
            this.state_0_ = state_0;
            return doGeneric(operandNodeValue, toNumeric_, INLINED_IS_BIG_INT, innerXorNode__);
        }
        if ((!(hasOverloadedOperators(operandNodeValue))) && (!(isInt))) {
            JSToNumericNode toNumeric_1;
            JSToNumericNode toNumeric_1_shared = this.toNumeric;
            if (toNumeric_1_shared != null) {
                toNumeric_1 = toNumeric_1_shared;
            } else {
                toNumeric_1 = this.insert((JSToNumericNode.create()));
                if (toNumeric_1 == null) {
                    throw new IllegalStateException("Specialization 'doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)' contains a shared cache with name 'toNumeric' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumeric == null) {
                VarHandle.storeStoreFence();
                this.toNumeric = toNumeric_1;
            }
            state_0 = state_0 & 0xfffffeaf /* remove SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)], SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)], SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] */;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */;
            this.state_0_ = state_0;
            return doGenericBigIntCase(operandNodeValue, toNumeric_1, INLINED_IS_BIG_INT);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111111111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b1111111111) & ((state_0 & 0b1111111111) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[11];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "doInteger";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doInteger(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doSafeInteger(SafeInteger)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDouble(double, JSToInt32Node)] */) {
            {
                JSToInt32Node leftInt32__ = this.double_leftInt32_;
                if (leftInt32__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.double_leftInt32_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doIntegerThrows";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doIntegerThrows(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doDoubleThrows";
        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doDoubleThrows(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigIntThrows";
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doBigIntThrows(BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doBigInt(BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doOverloaded";
        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedBinaryNode)] */) {
            {
                JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                if (overloadedOperatorNode__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.overloaded_overloadedOperatorNode_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGeneric(Object, JSToNumericNode, InlinedConditionProfile, JavaScriptNode)] */) {
            {
                JSToNumericNode toNumeric_ = this.toNumeric;
                if (toNumeric_ != null) {
                    JavaScriptNode innerXorNode__ = this.generic_innerXorNode_;
                    if (innerXorNode__ != null) {
                        s[1] = (byte)0b01 /* active */;
                        ArrayList<Object> cached = new ArrayList<>();
                        cached.add(Arrays.<Object>asList(this.toNumeric, INLINED_IS_BIG_INT, this.generic_innerXorNode_));
                        s[2] = cached;
                    }
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doGenericBigIntCase";
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSBitwiseXorConstantNode.doGenericBigIntCase(Object, JSToNumericNode, InlinedConditionProfile)] */) {
            {
                JSToNumericNode toNumeric_1 = this.toNumeric;
                if (toNumeric_1 != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.toNumeric, INLINED_IS_BIG_INT));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static JSBitwiseXorConstantNode create(JavaScriptNode left, Object rightValue) {
        return new JSBitwiseXorConstantNodeGen(left, rightValue);
    }

}
