// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSDivideNode#doInt1}
 *     Activation probability: 0.21250
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSDivideNode#doInt2}
 *     Activation probability: 0.18750
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSDivideNode#doInt3}
 *     Activation probability: 0.16250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSDivideNode#doDouble}
 *     Activation probability: 0.13750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSDivideNode#doBigIntZeroDivision}
 *     Activation probability: 0.11250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSDivideNode#doBigInt}
 *     Activation probability: 0.08750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSDivideNode#doOverloaded}
 *     Activation probability: 0.06250
 *     With/without class size: 5/4 bytes
 *   Specialization {@link JSDivideNode#doGeneric}
 *     Activation probability: 0.03750
 *     With/without class size: 5/13 bytes
 * </pre>
 */
@GeneratedBy(JSDivideNode.class)
@SuppressWarnings("javadoc")
public final class JSDivideNodeGen extends JSDivideNode implements Introspection.Provider {

    private static final StateField GENERIC__J_S_DIVIDE_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSDivideNode#doGeneric}
     *   Parameter: {@link InlinedBranchProfile} mixedNumericTypes
     *   Inline method: {@link InlinedBranchProfile#inline}</pre>
     */
    private static final InlinedBranchProfile INLINED_GENERIC_MIXED_NUMERIC_TYPES_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, GENERIC__J_S_DIVIDE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSDivideNode#doInt1}
     *   1: SpecializationExcluded {@link JSDivideNode#doInt1}
     *   2: SpecializationActive {@link JSDivideNode#doDouble}
     *   3: SpecializationActive {@link JSDivideNode#doGeneric}
     *   4: SpecializationActive {@link JSDivideNode#doInt2}
     *   5: SpecializationExcluded {@link JSDivideNode#doInt2}
     *   6: SpecializationActive {@link JSDivideNode#doInt3}
     *   7: SpecializationExcluded {@link JSDivideNode#doInt3}
     *   8: SpecializationActive {@link JSDivideNode#doBigIntZeroDivision}
     *   9: SpecializationActive {@link JSDivideNode#doBigInt}
     *   10: SpecializationActive {@link JSDivideNode#doOverloaded}
     *   11-13: ImplicitCast[type=double, index=0]
     *   14-16: ImplicitCast[type=double, index=1]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSDivideNode#doOverloaded}
     *   Parameter: {@link JSOverloadedBinaryNode} overloadedOperatorNode</pre>
     */
    @Child private JSOverloadedBinaryNode overloaded_overloadedOperatorNode_;
    @Child private GenericData generic_cache;

    private JSDivideNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public Object execute(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11101011101) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] || SpecializationActive[JSDivideNode.doInt2(int, int)] || SpecializationActive[JSDivideNode.doInt3(int, int)] || SpecializationActive[JSDivideNode.doDouble(double, double)] || SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] || SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1010001) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] || SpecializationActive[JSDivideNode.doInt2(int, int)] || SpecializationActive[JSDivideNode.doInt3(int, int)] */ && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] */) {
                        if ((rightNodeValue_ > 0)) {
                            try {
                                return doInt1(leftNodeValue_, rightNodeValue_);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSDivideNode.doInt1(int, int)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSDivideNode.doInt2(int, int)] */) {
                        if ((leftNodeValue_ > 0)) {
                            try {
                                return doInt2(leftNodeValue_, rightNodeValue_);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[JSDivideNode.doInt2(int, int)] */;
                                state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSDivideNode.doInt3(int, int)] */) {
                        if ((JSDivideNode.isCornercase(leftNodeValue_, rightNodeValue_))) {
                            try {
                                return doInt3(leftNodeValue_, rightNodeValue_);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[JSDivideNode.doInt3(int, int)] */;
                                state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue)) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue);
                if (JSTypesGen.isImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue)) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue);
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b1100000000) != 0 /* is SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] || SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] */ && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt) leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntZero(rightNodeValue_))) {
                            return doBigIntZeroDivision(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] */) {
                        if ((!(JSGuards.isBigIntZero(rightNodeValue_)))) {
                            return doBigInt(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
            }
            if ((state_0 & 0b10000001000) != 0 /* is SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
                                return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                    GenericData s7_ = this.generic_cache;
                    if (s7_ != null) {
                        if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                            Node node__ = (s7_);
                            return JSDivideNode.doGeneric(leftNodeValue, rightNodeValue, node__, s7_.nestedDivideNode_, s7_.toNumeric1Node_, s7_.toNumeric2Node_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11100001100) == 0 /* only-active SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
            return execute_int_int0(state_0, frameValue);
        } else if ((state_0 & 0b11101011001) == 0 /* only-active SpecializationActive[JSDivideNode.doDouble(double, double)] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
            return execute_double_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state_0 & 0b1010001) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] || SpecializationActive[JSDivideNode.doInt2(int, int)] || SpecializationActive[JSDivideNode.doInt3(int, int)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] */) {
                if ((rightNodeValue_ > 0)) {
                    try {
                        return doInt1(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSDivideNode.doInt1(int, int)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSDivideNode.doInt2(int, int)] */) {
                if ((leftNodeValue_ > 0)) {
                    try {
                        return doInt2(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xffffffef /* remove SpecializationActive[JSDivideNode.doInt2(int, int)] */;
                        state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSDivideNode.doInt3(int, int)] */) {
                if ((JSDivideNode.isCornercase(leftNodeValue_, rightNodeValue_))) {
                    try {
                        return doInt3(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[JSDivideNode.doInt3(int, int)] */;
                        state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_double_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0b11000000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0x18000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0x14000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(((state_0 & 0b10100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] */;
        return doDouble(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state_0 & 0b11101011101) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] || SpecializationActive[JSDivideNode.doInt2(int, int)] || SpecializationActive[JSDivideNode.doInt3(int, int)] || SpecializationActive[JSDivideNode.doDouble(double, double)] || SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] || SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1010001) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] || SpecializationActive[JSDivideNode.doInt2(int, int)] || SpecializationActive[JSDivideNode.doInt3(int, int)] */ && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (int) leftNodeValue_;
                if (rightNodeValue_ instanceof Integer) {
                    int rightNodeValue__ = (int) rightNodeValue_;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] */) {
                        if ((rightNodeValue__ > 0)) {
                            try {
                                return doInt1(leftNodeValue__, rightNodeValue__);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSDivideNode.doInt1(int, int)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSDivideNode.doInt2(int, int)] */) {
                        if ((leftNodeValue__ > 0)) {
                            try {
                                return doInt2(leftNodeValue__, rightNodeValue__);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[JSDivideNode.doInt2(int, int)] */;
                                state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSDivideNode.doInt3(int, int)] */) {
                        if ((JSDivideNode.isCornercase(leftNodeValue__, rightNodeValue__))) {
                            try {
                                return doInt3(leftNodeValue__, rightNodeValue__);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[JSDivideNode.doInt3(int, int)] */;
                                state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_)) {
                double leftNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_);
                if (JSTypesGen.isImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_)) {
                    double rightNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_);
                    return doDouble(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b1100000000) != 0 /* is SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] || SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] */ && leftNodeValue_ instanceof BigInt) {
                BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
                if (rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] */) {
                        if ((JSGuards.isBigIntZero(rightNodeValue__))) {
                            return doBigIntZeroDivision(leftNodeValue__, rightNodeValue__);
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] */) {
                        if ((!(JSGuards.isBigIntZero(rightNodeValue__)))) {
                            return doBigInt(leftNodeValue__, rightNodeValue__);
                        }
                    }
                }
            }
            if ((state_0 & 0b10000001000) != 0 /* is SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue_) || hasOverloadedOperators(rightNodeValue_))) {
                                return doOverloaded(leftNodeValue_, rightNodeValue_, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                    GenericData s7_ = this.generic_cache;
                    if (s7_ != null) {
                        if ((!(hasOverloadedOperators(leftNodeValue_))) && (!(hasOverloadedOperators(rightNodeValue_)))) {
                            Node node__ = (s7_);
                            return JSDivideNode.doGeneric(leftNodeValue_, rightNodeValue_, node__, s7_.nestedDivideNode_, s7_.toNumeric1Node_, s7_.toNumeric2Node_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10000001000) != 0 /* is SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            return JSTypesGen.expectDouble(execute(frameValue));
        }
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0b11000000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0x18000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0x14000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(((state_0 & 0b10100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult()));
        }
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] */) {
            return doDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(((state_0 & 0b10100000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ((state_0 & 0x14000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) rightNodeValue_int : (Object) rightNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10000001000) != 0 /* is SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        if ((state_0 & 0b1010001) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] || SpecializationActive[JSDivideNode.doInt2(int, int)] || SpecializationActive[JSDivideNode.doInt3(int, int)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] */) {
                if ((rightNodeValue_ > 0)) {
                    try {
                        return doInt1(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSDivideNode.doInt1(int, int)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSDivideNode.doInt2(int, int)] */) {
                if ((leftNodeValue_ > 0)) {
                    try {
                        return doInt2(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xffffffef /* remove SpecializationActive[JSDivideNode.doInt2(int, int)] */;
                        state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
                    }
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSDivideNode.doInt3(int, int)] */) {
                if ((JSDivideNode.isCornercase(leftNodeValue_, rightNodeValue_))) {
                    try {
                        return doInt3(leftNodeValue_, rightNodeValue_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[JSDivideNode.doInt3(int, int)] */;
                        state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b11100001100) == 0 /* only-active SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                executeInt(frameValue);
                return;
            } else if ((state_0 & 0b11101011001) == 0 /* only-active SpecializationActive[JSDivideNode.doDouble(double, double)] */ && ((state_0 & 0b11101011101) != 0  /* is-not SpecializationActive[JSDivideNode.doInt1(int, int)] && SpecializationActive[JSDivideNode.doInt2(int, int)] && SpecializationActive[JSDivideNode.doInt3(int, int)] && SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                executeDouble(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if (leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                if (((state_0 & 0b1100)) == 0 /* is-not SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && ((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                    if ((rightNodeValue_ > 0)) {
                        state_0 = state_0 | 0b1 /* add SpecializationActive[JSDivideNode.doInt1(int, int)] */;
                        this.state_0_ = state_0;
                        try {
                            return doInt1(leftNodeValue_, rightNodeValue_);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[JSDivideNode.doInt1(int, int)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
                if (((state_0 & 0b1100)) == 0 /* is-not SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && ((state_0 & 0b100000)) == 0 /* is-not SpecializationExcluded  */) {
                    if ((leftNodeValue_ > 0)) {
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[JSDivideNode.doInt2(int, int)] */;
                        this.state_0_ = state_0;
                        try {
                            return doInt2(leftNodeValue_, rightNodeValue_);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xffffffef /* remove SpecializationActive[JSDivideNode.doInt2(int, int)] */;
                            state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
                if (((state_0 & 0b1100)) == 0 /* is-not SpecializationActive[JSDivideNode.doDouble(double, double)] && SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && ((state_0 & 0b10000000)) == 0 /* is-not SpecializationExcluded  */) {
                    if ((JSDivideNode.isCornercase(leftNodeValue_, rightNodeValue_))) {
                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSDivideNode.doInt3(int, int)] */;
                        this.state_0_ = state_0;
                        try {
                            return doInt3(leftNodeValue_, rightNodeValue_);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[JSDivideNode.doInt3(int, int)] */;
                            state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
            }
        }
        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state_0 = state_0 & 0xffffffae /* remove SpecializationActive[JSDivideNode.doInt1(int, int)], SpecializationActive[JSDivideNode.doInt2(int, int)], SpecializationActive[JSDivideNode.doInt3(int, int)] */;
                    state_0 = (state_0 | (doubleCast0 << 11) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = (state_0 | (doubleCast1 << 14) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b100 /* add SpecializationActive[JSDivideNode.doDouble(double, double)] */;
                    this.state_0_ = state_0;
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if (leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt) leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                if ((JSGuards.isBigIntZero(rightNodeValue_))) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] */;
                    this.state_0_ = state_0;
                    return doBigIntZeroDivision(leftNodeValue_, rightNodeValue_);
                }
                if ((!(JSGuards.isBigIntZero(rightNodeValue_)))) {
                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] */;
                    this.state_0_ = state_0;
                    return doBigInt(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
            JSOverloadedBinaryNode overloadedOperatorNode__ = this.insert((JSOverloadedBinaryNode.createNumeric(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "Specialization 'doOverloaded(Object, Object, JSOverloadedBinaryNode)' cache 'overloadedOperatorNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
        }
        {
            Node node__ = null;
            if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                GenericData s7_ = this.insert(new GenericData());
                node__ = (s7_);
                s7_.nestedDivideNode_ = s7_.insert((JSDivideNode.create()));
                JSToNumericNode toNumeric1Node__ = s7_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(toNumeric1Node__, "Specialization 'doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)' cache 'toNumeric1Node' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s7_.toNumeric1Node_ = toNumeric1Node__;
                JSToNumericNode toNumeric2Node__ = s7_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(toNumeric2Node__, "Specialization 'doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)' cache 'toNumeric2Node' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s7_.toNumeric2Node_ = toNumeric2Node__;
                VarHandle.storeStoreFence();
                this.generic_cache = s7_;
                state_0 = state_0 & 0xffffffaa /* remove SpecializationActive[JSDivideNode.doInt1(int, int)], SpecializationActive[JSDivideNode.doInt2(int, int)], SpecializationActive[JSDivideNode.doInt3(int, int)], SpecializationActive[JSDivideNode.doDouble(double, double)] */;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */;
                this.state_0_ = state_0;
                return JSDivideNode.doGeneric(leftNodeValue, rightNodeValue, node__, s7_.nestedDivideNode_, toNumeric1Node__, toNumeric2Node__, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.leftNode, super.rightNode}, leftNodeValue, rightNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11101011101) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11101011101) & ((state_0 & 0b11101011101) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[9];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "doInt1";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSDivideNode.doInt1(int, int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && ((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doInt2";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSDivideNode.doInt2(int, int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && ((state_0 & 0b100000)) == 0 /* is-not SpecializationExcluded  */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doInt3";
        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSDivideNode.doInt3(int, int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] || SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && ((state_0 & 0b10000000)) == 0 /* is-not SpecializationExcluded  */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSDivideNode.doDouble(double, double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doBigIntZeroDivision";
        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSDivideNode.doBigIntZeroDivision(BigInt, BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSDivideNode.doBigInt(BigInt, BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doOverloaded";
        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSDivideNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
            {
                JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                if (overloadedOperatorNode__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.overloaded_overloadedOperatorNode_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSDivideNode.doGeneric(Object, Object, Node, JSDivideNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            GenericData s7_ = this.generic_cache;
            if (s7_ != null) {
                cached.add(Arrays.<Object>asList(s7_.nestedDivideNode_, s7_.toNumeric1Node_, s7_.toNumeric2Node_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_));
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static JSDivideNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSDivideNodeGen(left, right);
    }

    @GeneratedBy(JSDivideNode.class)
    @DenyReplace
    private static final class GenericData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: InlinedCache
         *        Specialization: {@link JSDivideNode#doGeneric}
         *        Parameter: {@link InlinedBranchProfile} mixedNumericTypes
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSDivideNode#doGeneric}
         *   Parameter: {@link JSDivideNode} nestedDivideNode</pre>
         */
        @Child JSDivideNode nestedDivideNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSDivideNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumeric1Node</pre>
         */
        @Child JSToNumericNode toNumeric1Node_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSDivideNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumeric2Node</pre>
         */
        @Child JSToNumericNode toNumeric2Node_;

        GenericData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
}
