// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.ReadCharUTF16Node;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToArrayIndexNode#doInteger}
 *     Activation probability: 0.14679
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayIndexNode#doLong}
 *     Activation probability: 0.13526
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayIndexNode#doDoubleAsIntIndex}
 *     Activation probability: 0.12372
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayIndexNode#doDoubleAsUintIndex}
 *     Activation probability: 0.11218
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayIndexNode#doSymbol}
 *     Activation probability: 0.10064
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayIndexNode#doBigInt}
 *     Activation probability: 0.08910
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToArrayIndexNode#convertFromString}
 *     Activation probability: 0.07756
 *     With/without class size: 5/5 bytes
 *   Specialization {@link ToArrayIndexNode#convertFromStringNotInRange}
 *     Activation probability: 0.06603
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToArrayIndexNode#doInteropArrayIndex}
 *     Activation probability: 0.05449
 *     With/without class size: 5/4 bytes
 *   Specialization {@link ToArrayIndexNode#doInteropArrayIndex}
 *     Activation probability: 0.04295
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToArrayIndexNode#doNonArrayIndex}
 *     Activation probability: 0.03141
 *     With/without class size: 5/12 bytes
 *   Specialization {@link ToArrayIndexNode#doNonArrayIndex}
 *     Activation probability: 0.01987
 *     With/without class size: 4/8 bytes
 * </pre>
 */
@GeneratedBy(ToArrayIndexNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class ToArrayIndexNodeGen extends ToArrayIndexNode implements Introspection.Provider {

    private static final StateField STATE_0_ToArrayIndexNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    static final ReferenceField<InteropArrayIndex0Data> INTEROP_ARRAY_INDEX0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "interopArrayIndex0_cache", InteropArrayIndex0Data.class);
    static final ReferenceField<NonArrayIndex0Data> NON_ARRAY_INDEX0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "nonArrayIndex0_cache", NonArrayIndex0Data.class);
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToArrayIndexNode#convertFromString}
     *   Parameter: {@link InlinedConditionProfile} startsWithDigitBranch
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_CONVERT_FROM_STRING_STARTS_WITH_DIGIT_BRANCH_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_ToArrayIndexNode_UPDATER.subUpdater(15, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToArrayIndexNode#convertFromString}
     *   Parameter: {@link InlinedBranchProfile} isArrayIndexBranch
     *   Inline method: {@link InlinedBranchProfile#inline}</pre>
     */
    private static final InlinedBranchProfile INLINED_CONVERT_FROM_STRING_IS_ARRAY_INDEX_BRANCH_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_ToArrayIndexNode_UPDATER.subUpdater(17, 1)));
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ToArrayIndexNode#doInteger}
     *   1: SpecializationActive {@link ToArrayIndexNode#doLong}
     *   2: SpecializationActive {@link ToArrayIndexNode#doDoubleAsIntIndex}
     *   3: SpecializationActive {@link ToArrayIndexNode#doDoubleAsUintIndex}
     *   4: SpecializationActive {@link ToArrayIndexNode#doSymbol}
     *   5: SpecializationActive {@link ToArrayIndexNode#doBigInt}
     *   6: SpecializationActive {@link ToArrayIndexNode#convertFromString}
     *   7: SpecializationActive {@link ToArrayIndexNode#convertFromStringNotInRange}
     *   8: SpecializationActive {@link ToArrayIndexNode#doInteropArrayIndex}
     *   9: SpecializationActive {@link ToArrayIndexNode#doInteropArrayIndex}
     *   10: SpecializationActive {@link ToArrayIndexNode#doNonArrayIndex}
     *   11: SpecializationActive {@link ToArrayIndexNode#doNonArrayIndex}
     *   12-14: ImplicitCast[type=double, index=0]
     *   15-16: InlinedCache
     *        Specialization: {@link ToArrayIndexNode#convertFromString}
     *        Parameter: {@link InlinedConditionProfile} startsWithDigitBranch
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   17: InlinedCache
     *        Specialization: {@link ToArrayIndexNode#convertFromString}
     *        Parameter: {@link InlinedBranchProfile} isArrayIndexBranch
     *        Inline method: {@link InlinedBranchProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ToArrayIndexNode#convertFromString}
     *   Parameter: {@link ReadCharUTF16Node} stringReadNode</pre>
     */
    @Child private ReadCharUTF16Node convertFromString_stringReadNode_;
    @UnsafeAccessedField @Child private InteropArrayIndex0Data interopArrayIndex0_cache;
    @UnsafeAccessedField @Child private NonArrayIndex0Data nonArrayIndex0_cache;
    @Child private NonArrayIndex1Data nonArrayIndex1_cache;

    private ToArrayIndexNodeGen(boolean convertToPropertyKey, boolean convertStringToIndex) {
        super(convertToPropertyKey, convertStringToIndex);
    }

    @ExplodeLoop
    @Override
    public Object execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111111111) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteger(int)] || SpecializationActive[ToArrayIndexNode.doLong(long)] || SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] || SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] || SpecializationActive[ToArrayIndexNode.doSymbol(Symbol)] || SpecializationActive[ToArrayIndexNode.doBigInt(BigInt)] || SpecializationActive[ToArrayIndexNode.convertFromString(TruffleString, InlinedConditionProfile, InlinedBranchProfile, ReadCharUTF16Node)] || SpecializationActive[ToArrayIndexNode.convertFromStringNotInRange(TruffleString)] || SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] || SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] || SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] || SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteger(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                if ((JSGuards.isIntArrayIndex(arg0Value_))) {
                    return ToArrayIndexNode.doInteger(arg0Value_);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToArrayIndexNode.doLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((JSGuards.isLongArrayIndex(arg0Value_))) {
                    return ToArrayIndexNode.doLong(arg0Value_);
                }
            }
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] || SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] */) {
                    if ((ToArrayIndexNode.doubleIsIntIndex(arg0Value_))) {
                        return ToArrayIndexNode.doDoubleAsIntIndex(arg0Value_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */) {
                    if ((ToArrayIndexNode.doubleIsUintIndex(arg0Value_))) {
                        return ToArrayIndexNode.doDoubleAsUintIndex(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToArrayIndexNode.doSymbol(Symbol)] */ && arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                return ToArrayIndexNode.doSymbol(arg0Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToArrayIndexNode.doBigInt(BigInt)] */ && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                if ((JSGuards.isBigIntArrayIndex(arg0Value_))) {
                    return ToArrayIndexNode.doBigInt(arg0Value_);
                }
            }
            if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[ToArrayIndexNode.convertFromString(TruffleString, InlinedConditionProfile, InlinedBranchProfile, ReadCharUTF16Node)] || SpecializationActive[ToArrayIndexNode.convertFromStringNotInRange(TruffleString)] */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToArrayIndexNode.convertFromString(TruffleString, InlinedConditionProfile, InlinedBranchProfile, ReadCharUTF16Node)] */) {
                    {
                        ReadCharUTF16Node stringReadNode__ = this.convertFromString_stringReadNode_;
                        if (stringReadNode__ != null) {
                            assert DSLSupport.assertIdempotence((convertStringToIndex));
                            if ((JSRuntime.arrayIndexLengthInRange(arg0Value_))) {
                                return convertFromString(arg0Value_, INLINED_CONVERT_FROM_STRING_STARTS_WITH_DIGIT_BRANCH_, INLINED_CONVERT_FROM_STRING_IS_ARRAY_INDEX_BRANCH_, stringReadNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToArrayIndexNode.convertFromStringNotInRange(TruffleString)] */) {
                    if ((!(convertStringToIndex) || !(JSRuntime.arrayIndexLengthInRange(arg0Value_)))) {
                        return ToArrayIndexNode.convertFromStringNotInRange(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b111100000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] || SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] || SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] || SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
                    InteropArrayIndex0Data s8_ = this.interopArrayIndex0_cache;
                    while (s8_ != null) {
                        if ((s8_.interop_.accepts(arg0Value)) && (ToArrayIndexNode.notArrayIndex(arg0Value))) {
                            long index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, s8_.interop_));
                            if ((index__ >= 0)) {
                                return ToArrayIndexNode.doInteropArrayIndex(arg0Value, s8_.interop_, index__);
                            }
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((ToArrayIndexNode.notArrayIndex(arg0Value))) {
                            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                            long index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, interop__));
                            if ((index__ >= 0)) {
                                return this.interopArrayIndex1Boundary(state_0, arg0Value);
                            }
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
                    NonArrayIndex0Data s10_ = this.nonArrayIndex0_cache;
                    while (s10_ != null) {
                        if ((s10_.interop_.accepts(arg0Value)) && (ToArrayIndexNode.notArrayIndex(arg0Value)) && (ToArrayIndexNode.toArrayIndex(arg0Value, s10_.interop_) < 0)) {
                            return doNonArrayIndex(arg0Value, s10_.interop_, s10_.toPropertyKey_, s10_.recursive_);
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
                    NonArrayIndex1Data s11_ = this.nonArrayIndex1_cache;
                    if (s11_ != null) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            if ((ToArrayIndexNode.notArrayIndex(arg0Value))) {
                                InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((ToArrayIndexNode.toArrayIndex(arg0Value, interop__1) < 0)) {
                                    return this.nonArrayIndex1Boundary(state_0, s11_, arg0Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object interopArrayIndex1Boundary(int state_0, Object arg0Value) {
        {
            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
            long index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, interop__));
            return ToArrayIndexNode.doInteropArrayIndex(arg0Value, interop__, index__);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object nonArrayIndex1Boundary(int state_0, NonArrayIndex1Data s11_, Object arg0Value) {
        {
            InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
            return doNonArrayIndex(arg0Value, interop__1, s11_.toPropertyKey_, s11_.recursive_);
        }
    }

    @ExplodeLoop
    @Override
    public long executeLong(Object arg0Value) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110001000000) != 0 /* is SpecializationActive[ToArrayIndexNode.convertFromString(TruffleString, InlinedConditionProfile, InlinedBranchProfile, ReadCharUTF16Node)] || SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] || SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
            return JSTypesGen.expectLong(execute(arg0Value));
        }
        if ((state_0 & 0b1100101111) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteger(int)] || SpecializationActive[ToArrayIndexNode.doLong(long)] || SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] || SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] || SpecializationActive[ToArrayIndexNode.doBigInt(BigInt)] || SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] || SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteger(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                if ((JSGuards.isIntArrayIndex(arg0Value_))) {
                    return ToArrayIndexNode.doInteger(arg0Value_);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToArrayIndexNode.doLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                if ((JSGuards.isLongArrayIndex(arg0Value_))) {
                    return ToArrayIndexNode.doLong(arg0Value_);
                }
            }
            if ((state_0 & 0b1100) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] || SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] */) {
                    if ((ToArrayIndexNode.doubleIsIntIndex(arg0Value_))) {
                        return ToArrayIndexNode.doDoubleAsIntIndex(arg0Value_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */) {
                    if ((ToArrayIndexNode.doubleIsUintIndex(arg0Value_))) {
                        return ToArrayIndexNode.doDoubleAsUintIndex(arg0Value_);
                    }
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToArrayIndexNode.doBigInt(BigInt)] */ && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                if ((JSGuards.isBigIntArrayIndex(arg0Value_))) {
                    return ToArrayIndexNode.doBigInt(arg0Value_);
                }
            }
            if ((state_0 & 0b1100000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] || SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
                    InteropArrayIndex0Data s8_ = this.interopArrayIndex0_cache;
                    while (s8_ != null) {
                        if ((s8_.interop_.accepts(arg0Value)) && (ToArrayIndexNode.notArrayIndex(arg0Value))) {
                            long index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, s8_.interop_));
                            if ((index__ >= 0)) {
                                return ToArrayIndexNode.doInteropArrayIndex(arg0Value, s8_.interop_, index__);
                            }
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        if ((ToArrayIndexNode.notArrayIndex(arg0Value))) {
                            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                            long index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, interop__));
                            if ((index__ >= 0)) {
                                return this.interopArrayIndex1Boundary0(state_0, arg0Value);
                            }
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectLong(executeAndSpecialize(arg0Value));
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private long interopArrayIndex1Boundary0(int state_0, Object arg0Value) throws UnexpectedResultException {
        {
            InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
            long index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, interop__));
            return ToArrayIndexNode.doInteropArrayIndex(arg0Value, interop__, index__);
        }
    }

    @SuppressWarnings("unused")
    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            if ((JSGuards.isIntArrayIndex(arg0Value_))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[ToArrayIndexNode.doInteger(int)] */;
                this.state_0_ = state_0;
                return ToArrayIndexNode.doInteger(arg0Value_);
            }
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            if ((JSGuards.isLongArrayIndex(arg0Value_))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[ToArrayIndexNode.doLong(long)] */;
                this.state_0_ = state_0;
                return ToArrayIndexNode.doLong(arg0Value_);
            }
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */) {
                    if ((ToArrayIndexNode.doubleIsIntIndex(arg0Value_))) {
                        state_0 = (state_0 | (doubleCast0 << 12) /* set-int ImplicitCast[type=double, index=0] */);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] */;
                        this.state_0_ = state_0;
                        return ToArrayIndexNode.doDoubleAsIntIndex(arg0Value_);
                    }
                }
                if ((ToArrayIndexNode.doubleIsUintIndex(arg0Value_))) {
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] */;
                    state_0 = (state_0 | (doubleCast0 << 12) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */;
                    this.state_0_ = state_0;
                    return ToArrayIndexNode.doDoubleAsUintIndex(arg0Value_);
                }
            }
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[ToArrayIndexNode.doSymbol(Symbol)] */;
            this.state_0_ = state_0;
            return ToArrayIndexNode.doSymbol(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt) arg0Value;
            if ((JSGuards.isBigIntArrayIndex(arg0Value_))) {
                state_0 = state_0 | 0b100000 /* add SpecializationActive[ToArrayIndexNode.doBigInt(BigInt)] */;
                this.state_0_ = state_0;
                return ToArrayIndexNode.doBigInt(arg0Value_);
            }
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString) arg0Value;
            if ((convertStringToIndex) && (JSRuntime.arrayIndexLengthInRange(arg0Value_))) {
                ReadCharUTF16Node stringReadNode__ = this.insert((ReadCharUTF16Node.create()));
                Objects.requireNonNull(stringReadNode__, "Specialization 'convertFromString(TruffleString, InlinedConditionProfile, InlinedBranchProfile, ReadCharUTF16Node)' cache 'stringReadNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.convertFromString_stringReadNode_ = stringReadNode__;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToArrayIndexNode.convertFromString(TruffleString, InlinedConditionProfile, InlinedBranchProfile, ReadCharUTF16Node)] */;
                this.state_0_ = state_0;
                return convertFromString(arg0Value_, INLINED_CONVERT_FROM_STRING_STARTS_WITH_DIGIT_BRANCH_, INLINED_CONVERT_FROM_STRING_IS_ARRAY_INDEX_BRANCH_, stringReadNode__);
            }
            if ((!(convertStringToIndex) || !(JSRuntime.arrayIndexLengthInRange(arg0Value_)))) {
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToArrayIndexNode.convertFromStringNotInRange(TruffleString)] */;
                this.state_0_ = state_0;
                return ToArrayIndexNode.convertFromStringNotInRange(arg0Value_);
            }
        }
        {
            long index__ = 0L;
            if (((state_0 & 0b1000000000)) == 0 /* is-not SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
                while (true) {
                    int count8_ = 0;
                    InteropArrayIndex0Data s8_ = INTEROP_ARRAY_INDEX0_CACHE_UPDATER.getVolatile(this);
                    InteropArrayIndex0Data s8_original = s8_;
                    while (s8_ != null) {
                        if ((s8_.interop_.accepts(arg0Value)) && (ToArrayIndexNode.notArrayIndex(arg0Value))) {
                            index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, s8_.interop_));
                            if ((index__ >= 0)) {
                                break;
                            }
                        }
                        count8_++;
                        s8_ = s8_.next_;
                    }
                    if (s8_ == null) {
                        if ((ToArrayIndexNode.notArrayIndex(arg0Value))) {
                            // assert (s8_.interop_.accepts(arg0Value));
                            InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, interop__));
                            if ((index__ >= 0) && count8_ < (JSConfig.InteropLibraryLimit)) {
                                s8_ = this.insert(new InteropArrayIndex0Data(s8_original));
                                Objects.requireNonNull(s8_.insert(interop__), "Specialization 'doInteropArrayIndex(Object, InteropLibrary, long)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s8_.interop_ = interop__;
                                if (!INTEROP_ARRAY_INDEX0_CACHE_UPDATER.compareAndSet(this, s8_original, s8_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s8_ != null) {
                        return ToArrayIndexNode.doInteropArrayIndex(arg0Value, s8_.interop_, index__);
                    }
                    break;
                }
            }
        }
        {
            long index__ = 0L;
            InteropLibrary interop__ = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    if ((ToArrayIndexNode.notArrayIndex(arg0Value))) {
                        interop__ = (INTEROP_LIBRARY_.getUncached());
                        index__ = (ToArrayIndexNode.toArrayIndex(arg0Value, interop__));
                        if ((index__ >= 0)) {
                            this.interopArrayIndex0_cache = null;
                            state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */;
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */;
                            this.state_0_ = state_0;
                            return ToArrayIndexNode.doInteropArrayIndex(arg0Value, interop__, index__);
                        }
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
            while (true) {
                int count10_ = 0;
                NonArrayIndex0Data s10_ = NON_ARRAY_INDEX0_CACHE_UPDATER.getVolatile(this);
                NonArrayIndex0Data s10_original = s10_;
                while (s10_ != null) {
                    if ((s10_.interop_.accepts(arg0Value)) && (ToArrayIndexNode.notArrayIndex(arg0Value)) && (ToArrayIndexNode.toArrayIndex(arg0Value, s10_.interop_) < 0)) {
                        break;
                    }
                    count10_++;
                    s10_ = s10_.next_;
                }
                if (s10_ == null) {
                    if ((ToArrayIndexNode.notArrayIndex(arg0Value))) {
                        // assert (s10_.interop_.accepts(arg0Value));
                        InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg0Value)));
                        if ((ToArrayIndexNode.toArrayIndex(arg0Value, interop__1) < 0) && count10_ < (JSConfig.InteropLibraryLimit)) {
                            s10_ = this.insert(new NonArrayIndex0Data(s10_original));
                            Objects.requireNonNull(s10_.insert(interop__1), "Specialization 'doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s10_.interop_ = interop__1;
                            JSToPropertyKeyNode toPropertyKey__ = s10_.insert((JSToPropertyKeyNode.create()));
                            Objects.requireNonNull(toPropertyKey__, "Specialization 'doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)' cache 'toPropertyKey' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s10_.toPropertyKey_ = toPropertyKey__;
                            ToArrayIndexNode recursive__ = s10_.insert((ToArrayIndexNode.createNoToPropertyKey()));
                            Objects.requireNonNull(recursive__, "Specialization 'doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)' cache 'recursive' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s10_.recursive_ = recursive__;
                            if (!NON_ARRAY_INDEX0_CACHE_UPDATER.compareAndSet(this, s10_original, s10_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s10_ != null) {
                    return doNonArrayIndex(arg0Value, s10_.interop_, s10_.toPropertyKey_, s10_.recursive_);
                }
                break;
            }
        }
        {
            InteropLibrary interop__1 = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    if ((ToArrayIndexNode.notArrayIndex(arg0Value))) {
                        interop__1 = (INTEROP_LIBRARY_.getUncached());
                        if ((ToArrayIndexNode.toArrayIndex(arg0Value, interop__1) < 0)) {
                            NonArrayIndex1Data s11_ = this.insert(new NonArrayIndex1Data());
                            JSToPropertyKeyNode toPropertyKey__ = s11_.insert((JSToPropertyKeyNode.create()));
                            Objects.requireNonNull(toPropertyKey__, "Specialization 'doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)' cache 'toPropertyKey' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s11_.toPropertyKey_ = toPropertyKey__;
                            ToArrayIndexNode recursive__ = s11_.insert((ToArrayIndexNode.createNoToPropertyKey()));
                            Objects.requireNonNull(recursive__, "Specialization 'doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)' cache 'recursive' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s11_.recursive_ = recursive__;
                            VarHandle.storeStoreFence();
                            this.nonArrayIndex1_cache = s11_;
                            this.nonArrayIndex0_cache = null;
                            state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */;
                            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */;
                            this.state_0_ = state_0;
                            return doNonArrayIndex(arg0Value, interop__1, toPropertyKey__, recursive__);
                        }
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111111111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b111111111111) & ((state_0 & 0b111111111111) - 1)) == 0 /* is-single  */) {
                InteropArrayIndex0Data s8_ = this.interopArrayIndex0_cache;
                NonArrayIndex0Data s10_ = this.nonArrayIndex0_cache;
                if ((s8_ == null || s8_.next_ == null) && (s10_ == null || s10_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[13];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "doInteger";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteger(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doLong";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToArrayIndexNode.doLong(long)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doDoubleAsIntIndex";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsIntIndex(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doDoubleAsUintIndex";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToArrayIndexNode.doDoubleAsUintIndex(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToArrayIndexNode.doSymbol(Symbol)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToArrayIndexNode.doBigInt(BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "convertFromString";
        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToArrayIndexNode.convertFromString(TruffleString, InlinedConditionProfile, InlinedBranchProfile, ReadCharUTF16Node)] */) {
            {
                ReadCharUTF16Node stringReadNode__ = this.convertFromString_stringReadNode_;
                if (stringReadNode__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(INLINED_CONVERT_FROM_STRING_STARTS_WITH_DIGIT_BRANCH_, INLINED_CONVERT_FROM_STRING_IS_ARRAY_INDEX_BRANCH_, this.convertFromString_stringReadNode_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "convertFromStringNotInRange";
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToArrayIndexNode.convertFromStringNotInRange(TruffleString)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doInteropArrayIndex";
        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            InteropArrayIndex0Data s8_ = this.interopArrayIndex0_cache;
            while (s8_ != null) {
                cached.add(Arrays.<Object>asList(s8_.interop_));
                s8_ = s8_.next_;
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doInteropArrayIndex";
        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doInteropArrayIndex(Object, InteropLibrary, long)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList());
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doNonArrayIndex";
        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            NonArrayIndex0Data s10_ = this.nonArrayIndex0_cache;
            while (s10_ != null) {
                cached.add(Arrays.<Object>asList(s10_.interop_, s10_.toPropertyKey_, s10_.recursive_));
                s10_ = s10_.next_;
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doNonArrayIndex";
        if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ToArrayIndexNode.doNonArrayIndex(Object, InteropLibrary, JSToPropertyKeyNode, ToArrayIndexNode)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            NonArrayIndex1Data s11_ = this.nonArrayIndex1_cache;
            if (s11_ != null) {
                cached.add(Arrays.<Object>asList(s11_.toPropertyKey_, s11_.recursive_));
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static ToArrayIndexNode create(boolean convertToPropertyKey, boolean convertStringToIndex) {
        return new ToArrayIndexNodeGen(convertToPropertyKey, convertStringToIndex);
    }

    @GeneratedBy(ToArrayIndexNode.class)
    @DenyReplace
    private static final class InteropArrayIndex0Data extends Node implements SpecializationDataNode {

        @Child InteropArrayIndex0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToArrayIndexNode#doInteropArrayIndex}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        InteropArrayIndex0Data(InteropArrayIndex0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(ToArrayIndexNode.class)
    @DenyReplace
    private static final class NonArrayIndex0Data extends Node implements SpecializationDataNode {

        @Child NonArrayIndex0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToArrayIndexNode#doNonArrayIndex}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToArrayIndexNode#doNonArrayIndex}
         *   Parameter: {@link JSToPropertyKeyNode} toPropertyKey</pre>
         */
        @Child JSToPropertyKeyNode toPropertyKey_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToArrayIndexNode#doNonArrayIndex}
         *   Parameter: {@link ToArrayIndexNode} recursive</pre>
         */
        @Child ToArrayIndexNode recursive_;

        NonArrayIndex0Data(NonArrayIndex0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(ToArrayIndexNode.class)
    @DenyReplace
    private static final class NonArrayIndex1Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link ToArrayIndexNode#doNonArrayIndex}
         *   Parameter: {@link JSToPropertyKeyNode} toPropertyKey</pre>
         */
        @Child JSToPropertyKeyNode toPropertyKey_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToArrayIndexNode#doNonArrayIndex}
         *   Parameter: {@link ToArrayIndexNode} recursive</pre>
         */
        @Child ToArrayIndexNode recursive_;

        NonArrayIndex1Data() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
