// CheckStyle: start generated
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSUnaryMinusNode#doInt}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSUnaryMinusNode#doDouble}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSUnaryMinusNode#doBigInt}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSUnaryMinusNode#doOverloaded}
 *     Activation probability: 0.14000
 *     With/without class size: 6/4 bytes
 *   Specialization {@link JSUnaryMinusNode#doGeneric}
 *     Activation probability: 0.08000
 *     With/without class size: 5/8 bytes
 * </pre>
 */
@GeneratedBy(JSUnaryMinusNode.class)
@SuppressWarnings("javadoc")
public final class JSUnaryMinusNodeGen extends JSUnaryMinusNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSUnaryMinusNode#doInt}
     *   1: SpecializationActive {@link JSUnaryMinusNode#doDouble}
     *   2: SpecializationActive {@link JSUnaryMinusNode#doBigInt}
     *   3: SpecializationActive {@link JSUnaryMinusNode#doOverloaded}
     *   4: SpecializationActive {@link JSUnaryMinusNode#doGeneric}
     *   5-7: ImplicitCast[type=double, index=0]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSUnaryMinusNode#doOverloaded}
     *   Parameter: {@link JSOverloadedUnaryNode} overloadedOperatorNode</pre>
     */
    @Child private JSOverloadedUnaryNode overloaded_overloadedOperatorNode_;
    @Child private GenericData generic_cache;

    private JSUnaryMinusNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public Object execute(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111) != 0 /* is SpecializationActive[JSUnaryMinusNode.doInt(int)] || SpecializationActive[JSUnaryMinusNode.doDouble(double)] || SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] || SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] || SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSUnaryMinusNode.doInt(int)] */ && operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (int) operandNodeValue;
                if ((JSUnaryMinusNode.isInt(operandNodeValue_))) {
                    return JSUnaryMinusNode.doInt(operandNodeValue_);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSUnaryMinusNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue)) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue);
                return JSUnaryMinusNode.doDouble(operandNodeValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] */ && operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                return JSUnaryMinusNode.doBigInt(operandNodeValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */ && operandNodeValue instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
                {
                    JSOverloadedUnaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */) {
                GenericData s4_ = this.generic_cache;
                if (s4_ != null) {
                    if ((!(hasOverloadedOperators(operandNodeValue)))) {
                        return JSUnaryMinusNode.doGeneric(operandNodeValue, s4_.toNumericNode_, s4_.recursiveUnaryMinus_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11110) == 0 /* only-active SpecializationActive[JSUnaryMinusNode.doInt(int)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b11101) == 0 /* only-active SpecializationActive[JSUnaryMinusNode.doDouble(double)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSUnaryMinusNode.doInt(int)] */;
        if ((JSUnaryMinusNode.isInt(operandNodeValue_))) {
            return JSUnaryMinusNode.doInt(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[JSUnaryMinusNode.doDouble(double)] */;
        return JSUnaryMinusNode.doDouble(operandNodeValue_);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b11111) != 0 /* is SpecializationActive[JSUnaryMinusNode.doInt(int)] || SpecializationActive[JSUnaryMinusNode.doDouble(double)] || SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] || SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] || SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSUnaryMinusNode.doInt(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                if ((JSUnaryMinusNode.isInt(operandNodeValue__))) {
                    return JSUnaryMinusNode.doInt(operandNodeValue__);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSUnaryMinusNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                return JSUnaryMinusNode.doDouble(operandNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                return JSUnaryMinusNode.doBigInt(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */ && operandNodeValue_ instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue__ = (JSOverloadedOperatorsObject) operandNodeValue_;
                {
                    JSOverloadedUnaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                    if (overloadedOperatorNode__ != null) {
                        return doOverloaded(operandNodeValue__, overloadedOperatorNode__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */) {
                GenericData s4_ = this.generic_cache;
                if (s4_ != null) {
                    if ((!(hasOverloadedOperators(operandNodeValue_)))) {
                        return JSUnaryMinusNode.doGeneric(operandNodeValue_, s4_.toNumericNode_, s4_.recursiveUnaryMinus_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] || SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */) {
            return JSTypesGen.expectDouble(execute(frameValue));
        }
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSUnaryMinusNode.doDouble(double)] */) {
            return JSUnaryMinusNode.doDouble(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */) ? (Object) operandNodeValue_int : (Object) operandNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] || SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSUnaryMinusNode.doInt(int)] */) {
            if ((JSUnaryMinusNode.isInt(operandNodeValue_))) {
                return JSUnaryMinusNode.doInt(operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b11110) == 0 /* only-active SpecializationActive[JSUnaryMinusNode.doInt(int)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
                executeInt(frameValue);
                return;
            } else if ((state_0 & 0b11101) == 0 /* only-active SpecializationActive[JSUnaryMinusNode.doDouble(double)] */ && ((state_0 & 0b11111) != 0  /* is-not SpecializationActive[JSUnaryMinusNode.doInt(int)] && SpecializationActive[JSUnaryMinusNode.doDouble(double)] && SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] && SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] && SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */)) {
                executeDouble(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            if ((JSUnaryMinusNode.isInt(operandNodeValue_))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSUnaryMinusNode.doInt(int)] */;
                this.state_0_ = state_0;
                return JSUnaryMinusNode.doInt(operandNodeValue_);
            }
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSUnaryMinusNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return JSUnaryMinusNode.doDouble(operandNodeValue_);
            }
        }
        if (operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSUnaryMinusNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return JSUnaryMinusNode.doBigInt(operandNodeValue_);
        }
        if (operandNodeValue instanceof JSOverloadedOperatorsObject) {
            JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject) operandNodeValue;
            JSOverloadedUnaryNode overloadedOperatorNode__ = this.insert((JSOverloadedUnaryNodeGen.create(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSUnaryMinusNode.doOverloaded(JSOverloadedOperatorsObject, JSOverloadedUnaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(operandNodeValue_, overloadedOperatorNode__);
        }
        if ((!(hasOverloadedOperators(operandNodeValue)))) {
            GenericData s4_ = this.insert(new GenericData());
            JSToNumericNode toNumericNode__ = s4_.insert((JSToNumericNode.create()));
            Objects.requireNonNull(toNumericNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s4_.toNumericNode_ = toNumericNode__;
            s4_.recursiveUnaryMinus_ = s4_.insert((JSUnaryMinusNode.create()));
            VarHandle.storeStoreFence();
            this.generic_cache = s4_;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSUnaryMinusNode.doGeneric(Object, JSToNumericNode, JSUnaryMinusNode)] */;
            this.state_0_ = state_0;
            return JSUnaryMinusNode.doGeneric(operandNodeValue, toNumericNode__, s4_.recursiveUnaryMinus_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
    }

    @NeverDefault
    public static JSUnaryMinusNode create(JavaScriptNode operand) {
        return new JSUnaryMinusNodeGen(operand);
    }

    @GeneratedBy(JSUnaryMinusNode.class)
    @DenyReplace
    private static final class GenericData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link JSUnaryMinusNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} toNumericNode</pre>
         */
        @Child JSToNumericNode toNumericNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSUnaryMinusNode#doGeneric}
         *   Parameter: {@link JSUnaryMinusNode} recursiveUnaryMinus</pre>
         */
        @Child JSUnaryMinusNode recursiveUnaryMinus_;

        GenericData() {
        }

    }
}
