// CheckStyle: start generated
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject.Interop;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObjectGen;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

@GeneratedBy(Interop.class)
@SuppressWarnings("javadoc")
final class InteropGen {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(Interop.class, new InteropLibraryExports());
    }

    private InteropGen() {
    }

    @GeneratedBy(Interop.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, Interop.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof Interop;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof Interop;
            return new Cached(receiver);
        }

        @GeneratedBy(Interop.class)
        private static final class Cached extends JSNonProxyObjectGen.InteropLibraryExports.Cached {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link Interop#getBufferSize}
             *   Parameter: {@link InlinedBranchProfile} errorBranch
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_ERROR_BRANCH = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(15, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Interop#getBufferSize(Interop, Node, InlinedBranchProfile, InteropLibrary)}
             *   1: SpecializationActive {@link Interop#readBuffer(Interop, long, byte[], int, int, Node, InlinedBranchProfile, InteropLibrary)}
             *   2: SpecializationActive {@link Interop#readBufferByte(Interop, long, Node, InlinedBranchProfile, InteropLibrary)}
             *   3: SpecializationActive {@link Interop#readBufferShort(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *   4: SpecializationActive {@link Interop#readBufferInt(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *   5: SpecializationActive {@link Interop#readBufferLong(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *   6: SpecializationActive {@link Interop#readBufferFloat(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *   7: SpecializationActive {@link Interop#readBufferDouble(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *   8: SpecializationActive {@link Interop#isBufferWritable(Interop, InteropLibrary)}
             *   9: SpecializationActive {@link Interop#writeBufferByte(Interop, long, byte, Node, InlinedBranchProfile, InteropLibrary)}
             *   10: SpecializationActive {@link Interop#writeBufferShort(Interop, ByteOrder, long, short, Node, InlinedBranchProfile, InteropLibrary)}
             *   11: SpecializationActive {@link Interop#writeBufferInt(Interop, ByteOrder, long, int, Node, InlinedBranchProfile, InteropLibrary)}
             *   12: SpecializationActive {@link Interop#writeBufferLong(Interop, ByteOrder, long, long, Node, InlinedBranchProfile, InteropLibrary)}
             *   13: SpecializationActive {@link Interop#writeBufferFloat(Interop, ByteOrder, long, float, Node, InlinedBranchProfile, InteropLibrary)}
             *   14: SpecializationActive {@link Interop#writeBufferDouble(Interop, ByteOrder, long, double, Node, InlinedBranchProfile, InteropLibrary)}
             *   15: InlinedCache
             *        Specialization: {@link Interop#getBufferSize}
             *        Parameter: {@link InlinedBranchProfile} errorBranch
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link JSObject#readMember}
             *   Parameter: {@link FromJavaStringNode} fromJavaString</pre>
             */
            @Child private FromJavaStringNode fromJavaString;
            /**
             * Source Info: <pre>
             *   Specialization: {@link JSObject#isMemberReadable}
             *   Parameter: {@link KeyInfoNode} keyInfo</pre>
             */
            @Child private KeyInfoNode keyInfo;
            /**
             * Source Info: <pre>
             *   Specialization: {@link JSObject#hasIterator}
             *   Parameter: {@link JSInteropGetIteratorNode} getIteratorNode</pre>
             */
            @Child private JSInteropGetIteratorNode getIteratorNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Interop#getBufferSize}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child private InteropLibrary interop;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean hasBufferElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((Interop) receiver)).hasBufferElements();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#getBufferSize(Interop, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long getBufferSize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[Interop.getBufferSize(Interop, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            return arg0Value.getBufferSize(node__, INLINED_ERROR_BRANCH, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getBufferSizeNode_AndSpecialize(arg0Value);
            }

            private long getBufferSizeNode_AndSpecialize(Interop arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b1 /* add SpecializationActive[Interop.getBufferSize(Interop, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.getBufferSize(node__, INLINED_ERROR_BRANCH, interop_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#readBuffer(Interop, long, byte[], int, int, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void readBuffer(Object arg0Value_, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[Interop.readBuffer(Interop, long, byte[], int, int, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            arg0Value.readBuffer(arg1Value, arg2Value, arg3Value, arg4Value, node__, INLINED_ERROR_BRANCH, interop_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                readBufferNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                return;
            }

            private void readBufferNode_AndSpecialize(Interop arg0Value, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b10 /* add SpecializationActive[Interop.readBuffer(Interop, long, byte[], int, int, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.readBuffer(arg1Value, arg2Value, arg3Value, arg4Value, node__, INLINED_ERROR_BRANCH, interop_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#readBufferByte(Interop, long, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[Interop.readBufferByte(Interop, long, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            return arg0Value.readBufferByte(arg1Value, node__, INLINED_ERROR_BRANCH, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readBufferByteNode_AndSpecialize(Interop arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b100 /* add SpecializationActive[Interop.readBufferByte(Interop, long, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readBufferByte(arg1Value, node__, INLINED_ERROR_BRANCH, interop_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#readBufferShort(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[Interop.readBufferShort(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            return arg0Value.readBufferShort(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferShortNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private short readBufferShortNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[Interop.readBufferShort(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readBufferShort(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#readBufferInt(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[Interop.readBufferInt(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            return arg0Value.readBufferInt(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferIntNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int readBufferIntNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[Interop.readBufferInt(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readBufferInt(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#readBufferLong(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[Interop.readBufferLong(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            return arg0Value.readBufferLong(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferLongNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private long readBufferLongNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[Interop.readBufferLong(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readBufferLong(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#readBufferFloat(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[Interop.readBufferFloat(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            return arg0Value.readBufferFloat(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private float readBufferFloatNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[Interop.readBufferFloat(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readBufferFloat(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#readBufferDouble(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[Interop.readBufferDouble(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            return arg0Value.readBufferDouble(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private double readBufferDoubleNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[Interop.readBufferDouble(Interop, ByteOrder, long, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readBufferDouble(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#isBufferWritable(Interop, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[Interop.isBufferWritable(Interop, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            return arg0Value.isBufferWritable(interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isBufferWritableNode_AndSpecialize(arg0Value);
            }

            private boolean isBufferWritableNode_AndSpecialize(Interop arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                InteropLibrary interop_;
                InteropLibrary interop__shared = this.interop;
                if (interop__shared != null) {
                    interop_ = interop__shared;
                } else {
                    interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                    if (interop_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.interop == null) {
                    VarHandle.storeStoreFence();
                    this.interop = interop_;
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[Interop.isBufferWritable(Interop, InteropLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.isBufferWritable(interop_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#writeBufferByte(Interop, long, byte, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[Interop.writeBufferByte(Interop, long, byte, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            arg0Value.writeBufferByte(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferByteNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeBufferByteNode_AndSpecialize(Interop arg0Value, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[Interop.writeBufferByte(Interop, long, byte, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeBufferByte(arg1Value, arg2Value, node__, INLINED_ERROR_BRANCH, interop_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#writeBufferShort(Interop, ByteOrder, long, short, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[Interop.writeBufferShort(Interop, ByteOrder, long, short, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            arg0Value.writeBufferShort(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferShortNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferShortNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[Interop.writeBufferShort(Interop, ByteOrder, long, short, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeBufferShort(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#writeBufferInt(Interop, ByteOrder, long, int, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[Interop.writeBufferInt(Interop, ByteOrder, long, int, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            arg0Value.writeBufferInt(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferIntNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferIntNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b100000000000 /* add SpecializationActive[Interop.writeBufferInt(Interop, ByteOrder, long, int, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeBufferInt(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#writeBufferLong(Interop, ByteOrder, long, long, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[Interop.writeBufferLong(Interop, ByteOrder, long, long, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            arg0Value.writeBufferLong(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferLongNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferLongNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[Interop.writeBufferLong(Interop, ByteOrder, long, long, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeBufferLong(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#writeBufferFloat(Interop, ByteOrder, long, float, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[Interop.writeBufferFloat(Interop, ByteOrder, long, float, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            arg0Value.writeBufferFloat(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferFloatNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[Interop.writeBufferFloat(Interop, ByteOrder, long, float, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeBufferFloat(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Interop#writeBufferDouble(Interop, ByteOrder, long, double, Node, InlinedBranchProfile, InteropLibrary)}
             *     Activation probability: 0.03333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                Interop arg0Value = ((Interop) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[Interop.writeBufferDouble(Interop, ByteOrder, long, double, Node, InlinedBranchProfile, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            Node node__ = (this);
                            arg0Value.writeBufferDouble(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferDoubleNode_AndSpecialize(Interop arg0Value, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary interop_;
                    InteropLibrary interop__shared = this.interop;
                    if (interop__shared != null) {
                        interop_ = interop__shared;
                    } else {
                        interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                        if (interop_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.interop == null) {
                        VarHandle.storeStoreFence();
                        this.interop = interop_;
                    }
                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[Interop.writeBufferDouble(Interop, ByteOrder, long, double, Node, InlinedBranchProfile, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeBufferDouble(arg1Value, arg2Value, arg3Value, node__, INLINED_ERROR_BRANCH, interop_);
                    return;
                }
            }

        }
        @GeneratedBy(Interop.class)
        @DenyReplace
        private static final class Uncached extends JSNonProxyObjectGen.InteropLibraryExports.Uncached {

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean hasBufferElements(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((Interop) receiver) .hasBufferElements();
            }

            @TruffleBoundary
            @Override
            public long getBufferSize(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.getBufferSize((this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void readBuffer(Object arg0Value_, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                arg0Value.readBuffer(arg1Value, arg2Value, arg3Value, arg4Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.readBufferByte(arg1Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.readBufferShort(arg1Value, arg2Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.readBufferInt(arg1Value, arg2Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.readBufferLong(arg1Value, arg2Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.readBufferFloat(arg1Value, arg2Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.readBufferDouble(arg1Value, arg2Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                return arg0Value.isBufferWritable((INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                arg0Value.writeBufferByte(arg1Value, arg2Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                arg0Value.writeBufferShort(arg1Value, arg2Value, arg3Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                arg0Value.writeBufferInt(arg1Value, arg2Value, arg3Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                arg0Value.writeBufferLong(arg1Value, arg2Value, arg3Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                arg0Value.writeBufferFloat(arg1Value, arg2Value, arg3Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Interop arg0Value = ((Interop) arg0Value_);
                arg0Value.writeBufferDouble(arg1Value, arg2Value, arg3Value, (this), (InlinedBranchProfile.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

        }
    }
}
