/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSLanguageOptions;
import com.oracle.truffle.js.runtime.JSRealm;

@NodeInfo(language="JavaScript", description="The abstract base node for all JavaScript nodes")
@TypeSystemReference(value=JSTypes.class)
@GenerateInline(value=false, inherit=true)
@ImportStatic(value={JSGuards.class})
public abstract class JavaScriptBaseNode
extends Node {
    public JavaScriptBaseNode() {
        JSNodeUtil.NODE_CREATE_COUNT.inc();
    }

    public JavaScriptBaseNode copy() {
        JSNodeUtil.NODE_CREATE_COUNT.inc();
        return (JavaScriptBaseNode)super.copy();
    }

    protected void onReplace(Node newNode, CharSequence reason) {
        super.onReplace(newNode, reason);
        JSNodeUtil.NODE_REPLACE_COUNT.inc();
    }

    protected final JSRealm getRealm() {
        return JSRealm.get(this);
    }

    @Idempotent
    protected final JavaScriptLanguage getLanguage() {
        return JavaScriptLanguage.get(this);
    }

    @Idempotent
    protected final JSContext getJSContext() {
        return this.getLanguage().getJSContext();
    }

    @Idempotent
    protected final JSLanguageOptions getLanguageOptions() {
        return this.getJSContext().getLanguageOptions();
    }

    protected final boolean hasOverloadedOperators(Object obj) {
        assert (!JSGuards.hasOverloadedOperators(obj) || this.getLanguageOptions().operatorOverloading());
        return (CompilerDirectives.inInterpreter() || this.getLanguageOptions().operatorOverloading()) && JSGuards.hasOverloadedOperators(obj);
    }
}

