// CheckStyle: start generated
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(DynamicScopeWrapper.class)
@SuppressWarnings("javadoc")
final class DynamicScopeWrapperGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<DynamicObjectLibrary> DYNAMIC_OBJECT_LIBRARY_ = LibraryFactory.resolve(DynamicObjectLibrary.class);

    static  {
        LibraryExport.register(DynamicScopeWrapper.class, new InteropLibraryExports());
    }

    private DynamicScopeWrapperGen() {
    }

    @GeneratedBy(DynamicScopeWrapper.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, DynamicScopeWrapper.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof DynamicScopeWrapper;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof DynamicScopeWrapper;
            return new Cached(receiver);
        }

        @GeneratedBy(DynamicScopeWrapper.class)
        private static final class Cached extends InteropLibrary {

            @Child private DynamicObjectLibrary receiverScopeDynamicObjectLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DynamicScopeWrapper#isMemberReadable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)}
             *   1: SpecializationActive {@link DynamicScopeWrapper#isMemberModifiable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)}
             *   2: SpecializationActive {@link DynamicScopeWrapper#readMember(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary, ExportValueNode)}
             *   3: SpecializationActive {@link DynamicScopeWrapper#writeMember(DynamicScopeWrapper, String, Object, FromJavaStringNode, DynamicObjectLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DynamicScopeWrapper#isMemberReadable}
             *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre>
             */
            @Child private FromJavaStringNode fromJavaStringNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DynamicScopeWrapper#readMember(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary, ExportValueNode)}
             *   Parameter: {@link ExportValueNode} exportValueNode</pre>
             */
            @Child private ExportValueNode readMemberNode__readMember_exportValueNode_;

            protected Cached(Object receiver) {
                DynamicScopeWrapper castReceiver = ((DynamicScopeWrapper) receiver) ;
                this.receiverScopeDynamicObjectLibrary_ = DYNAMIC_OBJECT_LIBRARY_.create((castReceiver.scope));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof DynamicScopeWrapper) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof DynamicScopeWrapper)) {
                    return false;
                } else if (!this.receiverScopeDynamicObjectLibrary_.accepts((((DynamicScopeWrapper) receiver).scope))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert receiver instanceof DynamicScopeWrapper : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DynamicScopeWrapper) receiver)).hasMembers();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link DynamicScopeWrapper#getMembers(DynamicScopeWrapper, boolean, DynamicObjectLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert arg0Value_ instanceof DynamicScopeWrapper : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                {
                    DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                    return arg0Value.getMembers(arg1Value, access__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link DynamicScopeWrapper#isMemberReadable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert arg0Value_ instanceof DynamicScopeWrapper : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[DynamicScopeWrapper.isMemberReadable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)] */) {
                    {
                        FromJavaStringNode fromJavaStringNode_ = this.fromJavaStringNode;
                        if (fromJavaStringNode_ != null) {
                            DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                            return arg0Value.isMemberReadable(arg1Value, fromJavaStringNode_, access__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                {
                    DynamicObjectLibrary access__ = null;
                    FromJavaStringNode fromJavaStringNode_;
                    FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                    if (fromJavaStringNode__shared != null) {
                        fromJavaStringNode_ = fromJavaStringNode__shared;
                    } else {
                        fromJavaStringNode_ = this.insert((FromJavaStringNode.create()));
                        if (fromJavaStringNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromJavaStringNode == null) {
                        VarHandle.storeStoreFence();
                        this.fromJavaStringNode = fromJavaStringNode_;
                    }
                    access__ = this.receiverScopeDynamicObjectLibrary_;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[DynamicScopeWrapper.isMemberReadable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.isMemberReadable(arg1Value, fromJavaStringNode_, access__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link DynamicScopeWrapper#isMemberModifiable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert arg0Value_ instanceof DynamicScopeWrapper : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[DynamicScopeWrapper.isMemberModifiable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)] */) {
                    {
                        FromJavaStringNode fromJavaStringNode_ = this.fromJavaStringNode;
                        if (fromJavaStringNode_ != null) {
                            DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                            return arg0Value.isMemberModifiable(arg1Value, fromJavaStringNode_, access__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                {
                    DynamicObjectLibrary access__ = null;
                    FromJavaStringNode fromJavaStringNode_;
                    FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                    if (fromJavaStringNode__shared != null) {
                        fromJavaStringNode_ = fromJavaStringNode__shared;
                    } else {
                        fromJavaStringNode_ = this.insert((FromJavaStringNode.create()));
                        if (fromJavaStringNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromJavaStringNode == null) {
                        VarHandle.storeStoreFence();
                        this.fromJavaStringNode = fromJavaStringNode_;
                    }
                    access__ = this.receiverScopeDynamicObjectLibrary_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[DynamicScopeWrapper.isMemberModifiable(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary)] */;
                    this.state_0_ = state_0;
                    return arg0Value.isMemberModifiable(arg1Value, fromJavaStringNode_, access__);
                }
            }

            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert receiver instanceof DynamicScopeWrapper : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((DynamicScopeWrapper) receiver)).isMemberInsertable(member);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link DynamicScopeWrapper#readMember(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary, ExportValueNode)}
             *     Activation probability: 0.20000
             *     With/without class size: 8/4 bytes
             * </pre>
             */
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert arg0Value_ instanceof DynamicScopeWrapper : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[DynamicScopeWrapper.readMember(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary, ExportValueNode)] */) {
                    {
                        FromJavaStringNode fromJavaStringNode_ = this.fromJavaStringNode;
                        if (fromJavaStringNode_ != null) {
                            ExportValueNode exportValueNode__ = this.readMemberNode__readMember_exportValueNode_;
                            if (exportValueNode__ != null) {
                                DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                                return arg0Value.readMember(arg1Value, fromJavaStringNode_, access__, exportValueNode__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value) throws UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    DynamicObjectLibrary access__ = null;
                    FromJavaStringNode fromJavaStringNode_;
                    FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                    if (fromJavaStringNode__shared != null) {
                        fromJavaStringNode_ = fromJavaStringNode__shared;
                    } else {
                        fromJavaStringNode_ = this.insert((FromJavaStringNode.create()));
                        if (fromJavaStringNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromJavaStringNode == null) {
                        VarHandle.storeStoreFence();
                        this.fromJavaStringNode = fromJavaStringNode_;
                    }
                    access__ = this.receiverScopeDynamicObjectLibrary_;
                    ExportValueNode exportValueNode__ = this.insert((ExportValueNode.create()));
                    Objects.requireNonNull(exportValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.readMemberNode__readMember_exportValueNode_ = exportValueNode__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[DynamicScopeWrapper.readMember(DynamicScopeWrapper, String, FromJavaStringNode, DynamicObjectLibrary, ExportValueNode)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readMember(arg1Value, fromJavaStringNode_, access__, exportValueNode__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link DynamicScopeWrapper#writeMember(DynamicScopeWrapper, String, Object, FromJavaStringNode, DynamicObjectLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert arg0Value_ instanceof DynamicScopeWrapper : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[DynamicScopeWrapper.writeMember(DynamicScopeWrapper, String, Object, FromJavaStringNode, DynamicObjectLibrary)] */) {
                    {
                        FromJavaStringNode fromJavaStringNode_ = this.fromJavaStringNode;
                        if (fromJavaStringNode_ != null) {
                            DynamicObjectLibrary access__ = this.receiverScopeDynamicObjectLibrary_;
                            arg0Value.writeMember(arg1Value, arg2Value, fromJavaStringNode_, access__);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(DynamicScopeWrapper arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    DynamicObjectLibrary access__ = null;
                    FromJavaStringNode fromJavaStringNode_;
                    FromJavaStringNode fromJavaStringNode__shared = this.fromJavaStringNode;
                    if (fromJavaStringNode__shared != null) {
                        fromJavaStringNode_ = fromJavaStringNode__shared;
                    } else {
                        fromJavaStringNode_ = this.insert((FromJavaStringNode.create()));
                        if (fromJavaStringNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromJavaStringNode == null) {
                        VarHandle.storeStoreFence();
                        this.fromJavaStringNode = fromJavaStringNode_;
                    }
                    access__ = this.receiverScopeDynamicObjectLibrary_;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[DynamicScopeWrapper.writeMember(DynamicScopeWrapper, String, Object, FromJavaStringNode, DynamicObjectLibrary)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeMember(arg1Value, arg2Value, fromJavaStringNode_, access__);
                    return;
                }
            }

        }
        @GeneratedBy(DynamicScopeWrapper.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof DynamicScopeWrapper) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof DynamicScopeWrapper;
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DynamicScopeWrapper) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                return arg0Value.getMembers(arg1Value, DYNAMIC_OBJECT_LIBRARY_.getUncached((arg0Value.scope)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                return arg0Value.isMemberReadable(arg1Value, (FromJavaStringNode.getUncached()), DYNAMIC_OBJECT_LIBRARY_.getUncached((arg0Value.scope)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                return arg0Value.isMemberModifiable(arg1Value, (FromJavaStringNode.getUncached()), DYNAMIC_OBJECT_LIBRARY_.getUncached((arg0Value.scope)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((DynamicScopeWrapper) receiver) .isMemberInsertable(member);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                return arg0Value.readMember(arg1Value, (FromJavaStringNode.getUncached()), DYNAMIC_OBJECT_LIBRARY_.getUncached((arg0Value.scope)), (ExportValueNode.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicScopeWrapper arg0Value = ((DynamicScopeWrapper) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (FromJavaStringNode.getUncached()), DYNAMIC_OBJECT_LIBRARY_.getUncached((arg0Value.scope)));
                return;
            }

        }
    }
}
