/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.IteratorHelperPrototypeBuiltins;
import com.oracle.truffle.js.builtins.IteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.GetIteratorDirectNode;
import com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorGetNextValueNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.SuppressFBWarnings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSIterator;
import com.oracle.truffle.js.runtime.builtins.JSIteratorHelperObject;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidAsyncIterator;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;
import java.util.function.Function;

public final class IteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<IteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new IteratorPrototypeBuiltins();
    public static final JSBuiltinsContainer ASYNC_BUILTINS = new IteratorPrototypeAsyncBuiltins();

    private IteratorPrototypeBuiltins() {
        super(JSIterator.PROTOTYPE_NAME, IteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, IteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return IteratorPrototypeBuiltinsFactory.IteratorToArrayNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 1: {
                return IteratorPrototypeBuiltinsFactory.IteratorForEachNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return IteratorPrototypeBuiltinsFactory.IteratorSomeNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return IteratorPrototypeBuiltinsFactory.IteratorEveryNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return IteratorPrototypeBuiltinsFactory.IteratorFindNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 5: {
                return IteratorPrototypeBuiltinsFactory.IteratorReduceNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 6: {
                return IteratorPrototypeBuiltinsFactory.IteratorMapNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 7: {
                return IteratorPrototypeBuiltinsFactory.IteratorFilterNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 8: {
                return IteratorPrototypeBuiltinsFactory.IteratorTakeNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 9: {
                return IteratorPrototypeBuiltinsFactory.IteratorDropNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 10: {
                return IteratorPrototypeBuiltinsFactory.IteratorFlatMapNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 11: {
                return IteratorPrototypeBuiltinsFactory.IteratorGetConstructorNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().createArgumentNodes(context));
            }
            case 12: {
                return IteratorPrototypeBuiltinsFactory.IteratorSetConstructorNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 13: {
                return IteratorPrototypeBuiltinsFactory.IteratorGetSymbolToStringTagNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().createArgumentNodes(context));
            }
            case 14: {
                return IteratorPrototypeBuiltinsFactory.IteratorSetSymbolToStringTagNodeGen.create(context, builtin, IteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum IteratorPrototype implements BuiltinEnum<IteratorPrototype>
    {
        toArray(0),
        forEach(1),
        some(1),
        every(1),
        find(1),
        reduce(1),
        map(1),
        filter(1),
        take(1),
        drop(1),
        flatMap(1),
        constructor(0),
        set_constructor(1),
        symbolToStringTag(0),
        set_symbolToStringTag(1);

        private final int length;

        @Override
        public Object getKey() {
            return switch (this.ordinal()) {
                case 12 -> constructor.getKey();
                case 13, 14 -> Symbol.SYMBOL_TO_STRING_TAG;
                default -> BuiltinEnum.super.getKey();
            };
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(constructor, symbolToStringTag).contains(this);
        }

        @Override
        public boolean isSetter() {
            return EnumSet.of(set_constructor, set_symbolToStringTag).contains(this);
        }

        private IteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    protected static abstract class IteratorToArrayNode
    extends IteratorMethodNode {
        @Node.Child
        private com.oracle.truffle.js.nodes.access.IteratorToArrayNode toArrayNode;

        protected IteratorToArrayNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.toArrayNode = com.oracle.truffle.js.nodes.access.IteratorToArrayNode.create(context, null);
        }

        @Specialization
        protected Object toArray(VirtualFrame frame, Object thisObj) {
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            return this.toArrayNode.execute(frame, iterated);
        }
    }

    public static abstract class IteratorForEachNode
    extends IteratorConsumerWithCallableNode {
        protected IteratorForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected Object step(IteratorRecord iterated, Object fn, Object value, long counter) {
            this.callMapper(iterated, fn, value, counter);
            return CONTINUE;
        }
    }

    public static abstract class IteratorSomeNode
    extends IteratorConsumerWithCallableNode {
        @Node.Child
        private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

        protected IteratorSomeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected Object step(IteratorRecord iterated, Object fn, Object value, long counter) {
            if (this.toBooleanNode.executeBoolean(this.callMapper(iterated, fn, value, counter))) {
                return true;
            }
            return CONTINUE;
        }

        @Override
        protected Object end() {
            return false;
        }
    }

    public static abstract class IteratorEveryNode
    extends IteratorConsumerWithCallableNode {
        @Node.Child
        private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

        protected IteratorEveryNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected Object step(IteratorRecord iterated, Object fn, Object value, long counter) {
            if (!this.toBooleanNode.executeBoolean(this.callMapper(iterated, fn, value, counter))) {
                return false;
            }
            return CONTINUE;
        }

        @Override
        protected Object end() {
            return true;
        }
    }

    public static abstract class IteratorFindNode
    extends IteratorConsumerWithCallableNode {
        @Node.Child
        private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();

        protected IteratorFindNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected Object step(IteratorRecord iterated, Object fn, Object value, long counter) {
            if (this.toBooleanNode.executeBoolean(this.callMapper(iterated, fn, value, counter))) {
                return value;
            }
            return CONTINUE;
        }
    }

    public static abstract class IteratorReduceNode
    extends IteratorMethodWithCallableNode {
        @Node.Child
        private IteratorStepNode iteratorStepNode = IteratorStepNode.create();
        @Node.Child
        private IteratorValueNode iteratorValueNode = IteratorValueNode.create();
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;

        protected IteratorReduceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isCallable(reducer)"})
        protected Object reduce(Object thisObj, Object reducer, Object[] args, @Cached(inline=true) LongToIntOrDoubleNode counterToJSNumber) {
            long counter;
            Object accumulator;
            Object next;
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            if (args.length == 0) {
                next = this.iteratorStepNode.execute(iterated);
                if (next == Boolean.FALSE) {
                    throw Errors.createTypeError("Reduce of empty iterator with no initial value");
                }
                accumulator = this.iteratorValueNode.execute(next);
                counter = 1L;
            } else {
                accumulator = args[0];
                counter = 0L;
            }
            while ((next = this.iteratorStepNode.execute(iterated)) != Boolean.FALSE) {
                Object value = this.iteratorValueNode.execute(next);
                try {
                    accumulator = this.callNode.executeCall(JSArguments.create((Object)Undefined.instance, reducer, accumulator, value, counterToJSNumber.execute(this, counter)));
                    ++counter;
                }
                catch (AbstractTruffleException ex) {
                    this.iteratorCloseNode().executeAbrupt(iterated.getIterator());
                    throw ex;
                }
            }
            return accumulator;
        }

        @Specialization(guards={"!isCallable(reducer)"})
        protected void incompatible(Object thisObj, Object reducer, Object[] args) {
            throw Errors.createTypeErrorNotAFunction(reducer);
        }

        private IteratorCloseNode iteratorCloseNode() {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            return this.iteratorCloseNode;
        }
    }

    protected static abstract class IteratorMapNode
    extends IteratorFromGeneratorNode<IteratorMapArgs> {
        protected IteratorMapNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, JSContext.BuiltinFunctionKey.IteratorMap, c -> IteratorMapNode.createIteratorFromGeneratorFunctionImpl(c, IteratorMapNextNode.create(c)));
        }

        @Specialization(guards={"isCallable(mapper)"})
        public JSDynamicObject map(Object thisObj, Object mapper) {
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            return this.createIteratorHelperObject(new IteratorMapArgs(iterated, mapper));
        }

        @Specialization(guards={"!isCallable(mapper)"})
        public Object unsupported(Object thisObj, Object mapper) {
            throw Errors.createTypeErrorCallableExpected();
        }

        protected static class IteratorMapArgs
        extends IteratorWithCounterArgs {
            public final Object mapper;

            public IteratorMapArgs(IteratorRecord target, Object mapper) {
                super(target);
                this.mapper = mapper;
            }
        }

        protected static abstract class IteratorMapNextNode
        extends IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorMapArgs> {
            @Node.Child
            private IteratorCloseNode iteratorCloseNode;
            @Node.Child
            private JSFunctionCallNode callNode;

            protected IteratorMapNextNode(JSContext context) {
                super(context);
                this.iteratorCloseNode = IteratorCloseNode.create(context);
                this.callNode = JSFunctionCallNode.createCall();
            }

            @Specialization
            protected Object next(VirtualFrame frame, JSIteratorHelperObject thisObj) {
                Object mapped;
                IteratorMapArgs args = (IteratorMapArgs)this.getArgs(thisObj);
                Object next = this.iteratorStep(args.iterated);
                if (next == Boolean.FALSE) {
                    return this.createResultDone(frame, thisObj);
                }
                Object value = this.iteratorValue(next);
                try {
                    mapped = this.callNode.executeCall(JSArguments.create((Object)Undefined.instance, args.mapper, value, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException e) {
                    this.iteratorCloseNode.executeAbrupt(args.iterated.getIterator());
                    throw e;
                }
                ++args.counter;
                return this.createResultContinue(frame, thisObj, mapped);
            }

            @Override
            public IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorMapArgs> copyUninitialized() {
                return IteratorMapNextNode.create(this.context);
            }

            public static IteratorMapNextNode create(JSContext context) {
                return IteratorPrototypeBuiltinsFactory.IteratorMapNodeGen.IteratorMapNextNodeGen.create(context);
            }
        }
    }

    protected static abstract class IteratorFilterNode
    extends IteratorFromGeneratorNode<IteratorFilterArgs> {
        protected IteratorFilterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, JSContext.BuiltinFunctionKey.IteratorFilter, c -> IteratorFilterNode.createIteratorFromGeneratorFunctionImpl(c, IteratorFilterNextNode.create(c)));
        }

        @Specialization(guards={"isCallable(filterer)"})
        public JSDynamicObject filter(Object thisObj, Object filterer) {
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            return this.createIteratorHelperObject(new IteratorFilterArgs(iterated, filterer));
        }

        @Specialization(guards={"!isCallable(filterer)"})
        public Object unsupported(Object thisObj, Object filterer) {
            throw Errors.createTypeErrorCallableExpected();
        }

        protected static class IteratorFilterArgs
        extends IteratorWithCounterArgs {
            public final Object filterer;

            public IteratorFilterArgs(IteratorRecord target, Object filterer) {
                super(target);
                this.filterer = filterer;
            }
        }

        protected static abstract class IteratorFilterNextNode
        extends IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorFilterArgs> {
            @Node.Child
            private IteratorCloseNode iteratorCloseNode;
            @Node.Child
            private JSFunctionCallNode callNode;
            @Node.Child
            private JSToBooleanNode toBooleanNode;

            protected IteratorFilterNextNode(JSContext context) {
                super(context);
                this.iteratorCloseNode = IteratorCloseNode.create(context);
                this.callNode = JSFunctionCallNode.createCall();
                this.toBooleanNode = JSToBooleanNode.create();
            }

            @Specialization
            protected Object next(VirtualFrame frame, JSIteratorHelperObject thisObj) {
                Object value;
                Object selected;
                IteratorFilterArgs args = (IteratorFilterArgs)this.getArgs(thisObj);
                do {
                    Object next;
                    if ((next = this.iteratorStep(args.iterated)) == Boolean.FALSE) {
                        return this.createResultDone(frame, thisObj);
                    }
                    value = this.iteratorValue(next);
                    try {
                        selected = this.callNode.executeCall(JSArguments.create((Object)Undefined.instance, args.filterer, value, this.indexToJS(args.counter)));
                    }
                    catch (AbstractTruffleException e) {
                        this.iteratorCloseNode.executeAbrupt(args.iterated.getIterator());
                        throw e;
                    }
                    ++args.counter;
                } while (!this.toBooleanNode.executeBoolean(selected));
                return this.createResultContinue(frame, thisObj, value);
            }

            @Override
            public IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorFilterArgs> copyUninitialized() {
                return IteratorFilterNextNode.create(this.context);
            }

            public static IteratorFilterNextNode create(JSContext context) {
                return IteratorPrototypeBuiltinsFactory.IteratorFilterNodeGen.IteratorFilterNextNodeGen.create(context);
            }
        }
    }

    protected static abstract class IteratorTakeNode
    extends IteratorFromGeneratorNode<IteratorTakeArgs> {
        @Node.Child
        private JSToNumberNode toNumberNode = JSToNumberNode.create();
        @Node.Child
        private JSToIntegerOrInfinityNode toIntegerOrInfinityNode = JSToIntegerOrInfinityNode.create();

        protected IteratorTakeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, JSContext.BuiltinFunctionKey.IteratorTake, c -> IteratorTakeNode.createIteratorFromGeneratorFunctionImpl(c, IteratorTakeNextNode.create(c)));
        }

        @Specialization
        public JSDynamicObject take(Object thisObj, Object limit, @Cached IsObjectNode isObjectNode, @Cached InlinedBranchProfile errorBranch) {
            if (!isObjectNode.executeBoolean(thisObj)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorNotAnObject(thisObj, this);
            }
            Number numLimit = this.toNumberNode.executeNumber(limit);
            if (JSRuntime.isNaN(numLimit)) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("NaN is not allowed", (Node)this);
            }
            double integerLimit = JSRuntime.doubleValue(this.toIntegerOrInfinityNode.executeNumber(numLimit));
            if (integerLimit < 0.0) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeErrorIndexNegative(this);
            }
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            return this.createIteratorHelperObject(new IteratorTakeArgs(iterated, integerLimit));
        }

        protected static class IteratorTakeArgs
        extends IteratorArgs {
            public double remaining;

            public IteratorTakeArgs(IteratorRecord target, double limit) {
                super(target);
                this.remaining = limit;
            }
        }

        protected static abstract class IteratorTakeNextNode
        extends IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorTakeArgs> {
            @Node.Child
            private IteratorCloseNode iteratorCloseNode;
            private final ConditionProfile finiteProfile = ConditionProfile.create();

            protected IteratorTakeNextNode(JSContext context) {
                super(context);
                this.iteratorCloseNode = IteratorCloseNode.create(context);
            }

            @Specialization
            protected Object next(VirtualFrame frame, JSIteratorHelperObject thisObj) {
                IteratorTakeArgs args = (IteratorTakeArgs)this.getArgs(thisObj);
                double remaining = args.remaining;
                if (remaining == 0.0) {
                    this.iteratorCloseNode.executeVoid(args.iterated.getIterator());
                    return this.createResultDone(frame, thisObj);
                }
                if (this.finiteProfile.profile(remaining != Double.POSITIVE_INFINITY)) {
                    args.remaining = remaining - 1.0;
                }
                return this.getNextValue(frame, thisObj, args.iterated);
            }

            @Override
            public IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorTakeArgs> copyUninitialized() {
                return IteratorTakeNextNode.create(this.context);
            }

            public static IteratorTakeNextNode create(JSContext context) {
                return IteratorPrototypeBuiltinsFactory.IteratorTakeNodeGen.IteratorTakeNextNodeGen.create(context);
            }
        }
    }

    protected static abstract class IteratorDropNode
    extends IteratorFromGeneratorNode<IteratorDropArgs> {
        @Node.Child
        private JSToNumberNode toNumberNode = JSToNumberNode.create();
        @Node.Child
        private JSToIntegerOrInfinityNode toIntegerOrInfinityNode = JSToIntegerOrInfinityNode.create();

        protected IteratorDropNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, JSContext.BuiltinFunctionKey.IteratorDrop, c -> IteratorDropNode.createIteratorFromGeneratorFunctionImpl(c, IteratorDropNextNode.create(c)));
        }

        @Specialization
        public JSDynamicObject drop(Object thisObj, Object limit, @Cached IsObjectNode isObjectNode, @Cached InlinedBranchProfile errorBranch) {
            if (!isObjectNode.executeBoolean(thisObj)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorNotAnObject(thisObj, this);
            }
            Number numLimit = this.toNumberNode.executeNumber(limit);
            if (JSRuntime.isNaN(numLimit)) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("NaN is not allowed", (Node)this);
            }
            double integerLimit = JSRuntime.doubleValue(this.toIntegerOrInfinityNode.executeNumber(numLimit));
            if (integerLimit < 0.0) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeErrorIndexNegative(this);
            }
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            return this.createIteratorHelperObject(new IteratorDropArgs(iterated, integerLimit));
        }

        protected static class IteratorDropArgs
        extends IteratorArgs {
            public double remaining;

            public IteratorDropArgs(IteratorRecord target, double limit) {
                super(target);
                this.remaining = limit;
            }
        }

        protected static abstract class IteratorDropNextNode
        extends IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorDropArgs> {
            private final ConditionProfile finiteProfile = ConditionProfile.create();

            protected IteratorDropNextNode(JSContext context) {
                super(context);
            }

            @Specialization
            @SuppressFBWarnings(value={"FL_FLOATS_AS_LOOP_COUNTERS"}, justification="intentional use of floating-point variable as loop counter")
            protected Object next(VirtualFrame frame, JSIteratorHelperObject thisObj) {
                IteratorDropArgs args = (IteratorDropArgs)this.getArgs(thisObj);
                double remaining = args.remaining;
                while (remaining > 0.0) {
                    Object next;
                    if (this.finiteProfile.profile(remaining != Double.POSITIVE_INFINITY)) {
                        args.remaining = remaining -= 1.0;
                    }
                    if ((next = this.iteratorStep(args.iterated)) != Boolean.FALSE) continue;
                    return this.createResultDone(frame, thisObj);
                }
                return this.getNextValue(frame, thisObj, args.iterated);
            }

            @Override
            public IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorDropArgs> copyUninitialized() {
                return IteratorDropNextNode.create(this.context);
            }

            public static IteratorDropNextNode create(JSContext context) {
                return IteratorPrototypeBuiltinsFactory.IteratorDropNodeGen.IteratorDropNextNodeGen.create(context);
            }
        }
    }

    protected static abstract class IteratorFlatMapNode
    extends IteratorFromGeneratorNode<IteratorFlatMapArgs> {
        protected IteratorFlatMapNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, JSContext.BuiltinFunctionKey.IteratorFlatMap, c -> IteratorFlatMapNode.createIteratorFromGeneratorFunctionImpl(c, IteratorFlatMapNextNode.create(c)));
        }

        @Specialization(guards={"isCallable(mapper)"})
        public JSDynamicObject flatMap(Object thisObj, Object mapper) {
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            return this.createIteratorHelperObject(new IteratorFlatMapArgs(iterated, mapper));
        }

        @Specialization(guards={"!isCallable(mapper)"})
        public Object unsupported(Object thisObj, Object mapper) {
            throw Errors.createTypeErrorCallableExpected();
        }

        protected static class IteratorFlatMapArgs
        extends IteratorWithCounterArgs {
            public final Object mapper;
            public boolean innerAlive;
            public IteratorRecord innerIterator;

            public IteratorFlatMapArgs(IteratorRecord target, Object mapper) {
                super(target);
                this.mapper = mapper;
            }
        }

        protected static abstract class IteratorFlatMapNextNode
        extends IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorFlatMapArgs> {
            @Node.Child
            private IteratorCloseNode iteratorCloseNode;
            @Node.Child
            private JSFunctionCallNode callNode;
            @Node.Child
            private GetIteratorFlattenableNode getIteratorFlattenableNode;
            @Node.Child
            private IteratorGetNextValueNode getNextValueNode;

            protected IteratorFlatMapNextNode(JSContext context) {
                super(context);
                this.iteratorCloseNode = IteratorCloseNode.create(context);
                this.callNode = JSFunctionCallNode.createCall();
                this.getIteratorFlattenableNode = GetIteratorFlattenableNode.create(true, false, context);
                this.getNextValueNode = IteratorGetNextValueNode.create(context, null, JSConstantNode.create(null), true);
            }

            @Specialization
            protected Object next(VirtualFrame frame, JSIteratorHelperObject thisObj) {
                IteratorFlatMapArgs args = (IteratorFlatMapArgs)this.getArgs(thisObj);
                boolean innerAlive = args.innerAlive;
                while (true) {
                    if (innerAlive) {
                        Object innerValue;
                        try {
                            innerValue = this.getNextValueNode.execute(frame, args.innerIterator);
                        }
                        catch (AbstractTruffleException e) {
                            this.iteratorCloseNode.executeAbrupt(args.iterated.getIterator());
                            throw e;
                        }
                        if (innerValue == null) {
                            innerAlive = false;
                            args.innerAlive = false;
                            args.innerIterator = null;
                            continue;
                        }
                        return this.createResultContinue(frame, thisObj, innerValue);
                    }
                    Object value = this.getNextValueNode.execute(frame, args.iterated);
                    if (value == null) {
                        return this.createResultDone(frame, thisObj);
                    }
                    try {
                        Object mapped = this.callNode.executeCall(JSArguments.create((Object)Undefined.instance, args.mapper, value, this.indexToJS(args.counter)));
                        args.innerIterator = this.getIteratorFlattenableNode.execute(mapped);
                    }
                    catch (AbstractTruffleException e) {
                        this.iteratorCloseNode.executeAbrupt(args.iterated.getIterator());
                        throw e;
                    }
                    ++args.counter;
                    innerAlive = true;
                    args.innerAlive = true;
                }
            }

            @Override
            public IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<IteratorFlatMapArgs> copyUninitialized() {
                return IteratorFlatMapNextNode.create(this.context);
            }

            public static IteratorFlatMapNextNode create(JSContext context) {
                return IteratorPrototypeBuiltinsFactory.IteratorFlatMapNodeGen.IteratorFlatMapNextNodeGen.create(context);
            }
        }
    }

    public static abstract class IteratorGetConstructorNode
    extends JSBuiltinNode {
        protected IteratorGetConstructorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getValue() {
            return this.getRealm().getIteratorConstructor();
        }
    }

    @ImportStatic(value={JSObject.class})
    public static abstract class IteratorSetConstructorNode
    extends JSBuiltinNode {
        protected IteratorSetConstructorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object setValue(Object thisObj, Object value, @Cached(value="create(getContext(), CONSTRUCTOR)") SetterThatIgnoresPrototypePropertiesNode setterNode) {
            JSDynamicObject home = this.getRealm().getIteratorPrototype();
            setterNode.executeWithHomeAndValue(thisObj, (Object)home, value);
            return Undefined.instance;
        }
    }

    public static abstract class IteratorGetSymbolToStringTagNode
    extends JSBuiltinNode {
        protected IteratorGetSymbolToStringTagNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getValue() {
            return JSIterator.CLASS_NAME;
        }
    }

    @ImportStatic(value={Symbol.class})
    public static abstract class IteratorSetSymbolToStringTagNode
    extends JSBuiltinNode {
        protected IteratorSetSymbolToStringTagNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object setValue(Object thisObj, Object value, @Cached(value="create(getContext(), SYMBOL_TO_STRING_TAG)") SetterThatIgnoresPrototypePropertiesNode setterNode) {
            JSDynamicObject home = this.getRealm().getIteratorPrototype();
            setterNode.executeWithHomeAndValue(thisObj, (Object)home, value);
            return Undefined.instance;
        }
    }

    public static final class IteratorPrototypeAsyncBuiltins
    extends JSBuiltinsContainer.SwitchEnum<IteratorPrototypeAsync> {
        private IteratorPrototypeAsyncBuiltins() {
            super(IteratorPrototypeAsync.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, IteratorPrototypeAsync builtinEnum) {
            switch (builtinEnum.ordinal()) {
                case 0: {
                    return IteratorPrototypeBuiltinsFactory.IteratorToAsyncNodeGen.create(context, builtin, IteratorPrototypeAsyncBuiltins.args().withThis().varArgs().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum IteratorPrototypeAsync implements BuiltinEnum<IteratorPrototypeAsync>
        {
            toAsync(0);

            private final int length;

            private IteratorPrototypeAsync(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static abstract class IteratorToAsyncNode
    extends IteratorMethodNode {
        protected IteratorToAsyncNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject toAsync(Object thisObj) {
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            return JSWrapForValidAsyncIterator.create(this.getContext(), this.getRealm(), iterated);
        }
    }

    protected static abstract class IteratorConsumerWithCallableNode
    extends IteratorMethodWithCallableNode {
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
        @Node.Child
        private PropertyGetNode getDoneNode;
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private JSToBooleanNode toBooleanNode;
        @Node.Child
        private IteratorValueNode iteratorValueNode = IteratorValueNode.create();
        @Node.Child
        private LongToIntOrDoubleNode indexToJS;
        protected static final Object CONTINUE = new Object();

        protected IteratorConsumerWithCallableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getDoneNode = PropertyGetNode.create(Strings.DONE, context);
            this.isObjectNode = IsJSObjectNode.create();
            this.toBooleanNode = JSToBooleanNode.create();
            this.indexToJS = LongToIntOrDoubleNode.create();
        }

        protected Object end() {
            return Undefined.instance;
        }

        protected Object step(IteratorRecord iterated, Object fn, Object value, long counter) {
            return CONTINUE;
        }

        protected final Object callMapper(IteratorRecord iterated, Object fn, Object value, long counter) {
            try {
                return this.callNode.executeCall(JSArguments.create((Object)Undefined.instance, fn, value, this.indexToJS(counter)));
            }
            catch (AbstractTruffleException ex) {
                if (this.iteratorCloseNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
                }
                this.iteratorCloseNode.executeAbrupt(iterated.getIterator());
                throw ex;
            }
        }

        @Specialization(guards={"isCallable(fn)"})
        protected Object compatible(Object thisObj, Object fn, @Cached InlinedBranchProfile errorBranch) {
            Object next;
            Object result;
            IteratorRecord iterated = this.getIteratorDirect(thisObj);
            long counter = 0L;
            do {
                if (!this.isObjectNode.executeBoolean(next = this.iteratorNextNode.execute(iterated))) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeErrorIterResultNotAnObject(next, this);
                }
                if (!this.toBooleanNode.executeBoolean(this.getDoneNode.getValue(next))) continue;
                return this.end();
            } while ((result = this.step(iterated, fn, this.iteratorValueNode.execute(next), counter++)) == CONTINUE);
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            return this.iteratorCloseNode.execute(iterated.getIterator(), result);
        }

        @Specialization(guards={"!isCallable(fn)"})
        protected void incompatible(Object thisObj, Object fn) {
            throw Errors.createTypeErrorNotAFunction(fn);
        }

        protected final Object indexToJS(long index) {
            return this.indexToJS.execute(null, index);
        }
    }

    private static abstract class IteratorFromGeneratorNode<T extends IteratorArgs>
    extends IteratorMethodWithCallableNode {
        private final JSContext.BuiltinFunctionKey nextKey;
        private final Function<JSContext, JSFunctionData> nextFactory;

        IteratorFromGeneratorNode(JSContext context, JSBuiltin builtin, JSContext.BuiltinFunctionKey nextKey, Function<JSContext, JSFunctionData> nextFactory) {
            super(context, builtin);
            this.nextKey = nextKey;
            this.nextFactory = nextFactory;
        }

        protected final JSIteratorHelperObject createIteratorHelperObject(T args) {
            return JSIteratorHelperObject.create(this.getContext().getIteratorHelperObjectFactory(), this.getRealm(), JSFunction.GeneratorState.SuspendedStart, args, this.createNextImplFunction());
        }

        protected static JSFunctionData createIteratorFromGeneratorFunctionImpl(JSContext context, IteratorFromGeneratorImplNode<?> implNode) {
            return JSFunctionData.createCallOnly(context, (CallTarget)IteratorRootNode.create(implNode).getCallTarget(), 0, Strings.EMPTY);
        }

        private JSFunctionObject createNextImplFunction() {
            return JSFunction.create(this.getRealm(), this.getContext().getOrCreateBuiltinFunctionData(this.nextKey, this.nextFactory));
        }

        private static class IteratorRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private IteratorFromGeneratorImplNode<?> implNode;

            IteratorRootNode(IteratorFromGeneratorImplNode<?> implNode) {
                this.implNode = implNode;
            }

            public Object execute(VirtualFrame frame) {
                return this.implNode.execute(frame, JSFrameUtil.getThisObj((Frame)frame));
            }

            public static IteratorRootNode create(IteratorFromGeneratorImplNode<?> implNode) {
                return new IteratorRootNode(implNode);
            }

            public boolean isCloningAllowed() {
                return true;
            }

            protected boolean isCloneUninitializedSupported() {
                return true;
            }

            protected RootNode cloneUninitialized() {
                return IteratorRootNode.create(this.implNode.copyUninitialized());
            }

            public String toString() {
                return this.implNode.toString();
            }
        }

        @GenerateCached(value=false)
        @ImportStatic(value={IteratorHelperPrototypeBuiltins.class})
        protected static abstract class IteratorFromGeneratorImplNode<T extends IteratorArgs>
        extends JavaScriptBaseNode {
            @Node.Child
            private CreateIterResultObjectNode createIterResultObjectNode;
            @Node.Child
            private IteratorStepNode iteratorStepNode;
            @Node.Child
            private IteratorValueNode iteratorValueNode;
            @Node.Child
            private LongToIntOrDoubleNode indexToNumber = LongToIntOrDoubleNode.create();
            protected final JSContext context;

            public IteratorFromGeneratorImplNode(JSContext context) {
                this.context = context;
                this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
                this.iteratorValueNode = IteratorValueNode.create();
                this.iteratorStepNode = IteratorStepNode.create();
            }

            protected abstract Object execute(VirtualFrame var1, Object var2);

            protected final Object iteratorStep(IteratorRecord iterated) {
                return this.iteratorStepNode.execute(iterated);
            }

            protected final Object iteratorValue(Object next) {
                return this.iteratorValueNode.execute(next);
            }

            protected final Object getNextValue(VirtualFrame frame, JSIteratorHelperObject thisObj, IteratorRecord iterated) {
                Object next = this.iteratorStep(iterated);
                if (next == Boolean.FALSE) {
                    return this.createResultDone(frame, thisObj);
                }
                return this.createResultContinue(frame, thisObj, this.iteratorValue(next));
            }

            protected final Object createResultContinue(VirtualFrame frame, JSIteratorHelperObject thisObj, Object value) {
                thisObj.setGeneratorState(JSFunction.GeneratorState.SuspendedYield);
                return this.createIterResultObjectNode.execute(frame, value, false);
            }

            protected final Object createResultDone(VirtualFrame frame, JSIteratorHelperObject thisObj) {
                thisObj.setGeneratorState(JSFunction.GeneratorState.Completed);
                return this.createIterResultObjectNode.execute(frame, (Object)Undefined.instance, true);
            }

            protected final T getArgs(JSIteratorHelperObject thisObj) {
                return (T)thisObj.getIteratorArgs();
            }

            @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
            @Fallback
            protected static Object incompatibleReceiver(Object thisObj) {
                throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
            }

            public abstract IteratorFromGeneratorImplNode<T> copyUninitialized();

            protected final Object indexToJS(long index) {
                return this.indexToNumber.fromIndex(null, index);
            }
        }
    }

    protected static abstract class IteratorMethodWithCallableNode
    extends IteratorMethodNode {
        @Node.Child
        private IsCallableNode isCallableNode = IsCallableNode.create();

        protected IteratorMethodWithCallableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        public final boolean isCallable(Object fn) {
            return this.isCallableNode.executeBoolean(fn);
        }
    }

    protected static abstract class IteratorMethodNode
    extends JSBuiltinNode {
        @Node.Child
        private GetIteratorDirectNode getIteratorDirectNode = GetIteratorDirectNode.create();

        protected IteratorMethodNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final IteratorRecord getIteratorDirect(Object thisObj) {
            return this.getIteratorDirectNode.execute(thisObj);
        }
    }

    protected static class IteratorWithCounterArgs
    extends IteratorArgs {
        public long counter;

        protected IteratorWithCounterArgs(IteratorRecord iterated) {
            super(iterated);
        }
    }

    public static class IteratorArgs {
        public final IteratorRecord iterated;

        public IteratorArgs(IteratorRecord iterated) {
            this.iterated = iterated;
        }
    }

    public static abstract class SetterThatIgnoresPrototypePropertiesNode
    extends JavaScriptBaseNode {
        protected final JSContext context;
        protected final Object propertyKey;

        protected SetterThatIgnoresPrototypePropertiesNode(JSContext context, Object propertyKey) {
            assert (JSRuntime.isPropertyKey(propertyKey));
            this.context = context;
            this.propertyKey = propertyKey;
        }

        @NeverDefault
        public static SetterThatIgnoresPrototypePropertiesNode create(JSContext context, Object propertyKey) {
            return IteratorPrototypeBuiltinsFactory.SetterThatIgnoresPrototypePropertiesNodeGen.create(context, propertyKey);
        }

        public abstract void executeWithHomeAndValue(Object var1, Object var2, Object var3);

        @Specialization
        protected void setValue(Object thisObj, Object home, Object value, @Cached IsObjectNode isObjectNode, @Cached(value="create(propertyKey, context, true)") HasPropertyCacheNode hasOwnConstructorPropertyNode, @Cached(value="create(context, propertyKey)") CreateDataPropertyNode createConstructorPropertyNode, @Cached(value="create(propertyKey, false, context, true)") PropertySetNode setConstructorNode, @Cached InlinedBranchProfile errorProfile, @Cached InlinedConditionProfile hasOwnPropertyProfile) {
            if (!isObjectNode.executeBoolean(thisObj)) {
                errorProfile.enter((Node)this);
                throw Errors.createTypeErrorNotAnObject(thisObj, this);
            }
            if (thisObj == home) {
                errorProfile.enter((Node)this);
                throw Errors.createTypeErrorCannotSetProperty(this.propertyKey, thisObj, this);
            }
            if (hasOwnPropertyProfile.profile((Node)this, hasOwnConstructorPropertyNode.hasProperty(thisObj))) {
                setConstructorNode.setValue(thisObj, value);
            } else {
                createConstructorPropertyNode.executeVoid(thisObj, value);
            }
        }
    }
}

