// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypesGen;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSReadScopeFrameSlotNode#doBoolean}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSReadScopeFrameSlotNode#doInt}
 *     Activation probability: 0.23095
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSReadScopeFrameSlotNode#doDouble}
 *     Activation probability: 0.18810
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSReadScopeFrameSlotNode#doObject}
 *     Activation probability: 0.14524
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSReadScopeFrameSlotNode#doSafeInteger}
 *     Activation probability: 0.10238
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSReadScopeFrameSlotNode#doDead}
 *     Activation probability: 0.05952
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(JSReadScopeFrameSlotNode.class)
@SuppressWarnings("javadoc")
final class JSReadScopeFrameSlotNodeGen extends JSReadScopeFrameSlotNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSReadScopeFrameSlotNode#doBoolean}
     *   1: SpecializationActive {@link JSReadScopeFrameSlotNode#doInt}
     *   2: SpecializationActive {@link JSReadScopeFrameSlotNode#doDouble}
     *   3: SpecializationActive {@link JSReadScopeFrameSlotNode#doObject}
     *   4: SpecializationActive {@link JSReadScopeFrameSlotNode#doSafeInteger}
     *   5: SpecializationActive {@link JSReadScopeFrameSlotNode#doDead}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private JSReadScopeFrameSlotNodeGen(int slot, Object identifier, ScopeFrameNode scopeFrameNode, boolean hasTemporalDeadZone) {
        super(slot, identifier, scopeFrameNode, hasTemporalDeadZone);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        if (state_0 != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doSafeInteger(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] */) {
                if ((scopeFrameNodeValue_.isBoolean(slot))) {
                    return doBoolean(scopeFrameNodeValue_);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] */) {
                if ((scopeFrameNodeValue_.isInt(slot))) {
                    return doInt(scopeFrameNodeValue_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] */) {
                if ((scopeFrameNodeValue_.isDouble(slot) || scopeFrameNodeValue_.isInt(slot))) {
                    return doDouble(scopeFrameNodeValue_);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] */) {
                if ((scopeFrameNodeValue_.isObject(slot))) {
                    return doObject(scopeFrameNodeValue_);
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doSafeInteger(Frame)] */) {
                if ((scopeFrameNodeValue_.isLong(slot))) {
                    return doSafeInteger(scopeFrameNodeValue_);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */) {
                if ((isIllegal(scopeFrameNodeValue_))) {
                    return doDead(scopeFrameNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(scopeFrameNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */) {
            return JSTypesGen.expectBoolean(execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] */) {
            if ((scopeFrameNodeValue_.isBoolean(slot))) {
                return doBoolean(scopeFrameNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(executeAndSpecialize(scopeFrameNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */) {
            return JSTypesGen.expectDouble(execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] */) {
            if ((scopeFrameNodeValue_.isDouble(slot) || scopeFrameNodeValue_.isInt(slot))) {
                return doDouble(scopeFrameNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(scopeFrameNodeValue_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] || SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */) {
            return JSTypesGen.expectInteger(execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] */) {
            if ((scopeFrameNodeValue_.isInt(slot))) {
                return doInt(scopeFrameNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(scopeFrameNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b111101) == 0 /* only-active SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] */ && (state_0 != 0  /* is-not SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doSafeInteger(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */)) {
                executeInt(frameValue);
                return;
            } else if ((state_0 & 0b111011) == 0 /* only-active SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] */ && (state_0 != 0  /* is-not SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doSafeInteger(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */)) {
                executeDouble(frameValue);
                return;
            } else if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] */ && (state_0 != 0  /* is-not SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doSafeInteger(Frame)] && SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */)) {
                executeBoolean(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Frame scopeFrameNodeValue) {
        int state_0 = this.state_0_;
        if ((scopeFrameNodeValue.isBoolean(slot))) {
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSReadScopeFrameSlotNode.doBoolean(Frame)] */;
            this.state_0_ = state_0;
            return doBoolean(scopeFrameNodeValue);
        }
        if ((scopeFrameNodeValue.isInt(slot))) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSReadScopeFrameSlotNode.doInt(Frame)] */;
            this.state_0_ = state_0;
            return doInt(scopeFrameNodeValue);
        }
        if ((scopeFrameNodeValue.isDouble(slot) || scopeFrameNodeValue.isInt(slot))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSReadScopeFrameSlotNode.doDouble(Frame)] */;
            this.state_0_ = state_0;
            return doDouble(scopeFrameNodeValue);
        }
        if ((scopeFrameNodeValue.isObject(slot))) {
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSReadScopeFrameSlotNode.doObject(Frame)] */;
            this.state_0_ = state_0;
            return doObject(scopeFrameNodeValue);
        }
        if ((scopeFrameNodeValue.isLong(slot))) {
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSReadScopeFrameSlotNode.doSafeInteger(Frame)] */;
            this.state_0_ = state_0;
            return doSafeInteger(scopeFrameNodeValue);
        }
        if ((isIllegal(scopeFrameNodeValue))) {
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSReadScopeFrameSlotNode.doDead(Frame)] */;
            this.state_0_ = state_0;
            return doDead(scopeFrameNodeValue);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.scopeFrameNode}, scopeFrameNodeValue);
    }

    @NeverDefault
    public static JSReadScopeFrameSlotNode create(int slot, Object identifier, ScopeFrameNode scopeFrameNode, boolean hasTemporalDeadZone) {
        return new JSReadScopeFrameSlotNodeGen(slot, identifier, scopeFrameNode, hasTemporalDeadZone);
    }

}
