/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.ArrayFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.AsyncIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.AsyncIteratorCloseNode;
import com.oracle.truffle.js.nodes.access.CreateAsyncFromSyncIteratorNode;
import com.oracle.truffle.js.nodes.access.GetIteratorFromMethodNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.array.JSSetLengthNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.InternalCallNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ArrayFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayFunction> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayFunctionBuiltins();

    protected ArrayFunctionBuiltins() {
        super(JSArray.CLASS_NAME, ArrayFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ArrayFunctionBuiltinsFactory.JSIsArrayNodeGen.create(context, builtin, ArrayFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return ArrayFunctionBuiltinsFactory.JSArrayOfNodeGen.create(context, builtin, false, ArrayFunctionBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 2: {
                return ArrayFunctionBuiltinsFactory.JSArrayFromNodeGen.create(context, builtin, false, ArrayFunctionBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 3: {
                return ArrayFunctionBuiltinsFactory.JSArrayFromAsyncNodeGen.create(context, builtin, ArrayFunctionBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayFunction implements BuiltinEnum<ArrayFunction>
    {
        isArray(1),
        of(0),
        from(1),
        fromAsync(1);

        private final int length;

        private ArrayFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 1, 2 -> 6;
                case 3 -> 16;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    public static abstract class JSIsArrayNode
    extends JSBuiltinNode {
        @Node.Child
        private com.oracle.truffle.js.nodes.unary.JSIsArrayNode isArrayNode = com.oracle.truffle.js.nodes.unary.JSIsArrayNode.createIsArrayLike();

        public JSIsArrayNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isArray(Object object) {
            return this.isArrayNode.execute(object);
        }
    }

    public static abstract class JSArrayOfNode
    extends JSArrayFunctionOperation {
        public JSArrayOfNode(JSContext context, JSBuiltin builtin, boolean isTypedArray) {
            super(context, builtin, isTypedArray);
        }

        @Specialization
        protected Object arrayOf(Object thisObj, Object[] args) {
            int len = args.length;
            Object obj = this.constructOrArray(thisObj, len, true);
            int pos = 0;
            for (Object arg : args) {
                Object value = JSRuntime.nullToUndefined(arg);
                this.writeOwn(obj, pos, value);
                ++pos;
            }
            this.setLength(obj, len);
            return obj;
        }
    }

    public static abstract class JSArrayFromNode
    extends JSArrayFunctionOperation {
        @Node.Child
        private JSFunctionCallNode callMapFnNode;
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private IteratorValueNode getIteratorValueNode;
        @Node.Child
        private IteratorStepNode iteratorStepNode;
        @Node.Child
        private GetMethodNode getIteratorMethodNode;
        @Node.Child
        private JSGetLengthNode getSourceLengthNode;
        private final ConditionProfile isIterable = ConditionProfile.create();

        public JSArrayFromNode(JSContext context, JSBuiltin builtin, boolean isTypedArray) {
            super(context, builtin, isTypedArray);
            this.getIteratorMethodNode = GetMethodNode.create(context, Symbol.SYMBOL_ITERATOR);
        }

        protected void iteratorCloseAbrupt(Object iterator) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iterator);
        }

        protected Object getIteratorValue(Object iteratorResult) {
            if (this.getIteratorValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIteratorValueNode = (IteratorValueNode)this.insert(IteratorValueNode.create());
            }
            return this.getIteratorValueNode.execute(iteratorResult);
        }

        protected Object iteratorStep(IteratorRecord iteratorRecord) {
            if (this.iteratorStepNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorStepNode = (IteratorStepNode)this.insert(IteratorStepNode.create());
            }
            return this.iteratorStepNode.execute(iteratorRecord);
        }

        protected final Object callMapFn(Object target, Object function, Object ... userArguments) {
            if (this.callMapFnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callMapFnNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.callMapFnNode.executeCall(JSArguments.create(target, function, userArguments));
        }

        protected long getSourceLength(Object thisObject) {
            if (this.getSourceLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSourceLengthNode = (JSGetLengthNode)this.insert(JSGetLengthNode.create(this.getContext()));
            }
            return this.getSourceLengthNode.executeLong(thisObject);
        }

        @Specialization
        protected Object arrayFrom(Object thisObj, Object items, Object mapFn, Object thisArg, @Cached GetIteratorFromMethodNode getIteratorFromMethod, @Cached InlinedBranchProfile growProfile) {
            return this.arrayFromCommon(thisObj, items, mapFn, thisArg, true, getIteratorFromMethod, growProfile);
        }

        protected Object arrayFromCommon(Object thisObj, Object items, Object mapFn, Object thisArg, boolean setLength, GetIteratorFromMethodNode getIteratorFromMethod, InlinedBranchProfile growProfile) {
            boolean mapping;
            if (mapFn == Undefined.instance) {
                mapping = false;
            } else {
                this.checkCallbackIsFunction(mapFn);
                mapping = true;
            }
            Object usingIterator = this.getIteratorMethodNode.executeWithTarget(items);
            if (this.isIterable.profile(usingIterator != Undefined.instance)) {
                return this.arrayFromIterable(thisObj, items, usingIterator, mapFn, thisArg, mapping, getIteratorFromMethod, growProfile);
            }
            Object itemsObject = this.toObject(items);
            return this.arrayFromArrayLike(thisObj, itemsObject, mapFn, thisArg, mapping, setLength);
        }

        protected Object arrayFromIterable(Object thisObj, Object items, Object usingIterator, Object mapFn, Object thisArg, boolean mapping, GetIteratorFromMethodNode getIteratorFromMethod, InlinedBranchProfile growProfile) {
            Object obj = this.constructOrArray(thisObj, 0L, false);
            IteratorRecord iteratorRecord = getIteratorFromMethod.execute(this, items, usingIterator);
            return this.arrayFromIteratorRecord(obj, iteratorRecord, mapFn, thisArg, mapping);
        }

        private Object arrayFromIteratorRecord(Object obj, IteratorRecord iteratorRecord, Object mapFn, Object thisArg, boolean mapping) {
            long k = 0L;
            try {
                while (true) {
                    Object next;
                    if ((next = this.iteratorStep(iteratorRecord)) == Boolean.FALSE) {
                        this.setLength(obj, k);
                        return obj;
                    }
                    Object mapped = this.getIteratorValue(next);
                    if (mapping) {
                        mapped = this.callMapFn(thisArg, mapFn, mapped, JSRuntime.positiveLongToIntOrDouble(k));
                    }
                    this.writeOwn(obj, k, mapped);
                    ++k;
                }
            }
            catch (AbstractTruffleException ex) {
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        protected Object arrayFromArrayLike(Object thisObj, Object items, Object mapFn, Object thisArg, boolean mapping, boolean setLength) {
            long len = this.getSourceLength(items);
            Object obj = this.constructOrArray(thisObj, len, true);
            for (long k = 0L; k < len; ++k) {
                Object value;
                Object mapped = value = this.read(items, k);
                if (mapping) {
                    mapped = this.callMapFn(thisArg, mapFn, mapped, JSRuntime.positiveLongToIntOrDouble(k));
                }
                this.writeOwn(obj, k, mapped);
            }
            if (setLength) {
                this.setLength(obj, len);
            }
            return obj;
        }
    }

    @ImportStatic(value={Symbol.class})
    public static abstract class JSArrayFromAsyncNode
    extends JSArrayFunctionOperation {
        @Node.Child
        private PropertySetNode setArgs;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        public JSArrayFromAsyncNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
            this.setArgs = PropertySetNode.createSetHidden(AsyncIteratorPrototypeBuiltins.AsyncIteratorAwaitNode.ARGS_ID, context);
        }

        private JSFunctionObject createFunctionWithArgs(ArrayFromAsyncArgs args, JSFunctionData functionData) {
            JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
            this.setArgs.setValue((Object)function, args);
            return function;
        }

        @Specialization
        protected final Object arrayFromAsync(Object thisObj, Object asyncItems, Object mapFn, Object thisArg, @Bind(value="this") Node node, @Cached(value="create(getContext())") NewPromiseCapabilityNode newPromiseCapability, @Cached(value="create(getContext(), SYMBOL_ASYNC_ITERATOR)") GetMethodNode getAsyncIteratorMethodNode, @Cached(value="create(getContext(), SYMBOL_ITERATOR)") GetMethodNode getIteratorMethodNode, @Cached(value="create(getContext())") JSGetLengthNode getLengthNode, @Cached CreateAsyncFromSyncIteratorNode createAsyncFromSyncIterator, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode, @Cached InternalCallNode internalCallNode, @Cached(value="createCall()") JSFunctionCallNode callRejectNode, @Cached InlinedConditionProfile isAsyncIterator) {
            PromiseCapabilityRecord promiseCapability = newPromiseCapability.executeDefault();
            try {
                JSFunctionObject closure;
                IteratorRecord asyncIteratorRecord;
                boolean mapping;
                if (mapFn == Undefined.instance) {
                    mapping = false;
                } else {
                    this.checkCallbackIsFunction(mapFn);
                    mapping = true;
                }
                Object usingAsyncIterator = getAsyncIteratorMethodNode.executeWithTarget(asyncItems);
                if (isAsyncIterator.profile(node, usingAsyncIterator != Undefined.instance)) {
                    asyncIteratorRecord = getIteratorFromMethodNode.execute(node, asyncItems, usingAsyncIterator);
                } else {
                    Object usingSyncIterator = getIteratorMethodNode.executeWithTarget(asyncItems);
                    if (usingSyncIterator != Undefined.instance) {
                        IteratorRecord syncIteratorRecord = getIteratorFromMethodNode.execute(node, asyncItems, usingSyncIterator);
                        asyncIteratorRecord = createAsyncFromSyncIterator.execute(node, syncIteratorRecord);
                    } else {
                        asyncIteratorRecord = null;
                    }
                }
                if (asyncIteratorRecord != null) {
                    result = this.constructOrArray(thisObj, 0L, false);
                    ArrayFromAsyncIteratorArgs args = new ArrayFromAsyncIteratorArgs(promiseCapability, asyncIteratorRecord, result, mapping, mapFn, thisArg);
                    closure = this.createFunctionWithArgs(args, this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayFromAsyncIteratorResumption, ArrayFromAsyncIteratorResumptionRootNode::createFunctionImpl));
                } else {
                    Object arrayLike = this.toObject(asyncItems);
                    long len = getLengthNode.executeLong(arrayLike);
                    result = this.constructOrArray(thisObj, len, true);
                    ArrayFromAsyncArrayLikeArgs args = new ArrayFromAsyncArrayLikeArgs(promiseCapability, len, arrayLike, result, mapping, mapFn, thisArg);
                    closure = this.createFunctionWithArgs(args, this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayFromAsyncArrayLikeResumption, ArrayFromAsyncArrayLikeResumptionRootNode::createFunctionImpl));
                }
                internalCallNode.execute(JSFunction.getCallTarget(closure), JSArguments.createOneArg((Object)Undefined.instance, (Object)closure, (Object)Undefined.instance));
            }
            catch (AbstractTruffleException ex) {
                Object error = this.getErrorObject(ex);
                callRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), error));
            }
            return promiseCapability.getPromise();
        }

        private Object getErrorObject(AbstractTruffleException ex) {
            if (this.getErrorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
            }
            return this.getErrorObjectNode.execute(ex);
        }

        static final class ArrayFromAsyncIteratorArgs
        extends ArrayFromAsyncArgs {
            final IteratorRecord iterator;

            ArrayFromAsyncIteratorArgs(PromiseCapabilityRecord promiseCapability, IteratorRecord iterator, Object result, boolean mapping, Object mapFn, Object thisArg) {
                super(promiseCapability, result, mapping, mapFn, thisArg);
                this.iterator = iterator;
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static abstract class ArrayFromAsyncArgs {
            final PromiseCapabilityRecord promiseCapability;
            final Object result;
            final boolean mapping;
            final Object mapFn;
            final Object thisArg;
            int state;
            long resultIndex;

            ArrayFromAsyncArgs(PromiseCapabilityRecord promiseCapability, Object result, boolean mapping, Object mapFn, Object thisArg) {
                this.promiseCapability = promiseCapability;
                this.result = result;
                this.mapping = mapping;
                this.mapFn = mapFn;
                this.thisArg = thisArg;
            }
        }

        static final class ArrayFromAsyncArrayLikeArgs
        extends ArrayFromAsyncArgs {
            final long len;
            final Object arrayLike;

            ArrayFromAsyncArrayLikeArgs(PromiseCapabilityRecord promiseCapability, long len, Object arrayLike, Object result, boolean mapping, Object mapFn, Object thisArg) {
                super(promiseCapability, result, mapping, mapFn, thisArg);
                this.len = len;
                this.arrayLike = arrayLike;
            }
        }

        protected static final class ArrayFromAsyncArrayLikeResumptionRootNode
        extends ArrayFromAsyncResumptionRootNode<ArrayFromAsyncArrayLikeArgs> {
            @Node.Child
            private ReadElementNode getNode;

            ArrayFromAsyncArrayLikeResumptionRootNode(JSContext context) {
                super(context);
                this.getNode = ReadElementNode.create(context);
            }

            public Object execute(VirtualFrame frame) {
                ArrayFromAsyncArrayLikeArgs args = (ArrayFromAsyncArrayLikeArgs)this.getArgs(frame);
                PromiseCapabilityRecord promiseCapability = args.promiseCapability;
                Object result = args.result;
                boolean mapping = args.mapping;
                long len = args.len;
                try {
                    int state = args.state;
                    for (long k = args.resultIndex; k < len; ++k) {
                        Object mappedValue;
                        if (state < 2) {
                            Object kValue;
                            if (state == 0) {
                                kValue = this.getNode.executeWithTargetAndIndex(args.arrayLike, k);
                                kValue = this.suspendAwait(frame, args, kValue, 1, k);
                            } else {
                                assert (state == 1);
                                kValue = this.resumeAwait(frame, args, 1);
                            }
                            if (mapping) {
                                mappedValue = this.callMapFn(args.mapFn, args.thisArg, kValue, k);
                                mappedValue = this.suspendAwait(frame, args, mappedValue, 2, k);
                            } else {
                                mappedValue = kValue;
                            }
                        } else {
                            assert (state == 2);
                            mappedValue = this.resumeAwait(frame, args, 2);
                        }
                        this.createDataPropertyOrThrow(result, k, mappedValue);
                        state = 0;
                    }
                    this.setLength(result, len);
                    this.callResolve(promiseCapability, result);
                }
                catch (YieldException e) {
                    assert (e.isAwait() && args.state != 0);
                }
                catch (AbstractTruffleException e) {
                    Object error = this.getErrorObject(e);
                    this.callReject(promiseCapability, error);
                }
                return promiseCapability.getPromise();
            }

            @Override
            protected JSFunctionObject createIfAbruptHandler(ArrayFromAsyncArrayLikeArgs args) {
                return this.createFunctionWithArgs(args, this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayFromAsyncAwaitIfAbruptReturn, ArrayFromAsyncArrayLikeResumptionRootNode::createIfAbruptReturnImpl));
            }

            static JSFunctionData createFunctionImpl(JSContext context) {
                return JSFunctionData.createCallOnly(context, (CallTarget)new ArrayFromAsyncArrayLikeResumptionRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
            }

            static JSFunctionData createIfAbruptReturnImpl(JSContext context) {
                return JSFunctionData.createCallOnly(context, (CallTarget)new IfAbruptReturnNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
            }

            private static class IfAbruptReturnNode
            extends AsyncIteratorPrototypeBuiltins.AsyncIteratorAwaitNode.AsyncIteratorRootNode<ArrayFromAsyncArrayLikeArgs> {
                IfAbruptReturnNode(JSContext context) {
                    super(context);
                }

                public Object execute(VirtualFrame frame) {
                    ArrayFromAsyncArrayLikeArgs args = (ArrayFromAsyncArrayLikeArgs)this.getArgs(frame);
                    PromiseCapabilityRecord promiseCapability = args.promiseCapability;
                    Object error = this.valueNode.execute(frame);
                    this.callReject(promiseCapability, error);
                    return promiseCapability.getPromise();
                }
            }
        }

        protected static final class ArrayFromAsyncIteratorResumptionRootNode
        extends ArrayFromAsyncResumptionRootNode<ArrayFromAsyncIteratorArgs> {
            @Node.Child
            private JSFunctionCallNode callNextMethodNode = JSFunctionCallNode.createCall();
            @Node.Child
            private IteratorValueNode iteratorValueNode = IteratorValueNode.create();
            @Node.Child
            private AsyncIteratorCloseNode asyncIteratorCloseNode;
            @Node.Child
            private IsObjectNode isObjectNode;
            @Node.Child
            private IteratorCompleteNode iteratorCompleteNode;

            ArrayFromAsyncIteratorResumptionRootNode(JSContext context) {
                super(context);
                this.asyncIteratorCloseNode = AsyncIteratorCloseNode.create(context);
                this.isObjectNode = IsObjectNode.create();
                this.iteratorCompleteNode = IteratorCompleteNode.create();
            }

            private Object checkIterResult(Object value) {
                if (!this.isObjectNode.executeBoolean(value)) {
                    throw Errors.createTypeErrorIterResultNotAnObject(value, (Node)this);
                }
                return value;
            }

            public Object execute(VirtualFrame frame) {
                ArrayFromAsyncIteratorArgs args = (ArrayFromAsyncIteratorArgs)this.getArgs(frame);
                PromiseCapabilityRecord promiseCapability = args.promiseCapability;
                IteratorRecord iteratorRecord = args.iterator;
                Object result = args.result;
                boolean mapping = args.mapping;
                try {
                    long k;
                    block12: {
                        int state = args.state;
                        for (k = args.resultIndex; k < JSRuntime.MAX_SAFE_INTEGER_LONG; ++k) {
                            Object mappedValue;
                            if (state < 2) {
                                Object nextResult;
                                if (state == 0) {
                                    nextResult = this.callNextMethodNode.executeCall(JSArguments.createZeroArg(iteratorRecord.getIterator(), iteratorRecord.getNextMethod()));
                                    nextResult = this.suspendAwait(frame, args, nextResult, 1, k);
                                } else {
                                    nextResult = this.resumeAwait(frame, args, 1);
                                    this.checkIterResult(nextResult);
                                    if (this.iteratorCompleteNode.execute(nextResult)) break block12;
                                }
                                Object nextValue = this.iteratorValueNode.execute(nextResult);
                                if (mapping) {
                                    mappedValue = this.callMapFn(args.mapFn, args.thisArg, nextValue, k);
                                    mappedValue = this.suspendAwait(frame, args, mappedValue, 2, k);
                                } else {
                                    mappedValue = nextValue;
                                }
                            } else {
                                mappedValue = this.resumeAwait(frame, args, 2);
                            }
                            this.createDataPropertyOrThrow(result, k, mappedValue);
                            state = 0;
                        }
                        assert (k >= JSRuntime.MAX_SAFE_INTEGER_LONG) : k;
                        throw Errors.createTypeErrorIndexTooLarge();
                    }
                    this.setLength(result, k);
                    this.callResolve(promiseCapability, result);
                }
                catch (YieldException e) {
                    assert (e.isAwait() && args.state != 0);
                }
                catch (AbstractTruffleException e) {
                    Object error = this.getErrorObject(e);
                    this.asyncIteratorCloseNode.executeAbruptReject(iteratorRecord.getIterator(), error, promiseCapability);
                }
                return promiseCapability.getPromise();
            }

            @Override
            protected JSFunctionObject createIfAbruptHandler(ArrayFromAsyncIteratorArgs args) {
                return this.createFunctionWithArgs(args, this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayFromAsyncAwaitIfAbruptClose, ArrayFromAsyncIteratorResumptionRootNode::createIfAbruptCloseImpl));
            }

            static JSFunctionData createFunctionImpl(JSContext context) {
                return JSFunctionData.createCallOnly(context, (CallTarget)new ArrayFromAsyncIteratorResumptionRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
            }

            static JSFunctionData createIfAbruptCloseImpl(JSContext context) {
                return JSFunctionData.createCallOnly(context, (CallTarget)new IfAbruptCloseNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
            }

            private static class IfAbruptCloseNode
            extends AsyncIteratorPrototypeBuiltins.AsyncIteratorAwaitNode.AsyncIteratorRootNode<ArrayFromAsyncIteratorArgs> {
                @Node.Child
                private AsyncIteratorCloseNode closeNode;

                IfAbruptCloseNode(JSContext context) {
                    super(context);
                    this.closeNode = AsyncIteratorCloseNode.create(context);
                }

                public Object execute(VirtualFrame frame) {
                    ArrayFromAsyncIteratorArgs args = (ArrayFromAsyncIteratorArgs)this.getArgs(frame);
                    PromiseCapabilityRecord promiseCapability = args.promiseCapability;
                    Object error = this.valueNode.execute(frame);
                    this.closeNode.executeAbruptReject(args.iterator.getIterator(), error, promiseCapability);
                    return promiseCapability.getPromise();
                }
            }
        }

        protected static abstract class ArrayFromAsyncResumptionRootNode<T extends ArrayFromAsyncArgs>
        extends AsyncIteratorPrototypeBuiltins.AsyncIteratorAwaitNode.AsyncIteratorRootNode<T> {
            @Node.Child
            private PromiseResolveNode promiseResolveNode;
            @Node.Child
            private PerformPromiseThenNode performPromiseThenNode;
            @Node.Child
            private PropertySetNode setArgs;
            @Node.Child
            private JSSetLengthNode setLengthNode;
            @Node.Child
            private WriteElementNode writeOwnElementNode;
            @Node.Child
            private JSFunctionCallNode callMapFnNode;
            @Node.Child
            private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
            protected static final int STATE_START = 0;
            protected static final int STATE_AWAIT_NEXT_RESULT = 1;
            protected static final int STATE_AWAIT_MAPPED_VALUE = 2;

            public ArrayFromAsyncResumptionRootNode(JSContext context) {
                super(context);
                this.promiseResolveNode = PromiseResolveNode.create(context);
                this.performPromiseThenNode = PerformPromiseThenNode.create(context);
                this.setArgs = PropertySetNode.createSetHidden(AsyncIteratorPrototypeBuiltins.AsyncIteratorAwaitNode.ARGS_ID, context);
                this.setLengthNode = JSSetLengthNode.create(context, true);
                this.writeOwnElementNode = WriteElementNode.create(context, true, true);
            }

            protected final JSFunctionObject createFunctionWithArgs(T args, JSFunctionData functionData) {
                JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
                this.setArgs.setValue((Object)function, args);
                return function;
            }

            protected final Object suspendAwait(VirtualFrame frame, T args, Object promiseOrValue, int nextState, long k) {
                JSPromiseObject promise = this.promiseResolveNode.executeDefault(promiseOrValue);
                assert (this.getArgs(frame) == args);
                ((ArrayFromAsyncArgs)args).state = nextState;
                ((ArrayFromAsyncArgs)args).resultIndex = k;
                JSFunctionObject resumeAwait = JSFrameUtil.getFunctionObject((Frame)frame);
                JSFunctionObject rejectAwait = this.createIfAbruptHandler(args);
                this.performPromiseThenNode.execute(promise, (Object)resumeAwait, (Object)rejectAwait);
                throw YieldException.AWAIT_NULL;
            }

            protected abstract JSFunctionObject createIfAbruptHandler(T var1);

            protected final Object resumeAwait(VirtualFrame frame, T args, int expectedState) {
                assert (this.getArgs(frame) == args && ((ArrayFromAsyncArgs)args).state == expectedState);
                Object awaitedValue = JSArguments.getUserArgument(frame.getArguments(), 0);
                ((ArrayFromAsyncArgs)args).state = 0;
                return awaitedValue;
            }

            protected final void setLength(Object thisObject, long length) {
                this.setLengthNode.execute(thisObject, this.indexToJS(length));
            }

            protected final void createDataPropertyOrThrow(Object result, long k, Object mappedValue) {
                this.writeOwnElementNode.executeWithTargetAndIndexAndValue(result, k, mappedValue);
            }

            protected final Object callMapFn(Object mapFn, Object thisArg, Object kValue, long k) {
                if (this.callMapFnNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.callMapFnNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
                }
                return this.callMapFnNode.executeCall(JSArguments.create(thisArg, mapFn, kValue, this.indexToJS(k)));
            }

            protected final Object getErrorObject(AbstractTruffleException ex) {
                if (this.getErrorObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                }
                return this.getErrorObjectNode.execute(ex);
            }
        }
    }

    public static abstract class JSArrayFunctionOperation
    extends ArrayPrototypeBuiltins.JSArrayOperation {
        @Node.Child
        protected IsConstructorNode isConstructor = IsConstructorNode.create();

        public JSArrayFunctionOperation(JSContext context, JSBuiltin builtin, boolean isTypedArray) {
            super(context, builtin, isTypedArray);
        }

        protected Object constructOrArray(Object thisObj, long len, boolean provideLengthArg) {
            if (this.isTypedArrayImplementation) {
                return this.getArraySpeciesConstructorNode().typedArrayCreate(thisObj, JSRuntime.longToIntOrDouble(len));
            }
            if (this.isConstructor.executeBoolean(thisObj)) {
                if (provideLengthArg) {
                    return this.getArraySpeciesConstructorNode().construct(thisObj, JSRuntime.longToIntOrDouble(len));
                }
                return this.getArraySpeciesConstructorNode().construct(thisObj, new Object[0]);
            }
            return this.arrayCreate(len);
        }
    }
}

